(function () {
  var keyboardCallbackfunc = null;
  var keyboardLanguage = "en";
  var switchLanguageInfo = {
    "en":"English",
    "ger":"German",
    "fr":"French",
    "it":"Italian",
    "es":"Spanish",
    "por":"Portuguese",
    "cn":"Chinese",
  };
  // var head = document.getElementsByTagName('head')[0];
  //key.js
  // var script = document.createElement('script');
  // script.type = 'text/javascript';
  // head.appendChild(script);
  // script.src = "../../../static/lib/keyboard/config/key.js";
  //Index.js
  // script = document.createElement('script');
  // script.type = 'text/javascript';
  // head.appendChild(script);
  // script.src = "../../../static/lib/keyboard/language/Index.js";

  function createInputtext (type) {
    var inputtext = document.createElement("input");
    inputtext.id = type + "virturalkeyboardinput";
    inputtext.className = type + "virturalkeyboardinput";
    return inputtext;
  }

  function setTextValue (value) {
    var type = document.getElementById("keyboardType").value;
    var origin_value = document.getElementById(type + "virturalkeyboardinput").value;
    var currentposition = getMousePosition(type + "virturalkeyboardinput");
    var nextposition = currentposition + 1;
    var leftContent = origin_value.substr(0, currentposition);
    var rightContent = origin_value.substr(currentposition);
    if (value === "delete") {
      document.getElementById(type + "virturalkeyboardinput").value = deleteChar(origin_value, currentposition);
      if (leftContent !== "") {
        if (currentposition >= 1) {
          nextposition = currentposition - 1;
        }
      } else {
        nextposition = 0;
      }
    } else {
      document.getElementById(type + "virturalkeyboardinput").value = leftContent + value + rightContent;
    }
    document.getElementById(type + "virturalkeyboardinput").selectionStart = nextposition;
    document.getElementById(type + "virturalkeyboardinput").selectionEnd = nextposition;
    document.getElementById(type + "virturalkeyboardinput").focus();
  }

  function deleteChar (originvalue, position) {
    var result = "";
    var leftContent = new String(originvalue.substr(0, position));
    var rightContent = new String(originvalue.substr(position));
    if (leftContent !== "") {
      var current_value = leftContent.substring(0, leftContent.length - 1);
      result = current_value + rightContent;
    } else {
      result = leftContent + rightContent;
    }
    return result;
  }

  function getMousePosition (elementid) {
    var element = document.getElementById(elementid);
    var cursorPos = 0;
    if (document.selection) {//IE
      var selectRange = document.selection.createRange();
      selectRange.moveStart('character', -(new String(element.value)).length);
      cursorPos = (new String(selectRange.text)).length;
    } else if (element.selectionStart || element.selectionStart == '0') {
      cursorPos = element.selectionStart;
    }
    return Number(cursorPos);
  }

  function clearInputValue (event) {
    stopPropagation(event);
    var type = document.getElementById("keyboardType").value;
    document.getElementById(type + "virturalkeyboardinput").style.color = "#000";
    document.getElementById(type + "virturalkeyboardinput").value = "";
  }

  function createClearBtn (type) {
    var clear_button = document.createElement("button");
    clear_button.id = "Clear";
    clear_button.innerHTML = "Clear";
    clear_button.className = type + "virturalkeyboardclearbutton";
    clear_button.onclick = clearInputValue;
    return clear_button;
  }

  function clickDeleteEvent (event) {
    stopPropagation(event);
    var type = document.getElementById("keyboardType").value;
    document.getElementById(type + "virturalkeyboardinput").style.color = "#000";
    setTextValue("delete");
  }

  function createNumberDeleteBtn (type) {
    var delete_button = document.createElement("button");
    delete_button.id = 8;
    delete_button.innerHTML = "←";
    delete_button.className = type + "virturalkeyboarddeletebutton";
    delete_button.onclick = clickDeleteEvent;
    return delete_button;
  }

  function clickCloseBtnEvent (event) {
    stopPropagation(event);
    hideKeyboard();
    document.body.click()
  }

  function createCloseBtn (type) {
    var close_button = document.createElement("button");
    close_button.id = type + "virturalkeyboardclosebutton";
    close_button.className = type + "virturalkeyboardclosebutton";
    close_button.onclick = clickCloseBtnEvent;
    return close_button;
  }

  function creatNumberEnterButton () {
    var enter_button = document.createElement("button");
    enter_button.id = "numberEnterbutton";
    enter_button.className = "virturalkeyboardEnterbutton";
    return enter_button;
  }

  function changeInternationalCaseAndShift () {
    var casetype = document.getElementById("caseType").value;
    var keytext = document.getElementById("keyText").value;
    var type = document.getElementById("keyboardType").value;
    var charList = getKeyCharlist();
    var objectlist = charList[type][keyboardLanguage];
    if (!objectlist) { 
      objectlist = charList[type]["en"];
    }
    if (casetype === "up") {
      for (var key in objectlist) {
        for (var index = 0; index < objectlist[key].length; index++) {
          var item = objectlist[key][index];
          if (document.getElementById(item["value"]) && document.getElementById(item["value"]).className.indexOf("normal") > -1) {
            document.getElementById(item["value"]).innerHTML = item[keytext].toUpperCase();
          }
        }
      }
    } else {
      for (var key in objectlist) {
        for (var index = 0; index < objectlist[key].length; index++) {
          var item = objectlist[key][index];
          if (document.getElementById(item["value"]) && document.getElementById(item["value"]).className.indexOf("normal") > -1) {
            document.getElementById(item["value"]).innerHTML = item[keytext].toLowerCase();
          }
        }
      }
    }
  }

  function createvirturalkeyboard (type) {
    var keybordbackgroud = document.createElement("div");
    keybordbackgroud.id = type + "virturalkeyboard";
    keybordbackgroud.style.display = "none";
    keybordbackgroud.className = type + "keybordbackgroud";
    var keybordheader = document.createElement("div");
    keybordheader.className = "keybordheader";
    var keybordheaderTitle = document.createElement("div");
    keybordheaderTitle.className = "keybordtitle"
    keybordheaderTitle.id = "virtural" + type + "title";
    keybordheader.appendChild(keybordheaderTitle);
    if (type === "international") {
      var inputType = document.createElement("input");
      inputType.type = "hidden";
      inputType.id = "caseType";
      inputType.value = "low";
      keybordheader.appendChild(inputType);
      inputType = document.createElement("input");
      inputType.type = "hidden";
      inputType.id = "keyText";
      inputType.value = "text";
      keybordheader.appendChild(inputType);
      inputType = null;
      keybordheader.appendChild(createInputtext(type));
      keybordheader.appendChild(createClearBtn(type));
      keybordheader.appendChild(createCloseBtn(type));
      keybordbackgroud.appendChild(keybordheader);
      keybordbackgroud.appendChild(createkeyboard(type));
    } else {
      var inputType = document.createElement("input");
      inputType.type = "hidden";
      inputType.id = "min";
      inputType.value = "";
      keybordheader.appendChild(inputType);
      inputType = document.createElement("input");
      inputType.type = "hidden";
      inputType.id = "max";
      inputType.value = "";
      keybordheader.appendChild(inputType);
      inputType = null;
      keybordheader.appendChild(createInputtext(type));
      keybordheader.appendChild(createCloseBtn(type));
      keybordbackgroud.appendChild(keybordheader);
      var numberheadercontainer = document.createElement("div");
      numberheadercontainer.id = "numberheadercontainer";
      numberheadercontainer.appendChild(createNumberDeleteBtn(type));
      numberheadercontainer.appendChild(createClearBtn(type));
      keybordbackgroud.appendChild(numberheadercontainer);
      keybordbackgroud.appendChild(createkeyboard(type));
    }
    var keybordfooter = document.createElement("div");
    keybordfooter.id = type + "keybordfooter";
    keybordfooter.className = "keybordfooter";
    keybordbackgroud.appendChild(keybordfooter);
    keybordbackgroud.onclick = stopPropagation;
    return keybordbackgroud;
  }

  function stopPropagation (event) {
    event.stopPropagation();
  }

  function keyboardPageClick (event) {
    event.stopPropagation();
    var pagevalue = document.getElementById("languagecharpage").value;
    if (event.target.id == "leftselectbutton") {
      document.getElementById("languagecharpage").value = Number(pagevalue) - 1;
    } else { 
      document.getElementById("languagecharpage").value = Number(pagevalue) + 1;
    }
    setLanguageList();
  }

  function createCharSelectContainer () { 
    var languagecontainer = document.createElement("div");
    languagecontainer.className = "languagecontainer";
    var inputlanguage = document.createElement("div");
    inputlanguage.id = "inputlanguage";
    languagecontainer.appendChild(inputlanguage);
    var keybordheader = document.createElement("div");
    keybordheader.className = "languageSelectChar";
    var leftbutton = document.createElement("button");
    leftbutton.id = "leftselectbutton";
    leftbutton.className = "selectbuttonlist";
    leftbutton.style.display = "none";
    leftbutton.innerHTML = "<";
    leftbutton.onclick = keyboardPageClick;
    var languagelist = document.createElement("div");
    languagelist.id = "languagelist";
    languagelist.className = "languagelist";
    var page = document.createElement("input");
    page.type = "hidden";
    page.id = "languagecharpage";
    page.value = 1;
    var rightbutton = document.createElement("button");
    rightbutton.id = "rightselectbutton";
    rightbutton.className = "selectbuttonlist";
    rightbutton.style.display = "none";
    rightbutton.innerHTML = ">";
    rightbutton.onclick = keyboardPageClick;
    keybordheader.appendChild(leftbutton);
    keybordheader.appendChild(page);
    keybordheader.appendChild(languagelist);
    keybordheader.appendChild(rightbutton);
    languagecontainer.appendChild(keybordheader);
    var clearfix = document.createElement("div");
    clearfix.className = "keyboadclearfix";
    languagecontainer.appendChild(clearfix);
    return languagecontainer;
  }

  function createkeyboard (type) {
    var charList = getKeyCharlist();
    var objectlist = charList[type][keyboardLanguage];
    if (!objectlist) { 
      objectlist = charList[type]["en"];
    }
    var keyborditemlist = document.createElement("div");
    keyborditemlist.id = type + "keyborditemlist";
    keyborditemlist.className = "keyborditemlist";
    var clearfix = document.createElement("div");
    clearfix.className = "keyboadclearfix";
    keyborditemlist.appendChild(clearfix);
    if (type === "number") {
      var leftkeyboadlist = document.createElement("div");
      leftkeyboadlist.className = "leftkeyboadlist";
      var rightkeyboadlist = document.createElement("div");
      rightkeyboadlist.className = "rightkeyboadlist";
      rightkeyboadlist.appendChild(creatNumberEnterButton());
      keyborditemlist.appendChild(leftkeyboadlist);
      keyborditemlist.appendChild(rightkeyboadlist);
      keyborditemlist.appendChild(clearfix);
    } else {
      var chartContainer = createCharSelectContainer();
      keyborditemlist.appendChild(chartContainer);
      var switchLanguageContainer = document.createElement("div");
      switchLanguageContainer.id = "switchLanguageContainer";
      switchLanguageContainer.style.display = "none";
      switchLanguageContainer.className = "switchLanguageContainer";
      var switchMask = document.createElement("div");
      switchMask.className = "switchBackgroundMask";
      switchLanguageContainer.appendChild(switchMask);
      var switchBtnList = document.createElement("div");
      switchBtnList.className = "switchBtnList";
      for (var key in switchLanguageInfo) {
        switch_button = document.createElement("button");
        switch_button.className = "keyborditembtn btnSwitchLanguage";
        switch_button.innerHTML = switchLanguageInfo[key];
        switch_button.id = key;
        switchBtnList.appendChild(switch_button);
      }
      switchLanguageContainer.appendChild(switchBtnList);
      keyborditemlist.appendChild(switchLanguageContainer);
    }
    for (var key in objectlist) {
      var keyborditem = document.createElement("div");
      keyborditem.className = "keyborditem " + key;
      for (var index = 0; index < objectlist[key].length; index++) {
        var item = objectlist[key][index];
        if (item["class"] === "normal") {
          keyborditem.appendChild(createNormalKeyboard(item));
        } else {
          keyborditem.appendChild(createInternationalSpecial(item));
        }
      }
      if (type === "number") {
        leftkeyboadlist.appendChild(keyborditem);
      } else {
        keyborditemlist.appendChild(keyborditem);
      }
      keyborditem = null;
    }
    keyborditemlist.onclick = clickHandleKeyCharEvent.bind(this);
    return keyborditemlist;
  }

  function createInternationalSpecial (item) {
    var specialbutton = document.createElement("button");
    specialbutton.id = item["value"];
    specialbutton.className = "keyborditembtn " + item["class"];
    if (item["value"] == "-1") {
      specialbutton.innerHTML = switchLanguageInfo[keyboardLanguage];
    } else { 
      specialbutton.innerHTML = item["text"];
    }
    return specialbutton;
  }

  function createNormalKeyboard (item) {
    var normalbutton = document.createElement("button");
    normalbutton.id = item["value"];
    normalbutton.className = "keyborditembtn " + item["class"];
    normalbutton.innerHTML = item["text"].toLowerCase();
    return normalbutton;
  }

  function inputInternationalFocusCallback (event) {
    event.stopPropagation();
    //check user login
    if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id,"noLoginState")) {
      userlogin.showLoginDialog();
      return false;
    }
    document.getElementById("keyboardType").value = "international";
    if (document.getElementById("numbervirturalkeyboard")) {
      document.getElementById("numbervirturalkeyboard").style.display = "none";
    }
    document.getElementById("internationalvirturalkeyboard").style.display = "block";
    if (document.getElementById("keyboardContainer")) {
      document.getElementById("keyboardContainer").style.display = "block";
      document.addEventListener("keydown", enterKeyboardCallback);
    }
    document.getElementById("virturalinternationaltitle").innerHTML = event.target.getAttribute("data-title");
    document.getElementById("internationalvirturalkeyboardinput").setAttribute("focusValue", event.target.value);
    document.getElementById("elementId").value = event.target.id;
    document.getElementById("internationalvirturalkeyboardinput").type = event.target.type;
    if (event.target.getAttribute("default-value")) {
      document.getElementById("internationalvirturalkeyboardinput").value = event.target.getAttribute("default-value");
    } else {
      document.getElementById("internationalvirturalkeyboardinput").value = event.target.value;
    }
    document.getElementById("internationalvirturalkeyboardinput").focus();
  }

  function inputNumberFocusCallback (event) {
    event.stopPropagation();
    if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id,"noLoginState")) {
      userlogin.showLoginDialog();
      return false;
    }
    var footHtml = [];
    document.getElementById("keyboardType").value = "number";
    document.getElementById("numberkeybordfooter").innerHTML = "";
    document.getElementById("min").value = "";
    document.getElementById("max").value = "";
    if (document.getElementById("internationalvirturalkeyboard")) {
      document.getElementById("internationalvirturalkeyboard").style.display = "none";
    }
    document.getElementById("numbervirturalkeyboard").style.display = "block";
    if (document.getElementById("keyboardContainer")) {
      document.getElementById("keyboardContainer").style.display = "block";
      document.addEventListener("keydown", enterKeyboardCallback);
    }
    document.getElementById("virturalnumbertitle").innerHTML = event.target.getAttribute("data-title");
    if (event.target.getAttribute("data-min")) {
      document.getElementById("min").value = event.target.getAttribute("data-min");
      footHtml.push(Number(event.target.getAttribute("data-min")) + "-");
    }
    if (event.target.getAttribute("data-max")) {
      document.getElementById("max").value = event.target.getAttribute("data-max");
      footHtml.push(Number(event.target.getAttribute("data-max")));
    }
    if (footHtml.length > 0) {
      document.getElementById("numberkeybordfooter").innerHTML = footHtml.join("");
      footHtml = null;
    }
    document.getElementById("numbervirturalkeyboardinput").setAttribute("focusValue", event.target.value);
    document.getElementById("elementId").value = event.target.id;
    document.getElementById("numbervirturalkeyboardinput").type = event.target.type;
    if (event.target.getAttribute("default-value")) {
      document.getElementById("numbervirturalkeyboardinput").value = event.target.getAttribute("default-value");
    } else {
      document.getElementById("numbervirturalkeyboardinput").value = Number(event.target.value) === 0 ? "" : event.target.value;
    }
    document.getElementById("numbervirturalkeyboardinput").focus();
  }

  function initLanguage (value) {
    var list = getLanguageList();
    if (typeof list[keyboardLanguage] == "undefined" || typeof list[keyboardLanguage][value] == "undefined") {
      setTextValue(value);
    } else {
      document.getElementById("inputlanguage").innerHTML = document.getElementById("inputlanguage").innerHTML + value;
      setLanguageList();
    }
  }

  function setLanguageList () {
    if (!document.getElementById("inputlanguage").innerHTML) {
      document.getElementById("languagelist").innerHTML = "";
      return false;
    }
    var list = getLanguageList();
    var charList = list[keyboardLanguage][document.getElementById("inputlanguage").innerHTML];
    document.getElementById("languagelist").innerHTML = "";
    var page = Number(document.getElementById("languagecharpage").value);
    if (page === 1) {
      document.getElementById("leftselectbutton").style.display = "none";
    } else {
      document.getElementById("leftselectbutton").style.display = "block";
    }
    var start = (page - 1) * 14;
    var lastchar = charList[charList.length - 1];
    var library = charList.substr(start, 14).split("");
    if (library.length > 0) { 
      library.forEach(function (item, index) {
        var languagebutton = document.createElement("button");
        languagebutton.innerHTML = item;
        languagebutton.id = "char-" + index;
        languagebutton.className = "keyborditembtn normal";
        languagebutton.onclick = charListClick;
        document.getElementById("languagelist").appendChild(languagebutton);
      })
      if (library[library.length - 1] === lastchar) {
        document.getElementById("rightselectbutton").style.display = "none";
      } else {
        document.getElementById("rightselectbutton").style.display = "block";
      }
    }
  }

  function charListClick (event) {
    event.stopPropagation(); 
    setTextValue(event.target.innerHTML);
    document.getElementById("inputlanguage").innerHTML = "";
    document.getElementById("languagelist").innerHTML = "";
  }

  function clickHandleKeyCharEvent (event) {
    var type = document.getElementById("keyboardType").value;
    var elementId = document.getElementById("elementId").value;
    var focus_value = document.getElementById(type + "virturalkeyboardinput").getAttribute("focusvalue");
    var origin_value = document.getElementById(type + "virturalkeyboardinput").value;
    var min = document.getElementById("min").value;
    var max = document.getElementById("max").value;
    var defaultValue = document.getElementById(elementId).getAttribute("default-value");
    stopPropagation(event);
    if (!event.target.id) {
      return;
    }
    if (event.target.id === "numberEnterbutton") {
      if (min !== "" && Number(origin_value) < Number(min) || max !== "" && Number(origin_value) > Number(max)) {
        document.getElementById(type + "virturalkeyboardinput").style.color = "red";
        return false;
      }
      if (defaultValue) {
        document.getElementById(elementId).setAttribute("default-value", origin_value);
      } else {
        document.getElementById(elementId).value = origin_value;
      }
      keyboardCallbackfunc(elementId, Number(origin_value), Number(focus_value));
      document.getElementById(type + "virturalkeyboardclosebutton").click();
    } else if (event.target.id === "46") {
      // international delete
      if (document.getElementById("inputlanguage").innerHTML != "") { 
        var languageValue = document.getElementById("inputlanguage").innerHTML;
        document.getElementById("inputlanguage").innerHTML = languageValue.substring(0, languageValue.length - 1);
        setLanguageList();
      } else { 
        setTextValue("delete");
      }
    } else if (event.target.id === "9") {
      //tab
    } else if (event.target.id === "20") {
      //CapsLock
      document.getElementById("caseType").value = (document.getElementById("caseType").value === "up") ? "low" : "up";
      changeInternationalCaseAndShift();
    } else if (event.target.id === "internationalEnterbutton") {
      //Enter
      if (defaultValue) {
        document.getElementById(elementId).setAttribute("default-value", origin_value);
      } else {
        document.getElementById(elementId).value = origin_value;
      }
      keyboardCallbackfunc(elementId, origin_value, focus_value);
      document.getElementById(type + "virturalkeyboardclosebutton").click();
    } else if (event.target.id === "16") {
      //Shift
      document.getElementById("keyText").value = (document.getElementById("keyText").value === "text") ? "smalltext" : "text";
      changeInternationalCaseAndShift();
    } else if (event.target.id === "32") {
      //Space
      setTextValue(" ");
    } else if (event.target.id === "-1") {
      // language switch
      document.getElementById("switchLanguageContainer").style.display = "block";
    } else if (["en","ger","fr","it","es","por","cn"].indexOf(event.target.id) > -1) {
      keyboardLanguage = event.target.id;
      document.getElementById("keyboardContainer").removeChild(document.getElementById(type + "virturalkeyboard"));
      document.getElementById("keyboardContainer").appendChild(createvirturalkeyboard("international"));
      if (defaultValue) {
        document.getElementById(elementId).setAttribute("default-value", origin_value);
      } else {
        document.getElementById(elementId).value = origin_value;
      }
      document.getElementById(elementId).click();
    }else {
      //noramal
      var selectvalue = event.target.innerHTML;
      selectvalue = selectvalue.replace(/&amp;/g, "&");
      selectvalue = selectvalue.replace(/&lt;/g, "<");
      selectvalue = selectvalue.replace(/&gt;/g, ">");
      initLanguage(selectvalue)
    }
  }

  function hideKeyboard () {
    if (document.getElementById("keyboardContainer")) {
      document.getElementById("keyboardContainer").style.display = "none";
      document.removeEventListener("keydown", enterKeyboardCallback)
    }

    if (document.getElementById("internationalvirturalkeyboard")) {
      document.getElementById("internationalvirturalkeyboard").style.display = "none";
    }
    if (document.getElementById("numbervirturalkeyboard")) {
      document.getElementById("numbervirturalkeyboard").style.display = "none";
    }
  }

  function createKeyboardDomElement (callback) {
    //create keyboard Container
    keyboardCallbackfunc = callback;
    var keyboardContainer = document.createElement("div");
    keyboardContainer.id = "keyboardContainer";
    keyboardContainer.style.display = "none";
    var keyboardMask = document.createElement("div");
    keyboardMask.className = "keyboardMask";
    keyboardMask.onclick = hideKeyboard;
    keyboardContainer.appendChild(keyboardMask);
    keyboardMask = null;
    var inputType = document.createElement("input");
    inputType.type = "hidden";
    inputType.id = "elementId";
    keyboardContainer.appendChild(inputType);
    inputType = document.createElement("input");
    inputType.type = "hidden";
    inputType.id = "keyboardType";
    keyboardContainer.appendChild(inputType);
    inputType = null;
    //create keyboard
    var keyboardList = ["international", "number"]
    for (var index = 0; index < keyboardList.length; index++) {
      keyboardContainer.appendChild(createvirturalkeyboard(keyboardList[index]));
    }
    document.body.appendChild(keyboardContainer);
    keyboardContainer = null;
  }

  function initSoftKeyboard () {
    var international = document.getElementsByClassName("keyboardinternationalInput");
    var number = document.getElementsByClassName("keyboardnumberInput");
    if (international.length > 0) {
      for (var i = 0; i < international.length; i++) {
        international[i].onclick = inputInternationalFocusCallback;
        international[i] = null;
      }
    }
    if (number.length > 0) {
      for (var i = 0; i < number.length; i++) {
        number[i].onclick = inputNumberFocusCallback;
        number[i] = null;
      }
    }
  }

  function enterKeyboardCallback (event) {
    var e = event || window.event || arguments.callee.caller.arguments[0];
    if (e && e.keyCode == 13) {
      if (document.getElementById("internationalvirturalkeyboard").style.display !== "none") {
        document.getElementById("internationalEnterbutton").click();
      }
      if (document.getElementById("numbervirturalkeyboard").style.display !== "none") {
        document.getElementById("numberEnterbutton").click();
      }
    }
  }

  window.bindSoftKeyboard = initSoftKeyboard;
  window.createKeyboard = createKeyboardDomElement;
})()