(function () {
  /**
   * 
   * @param {*} url websocket address
   * @param {*} port websocket port
   * @param {*} func function
   * @param {*} is_reconnect  Disconnect the reconnection
   * @param {*} protocol websocket protocol
   * @param {*} notify The background actively sends notifications to the front end
   * @param {*} remote is remote
   */
  function WebSocketObj (url, port, func, is_reconnect, protocol, notify) {
    if (window.location.hostname.indexOf("127.0.0.1") > -1 || window.location.hostname.indexOf("localhost") > -1) {
      this.remote = false;
    } else { 
      this.remote = true;
    }
    this.url = url;
    this.port = port;
    this.func = func;
    this.protocol = protocol;
    this.is_reconnect = is_reconnect;
    this.scoketconnecttimeout = null;
    this.notify = notify;
    this.connecting = false;
    this.reciveTimeValue = "";
    this.sendTimeValue = "";
    this.timeOut = null;
    this.sendState = false;
    this.connect();
  }
  WebSocketObj.prototype = {
    connect: function () {
      var that = this;
      var websocketurl = this.url.replace("http","ws");
      if (this.port) {
        websocketurl += ":" + this.port;
      }
      if (this.func) {
        websocketurl += "/" + this.func;
      }
      if (that.protocol) {
        that.websocketintance = new WebSocket(websocketurl, that.protocol);
      } else {
        that.websocketintance = new WebSocket(websocketurl);
      }
      that.websocketintance.onopen = function () {
        that.sendTimeValue = new Date().getTime();
        that.notify();
        removeWebsocketToolsTip();
      }
      that.websocketintance.onmessage = function (result) {
        that.reciveTimeValue = new Date().getTime();
        var data = JSON.parse(result.data);
        if (that.scoketconnecttimeout) {
          clearTimeout(that.scoketconnecttimeout);
          that.scoketconnecttimeout = null;
        }
        if (that.notify && data) {
          if (that.remote && data.error) {
            that.closeRemoteSocket(data.error);
          } else { 
            that.notify(data);
          }
        }
      }
      that.websocketintance.onclose = function () {
        if(that.websocketintance){
          that.closeWebsocket("wait connecting");
        }
        
      }
      that.websocketintance.onerror = function () {
        if(that.websocketintance){
          that.closeWebsocket("wait connecting");
        }
      }
    },
    sendMessage: function (message, callback, params) {
      var that = this;
      if (that.websocketintance.readyState === 0) {
        that.websocketintance.onopen = function () {
          that.sendWSMessage(message);
        }
      } else {
        that.sendWSMessage(message);
      }
      that.websocketintance.onmessage = function (result) {
        that.sendState = false;
        that.reciveTimeValue = new Date().getTime();
        var data = JSON.parse(result.data);
        if (this.scoketconnecttimeout) {
          clearTimeout(this.scoketconnecttimeout);
          this.scoketconnecttimeout = null;
        }
        if (callback && data) {
          if (that.remote && data.error) {
            that.closeRemoteSocket(data.error);
          } else { 
            callback(data, params);
          } 
        }
      }
    },
    checkWSTimeout: function () {
      var that = this;
      this.timeOut = setInterval(function () {
        if (that.remote && that.sendTimeValue < that.reciveTimeValue) {
          that.closeRemoteSocket("time out 60s");
        }
        clearInterval(that.timeOut);
        that.timeOut = null;
      },60000)
    },
    sendWSMessage: function (message) { 
      this.sendState = true;
      this.sendTimeValue = new Date().getTime();
      if (message) {
        if (typeof message === "string") {
          this.websocketintance.send(message);
        } else {
          this.websocketintance.send(JSON.stringify(message));
        }
      }
    },
    closeRemoteSocket: function (error) {
      var websocketError = "wait connecting";
      if(error){
        createWebsocketToolsTip(error);
      }else{
        websocketError = "";
      }
      if (cmdlist) { 
        if (cmdlist.commandSocket) {
          cmdlist.commandSocket.is_reconnect = false;
          cmdlist.commandSocket.closeWebsocket(websocketError);
        }
        if (cmdlist.liveData) {
          cmdlist.liveData.is_reconnect = false;
          cmdlist.liveData.closeWebsocket(websocketError);
        }
      }
    },
    closeWebsocket: function (websocketError) {
      this.sendState = false;
      if (this.connecting) return;
      this.connecting = true;
      if(websocketError){
        createWebsocketToolsTip(websocketError);
      }
      if (this.websocketintance) { 
        this.websocketintance.close();
        this.websocketintance = null;
      }
      if (this.is_reconnect) {
        this.reconnect();
      } else {
        this.connecting = false;
      }
    },
    reconnect: function () {
      var that = this;
      this.scoketconnecttimeout = setTimeout(function () {
        that.connect();
        that.connecting = false;
      }, 5000);
    }
  }
  function initWebSocket (url, port, func, is_reconnect, protocol, notify) {
    if (url) {
      return new WebSocketObj(url, port, func, is_reconnect, protocol, notify);
    }
  }
  function createWebsocketToolsTip (message) {
    if (!document.getElementById("websocket-close-toolstip")) {
      var string = document.createElement('div');
      string.id = "websocket-close-toolstip";
      string.style = "position: absolute;background: red;left: 50%;top: 30%;padding: 6px 12px;font-size: 30px;color: #fff;margin-left: -200px;width: 600px;text-align: center";
      string.innerHTML = message;
      document.body.appendChild(string);
    }
  }
  function removeWebsocketToolsTip () {
    if (document.getElementById("websocket-close-toolstip")) {
      document.getElementById("websocket-close-toolstip").remove();
    }
  }
  window.initWebSocket = initWebSocket;
})()