(function () {
  var selectDataAndTimeDialog = {
    callback: null,
    setStartAndEndDateTime: function (startTime, endTime) {
      var startYear = "";
      var startMonth = "";
      var startDate = "";
      var startHour = "";
      var startMinute = "";
      var startSecond = "";
      var endYear = "";
      var endMonth = "";
      var endDate = "";
      var endHour = "";
      var endMinute = "";
      var endSecond = "";
      if (!jCommon.empty(startTime)) {
        var startTimeDate = new Date(startTime);
        startYear = startTimeDate.getFullYear();
        startMonth = startTimeDate.getMonth() + 1;
        startDate = startTimeDate.getDate();
        startHour = startTimeDate.getHours();
        startMinute = startTimeDate.getMinutes();
        startSecond = startTimeDate.getSeconds();
      }
      jCommon.setHtmlValue("start_date_year", startYear);
      jCommon.setHtmlValue("start_date_month", jCommon.formatExceptYYYY(startMonth));
      jCommon.setHtmlValue("start_date_day", jCommon.formatExceptYYYY(startDate));
      jCommon.setHtmlValue("start_date_hour", jCommon.formatExceptYYYY(startHour));
      jCommon.setHtmlValue("start_date_min", jCommon.formatExceptYYYY(startMinute));
      jCommon.setHtmlValue("start_date_sec", jCommon.formatExceptYYYY(startSecond));
      var endTimeDate;
      if (jCommon.empty(endTime)) {
        endTimeDate = new Date();
      } else {
        var currentTime = jCommon.getDifferCurrentDate();
        if (Date.parse(endTime) > Date.parse(currentTime)) {
          endTimeDate = new Date(currentTime);
        } else {
          endTimeDate = new Date(endTime);
        }
      }
      endYear = endTimeDate.getFullYear();
      endMonth = endTimeDate.getMonth() + 1;
      endDate = endTimeDate.getDate();
      endHour = endTimeDate.getHours();
      endMinute = endTimeDate.getMinutes();
      endSecond = endTimeDate.getSeconds();
      jCommon.setHtmlValue("end_date_year", endYear);
      jCommon.setHtmlValue("end_date_month", jCommon.formatExceptYYYY(endMonth));
      jCommon.setHtmlValue("end_date_day", jCommon.formatExceptYYYY(endDate));
      jCommon.setHtmlValue("end_date_hour", jCommon.formatExceptYYYY(endHour));
      jCommon.setHtmlValue("end_date_min", jCommon.formatExceptYYYY(endMinute));
      jCommon.setHtmlValue("end_date_sec", jCommon.formatExceptYYYY(endSecond));
    },
    calculateIntermediateTime: function () {
      var data = selectDataAndTimeDialog.getDateDialogData();
      var start_Time = data.startTimeStamp;
      var end_Time = data.endTimeStamp;
      jCommon.setHtmlValue("middleDate", jCommon.formatDate((start_Time + end_Time) / 2));
    },
    show: function (callbackfun) {
      selectDataAndTimeDialog.callback = callbackfun;
      jCommon.removeHtmlClass("#selectDateTimeDialog", "hide");
    },
    selectDateTimeClick: function (event) {
      repeatAllPage.clearEventClick(event);
      var dateTimeList = jCommon.getHtmlValue("header-server-time").split(" ");
      var dateList = dateTimeList[0].split("-");
      var timeList = dateTimeList[1].split(":");
      if (event.target.id === "btn-close") {
        jCommon.addHtmlClass("#selectDateTimeDialog", "hide");
      } else if (event.target.id === "select-date-ok") {
        jCommon.setHtmlValue("clickNumber", 1);
        selectDataAndTimeDialog.callback();
        selectDataAndTimeDialog.callback = null;
        jCommon.addHtmlClass("#selectDateTimeDialog", "hide");
      } else if (event.target.id === "set-now-date") {
        jCommon.setHtmlValue("end_date_year", jCommon.formatExceptYYYY(dateList[0]));
        jCommon.setHtmlValue("end_date_month", jCommon.formatExceptYYYY(dateList[1]));
        jCommon.setHtmlValue("end_date_day", jCommon.formatExceptYYYY(dateList[2]));
        jCommon.setHtmlValue("end_date_hour", jCommon.formatExceptYYYY(timeList[0]));
        jCommon.setHtmlValue("end_date_min", jCommon.formatExceptYYYY(timeList[1]));
        jCommon.setHtmlValue("end_date_sec", jCommon.formatExceptYYYY(timeList[2]));
      }
    },
    getDateDialogData: function () {
      var startTime = jCommon.formatExceptYYYY(document.getElementById("start_date_year").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("start_date_month").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("start_date_day").value) + " " + jCommon.formatExceptYYYY(document.getElementById("start_date_hour").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("start_date_min").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("start_date_sec").value);
      var endTime = jCommon.formatExceptYYYY(document.getElementById("end_date_year").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("end_date_month").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("end_date_day").value) + " " + jCommon.formatExceptYYYY(document.getElementById("end_date_hour").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("end_date_min").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("end_date_sec").value);
      return {
        "startTime": startTime,
        "endTime": endTime,
        "startTimeStamp": jCommon.formatTimeStamp(startTime),
        "endTimeStamp": jCommon.formatTimeStamp(endTime)
      };
    }
  }

  var repeatAllPage = {
    initLiveData: {},
    parameterData: {},
    isUpdating: false,
    clientUpdating: false,
    acknowledgeUpdateing: false,
    alarmInfo: {},
    initCurrentPageData: function () {
      // Called on Page Change/Load + parameterData.version change and not updating in process + other
      cmdlist.loadParameters(function (message) {
        repeatAllPage.clientUpdating = false;
        repeatAllPage.setParameterData(message)
      })
    },
    setParameterData: function (message) {
      if (jCommon.empty(repeatAllPage.parameterData)) {
        repeatAllPage.setParameterFunction(message);
      } else {
        jCommon.mergeLiveData(repeatAllPage.parameterData, message, function (res) {
          repeatAllPage.setParameterFunction(res);
        });
      }
    },
    setParameterFunction: function (res) {
      repeatAllPage.parameterData = res;
      repeatAllPage.initFunction();
    },
    initFunction: function () {
      // Called on Page Change/Load + parameterData.version change and not updating in process from above + other
      if (jCommon.checkClassNameExits("main-content", "hide")) {
        return false;
      }
      var user_account = Number(jCommon.getLocalStorge("user_account"));
      jCommon.setHtmlValue("user_account", user_account);
      jCommon.controlDOMShow("user_account");
      var message = repeatAllPage.parameterData;
      if (jCommon.empty(message)) {
        return false;
      }
      jCommon.setDocumentTitle(message.controller.name)
      var currentPage = jCommon.getCurrentPage();
      channelPage.setChannelInfo(message);
      curveConfig.setCurveConfigInfo(message["curves"]);
      repeatAllPage.hanleMoreTools(message);
      pageNavigate.setStep();
      if (currentPage.endsWith("channel")) {
        jCommon.setLocalStorge(currentPage, jCommon.getUrlParams("p"));
      }
      if (currentPage === "channeloverview") {
        initChannelView(message);
      } else if (currentPage === "aichannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["ais"].length);
        pageNavigate.controlPageState();
        initAiChannel(message["ais"]);
      } else if (currentPage === "aochannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["aos"].length);
        pageNavigate.controlPageState();
        initAoChannel(message["aos"]);
      } else if (currentPage === "aintchannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["aitns"].length);
        pageNavigate.controlPageState();
        initAIntChannel(message);
      } else if (currentPage === "afbchannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["afbs"].length);
        pageNavigate.controlPageState();
        initAFbChannel(message["afbs"]);
      } else if (currentPage === "dichannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["dis"].length);
        pageNavigate.controlPageState();
        initDiChannel(message["dis"]);
      } else if (currentPage === "dochannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["dos"].length);
        pageNavigate.controlPageState();
        initDoChannel(message["dos"]);
      } else if (currentPage === "dintchannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["ditns"].length);
        pageNavigate.controlPageState();
        initDIntChannel(message["ditns"]);
      } else if (currentPage === "dfbchannel") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["dfbs"].length);
        pageNavigate.controlPageState();
        initDfbChannel(message["dfbs"]);
      } else if (currentPage === "menu") {
        initMenuPage(message);
      } else if (currentPage === "menuconfig") {
        initMenuConfigPage(message);
      } else if (currentPage === "systemconfig") {
        initSystemConfigPage(message["systems"]);
      } else if (currentPage === "chemicalfeed") {
        initSystemChemicalFeedData(message);
      } else if (currentPage === "trendconfig") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        initTrendConfigPage(message);
        pageNavigate.controlPageState();
      } else if (currentPage === "trend") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        var liveTimeout = setTimeout(function () {
          clearTimeout(liveTimeout);
          liveTimeout = null;
          initTrendData(message);
          pageNavigate.controlPageState()
        }, 1000);
      } else if (currentPage === "trendoverview") {
        initTrendOverveiwData(message["trends"]);
      } else if (currentPage === "trendconfigoverview") {
        initTrendConfigOverveiwData(message["trends"]);
      } else if (currentPage === "interval") {
        initIntervalData(message);
      } else if (currentPage === "intervaltime") {
        initIntervalTimeData(message);
      } else if (currentPage === "ratio") {
        initRatioData(message);
      } else if (currentPage === "ratiotime") {
        initRatioTimeData(message);
      } else if (currentPage === "schedule") {
        initScheduleData(message);
      } else if (currentPage === "scheduletime") {
        cmdlist.getParamersExt(function (data) {
          initScheduleTimeData(message, data);
        })
      } else if (currentPage === "schedulesetup") {
        cmdlist.getParamersExt(function (data) {
          initScheduleSetupData(message, data);
        })
      } else if (currentPage === "bppcboiler") {
        initSystemBppcBoilerData(message);
      } else if (currentPage === "bppcprocess") {
        initSystemBppcProcessData(message);
      } else if (currentPage === "bppchemical") {
        initSystemBppcChemicalData(message);
      } else if (currentPage === "bppccontrol") {
        initSystemBppcControlData(message);
      } else if (["bppctimefd", "bppctime", "bppctimechemical"].indexOf(currentPage) > -1) {
        initBPPCTimeData(message);
      } else if (currentPage === "feeddevice") {
        initFeedDeviceData(message);
      } else if (currentPage === "fvcontrolmonitor") {
        initFVControlMonitorData(message);
      } else if (currentPage === "feedmonitor") {
        initFeedMonitorData(message);
      } else if (["alarmsumary", "eventsumary"].indexOf(currentPage) > -1) {
        initAlarmEventSumaryData(message);
      } else if (currentPage === "interlock") {
        initInterlockData(message);
      } else if (currentPage === "systemcycle") {
        initSystemcycleData(message);
      } else if (currentPage === "systemblowdown") {
        initSystemBlowdownData(message);
      } else if (currentPage === "recipe") {
        initRecipeData(message);
      } else if (currentPage === "system") {
        initSystemData(message);
      } else if (currentPage === "display") {
        initDisplayData(message["setup"]["rtDisplay"]);
      } else if (currentPage === "analogdisplay") {
        initAnalogDisplayData(message);
      } else if (currentPage === "digitaldisplay") {
        initDigitalDisplayData(message);
      } else if (["curveview", "curve"].indexOf(currentPage) > -1) {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["curves"].length);
        pageNavigate.controlPageState();
        initCurveData(message["curves"]);
      } else if (currentPage === "curvegraph") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["curves"].length);
        pageNavigate.controlPageState();
        initCurveGraphData(message["curves"]);
      } else if (currentPage === "modbus") {
        initModbusData(message["modbus"]);
      } else if (currentPage === "modbusdv") {
        initModbusDVData();
      } else if (currentPage === "overview") {
        initOverveiwData(message);
      } else if (currentPage === "pdc") {
        inintPDCData(message);
      } else if (currentPage === "onoff") {
        inintOnOffData(message);
      } else if (currentPage === "onofftime") {
        initOnOffTimeData(message);
      } else if (currentPage === "pid") {
        inintPidData(message);
      } else if (currentPage === "pidtime") {
        initPidTimeData(message);
      } else if (currentPage === "pidloop") {
        initPidloopData(message);
      } else if (currentPage === "pidauto") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["plc"]["pids"].length);
        pageNavigate.controlPageState();
        initPidAutoData(message);
      } else if (currentPage === "pfc") {
        inintPFCData(message);
      } else if (currentPage === "pfctime") {
        initPFCTimeData(message);
      } else if (currentPage === "smtp") {
        initSMTPData(message["setup"]["smtp"]);
      } else if (currentPage === "redundantpump") {
        initRedundantpumpData(message);
      } else if (currentPage === "monitor") {
        initMonitorData(message);
      } else if (currentPage === "ogolanalog") {
        initOgolAnalogData(message);
      } else if (currentPage === "remotesetup") {
        initRemoteSetupData(message["setup"]["remoteAlarm"]);
      } else if (currentPage === "remoteanalog") {
        initRemoteAnalogData(message);
      } else if (currentPage === "remotedigital") {
        initRemoteDigitalData(message);
      } else if (currentPage === "remoteloop") {
        initRemoteLoopData(message);
      } else if (currentPage === "statmonconfig") {
        initStatMonitorData(message);
      } else if (currentPage === "monitorprocess") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["sms"]["processes"].length);
        pageNavigate.controlPageState();
        initMonitorProcessData(message);
      } else if (currentPage === "monitorgroup") {
        jCommon.setHtmlValue("pageNum", jCommon.getUrlParams("p"));
        jCommon.setHtmlAttribute("pageNum", "data-max", message["sms"]["groups"].length);
        pageNavigate.controlPageState();
        initMonitorGroupData(message);
      } else if (currentPage === "displayfallback") {
        initDisplayFallbackData(message);
      } else if (currentPage === "rtdisplayconfig") {
        initRtDisplayConfigPage(message);
      } else if (["curveruntime", "curveconfig"].indexOf(currentPage) > -1) {
        initCurveOverveiwData(message["curves"]);
      } else if (currentPage === "plcstatus") {
        initPlcStatusData(message["plc"]);
      } else if (currentPage === "guardonline") {
        initGuardOnlineData(message["setup"]);
      } else if (["probetime", "probe"].indexOf(currentPage) > -1) {
        initProbeConfigData(message);
      } else if (["pyxissensorcaltime", "pyxissensorcal"].indexOf(currentPage) > -1) {
        initPyxisSensorCalPage(message);
      } else if (currentPage === "3b3hconfig") {
        init3b3hconfigPage(message["analyzer_3C"]);
      } else if (currentPage === "3b3hrtime") {
        init3b3hrtimePage(message["analyzer_3C"]);
      } else if (currentPage === "3bconfig") {
        init3bconfigPage(message["analyzer_3C"]);
      } else if (currentPage === "3bconfig2") {
        init3bconfig2Page(message["analyzer_3C"]);
      } else if (currentPage === "3brtime") {
        init3brtimePage(message["analyzer_3C"]);
      } else if (currentPage === "3hconfig") {
        init3hconfigPage(message["analyzer_3C"]);
      } else if (currentPage === "3hconfig2") {
        init3hconfigPage(message["analyzer_3C"]);
      } else if (currentPage === "3hrtime") {
        init3hrtimePage(message["analyzer_3C"]);
      } else if (currentPage === "3bdiagresult") {
        init3bdiagresultData();
      } else if (currentPage === "systemsetting") {
        initSystemSettingData();
      } else if (currentPage === "factoryconfig") {
        initFactoryConfigPage(message);
      } else if (currentPage === "moxaio") {
        initMoxaioPage(message);
      } else if (currentPage === "export") {
        initExportPageData(message);
      } else if (currentPage === "pbc1") {
        initPBCPageData(message);
      } else if (currentPage === "pbc2") {
        initPBCPageData(message);
      } else if (currentPage === "pbc3") {
        initPBCPageData(message);
      } else if (currentPage === "pbc4") {
        initPBCPageData(message);
      } else if (currentPage === "apid1") {
        initAPIDPageData(message);
      } else if (currentPage === "apid2") {
        initAPIDPageData(message);
      } else if (currentPage === "apidrtime") {
        initAPidRTimeData(message);
      } else if (currentPage === "pyxissensorlog") {
        initPyxisSensorLogPageData(message);
      }
      bindSoftKeyboard();
    },
    hanleMoreTools: function (message) {
      var channelList = ["aichannel", "aochannel", "aintchannel", "afbchannel", "dichannel", "dochannel", "dintchannel", "dfbchannel"];
      var channelId = 0;
      channelList.forEach(function (item) {
        channelId = !jCommon.empty(jCommon.getLocalStorge(item)) ? jCommon.getLocalStorge(item) : 1;
        jCommon.setHtmlAttribute("top-left-" + item, "data-href", item + "&p=" + channelId);
      })
      userlogin.initSystemAndRtDisplay(message, "top-left-");
      jCommon.addHtmlClass(".monitor-setup", "hide");
      jCommon.removeHtmlClass(".monitor-overview", "hide");
      jCommon.checkBtnLoginDisabled();
    },
    keyboardCallBackFunction: function () {
      var elementId = arguments[0];
      var newValue = arguments[1];
      var orignValue = arguments[2];
      var currentPage = jCommon.getCurrentPage();
      if (orignValue === newValue && currentPage !== "smtp") {
        return false;
      }
      if (["aichannel", "aochannel", "aintchannel", "afbchannel"].indexOf(currentPage) > -1) {
        checkAnalogValue(elementId, newValue, orignValue);
      } else if (["dichannel", "dochannel", "dintchannel", "dfbchannel"].indexOf(currentPage) > -1) {
        checkDigitalValue(elementId, newValue, orignValue);
      } else if (currentPage === "trend") {
        checkTrendInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "trendconfig") {
        checkTrendConfigInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "systemconfig") {
        checkSystemConfigInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "system") {
        checkSystemInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "monitor") {
        checkMonitorInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "smtp") {
        checkSmtpInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "feeddevice") {
        checkFeeddeviceInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "monitorgroup") {
        checkMonitorGroupInputValue(elementId, newValue, orignValue);
      } else if (currentPage === "pyxissensorcal") {
        checkPyxisSensorcalInputValue(elementId, newValue, orignValue);
      } else {
        repeatAllPage.updateParameter(elementId);
        jCommon.controlDOMShow(elementId);
        jCommon.setClassListValue(elementId, newValue);
      }
    },
    updateParameter: function (elementId, callbackfun, anotherData) {
      repeatAllPage.isUpdating = true;
      var pdata = {};
      var filedList = jCommon.getSaveProperty(elementId);
      filedList.forEach(function (item) {
        var modifKey = jCommon.getHtmlAttriute(item, "data-save-property");
        if (!jCommon.empty(modifKey)) {
          pdata[modifKey] = jCommon.getHtmlValue(item);
          if (modifKey == "/controller/name") {
            //modify page title
            jCommon.setDocumentTitle(jCommon.getHtmlValue(item));
          }
        }
      })
      if (!jCommon.empty(anotherData)) {
        for (var key in anotherData) {
          pdata[key] = anotherData[key];
        }
      }
      if (!jCommon.empty(pdata)) {
        pdata["/other/version"] = repeatAllPage.parameterData.version;
        jCommon.removeHtmlClass("#update-state", "hide");
        cmdlist.updateParameter(pdata, function (message) {
          message.version = repeatAllPage.parameterData.version;
          jCommon.mergeLiveData(repeatAllPage.parameterData, message, function (res) {
            jCommon.addHtmlClass("#update-state", "hide");
            repeatAllPage.isUpdating = false;
            if (callbackfun) {
              callbackfun(res);
            }
          });
        });
      } else {
        repeatAllPage.isUpdating = false;
      }
    },
    setRegisterRealTime: function () {
      cmdlist.setLiveData(function (message) {
        // shuibao.yu test, don't move the code	     
        state = message["dos/0/state"];
        cnt = message["liveSampleCount"];
        // console.log("live data state, cnt ", state, cnt);
        repeatAllPage.hanleRealTime(message);
      })
    },
    hanleRealTime: function (message) { // Called every second
      if (!message) {
        return false;
      }
      if (jCommon.empty(repeatAllPage.initLiveData)) {
        repeatAllPage.initLiveData = message;
      } else {
        jCommon.mergeLiveData(repeatAllPage.initLiveData, message, function (res) {
          repeatAllPage.handleRealTimePage(res)
        });
      }
    },
    handleRealTimePage: function (message) { // Called every second
      var currentPage = jCommon.getCurrentPage();
      if (repeatAllPage.parameterData.version < message.version && currentPage != "alarmsumary") {
        if (jCommon.empty(cmdlist.sendMessageClient)) {
          if (jCommon.empty(repeatAllPage.isUpdating) && jCommon.empty(repeatAllPage.clientUpdating)) {
            repeatAllPage.clientUpdating = true;
            repeatAllPage.initCurrentPageData();
          }
        } else {
          cmdlist.sendMessageClient = ""
        }
      }
      repeatAllPage.parameterData.version = message.version;
      repeatAllPage.parameterData.liveSampleCount = message.liveSampleCount;
      jCommon.setHtmlValue("header-time", jCommon.getHeaderFormatTime(message["now"]));
      jCommon.setHtmlValue("header-server-timestamp", message["timestamp"]);
      jCommon.setHtmlValue("header-server-time", message["now"]);
      if (message["alarm"]["almFlag"]) {
        jCommon.setHtmlValue("alarmRealState", "Alarm");
        jCommon.removeHtmlClass("#alarmRealState", "alarm-realtime-green");
        jCommon.addHtmlClass("#alarmRealState", "alarm-realtime-red");
        if (message["alarm"]["almFlag"] === 2) {
          if (jCommon.checkClassNameExits("alarmRealState", "color-flash")) {
            jCommon.removeHtmlClass("#alarmRealState", "color-flash");
          } else {
            jCommon.addHtmlClass("#alarmRealState", "color-flash");
          }
        } else {
          jCommon.removeHtmlClass("#alarmRealState", "color-flash");
        }
      } else {
        jCommon.setHtmlValue("alarmRealState", "Clear");
        jCommon.removeHtmlClass("#alarmRealState", "alarm-realtime-red");
        jCommon.addHtmlClass("#alarmRealState", "alarm-realtime-green");
      }
      if (currentPage === "trend") {
        hanleLiveDataObject.hanleTrendChartData(message);
      } else if (currentPage === "aichannel") {
        hanleLiveDataObject.hanleAiChannelData(message);
      } else if (currentPage === "aochannel") {
        hanleLiveDataObject.hanleAoChannelData(message);
      } else if (currentPage === "afbchannel") {
        hanleLiveDataObject.hanleAfbChannelData(message);
      } else if (currentPage === "aintchannel") {
        hanleLiveDataObject.hanleAIntChannelData(message);
      } else if (currentPage === "dichannel") {
        hanleLiveDataObject.hanleDiChannelData(message);
      } else if (currentPage === "dochannel") {
        hanleLiveDataObject.hanleDoChannelData(message);
      } else if (currentPage === "dintchannel") {
        hanleLiveDataObject.hanleDintChannelData(message);
      } else if (currentPage === "dfbchannel") {
        hanleLiveDataObject.hanleDfbChannelData(message);
      } else if (currentPage === "system") {
        hanleLiveDataObject.hanleSystemData(message);
      } else if (currentPage === "systemconfig") {
        channelPage.controlDigitalChnState(message);
      } else if (currentPage === "ratio") {
        hanleLiveDataObject.hanleRatioData(message);
      } else if (currentPage === "ratiotime") {
        hanleLiveDataObject.hanleRatioTimeData(message);
      } else if (currentPage === "interval") {
        hanleLiveDataObject.hanleIntervalData(message);
      } else if (currentPage === "intervaltime") {
        hanleLiveDataObject.hanleIntervalTimeData(message);
      } else if (currentPage === "schedule") {
        hanleLiveDataObject.hanleScheduleData(message);
      } else if (currentPage === "schedulesetup") {
        hanleLiveDataObject.hanleScheduleSetupData(message);
      } else if (currentPage === "scheduletime") {
        hanleLiveDataObject.hanleScheduleTimeData(message);
      } else if (currentPage === "feeddevice") {
        hanleLiveDataObject.hanleFeedDeviceData(message);
      } else if (currentPage === "fvcontrolmonitor") {
        systemFeed.controlLoopStateAndConfigValid(message);
      } else if (currentPage === "interlock") {
        hanleLiveDataObject.hanleInterlockData(message);
      } else if (currentPage === "systemblowdown") {
        hanleLiveDataObject.hanleSystemblowdownData(message);
      } else if (currentPage === "systemcycle") {
        hanleLiveDataObject.hanleSystemcycleData(message);
      } else if (currentPage === "ogicstatis") {
        hanleLiveDataObject.hanleOgicStatisData(message);
      } else if (currentPage === "plcstatus") {
        hanleLiveDataObject.hanlePLCstatusData(message);
      } else if (currentPage === "chemicalfeed") {
        hanleLiveDataObject.hanleChemicalFeedData(message);
      } else if (currentPage === "analogdisplay") {
        hanleLiveDataObject.hanleAnalogDisplayData(message);
      } else if (currentPage === "digitaldisplay") {
        hanleLiveDataObject.hanleDigitalDisplayData(message);
      } else if (["curve", "curveview"].indexOf(currentPage) > -1) {
        hanleLiveDataObject.hanleAnalogDisplayData(message);
      } else if (currentPage === "modbus") {
        hanleLiveDataObject.hanleModbusData(message);
      } else if (currentPage === "modbusdv") {
        hanleLiveDataObject.hanleModbusStauts(message["modbus"]);
      } else if (currentPage === "overview") {
        hanleLiveDataObject.hanleOverviewData(message);
      } else if (currentPage === "pdc") {
        hanleLiveDataObject.hanlePDCData(message);
      } else if (currentPage === "onoff") {
        hanleLiveDataObject.hanleOnOffData(message);
      } else if (currentPage === "onofftime") {
        hanleLiveDataObject.hanleOnOffTimeData(message);
      } else if (currentPage === "pid") {
        hanleLiveDataObject.hanlePidData(message);
      } else if (currentPage === "pidauto") {
        hanleLiveDataObject.hanlePidAutoData(message);
      } else if (currentPage === "pidtime") {
        hanleLiveDataObject.hanlePidTimeData(message);
      } else if (currentPage === "pfc") {
        hanleLiveDataObject.hanlePFCData(message);
      } else if (currentPage === "pfctime") {
        hanleLiveDataObject.hanlePFCTimeData(message);
      } else if (currentPage === "bppcboiler") {
        hanleLiveDataObject.hanleBPPCBoilerData(message);
      } else if (currentPage === "bppcprocess") {
        hanleLiveDataObject.hanleBPPCProcessData(message);
      } else if (currentPage === "bppchemical") {
        hanleLiveDataObject.hanleBPPCChemicalData(message);
      } else if (currentPage === "bppccontrol") {
        hanleLiveDataObject.hanleBPPCControlData(message);
      } else if (["bppctimefd", "bppctime", "bppctimechemical"].indexOf(currentPage) > -1) {
        hanleLiveDataObject.hanleBPPCTimeData(message);
      } else if (currentPage === "redundantpump") {
        hanleLiveDataObject.hanleRedundantPumpData(message);
      } else if (currentPage === "monitor") {
        hanleLiveDataObject.hanleMonitorData(message);
      } else if (currentPage === "3b3hconfig") {
        hanleLiveDataObject.handle3CData(message);
      } else if (currentPage === "3b3hrtime") {
        hanleLiveDataObject.handle3CData(message);
      } else if (currentPage === "3bconfig") {
        hanleLiveDataObject.handle3BData(message);
      } else if (currentPage === "3bconfig2") {
        hanleLiveDataObject.handle3BData(message);
      } else if (currentPage === "3brtime") {
        hanleLiveDataObject.handle3BData(message);
      } else if (currentPage === "3hconfig") {
        hanleLiveDataObject.handle3HData(message);
      } else if (currentPage === "3hconfig2") {
        hanleLiveDataObject.handle3HData(message);
      } else if (currentPage === "3hrtime") {
        hanleLiveDataObject.handle3HData(message);
      } else if (currentPage === "pbc1") {
        hanleLiveDataObject.handlePBCData(message);
      } else if (currentPage === "pbc2") {
        hanleLiveDataObject.handlePBCData(message);
      } else if (currentPage === "pbc3") {
        hanleLiveDataObject.handlePBCData(message);
      } else if (currentPage === "pbc4") {
        hanleLiveDataObject.handlePBCData(message);
      } else if (currentPage === "apid1") {
        hanleLiveDataObject.handleAPIDData(message);
      } else if (currentPage === "apid2") {
        hanleLiveDataObject.handleAPIDData(message);
      } else if (currentPage === "apidrtime") {
        hanleLiveDataObject.hanleAPidRTimeData(message);
      } else if (["alarmsumary", "eventsumary"].indexOf(currentPage) > -1) {
        var alertCount = jCommon.getHtmlValue("alertCount");
        var currentPageNumber = jCommon.getHtmlValue("currentPage");
        if (currentPageNumber === 1 && alertCount != message["alertCount"] && !repeatAllPage.acknowledgeUpdateing) {
          initAlarmEventSumaryData();
        }
        jCommon.setHtmlValue("alertCount", message["alertCount"]);
      } else if (["remoteanalog", "remotedigital", "remoteloop"].indexOf(currentPage) > -1) {
        var remoteAlarmInfo = message["remoteAlarm"];
        for (var key in remoteAlarmInfo) {
          jCommon.setHtmlValue(key + "-Mins", Number(remoteAlarmInfo[key]["sec"] / 60).toFixed(1));
          if (remoteAlarmInfo[key]["sent"] > 0) {
            jCommon.addHtmlClass("#" + key + "-Mins", "remote-blue");
          } else {
            jCommon.removeHtmlClass("#" + key + "-Mins", "remote-blue");
          }
        }
      } else if (["pyxissensorcaltime", "pyxissensorcal"].indexOf(currentPage) > -1) {
        hanleLiveDataObject.hanlePyxisMetaData(message);
      } else if (["probetime", "probe"].indexOf(currentPage) > -1) {
        pyxisControl.handleProbeListConnect(message);
      } else if (currentPage === "export") {
        hanleLiveDataObject.hanleExportPageData(message);
      }
    },
    updateSelectValueData: function (value, id, callbackfun) {
      var key = id.replace("Label", "");
      jCommon.setHtmlValue(key, value);
      jCommon.controlDOMShow(key);
      if (typeof callbackfun === "function") {
        repeatAllPage.updateParameter(key, callbackfun);
      } else {
        repeatAllPage.updateParameter(key);
      }
    },
    clearEventClick(event) {
      event.stopPropagation();
      toolsControl.hideToolsDialog();
      if (jCommon.empty(event.target.id)) {
        return false;
      }
    },
    setControlTitle(controllerInfo) {
      jCommon.setHtmlValue("page-header-title", controllerInfo["name"]);
    }
  }

  var hanleLiveDataObject = {
    trendLiveDataCount: 0,
    hanleTrendChartData: function (message) {
      if (jCommon.empty(message["now"]) || jCommon.empty(message["trends"])) {
        return;
      }
      var trendIndex = jCommon.getHtmlValue("pageNum") - 1;
      var dataFrequency = constVar.trendTimeRange(trendIndex, "dataFrequency");
      if (hanleLiveDataObject.trendLiveDataCount > 0) {
        hanleLiveDataObject.trendLiveDataCount++;
        return;
      }
      if (hanleLiveDataObject.trendLiveDataCount >= dataFrequency) {
        hanleLiveDataObject.trendLiveDataCount = 0;
      }
      var messageInfo = jCommon.ObjectToArray(message["trends"][trendIndex]);
      var scaled = !jCommon.checkBoolenValue(jCommon.getHtmlValue("unscaled"));
      if (messageInfo == null || jCommon.empty(dygraphInstance)) {
        return;
      }
      var scales = dygraphInstance.getOption("customScales");
      var minScales = dygraphInstance.getOption("customMinScales");
      if (!jCommon.empty(messageInfo) && !jCommon.empty(dygraphInstance) && jCommon.checkBoolenValue(jCommon.getHtmlValue("realtime"))) {
        var rowList = [new Date(message["now"])];
        if (!jCommon.isArray(dygraphInstance.rawData_)) {
          dygraphInstance.rawData_ = [];
        }
        dygraphInstance.rawData_.shift();
        var realTimeToolstip = [];
        var colorsMap_ = dygraphInstance.colorsMap_;
        var labels = dygraphInstance.getLabels();
        messageInfo.forEach(function (item, index) {
          if (!jCommon.empty(item) && typeof (dygraphInstance.setIndexByName_[item["name"] + "#" + index]) !== "undefined") {
            rowList[dygraphInstance.setIndexByName_[item["name"] + "#" + index]] = item["data"];
            var labeledData = '<div class="legend-item"><span style="color:' + colorsMap_[item["name"] + "#" + index] + '">' + item["name"] + ":" + jCommon.formatNumber(item["data"]) + "</span></div>";
            realTimeToolstip.push(labeledData);
          }
        })
        var currentData = [];
        if (scaled) {
          rowList = getScaleVirtualData([rowList]);
          currentData = rowList[0];
        } else {
          currentData = rowList;
        }
        dygraphInstance.rawData_.push(currentData);
        if (jCommon.checkClassNameExits("toolTipLine", "hide")) {
          jCommon.setHtmlValue("trendItemList", realTimeToolstip.join(","));
        } else {
          var clickCurrentIndex = jCommon.getHtmlValue("clickCurrentIndex");
          var clickCurrentData = dygraphInstance.rawData_[clickCurrentIndex];
          var realTimeToolstipString = [];
          if (dygraphInstance.getOption("isScales")) {
            for (var index = 1; index < labels.length; index++) {
              var currentRealData = trendPage.getDyGraphRealData(scales[labels[index]], clickCurrentData[index], minScales[labels[index]]);
              realTimeToolstipString.push('<div class="legend-item"><span style="color:' + colorsMap_[labels[index]] + '">' + labels[index].split("#")[0] + ":" + jCommon.formatNumber(currentRealData) + "</span></div>")
            }
          } else {
            for (var index = 1; index < labels.length; index++) {
              realTimeToolstipString.push('<div class="legend-item"><span style="color:' + colorsMap_[labels[index]] + '">' + labels[index].split("#")[0] + ":" + jCommon.formatNumber(clickCurrentData[index]) + "</span></div>")
            }
          }
          jCommon.setHtmlValue("toolTipXValue", jCommon.formatDate(dygraphInstance.rawData_[clickCurrentIndex][0]));
          jCommon.setHtmlValue("trendItemList", realTimeToolstipString.join(","));
        }
        dygraphInstance.updateOptions({
          'file': dygraphInstance.rawData_
        });
      }
    },
    hanleAiChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["ais"][currentIndex];
      hanleLiveDataObject.hanleAnalogData(currentData);
      channelPage.controlDigitalChnState(message);
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
      pyxisControl.handleProbeConnect(message);
    },
    hanleAoChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["aos"][currentIndex];
      hanleLiveDataObject.hanleAnalogData(currentData);
      channelPage.controlDigitalChnState(message);
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
    },
    hanleAIntChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["aitns"][currentIndex];
      hanleLiveDataObject.hanleAnalogData(currentData);
      channelPage.controlDigitalChnState(message);
      var loopIndex = jCommon.getHtmlValue("pdLoop");
      var loopInfo = message["loop"][loopIndex];
      var pdChn = jCommon.getHtmlValue("pdChn");
      if (!jCommon.empty(loopInfo)) {
        if (pdChn === 0) {
          jCommon.setHtmlValue("mode", loopInfo["pdcValues"][0]);
          systemFeed.controlLoopStatus("mode");
        } else {
          jCommon.setHtmlValue("pdcValue", loopInfo["pdcValues"][pdChn]);
        }
      }
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
    },
    hanleAfbChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["afbs"][currentIndex];
      hanleLiveDataObject.hanleAnalogData(currentData);
      channelPage.controlDigitalChnState(message);
      channelPage.controlAnglogChValue(message);
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
    },
    hanleAnalogData: function (currentData) {
      for (var key in currentData) {
        jCommon.setHtmlValue(key, currentData[key]);
      }
      var signalMin = jCommon.getHtmlValue("signalMin");
      var signalMax = jCommon.getHtmlValue("signalMax");

      if (currentData["signal"] < signalMin || currentData["signal"] > signalMax) {
        jCommon.addHtmlClass("#signal", "signal-red");
      } else {
        jCommon.removeHtmlClass("#signal", "signal-red");
      }
      jCommon.setClassListValue("simData", currentData["data"]);
      jCommon.removeHtmlClass("#alarmMsg", "message-warning");
      jCommon.removeHtmlClass("#alarmMsg", "message-alarm");
      jCommon.removeHtmlClass(".simDataState", "message-warning");
      jCommon.removeHtmlClass(".simDataState", "message-alarm");
      if (jCommon.empty(currentData["loAlarm"]) && jCommon.empty(currentData["loWarn"]) && jCommon.empty(currentData["hiWarn"]) && jCommon.empty(currentData["hiAlarm"])) {
        jCommon.setHtmlValue("alarmStatus", 0); //no show Waring And Alarm
      } else {
        if (!jCommon.empty(currentData["loAlarm"]) || !jCommon.empty(currentData["hiAlarm"])) {
          jCommon.setHtmlValue("alarmStatus", 1); //show alarm
          jCommon.addHtmlClass("#alarmMsg", "message-alarm");
          jCommon.addHtmlClass(".simDataState", "message-alarm");
        } else {
          jCommon.setHtmlValue("alarmStatus", 2); //show warning
          jCommon.addHtmlClass("#alarmMsg", "message-warning");
          jCommon.addHtmlClass(".simDataState", "message-warning");
        }
      }
      jCommon.controlDOMShow("alarmStatus");
      jCommon.controlDOMShow("configValid");
    },
    hanleChannelMoudbusState: function (modbusData) {
      var dcsIndex = jCommon.getHtmlValue("dcsIndex");
      var currentData = modbusData[dcsIndex];
      if (!jCommon.empty(currentData)) {
        jCommon.setHtmlValue('status', currentData["status"]);
        jCommon.controlDOMShow("status");
      }
    },
    hanleDiChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["dis"][currentIndex];
      hanleLiveDataObject.hanleDigitalData(currentData);
      channelPage.controlDigitalChnState(message);
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
    },
    hanleDoChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["dos"][currentIndex];
      hanleLiveDataObject.hanleDigitalData(currentData);
      channelPage.controlDigitalChnState(message);
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
    },
    hanleDintChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["ditns"][currentIndex];
      hanleLiveDataObject.hanleDigitalData(currentData);
      channelPage.controlDigitalChnState(message);
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
    },
    hanleDfbChannelData: function (message) {
      var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
      var currentData = message["dfbs"][currentIndex];
      hanleLiveDataObject.hanleDigitalData(currentData);
      channelPage.controlDigitalChnState(message);
      channelPage.controlAnglogChValue(message);
      hanleLiveDataObject.hanleChannelMoudbusState(message["modbus"]);
    },
    hanleDigitalData: function (currentData) {
      for (var key in currentData) {
        jCommon.setHtmlValue(key, currentData[key]);
        jCommon.controlDOMShow(key);
      }
      if (currentData["warn"] || currentData["alarm"]) {
        jCommon.setHtmlValue("alarmWarning", true);
      } else {
        jCommon.setHtmlValue("alarmWarning", false);
      }
      if (currentData["warn"]) { //warning
        jCommon.removeHtmlClass("#alarmMsg", "message-alarm");
        jCommon.addHtmlClass("#alarmMsg", "message-warning");
      }
      if (currentData["alarm"]) {
        jCommon.removeHtmlClass("#alarmMsg", "message-warning");
        jCommon.addHtmlClass("#alarmMsg", "message-alarm");
      }
      jCommon.controlDOMShow("alarm");
    },
    hanleModbusData: function (message) {
      channelPage.controlDigitalChnState(message);
      hanleLiveDataObject.hanleModbusStauts(message["modbus"]);
    },
    hanleModbusStauts: function (modbusList) {
      modbusList.forEach(function (item, index) {
        for (var key in item) {
          jCommon.setHtmlValue("DCS-" + index + "-" + key, item[key]);
        }
        jCommon.controlDOMShow("DCS-" + index + "-status");
      })
    },
    hanleRatioData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanleRedundantPumpData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
      channelPage.controlDigitalChnState(message);
      channelPage.controlAnglogChValue(message);
    },
    hanleRatioTimeData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanlePFCTimeData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanlePidAutoData: function (message) {
      var pidIndex = jCommon.getUrlParams("p") - 1;
      var pidInfo = message["plc"]["pid"][pidIndex];
      jCommon.setDomElementLiveValue(pidInfo, "live-pid-");
    },
    hanlePidTimeData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanleIntervalData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      systemFeed.hanleIntervalTableData(message["loop"][loopIndex]);
    },
    hanleIntervalTimeData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      systemFeed.hanleIntervalTableData(message["loop"][loopIndex]);
    },
    hanleFeedDeviceData: function (message) {
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      var currentData = message["loop"][loopIndex];
      jCommon.setHtmlValue("flowmeterMonitor-pv", currentData["pv"]);
      channelPage.controlDigitalChnState(message);
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
      systemFeed.handlePidLiveData(message, "flowmeterCtrl-");
      systemFeed.controlLoopStatus("flowmeterCtrl-autoMode");
    },
    hanleInterlockData: function (message) {
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      var currentData = message["loop"][loopIndex];
      var SI_LoopNum = jCommon.getHtmlValue("SI_LoopNum");
      if (SI_LoopNum > -1) {
        jCommon.setHtmlValue("mode", message["loop"][SI_LoopNum]["mode"]);
      }
      systemFeed.controlLoopStatus("mode");
      jCommon.setHtmlValue("enable", currentData["enable"]);
      jCommon.controlDOMShow("enable");
      channelPage.controlDigitalChnState(message);
    },
    hanleSystemblowdownData: function (message) {
      var systemIndex = jCommon.getUrlParams("system") - 1;
      var blowdownInfo = message["system"][systemIndex]["blowdown"];
      for (var key in blowdownInfo) {
        jCommon.setHtmlValue(key, blowdownInfo[key]);
      }
      jCommon.controlDOMShow("configValid");
      channelPage.controlDigitalChnState(message);
      channelPage.controlAnglogChValue(message);
    },
    hanleSystemcycleData: function (message) {
      var systemIndex = jCommon.getUrlParams("system") - 1;
      if (!jCommon.empty(message["system"])) {
        var cycleInfo = message["system"][systemIndex]["cycles"];
        for (var key in cycleInfo) {
          jCommon.setHtmlValue(key, cycleInfo[key]);
        }
        jCommon.setClassListValue("value", cycleInfo["value"]);
        channelPage.controlAnglogChValue(message);
        systemFeed.controlLoopStatus("mode");
      }
    },
    hanleOgicStatisData: function (message) {
      if (!jCommon.empty(message["others"])) {
        for (var key in message["others"]) {
          jCommon.setHtmlValue(key, message["others"][key]);
        }
      }
    },
    hanlePLCstatusData: function (message) {
      if (!jCommon.empty(message["plc"])) {
        for (var key in message["plc"]) {
          jCommon.setHtmlValue(key, message["plc"][key]);
        }
      }
      jCommon.controlDOMShow("status");
      channelPage.controlDigitalChnState(message);
    },
    hanleChemicalFeedData: function (message) {
      var domList = document.querySelectorAll(".btn-loop-status");
      for (var index = 0; index < domList.length; index++) {
        var loopIndex = jCommon.getHtmlAttriute("row-" + index + "-state", "data-loopIndex");
        if (loopIndex !== null && !jCommon.empty(message["loop"][loopIndex])) {
          var currentData = message["loop"][loopIndex];
          if (!jCommon.empty(currentData["enable"])) {
            jCommon.setHtmlValue("row-" + index + "-state", "Enabled");
            jCommon.removeHtmlClass("#row-" + index + "-state", "loop-state-disabled");
            jCommon.addHtmlClass("#row-" + index + "-state", "loop-state-enabled");
          } else {
            jCommon.setHtmlValue("row-" + index + "-state", "Disabled");
            jCommon.removeHtmlClass("#row-" + index + "-state", "loop-state-enabled");
            jCommon.addHtmlClass("#row-" + index + "-state", "loop-state-disabled");
          }
        }
      }
    },
    hanleSystemData: function (message) {
      channelPage.controlAnglogChValue(message);
      channelPage.controlDigitalChnState(message);
      systemFeed.controlPredefinedLoopStatus(message);
      hanleLiveDataObject.hanleLoopItemData(message["loop"]);
    },
    hanleMonitorData: function (message) {
      var inputAnalogChDomList = document.querySelectorAll('input[data-value-name="value-name-analog"]');
      var keyObjectInfo = constVar.getChannelDataKey();
      for (var analogIndex = 0; analogIndex < inputAnalogChDomList.length; analogIndex++) {
        var inputAnalogItem = inputAnalogChDomList[analogIndex];
        var analogTypeKey = jCommon.getHtmlValue(inputAnalogItem.id + "Type");
        var analogch = jCommon.getHtmlValue(inputAnalogItem.id);
        var analogTypeName = keyObjectInfo[analogTypeKey];
        var liveDataDomId = inputAnalogItem.id + "-liveDataLabel";
        var simDataDomId = inputAnalogItem.id + "-simData";
        var currentAnalogData = message[analogTypeName][analogch - 1];
        if (jCommon.checkClassNameExits(liveDataDomId, "alarm-status")) {
          jCommon.removeHtmlClass("#" + liveDataDomId, "message-warning");
          jCommon.removeHtmlClass("#" + liveDataDomId, "message-alarm");
          if (currentAnalogData["hiAlarm"] || currentAnalogData["loAlarm"]) {
            jCommon.addHtmlClass("#" + liveDataDomId, "message-alarm");
          } else if (currentAnalogData["hiWarn"] || currentAnalogData["loWarn"]) {
            jCommon.addHtmlClass("#" + liveDataDomId, "message-warning");
          }
        }
        jCommon.setHtmlValue(liveDataDomId, currentAnalogData["data"]);
        if (jCommon.checkClassNameExits(simDataDomId, "alarm-status")) {
          jCommon.removeHtmlClass("#" + simDataDomId, "message-warning");
          jCommon.removeHtmlClass("#" + simDataDomId, "message-alarm");
          if (currentAnalogData["hiAlarm"] || currentAnalogData["loAlarm"]) {
            jCommon.addHtmlClass("#" + simDataDomId, "message-alarm");
          } else if (currentAnalogData["hiWarn"] || currentAnalogData["loWarn"]) {
            jCommon.addHtmlClass("#" + simDataDomId, "message-warning");
          }
        }
      }
      var inputDigitalChDomList = document.querySelectorAll('input[data-value-name="value-name-digital"]');
      for (var digitalIndex = 0; digitalIndex < inputDigitalChDomList.length; digitalIndex++) {
        var inputDigitalItem = inputDigitalChDomList[digitalIndex];
        var digitaltype = jCommon.getHtmlValue(inputDigitalItem.id + "Type");
        var digitalch = jCommon.getHtmlValue(inputDigitalItem.id);
        var digitaltypeName = keyObjectInfo[digitaltype];
        var stateDomId = inputDigitalItem.id + "State";
        if (!jCommon.empty(message[digitaltypeName]) && !jCommon.empty(message[digitaltypeName][digitalch - 1])) {
          var currentDigitalData = message[digitaltypeName][digitalch - 1];
          jCommon.setHtmlValue(stateDomId, currentDigitalData["state"]);
          jCommon.removeHtmlClass("#" + stateDomId + "-label", "digital-Off");
          jCommon.removeHtmlClass("#" + stateDomId + "-label", "digital-On");
          if (currentDigitalData["state"]) {
            jCommon.setHtmlValue(stateDomId + "-label", "ON");
            jCommon.addHtmlClass("#" + stateDomId + "-label", "digital-On");
          } else {
            jCommon.setHtmlValue(stateDomId + "-label", "OFF");
            jCommon.addHtmlClass("#" + stateDomId + "-label", "digital-Off");
          }
        }
      }
      systemFeed.controlPredefinedLoopStatus(message);
    },
    hanleOverviewData: function (message) {
      hanleLiveDataObject.hanleLoopItemData(message["loop"]);
      hanleLiveDataObject.handle3CData(message);
    },
    hanleLoopItemData: function (loopList) {
      var domList = document.querySelectorAll(".loop-item");
      for (var index = 0; index < domList.length; index++) {
        var domId = domList[index].id;
        var loopIndex = jCommon.getHtmlValue(domId);
        if (loopIndex !== null && !jCommon.empty(loopList[loopIndex])) {
          var currentData = loopList[loopIndex];
          jCommon.setHtmlValue(domId + "-upPercent_SP", currentData["upPercent_SP"]);
          jCommon.setClassListValue(domId + "-upfeedRate_ACT", currentData["upfeedRate_ACT"]);
          jCommon.setClassListValue(domId + "-downfeedRate_ACT", currentData["downfeedRate_ACT"]);
          jCommon.setClassListValue(domId + "-totalfeedRate_SP", currentData["totalfeedRate_SP"]);
          jCommon.setHtmlValue(domId + "-mode", currentData["mode"]);
          jCommon.setHtmlValue(domId + "-enable", currentData["enable"]);
          jCommon.setHtmlValue(domId + "-configValid", currentData["configValid"]);
          jCommon.setHtmlValue(domId + "-cv", currentData["cv"]);
          // jCommon.setHtmlValue(domId + "-feedRate", currentData["feedRate"]);
          jCommon.setHtmlValue(domId + "-fdRateAC", currentData["fdRateAC"]);
          jCommon.setHtmlValue(domId + "-feedSp", currentData["feedSp"]);
          if (currentData["signal"] == 1) {
            jCommon.setSvgStyle(domId + "-signal-status", "fill:#09d309");
            jCommon.setSvgText(domId + "-signal-text", "ON");
          } else {
            jCommon.setSvgStyle(domId + "-signal-status", "fill:red");
            jCommon.setSvgText(domId + "-signal-text", "OFF");
          }
          jCommon.removeHtmlClass("#" + domId + "-loopstatus", "loop-status-green");
          jCommon.removeHtmlClass("#" + domId + "-loopstatus", "loop-status-yellow");
          jCommon.removeHtmlClass("#" + domId + "-loopstatus", "loop-state-red");
          if (currentData["warnAlarmFlag"] == 0) {
            jCommon.addHtmlClass("#" + domId + "-loopstatus", "loop-status-green");
            jCommon.setSvgStyle(domId + "-loop-svgstatus", "fill:#09d309");
          } else if (currentData["warnAlarmFlag"] == 1) {
            jCommon.addHtmlClass("#" + domId + "-loopstatus", "loop-status-yellow");
            jCommon.setSvgStyle(domId + "-loop-svgstatus", "fill:#09d309");
          } else if (currentData["warnAlarmFlag"] == 2) {
            jCommon.addHtmlClass("#" + domId + "-loopstatus", "loop-state-red");
            jCommon.setSvgStyle(domId + "-loop-svgstatus", "fill:#09d309");
          }
          jCommon.controlDOMShow(domId + "-mode");
          jCommon.controlDOMShow(domId + "-enable");
          jCommon.controlDOMShow(domId + "-configValid");
        }
      }
    },
    hanleScheduleData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanleScheduleSetupData: function (message) {
      systemFeed.hanleScheduleTableData(message);
    },
    hanleScheduleTimeData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
      systemFeed.hanleScheduleTableData(message);
    },
    hanleAnalogDisplayData: function (message) {
      channelPage.controlAnglogChValue(message);
    },
    hanleDigitalDisplayData: function (message) {
      channelPage.controlDigitalChnState(message);
    },
    hanlePDCData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanleBPPCBoilerData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanleBPPCProcessData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
      channelPage.controlAnglogChValue(message);
      channelPage.controlDigitalChnState(message);
    },
    hanleBPPCChemicalData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
      channelPage.controlDigitalChnState(message);
    },
    hanleBPPCControlData: function (message) { // livedata
      systemFeed.controlLoopStateAndConfigValid(message);
      channelPage.controlAnglogChValue(message);
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      var msg = message["loop"][loopIndex]["from_bppc"];
      for (var key in msg) {
        if (msg[key] !== "object") {
          jCommon.setHtmlValue(key, msg[key]);
        }
      }
    },
    hanleBPPCTimeData: function (message) {
      var currentPage = jCommon.getCurrentPage();
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      systemFeed.controlLoopStateAndConfigValid(message);
      channelPage.controlAnglogChValue(message);
      channelPage.controlDigitalChnState(message);
      if (currentPage == "bppctimefd") {
        var currentData = message["loop"][loopIndex];
        var nextData = message["loop"][loopIndex + 1];
        var msg = currentData["from_bppc"];
        for (var key in msg) {
          jCommon.setHtmlValue(key, msg[key]);
        }
        if (currentData["signal"] == 1) {
          jCommon.setSvgStyle("high-signal-status", "fill:#09d309");
          jCommon.setSvgText("high-signal-text", "ON");
        } else {
          jCommon.setSvgStyle("high-signal-status", "fill:red");
          jCommon.setSvgText("high-signal-text", "OFF")
        }
        if (nextData["signal"] == 1) {
          jCommon.setSvgStyle("low-signal-status", "fill:#09d309");
          jCommon.setSvgText("low-signal-text", "ON");
        } else {
          jCommon.setSvgStyle("low-signal-status", "fill:red");
          jCommon.setSvgText("low-signal-text", "OFF")
        }
      } else if (currentPage == "bppctime") {
        var currentData = message["loop"][loopIndex];
        var nextData = message["loop"][loopIndex + 1];
        var msg = currentData["from_bppc"];
        for (var key in msg) {
          jCommon.setHtmlValue(key, msg[key]);
        }
      } else if (currentPage == "bppctimechemical") {
        var hiDiChnState = jCommon.getHtmlValue("hiDiChnState");
        var loDiChnState = jCommon.getHtmlValue("loDiChnState");
        if (jCommon.checkBoolenValue(hiDiChnState)) {
          jCommon.setHtmlStyleAttribute("high_level_ch", "fill", "#0BEA0F");
        } else {
          jCommon.setHtmlStyleAttribute("high_level_ch", "fill", "red");
        }
        if (!jCommon.checkBoolenValue(loDiChnState)) {
          jCommon.setHtmlStyleAttribute("low_level_ch", "fill", "red");
          jCommon.setHtmlStyleAttribute("water-level-top", "fill", "transparent");
          jCommon.setHtmlStyleAttribute("water-level-center", "fill", "transparent");
          jCommon.setHtmlStyleAttribute("water-level-bottom", "fill", "transparent");
        } else {
          jCommon.setHtmlStyleAttribute("low_level_ch", "fill", "#0BEA0F");
          jCommon.setHtmlStyleAttribute("water-level-center", "fill", "#00F8F8");
          jCommon.setHtmlStyleAttribute("water-level-bottom", "fill", "#00F8F8");
          if (jCommon.checkBoolenValue(hiDiChnState)) {
            jCommon.setHtmlStyleAttribute("water-level-top", "fill", "#00F8F8");
          } else {
            jCommon.setHtmlStyleAttribute("water-level-top", "fill", "transparent");
          }
        }
      }
    },
    hanleOnOffData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
      jCommon.controlDOMShow("hiWarn");
      jCommon.controlDOMShow("loWarn");
      channelPage.controlAnglogChValue(message);
    },
    hanleOnOffTimeData: function (message) {
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanlePidData: function (message) {
      systemFeed.handlePidLiveData(message, "");
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanlePFCData: function (message) {
      systemFeed.controlLoopStateAndConfigValid(message);
      channelPage.controlAnglogChValue(message);
    },
    hanlePyxisMetaData: function (message) {
      var idxP = jCommon.getUrlParams("idxP");
      // channelPage.controlDigitalChnState(message);
      if (!jCommon.empty(message["probes"])) {
        pyxisControl.handleProbeConnect(message);
        var probesInfo = message["probes"];
        if (!jCommon.empty(probesInfo["diagnose"])) {
          var diagnose = probesInfo["diagnose"];
          var message = [];
          diagnose.forEach(function (item) {
            message.push('<div class="col-md-2 text-center calibration-row">');
            if (item == null) {
              message.push("NAN");
            } else {
              message.push(item);
            }
            message.push('</div>');
          })
          jCommon.setHtmlValue("metadatalist", message.join(""))
        } else {
          jCommon.setHtmlValue("metadatalist", "")
        }
        if (!jCommon.empty(probesInfo["infos"])) {
          var info = probesInfo["infos"][idxP];
          info["alloyFactor"] = info["alloyFactor"] < 0 ? "" : info["alloyFactor"];
          for (var key in info) {
            jCommon.setHtmlValue(key, info[key]);
          }
        }
        if (!jCommon.empty(probesInfo["sensors"])) {
          var sensorValueList = probesInfo["sensors"][idxP];
          var probInfo = channelPage.getPyxisOnlineInfo(idxP);
          var sensorList = channelPage.getPyxisSensorInfoByPN(probInfo["PN"]);
          var readingString = [];
          sensorList.forEach(function (item, index) {
            if (item.name != "runStatus")
              readingString.push('<label class="dom-container">' + item.name + ":" + Number(sensorValueList[index]).toFixed(item.decimal) + " " + item.unit + '</label>')
          })
          jCommon.setHtmlValue("currentReading", readingString.join(","));
        }
        // calibrate result
        if (!jCommon.empty(probesInfo["cmdRet"])) {
          var cmdRetInfo = probesInfo["cmdRet"];
          var disabledStatus = cmdRetInfo["status"] == 1 ? true : false;
          var btnCalibrateList = document.getElementsByClassName("btn-calibrate");
          for (var index = 0; index < btnCalibrateList.length; index++) {
            var elementItem = btnCalibrateList[index];
            elementItem.disabled = disabledStatus;
          }
          jCommon.addHtmlClass("#calibrate-result-container", "hide");
          jCommon.addHtmlClass("#factory-result-container", "hide");
          jCommon.addHtmlClass("#change-result-container", "hide");
          if (cmdRetInfo["status"] == 0) {
            jCommon.setHtmlValue("factory-result", "");
            jCommon.setHtmlValue("calibrate-result", "");
            jCommon.setHtmlValue("change-result", "");
          } else {
            if (Number(cmdRetInfo["lastIndexProbe"]) == Number(idxP)) {
              if (cmdRetInfo["lastCmd"] == "restoreProbe") {
                jCommon.removeHtmlClass("#factory-result-container", "hide");
                jCommon.setHtmlValue("factory-result", cmdRetInfo["errorMsg"])
              } else if (cmdRetInfo["lastCmd"] == "changeAddrProbe") {
                jCommon.removeHtmlClass("#change-result-container", "hide");
                jCommon.setHtmlValue("change-result", cmdRetInfo["errorMsg"])
              } else {
                jCommon.removeHtmlClass("#calibrate-result-container", "hide");
                jCommon.setHtmlValue("calibrate-result", cmdRetInfo["errorMsg"])
              }
            }
          }
        }
      }
    },
    handle3CData: function (message) {
      channelPage.controlAnglogChValue(message);
      msg = message["analyzer_3C"];
      if (!jCommon.empty(msg)) {
        for (var key in msg) {
          if (msg[key] !== "object") {
            jCommon.setHtmlValue(key, msg[key]);
          }
        }
      }
      jCommon.controlDOMShow("status");
      // 3B
      jCommon.setHtmlValue("heaterOnAct3B", message["analyzer_3C"]["B"]["liveData_Base"]["heaterOnAct"]);
      jCommon.setHtmlValue("flowRate3B", message["analyzer_3C"]["B"]["liveData_Base"]["flowRate"]);
      jCommon.setHtmlValue("heaterPowerAct3B", message["analyzer_3C"]["B"]["liveData_Base"]["heaterPowerAct"]);
      jCommon.setHtmlValue("fouling3B", message["analyzer_3C"]["B"]["fouling"]);
      jCommon.setHtmlValue("skinTemp3B", message["analyzer_3C"]["B"]["liveData_Base"]["skinTemp"]);
      jCommon.setHtmlValue("scaleThk3B", message["analyzer_3C"]["B"]["scale_thk_n1"]);
      jCommon.setHtmlValue("biofilmThk3B", message["analyzer_3C"]["B"]["bioFlm_thk_n3"]);
      // 3H
      jCommon.setHtmlValue("heaterOnAct3H", message["analyzer_3C"]["H"]["liveData_Base"]["heaterOnAct"]);
      jCommon.setHtmlValue("flowRate3H", message["analyzer_3C"]["H"]["liveData_Base"]["flowRate"]);
      jCommon.setHtmlValue("heaterPowerAct3H", message["analyzer_3C"]["H"]["liveData_Base"]["heaterPowerAct"]);
      jCommon.setHtmlValue("fouling3H", message["analyzer_3C"]["H"]["fouling"]);
      jCommon.setHtmlValue("skinTemp3H", message["analyzer_3C"]["H"]["liveData_Base"]["skinTemp"]);
      jCommon.setHtmlValue("scaleThk3H", message["analyzer_3C"]["H"]["thickness"]);
      jCommon.setHtmlValue("bulkTemp3B", message["analyzer_3C"]["B"]["liveData_Base"]["bulkTemp"]);
    },
    handle3BData: function (message) {
      // channelPage.controlDigitalChnState(message);
      channelPage.controlAnglogChValue(message)
      if (message["analyzer_3C"]["B"]["liveData_Base"]["zeroCalActive"] === true) {
        jCommon.setHtmlAttribute("zeroCalbtn3b", "disabled", true);
      }
      else {
        jCommon.setHtmlAttribute("zeroCalbtn3b", "disabled", false);
      }
      if (message["analyzer_3C"]["B"]["diagActive"] === true) {
        jCommon.setHtmlAttribute("diagbtn3b", "disabled", true);
      }
      else {
        jCommon.setHtmlAttribute("diagbtn3b", "disabled", false);
      }
      if (message["analyzer_3C"]["B"]["getDiagDataActive"] === true) {
        jCommon.setHtmlAttribute("getDiagbtn3b", "disabled", true);
      }
      else {
        jCommon.setHtmlAttribute("getDiagbtn3b", "disabled", false);
      }
      hanleLiveDataObject.setHtmlValue3B(message);
    },
    setHtmlValue3B: function (message) {
      msg = message["analyzer_3C"]["B"];
      if (!jCommon.empty(msg)) {
        for (var key in msg) {
          if (msg[key] !== "object") {
            jCommon.setHtmlValue(key, msg[key]);
          }
        }
      }
      msg = message["analyzer_3C"]["B"]["liveData_Base"];
      if (!jCommon.empty(msg)) {
        for (var key in msg) {
          if (msg[key] !== "object") {
            jCommon.setHtmlValue(key, msg[key]);
          }
        }
      }
    },
    handle3HData: function (message) {
      // channelPage.controlDigitalChnState(message);
      channelPage.controlAnglogChValue(message)
      if (message["analyzer_3C"]["H"]["liveData_Base"]["zeroCalActive"] === true) {
        jCommon.setHtmlAttribute("zeroCalbtn3h", "disabled", true);
      }
      else {
        jCommon.setHtmlAttribute("zeroCalbtn3h", "disabled", false);
      }
      hanleLiveDataObject.setHtmlValue3H(message);
    },
    setHtmlValue3H: function (message) {
      msg = message["analyzer_3C"]["H"];
      if (!jCommon.empty(msg)) {
        for (var key in msg) {
          if (msg[key] !== "object") {
            jCommon.setHtmlValue(key, msg[key]);
          }
        }
      }
      msg = message["analyzer_3C"]["H"]["liveData_Base"];
      if (!jCommon.empty(msg)) {
        for (var key in msg) {
          if (msg[key] !== "object") {
            jCommon.setHtmlValue(key, msg[key]);
          }
        }
      }
    },
    hanleExportPageData: function (message) {
      var pathList = [];
      var defaultvalue = "";
      var exportcode = message["exportcode"];
      var usbpath = jCommon.empty(message["usbpath"]) ? "" : message["usbpath"].join(",");
      if (jCommon.getHtmlValue("usbpathList") != usbpath) {
        jCommon.setHtmlValue("usbpathList", usbpath);
        if (!jCommon.empty(message["usbpath"])) {
          message["usbpath"].forEach(function (item) {
            pathList.push({
              "value": item, "name": item
            })
          })
          defaultvalue = pathList[0]["value"];
        }
        jCommon.dropDownMenu({
          element: document.getElementById("mediaLabel"),
          choices: pathList,
          defaultvalue: defaultvalue,
        });
      }
      if ([0, 1].indexOf(exportcode) > -1) {
        jCommon.contorlBtnStatus("btn-export", false);
        jCommon.setHtmlValue("export-Result", exportcode == 0 ? 'success' : 'error');
      }
    },
    handlePBCData: function (message) {
      channelPage.controlAnglogChValue(message);
      msg = message["pbc"];
      if (!jCommon.empty(msg)) {
        for (var key in msg) {
          if (msg[key] !== "object") {
            jCommon.setHtmlValue(key, msg[key]);
          }
        }
      }
      msg2 = message["pbc"]["fromPBC"];
      if (!jCommon.empty(msg2)) {
        for (var key in msg2) {
          if (msg2[key] !== "object") {
            jCommon.setHtmlValue(key, msg2[key]);
          }
        }
      }
      var PBCStateList = constVar.getPBCStateList();
      PBCStateList.forEach(function(item){
        if(item.value == msg2["state"]){
          jCommon.setHtmlValue("stateLabel",item.name)
        }
      })
      jCommon.controlDOMShow("status");
    },
    handleAPIDData: function (message) {
      systemFeed.handlePidLiveData(message, "");
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    },
    hanleAPidRTimeData: function (message) {
      systemFeed.handlePidLiveData(message, "");
      channelPage.controlAnglogChValue(message);
      systemFeed.controlLoopStateAndConfigValid(message);
    }
  }

  var ToolstipDialog = {
    hideToolstipDialog: function () {
      jCommon.addHtmlClass("#confirmFooter", "hide");
      jCommon.addHtmlClass("#alertFooter", "hide");
      jCommon.addHtmlClass("#ToolstipDialog", "hide");
    },
    setToolsTipTitleAndMessage: function (title, message) {
      if (title == "") {
        jCommon.addHtmlClass("#alert-title", "hide");
      } else {
        jCommon.removeHtmlClass("#alert-title", "hide");
      }
      document.getElementById("alert-title").innerHTML = title;
      document.getElementById("alert-message").innerHTML = message;
    },
    showAlertToolsTip: function (title, message, callback) {
      var alertDom = document.getElementById("alertOk");
      var alertFunc = function () {
        ToolstipDialog.hideToolstipDialog();
        if (callback) {
          callback();
        }
        removeFunc();
        removeFunc = null;
      }
      var removeFunc = function () {
        alertDom.removeEventListener("mousedown", alertFunc);
        callback = null;
        alertFunc = null;
        alertDom = null;
      }
      ToolstipDialog.setToolsTipTitleAndMessage(title, message);
      jCommon.addHtmlClass("#confirmFooter", "hide");
      jCommon.removeHtmlClass("#alertFooter", "hide");
      jCommon.removeHtmlClass("#ToolstipDialog", "hide");
      alertDom.addEventListener("mousedown", alertFunc);
    },
    showConfirmToolsTip: function (title, message, confirmCallback, cancelCallBack, confirmLabel) {
      var confirmDom = document.getElementById("confirmOk");
      var cancelDom = document.getElementById("confirmCancel");
      if (!jCommon.empty(confirmLabel)) {
        jCommon.setHtmlValue("confirmOk", confirmLabel)
      }
      var removeFunc = function () {
        confirmDom.removeEventListener("mousedown", confirmFunc);
        cancelDom.removeEventListener("mousedown", cancelFunc);
        cancelCallBack = null;
        confirmCallback = null;
        confirmFunc = null;
        confirmDom = null;
        cancelFunc = null;
        cancelDom = null;
      }
      var confirmFunc = function () {
        ToolstipDialog.hideToolstipDialog();
        if (confirmCallback) {
          confirmCallback();
        }
        removeFunc();
        removeFunc = null;
      }
      var cancelFunc = function () {
        ToolstipDialog.hideToolstipDialog();
        if (cancelCallBack) {
          cancelCallBack();
        }
        removeFunc();
        removeFunc = null;
      }
      ToolstipDialog.setToolsTipTitleAndMessage(title, message);
      jCommon.addHtmlClass("alertFooter", "hide");
      jCommon.removeHtmlClass("#confirmFooter", "hide");
      jCommon.removeHtmlClass("#ToolstipDialog", "hide");
      confirmDom.addEventListener("mousedown", confirmFunc);
      cancelDom.addEventListener("mousedown", cancelFunc);
    }
  }

  var userlogin = {
    userlogin: function () {
      jCommon.setHtmlValue("username-error-messsage", "");
      jCommon.setHtmlValue("password-error-messsage", "");
      var username = document.getElementById("UserName").value;
      var password = document.getElementById("Password").value;
      if (jCommon.empty(username)) {
        jCommon.setHtmlValue("username-error-messsage", "UserName is not empty")
        return false;
      }
      if (jCommon.empty(password)) {
        jCommon.setHtmlValue("password-error-messsage", "Password is not empty")
        return false;
      }
      var pdata = {};
      pdata.username = username;
      pdata.password = hex_md5(password);
      cmdlist.login(pdata, function (message) {
        if (message.status > 0) {
          jCommon.setLocalStorge("user_account", message.roleType);
          jCommon.setLocalStorge("loginstart", (new Date()).getTime());
          jCommon.setLocalStorge("username", username);
          window.top.location.reload();
        } else {
          jCommon.setHtmlValue("password-error-messsage", "Error UserName or Error Password");
        }
      })
    },
    loginDialogCallback: function (event) {
      repeatAllPage.clearEventClick(event);
      if (event.target.id === "btn-cancel-login") {
        jCommon.addHtmlClass("#logindialog", "hide");
      } else if (event.target.id === "btn-login") {
        userlogin.userlogin();
      }
    },
    checkUserLoginIsExpire: function () {
      var is_expired = false;
      var current_time = (new Date()).getTime();
      var loginstart = jCommon.getLocalStorge("loginstart");
      var diff_time = current_time - loginstart;
      if (diff_time > 3600000) {
        is_expired = true;
      }
      return is_expired;
    },
    expireLoginOut: function () {
      userlogin.removeExpireLogin();
      document.getElementById("visiableUserName").innerHTML = userlogin.getVisiableUserName();
    },
    removeExpireLogin: function () {
      jCommon.removeLocalStorge("user_account");
      jCommon.removeLocalStorge("loginstart");
    },
    getVisiableUserName: function () {
      var data = {};
      data[1] = "Oper";
      data[2] = "Actmgr";
      data[3] = "Admin";
      if (jCommon.empty(jCommon.getLocalStorge("user_account")) || jCommon.empty(data[jCommon.getLocalStorge("user_account")])) {
        if (!jCommon.empty(jCommon.getLocalStorge("user_account"))) {
          userlogin.removeExpireLogin();
        }
        return "Login";
      } else {
        return data[jCommon.getLocalStorge("user_account")]
      }
    },
    showLoginDialog: function () {
      if (jCommon.empty(jCommon.getLocalStorge("user_account"))) {
        if (!jCommon.empty(jCommon.getLocalStorge("username"))) {
          document.getElementById("UserName").value = jCommon.getLocalStorge("username");
        }
        jCommon.removeHtmlClass("#logindialog", "hide");
      } else {
        ToolstipDialog.showConfirmToolsTip("", "Are you sure you want to quit?", function () {
          userlogin.removeLoginState();
          window.location.href = "/startup.html?remote=" + jCommon.getLocalStorge("remote");
        })
      }
    },
    btnLoginClick: function (domItem) {
      var hash = domItem.getAttribute("data-href");
      var user_account = jCommon.getLocalStorge("user_account");
      if (domItem.className.indexOf("btn-login") > -1 && (jCommon.empty(user_account) || user_account == 1)) {
        return false;
      } else if (!jCommon.empty(hash)) {
        window.location.hash = "#" + hash;
      }
    },
    initSystemAndRtDisplay: function (message, prefix) {
      var controlOverview = false;
      var systemList = message["systems"];
      var rtDisplay = message["setup"]["rtDisplay"];
      var systemRuntimeCount = 0;
      for (var index = 0; index < systemList.length; index++) {
        var item = systemList[index];
        var systemId = Number(index + 1);
        var systemTitle = jCommon.empty(item["name"]) ? "System" + systemId : item["name"];
        jCommon.setHtmlValue(prefix + "system" + systemId, systemTitle);
        jCommon.setHtmlValue(prefix + "config-system" + systemId, systemTitle);
        jCommon.setHtmlAttribute(prefix + "config-system" + systemId, "data-href", "systemconfig&sys=" + systemId + "&name=" + systemTitle);
        if (item["feedNum"]) {
          controlOverview = true;
          jCommon.setHtmlAttribute(prefix + "system" + systemId, "data-href", "system&sys=" + systemId + "&name=" + systemTitle);
          jCommon.setHtmlAttribute(prefix + "system" + systemId, "disabled", false);
        } else {
          systemRuntimeCount++;
          jCommon.setHtmlAttribute(prefix + "system" + systemId, "disabled", true);
        }
      }
      if (systemRuntimeCount < systemList.length) {
        jCommon.setHtmlAttribute(prefix + "system", "disabled", false);
      } else {
        jCommon.setHtmlAttribute(prefix + "system", "disabled", true);
      }
      systemRuntimeCount = 0;
      for (var key in rtDisplay) {
        if (!jCommon.getHtmlAttriute(prefix + key, "disabled")) {
          if (key.startsWith("system") && rtDisplay[key]) {
            systemRuntimeCount++;
          }
          if (rtDisplay[key]) {
            jCommon.addHtmlClass("#" + prefix + key, "btn-login");
          } else {
            jCommon.removeHtmlClass("#" + prefix + key, "btn-login");
          }
        }
      }
      if (systemRuntimeCount > 0) {
        jCommon.addHtmlClass("#" + prefix + "system", "btn-login");
      } else {
        jCommon.removeHtmlClass("#" + prefix + "system", "btn-login");
      }
      if (rtDisplay["analog"]) {
        jCommon.addHtmlClass("." + prefix + "analog", "btn-login");
      } else {
        jCommon.removeHtmlClass("." + prefix + "analog", "btn-login");
      }
      if (rtDisplay["digital"]) {
        jCommon.addHtmlClass("." + prefix + "digital", "btn-login");
      } else {
        jCommon.removeHtmlClass("." + prefix + "digital", "btn-login");
      }
      if (rtDisplay["analog"] && rtDisplay["digital"]) {
        jCommon.addHtmlClass("#" + prefix + "display", "btn-login");
      } else {
        jCommon.removeHtmlClass("#" + prefix + "display", "btn-login");
      }
      return controlOverview;
    },
    removeLoginState: function () {
      jCommon.removeLocalStorge("user_account");
      jCommon.removeLocalStorge("loginstart");
    }
  }

  var pageNavigate = {
    currentStep: 1,
    getPage: function (pageFlag) {
      var channelpage = jCommon.getHtmlValue("pageNum");
      var lastPageNumber = Number(jCommon.getHtmlAttriute("pageNum", "data-max"));
      switch (pageFlag) {
        case "btnFirstPage":
          channelpage = 1;
          break;
        case "btnPrePage":
          channelpage--;
          break;
        case "btnNextPage":
          channelpage++;
          break;
        case "btnLastPage":
          channelpage = lastPageNumber;
          break;
      }
      return channelpage;
    },
    controlPageState: function () {
      var channelpage = Number(jCommon.getHtmlValue("pageNum"));
      var lastPageNumber = Number(jCommon.getHtmlAttriute("pageNum", "data-max"));
      if (channelpage === 1) {
        jCommon.setHtmlAttribute("btnFirstPage", "disabled", true);
        jCommon.setHtmlAttribute("btnPrePage", "disabled", true);
      } else {
        jCommon.setHtmlAttribute("btnFirstPage", "disabled", false);
        jCommon.setHtmlAttribute("btnPrePage", "disabled", false);
      }
      if (channelpage === lastPageNumber) {
        jCommon.setHtmlAttribute("btnNextPage", "disabled", true);
        jCommon.setHtmlAttribute("btnLastPage", "disabled", true);
      } else {
        jCommon.setHtmlAttribute("btnNextPage", "disabled", false);
        jCommon.setHtmlAttribute("btnLastPage", "disabled", false);
      }
    },
    goToStep: function (targetStep) {
      if (targetStep === "step-two") {
        pageNavigate.currentStep = 2;
        jCommon.addHtmlClass("#step-one", "hide");
        jCommon.removeHtmlClass("#step-two", "hide");
      } else {
        pageNavigate.currentStep = 1;
        jCommon.removeHtmlClass("#step-one", "hide");
        jCommon.addHtmlClass("#step-two", "hide");
      }
    },
    setStep: function () {
      if (pageNavigate.currentStep === 2) {
        jCommon.addHtmlClass("#step-one", "hide");
        jCommon.removeHtmlClass("#step-two", "hide");
      } else {
        jCommon.removeHtmlClass("#step-one", "hide");
        jCommon.addHtmlClass("#step-two", "hide");
      }
    },
    redirect: function (event) {
      event.stopPropagation();
      if (jCommon.empty(event.target.id)) {
        return;
      }
      var currentPageName = jCommon.getCurrentPage();
      var channelId = pageNavigate.getPage(event.target.id);
      window.location.hash = currentPageName + "&p=" + channelId;
    },
    rowAndPageClick: function (domId, limit, lastCurrentIndex, itemHeight) {
      var topCurrentIndex = jCommon.getHtmlValue("topCurrentIndex");
      switch (domId) {
        case "lastPage":
          topCurrentIndex = topCurrentIndex - limit;
          break;
        case "lastItem":
          topCurrentIndex--;
          break;
        case "nextItem":
          topCurrentIndex++;
          break;
        case "nextPage":
          topCurrentIndex = topCurrentIndex + limit;
          break;
      }
      if (topCurrentIndex < 0) {
        topCurrentIndex = 0;
      } else if (topCurrentIndex > lastCurrentIndex) {
        topCurrentIndex = lastCurrentIndex;
      }
      jCommon.setHtmlValue("topCurrentIndex", topCurrentIndex)
      return "-" + itemHeight * topCurrentIndex + "px";
    },
    redirectPage: function (event) {
      event.stopPropagation();
      var hash = event.target.getAttribute("href");
      if (!jCommon.empty(hash)) {
        window.location.hash = "#" + hash;
      }
    }
  }

  var channelPage = {
    channelConfig: null,
    getChannelInputLabel: function (channelType, channel) {
      var channTypeInfo = {
        1: "ai",
        2: "ao",
        3: "aint",
        4: "afb",
        5: "di",
        6: "do",
        7: "dint",
        8: "dfb"
      };
      if (Number(channelType) === 0) {
        return "";
      } else {
        return channTypeInfo[channelType] + "-" + channel;
      }
    },
    initChannelInput: function (elementId, channelType, channelValue, type, callbackfun, disabled) {
      if (type === "analog") {
        new jCommon.channelInput({
          element: document.getElementById(elementId + "AnalogLabel"),
          defaultvalue: channelType + "-" + channelValue,
          callback: channelPage.initChannelInputCallback.bind(this, callbackfun)
        }, type, disabled);
      } else if (type === "analog-digital") {
        new jCommon.channelInput({
          element: document.getElementById(elementId + "AnalogLabel"),
          defaultvalue: channelType + "-" + channelValue,
          callback: channelPage.initChannelInputCallback.bind(this, callbackfun)
        }, "analog", disabled);
        new jCommon.channelInput({
          element: document.getElementById(elementId + "DigitalLabel"),
          defaultvalue: channelType + "-" + channelValue,
          callback: channelPage.initChannelInputCallback.bind(this, callbackfun)
        }, "", disabled);
      } else {
        new jCommon.channelInput({
          element: document.getElementById(elementId + "DigitalLabel"),
          defaultvalue: channelType + "-" + channelValue,
          callback: channelPage.initChannelInputCallback.bind(this, callbackfun)
        }, type, disabled);
      }
      channelPage.setChannelConfig(channelType, channelValue, elementId);
      jCommon.controlDOMShow(elementId);
    },
    initChannelInputCallback: function (callbackfun, value, id) {
      systemFeed.positionTypeChannelCallback(value, id);
      if (callbackfun) {
        callbackfun();
      }
    },
    updateChannelConfig: function (key, value) {
      var list = key.split("/");
      var keyName = constVar.getRevertChannelThumbnail(list[1]);
      channelPage.channelConfig[keyName][list[2]][list[3]] = value;
    },
    setChannelInfo: function (message) {
      if (!jCommon.empty(message)) {
        channelPage.channelConfig = {
          1: message["ais"],
          2: message["aos"],
          3: message["aitns"],
          4: message["afbs"],
          5: message["dis"],
          6: message["dos"],
          7: message["ditns"],
          8: message["dfbs"],
        };
      }
    },
    getChannelKeyLength: function (index) {
      if (jCommon.empty(channelPage.channelConfig[index])) {
        return 0;
      } else {
        return channelPage.channelConfig[index].length;
      }
    },
    getChannelInfo: function (type, channelId, key) {
      var channelConfig = channelPage.channelConfig;
      if (!jCommon.empty(channelConfig) && !jCommon.empty(channelConfig[type]) && !jCommon.empty(channelConfig[type][channelId - 1])) {
        if (jCommon.empty(key)) {
          channelConfig[type][channelId - 1]["chType"] = type;
          channelConfig[type][channelId - 1]["chValue"] = channelId;
          return channelConfig[type][channelId - 1];
        } else {
          return channelConfig[type][channelId - 1][key];
        }
      } else {
        return ""
      }
    },
    setChannelConfig: function (channelType, channelId, elementId) {
      var configName = (channelType === 0 || channelId === 0) ? "" : "Config";
      var baseUnit = 0;
      var timeUnit = 0;
      var unitLabel = "";
      var objectInfo = constVar.getChannelDataKey();
      var simData = "";
      var engMin = "";
      var engMax = "";
      var saveProperty = "";
      var info = channelPage.getChannelInfo(channelType, channelId);
      if (!jCommon.empty(info)) {
        baseUnit = info["baseUnit"];
        timeUnit = info["timeUnit"];
        unitLabel = channelPage.getChannelUnitLabel(info);
        if (typeof info["simData_OP"] !== undefined) {
          simData = typeof info["simData_OP"] !== undefined ? info["simData_OP"] : "";
          engMin = typeof info["engMin"] !== undefined ? info["engMin"] : "";
          engMax = typeof info["engMax"] !== undefined ? info["engMax"] : "";
          saveProperty = typeof objectInfo[channelType] !== undefined ? "/" + objectInfo[channelType] + "/" + (channelId - 1) + "/simData_OP" : "";
          jCommon.setHtmlValue(elementId + "-simData_OP", info["simData_OP"]);
        }
        if (typeof info["simEn"] !== undefined) {
          jCommon.setHtmlValue(elementId + "-simEn", info["simEn"]);
          jCommon.controlDOMShow(elementId + "-simEn")
        }
      }
      if (!jCommon.empty(info) && typeof info["name"] !== undefined && info["name"] !== "") {
        configName = info["name"];
        jCommon.setHtmlValue(elementId + "-isConfigName", true);
      } else {
        jCommon.setHtmlValue(elementId + "-isConfigName", false);
      }
      jCommon.setHtmlValue(elementId + "-baseUnit", baseUnit);
      jCommon.controlDOMShow(elementId + "-baseUnit");
      jCommon.setHtmlValue(elementId + "-timeUnit", timeUnit);
      jCommon.controlDOMShow(elementId + "-timeUnit");
      jCommon.setClassListValue(elementId + "-simDataUnit", unitLabel);
      //button and alink
      jCommon.setHtmlValue(elementId + "-ConfigName", configName);
      jCommon.setHtmlAttribute(elementId + "-ConfigName", "href", "#" + channelPage.getChannelPageUrl(channelType, channelId));
      //label
      jCommon.setHtmlValue(elementId + "-LabelName", configName);
      jCommon.setHtmlValue(elementId + "-simData", simData);
      jCommon.setHtmlAttribute(elementId + "-simData", "data-min", engMin);
      jCommon.setHtmlAttribute(elementId, "data-value-name", constVar.distinguishAnalogOrDigital(channelType));
      jCommon.setHtmlClassAttribute(elementId + "-simData", "data-min", engMin);
      jCommon.setHtmlAttribute(elementId + "-simData", "data-max", engMax);
      jCommon.setHtmlClassAttribute(elementId + "-simData", "data-max", engMax);
      jCommon.setDataSaveProperty(elementId + "-simData", saveProperty);
      jCommon.setDataSaveProperty(elementId + "-simData_OP", saveProperty);
      jCommon.setHtmlValue(elementId + "-min", engMin);
      jCommon.setHtmlValue(elementId + "-max", engMax);
      jCommon.setHtmlValue(elementId + "-liveDataLabel", "");
      jCommon.setHtmlValue(elementId + "-configValid", false);
      jCommon.controlDOMShow(elementId + "-configValid");
      jCommon.setHtmlStyleAttribute(elementId + "-progress", "width", "0%");
    },
    getChannelUnitLabel: function (info) {
      if (info["chType"] == 2) {
        //ao
        return "%";
      }
      var list = [];
      var baseUnitLabel = "";
      var timeUnitLabel = "";
      var unitLabel = "";
      if (!jCommon.empty(info)) {
        if (jCommon.empty(info["metricFlag"])) {
          list = constVar.getImpUnits();
          list.forEach(function (item) {
            if (item["value"] === info["baseUnit"] && info["baseUnit"] !== 0) {
              baseUnitLabel = item["name"];
            }
          })
        } else {
          list = constVar.getMetricUnit();
          list.forEach(function (item) {
            if (item["value"] === info["baseUnit"] && info["baseUnit"] !== 100) {
              baseUnitLabel = item["name"];
            }
          })
        }
        list = constVar.getTimeUnits();
        list.forEach(function (item) {
          if (item["value"] === info["timeUnit"] && info["timeUnit"] !== 0) {
            timeUnitLabel = item["name"];
          }
        })
        if (!jCommon.empty(baseUnitLabel) || !jCommon.empty(timeUnitLabel)) {
          unitLabel = jCommon.empty(timeUnitLabel) ? baseUnitLabel : baseUnitLabel + "/" + timeUnitLabel;
        }
      }
      return unitLabel;
    },
    setChannelTypeAndValueAndConfig: function (elementId, channelType, channelId) {
      jCommon.setHtmlValue(elementId + "Type", channelType);
      jCommon.setHtmlValue(elementId, channelId);
      channelPage.setChannelConfig(channelType, channelId, elementId);
      jCommon.controlDOMShow(elementId);
    },
    getDropDownDataConfig: function (item, key) {
      var dropDowList = {
        "signalType": {
          "data": constVar.getSignalType(jCommon.getCurrentPage()),
          "defaultkey": "signalType"
        },
        "metricUnit": {
          "data": constVar.getMetricUnit(),
          "defaultkey": "baseUnit"
        },
        "imperialUnit": {
          "data": constVar.getImpUnits(),
          "defaultkey": "baseUnit"
        },
        "timeUnit": {
          "data": constVar.getTimeUnits(),
          "defaultkey": "timeUnit"
        },
        "alarmEn": {
          "data": constVar.getAlarmStatus(),
          "defaultkey": "alarm/alarmEn"
        },
      };
      if (jCommon.empty(item) && jCommon.empty(key)) {
        return dropDowList;
      } else {
        if (!jCommon.empty(item)) {
          if (jCommon.empty(key)) {
            return dropDowList[item];
          } else {
            return dropDowList[item][key];
          }
        } else {
          return false;
        }
      }
    },
    getChannelPageUrl: function (keyId, page) {
      var info = {
        1: "aichannel",
        2: "aochannel",
        3: "aintchannel",
        4: "afbchannel",
        5: "dichannel",
        6: "dochannel",
        7: "dintchannel",
        8: "dfbchannel",
      };
      return info[keyId] + "&p=" + page;
    },
    getChannelKeyIndex: function (key) {
      var page = Number(jCommon.getUrlParams("p"));
      var currentPage = jCommon.getCurrentPage();
      var pageKeyInfo = {
        "aichannel": "ais",
        "aochannel": "aos",
        "afbchannel": "afbs",
        "aintchannel": "aitns",
        "dichannel": "dis",
        "dochannel": "dos",
        "dfbchannel": "dfbs",
        "dintchannel": "ditns"
      };
      var info = {
        "pageKey": pageKeyInfo[currentPage],
        "currentIndex": page - 1
      };
      if (jCommon.empty(key)) {
        return info;
      } else {
        return info[key];
      }
    },
    controlDigitalChnState: function (message) {
      var inputDigitalChDomList = document.querySelectorAll('input[data-value-name="value-name-digital"]');
      var keyObjectInfo = constVar.getChannelDataKey();
      for (var digitalIndex = 0; digitalIndex < inputDigitalChDomList.length; digitalIndex++) {
        var inputDigitalItem = inputDigitalChDomList[digitalIndex];
        var digitaltype = jCommon.getHtmlValue(inputDigitalItem.id + "Type");
        var digitalch = jCommon.getHtmlValue(inputDigitalItem.id);
        var digitaltypeName = keyObjectInfo[digitaltype];
        var alarmWarningDomId = inputDigitalItem.id + "-alarmWarning";
        var StateDomId = inputDigitalItem.id + "State";
        var configValidDomId = inputDigitalItem.id + "-configValid";
        if (!jCommon.empty(message[digitaltypeName]) && !jCommon.empty(message[digitaltypeName][digitalch - 1])) {
          var currentDigitalData = message[digitaltypeName][digitalch - 1];
          if (currentDigitalData["alarm"]) {
            jCommon.setHtmlValue(alarmWarningDomId, 2);
          }
          if (currentDigitalData["warn"]) {
            jCommon.setHtmlValue(alarmWarningDomId, 1);
          }
          jCommon.controlDOMShow(alarmWarningDomId);
          jCommon.setHtmlValue(StateDomId, currentDigitalData["state"]);
          jCommon.controlDOMShow(StateDomId);
          jCommon.setHtmlValue(configValidDomId, currentDigitalData["configValid"]);
          jCommon.controlDOMShow(configValidDomId);
        }
      }
    },
    controlAnglogChValue: function (message) {
      var inputAnalogChDomList = document.querySelectorAll('input[data-value-name="value-name-analog"]');
      var keyObjectInfo = constVar.getChannelDataKey();
      for (var analogIndex = 0; analogIndex < inputAnalogChDomList.length; analogIndex++) {
        var inputAnalogItem = inputAnalogChDomList[analogIndex];
        var analogTypeKey = jCommon.getHtmlValue(inputAnalogItem.id + "Type");
        var analogch = jCommon.getHtmlValue(inputAnalogItem.id);
        var analogTypeName = keyObjectInfo[analogTypeKey];
        var channInfo = channelPage.getChannelInfo(analogTypeKey, analogch);
        var liveDataDomId = inputAnalogItem.id + "-liveDataLabel";
        var simDataDomId = inputAnalogItem.id + "-simData";
        var configValidDomId = inputAnalogItem.id + "-configValid";
        var progressDomId = inputAnalogItem.id + "-progress";
        if (!jCommon.empty(channInfo)) {
          var currentAnalogData = message[analogTypeName][analogch - 1];
          var progressValue = 0;
          if (!jCommon.empty(channInfo["engMax"])) {
            progressValue = Number(currentAnalogData["data"] / channInfo["engMax"] * 100).toFixed(0);
          }
          if (jCommon.checkClassNameExits(liveDataDomId, "alarm-status")) {
            jCommon.removeHtmlClass("#" + liveDataDomId, "message-warning");
            jCommon.removeHtmlClass("#" + liveDataDomId, "message-alarm");
            if (currentAnalogData["hiAlarm"] || currentAnalogData["loAlarm"]) {
              jCommon.addHtmlClass("#" + liveDataDomId, "message-alarm");
            } else if (currentAnalogData["hiWarn"] || currentAnalogData["loWarn"]) {
              jCommon.addHtmlClass("#" + liveDataDomId, "message-warning");
            }
          }
          jCommon.setHtmlValue(liveDataDomId, currentAnalogData["data"]);
          if (jCommon.checkClassNameExits(simDataDomId, "alarm-status")) {
            jCommon.removeHtmlClass("#" + simDataDomId, "message-warning");
            jCommon.removeHtmlClass("#" + simDataDomId, "message-alarm");
            if (currentAnalogData["hiAlarm"] || currentAnalogData["loAlarm"]) {
              jCommon.addHtmlClass("#" + simDataDomId, "message-alarm");
            } else if (currentAnalogData["hiWarn"] || currentAnalogData["loWarn"]) {
              jCommon.addHtmlClass("#" + simDataDomId, "message-warning");
            }
          }
          jCommon.setHtmlValue(simDataDomId, currentAnalogData["data"]);
          jCommon.setHtmlValue(configValidDomId, currentAnalogData["configValid"]);
          jCommon.controlDOMShow(configValidDomId);
          jCommon.controlDOMShow(inputAnalogItem.id + "-isConfigName");
          jCommon.setHtmlStyleAttribute(progressDomId, "width", progressValue + "%");
          jCommon.removeHtmlClass("#" + progressDomId, "progress-alarm");
          jCommon.removeHtmlClass("#" + progressDomId, "progress-warning");
          if (currentAnalogData["hiAlarm"] || currentAnalogData["loAlarm"]) {
            jCommon.addHtmlClass("#" + progressDomId, "progress-alarm");
          } else if (currentAnalogData["hiWarn"] || currentAnalogData["loWarn"]) {
            jCommon.addHtmlClass("#" + progressDomId, "progress-warning");
          } else {
            jCommon.addHtmlClass("#" + progressDomId, "progress-normal");
          }
        }
      }
    },
    setAFBOperationConfig: function (operation) {
      var input1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29];
      var input1DataTypeDisable = [17, 18, 19, 23, 26];
      var input2 = [1, 2, 3, 4, 10, 11, 12, 13, 22, 25, 26, 28];
      var input3 = [1, 2, 3, 4, 12, 13, 22, 25, 26, 28];
      var input4 = [1, 2, 3, 4, 12, 13, 25, 26, 28];
      var inputNote = [1, 2, 3, 4, 11, 12, 13, 17, 18, 19, 22];
      var avgReset = [20, 21];
      var selectorNote = [22];
      if (input1.indexOf(operation) > -1) {
        jCommon.setHtmlValue("input1Value", true);
        if (input1DataTypeDisable.indexOf(operation) > -1) {
          jCommon.setHtmlAttribute("input1-dataType", "disabled", true);
        } else {
          jCommon.setHtmlAttribute("input1-dataType", "disabled", false);
        }
      } else {
        jCommon.setHtmlValue("input1Value", false);
      }
      jCommon.controlDOMShow("input1Value");
      if (input2.indexOf(operation) > -1) {
        jCommon.setHtmlValue("input2Value", true);
        if ([26].indexOf(operation) > -1) {
          jCommon.setHtmlAttribute("input2-dataType", "data-label-range", "Channel,State");
          jCommon.setHtmlAttribute("input2-dataType", "data-value-range", "1,3");
        } else {
          jCommon.setHtmlAttribute("input2-dataType", "data-label-range", "Channel,Constant");
          jCommon.setHtmlAttribute("input2-dataType", "data-value-range", "1,2");
        }
      } else {
        jCommon.setHtmlValue("input2Value", false);
      }
      jCommon.controlDOMShow("input2Value");
      if (input3.indexOf(operation) > -1) {
        jCommon.setHtmlValue("input3Value", true);
        if ([22, 25, 26].indexOf(operation) > -1) {
          jCommon.setHtmlAttribute("input3-dataType", "data-label-range", "Channel,State");
          jCommon.setHtmlAttribute("input3-dataType", "data-value-range", "1,3");
        } else {
          jCommon.setHtmlAttribute("input3-dataType", "data-label-range", "Channel,Constant");
          jCommon.setHtmlAttribute("input3-dataType", "data-value-range", "1,2");
        }
      } else {
        jCommon.setHtmlValue("input3Value", false);
      }
      jCommon.controlDOMShow("input3Value");
      if (input4.indexOf(operation) > -1) {
        jCommon.setHtmlValue("input4Value", true);
        if ([25, 26].indexOf(operation) > -1) {
          jCommon.setHtmlAttribute("input4-dataType", "data-label-range", "Channel,State");
          jCommon.setHtmlAttribute("input4-dataType", "data-value-range", "1,3");
        } else {
          jCommon.setHtmlAttribute("input4-dataType", "data-label-range", "Channel,Constant");
          jCommon.setHtmlAttribute("input4-dataType", "data-value-range", "1,2");
        }
      } else {
        jCommon.setHtmlValue("input4Value", false);
      }
      jCommon.controlDOMShow("input4Value");
      if (inputNote.indexOf(operation) > -1) {
        if ([17, 18, 19].indexOf(operation) > -1) {
          jCommon.setHtmlValue("inputNoteValueContent", "Note:Input1 Channel must have eng unit with a time unit for totalling to work");
        } else {
          jCommon.setHtmlValue("inputNoteValueContent", "Note:All Inputs and outputs must have the same engineering units");
        }
        jCommon.setHtmlValue("inputNoteValue", true);
      } else {
        jCommon.setHtmlValue("inputNoteValue", false);
      }
      jCommon.controlDOMShow("inputNoteValue");
      if (avgReset.indexOf(operation) > -1) {
        jCommon.setHtmlValue("avgResetValue", true);
      } else {
        jCommon.setHtmlValue("avgResetValue", false);
      }
      jCommon.controlDOMShow("avgResetValue");
      if (selectorNote.indexOf(operation) > -1) {
        jCommon.setHtmlValue("selectorNoteValue", true);
      } else {
        jCommon.setHtmlValue("selectorNoteValue", false);
      }
      jCommon.controlDOMShow("selectorNoteValue");
      jCommon.setHtmlValue("defaultOpValue", operation);
      jCommon.controlDOMShow("defaultOpValue");
      if (operation === 28) {
        if (jCommon.getHtmlValue("metricFlag")) {
          jCommon.setDropDownMenuDisabled("metricUnitLabel", true);
        } else {
          jCommon.setDropDownMenuDisabled("imperialUnitLabel", true);
        }
      }
    },
    setDFBOperationConfig: function () {
      var operation = jCommon.getHtmlValue("operation");
      var boolnOps = jCommon.getHtmlValue("boolnOps");
      var input1 = [1, 2];
      var input2 = [1, 2];
      var input3 = [2];
      var input4 = [2];
      if (input1.indexOf(operation) > -1) {
        jCommon.setHtmlValue("input1Value", true);
      } else {
        jCommon.setHtmlValue("input1Value", false);
      }
      jCommon.controlDOMShow("input1Value");
      if (input2.indexOf(operation) > -1) {
        if (operation === 1 || (operation === 2 && boolnOps !== 5) && (operation === 2 && boolnOps !== 7)) {
          jCommon.setHtmlValue("input2Value", true);
        } else {
          jCommon.setHtmlValue("input2Value", false);
        }
      } else {
        jCommon.setHtmlValue("input2Value", false);
      }
      jCommon.controlDOMShow("input2Value");
      if (input3.indexOf(operation) > -1 && boolnOps < 5) {
        jCommon.setHtmlValue("input3Value", true);
      } else {
        jCommon.setHtmlValue("input3Value", false);
      }
      jCommon.controlDOMShow("input3Value");
      if (input4.indexOf(operation) > -1 && boolnOps < 5) {
        jCommon.setHtmlValue("input4Value", true);
      } else {
        jCommon.setHtmlValue("input4Value", false);
      }
      jCommon.controlDOMShow("input4Value");
      jCommon.setHtmlValue("defaultOpValue", operation);
      jCommon.controlDOMShow("defaultOpValue");
    },
    controlDigitalState: function (domId) {
      var state = jCommon.getHtmlValue(domId);
      if (document.getElementById(domId) && document.getElementById(domId).className.indexOf("digital-status") > -1) {
        if (jCommon.empty(state)) {
          jCommon.removeHtmlClass("#" + domId, "digital-On");
          jCommon.addHtmlClass("#" + domId, "digital-Off");
        } else {
          jCommon.removeHtmlClass("#" + domId, "digital-Off");
          jCommon.addHtmlClass("#" + domId, "digital-On");
        }
      }
    },
    getPyxisOnlineInfo: function (idxProbe) {
      var info = {};
      repeatAllPage.parameterData.probes["onlines"].forEach(function (item, index) {
        if (idxProbe == index) {
          info = item;
        }
      });
      return info;
    },
    getPyxisLastCalibrateList: function () {
      var model = jCommon.getHtmlValue("ModelName");
      var modbusAddr = jCommon.getHtmlValue("ModbusAddr");
      if (!jCommon.empty(repeatAllPage.parameterData.probes["lastCalibTime_OP"]) && !jCommon.empty(model) && !jCommon.empty(modbusAddr)) {
        return repeatAllPage.parameterData.probes["lastCalibTime_OP"][model + "." + modbusAddr];
      } else {
        return [];
      }
    },
    getPyxisSensorInfoByPN: function (PN, key, filterEmpty) {
      var info = {};
      var probeTypeList = repeatAllPage.parameterData.probeTypes;
      probeTypeList.forEach(function (item) {
        var sensorsList = [];
        item.sensors.forEach(function (citem) {
          // if(!jCommon.empty(citem.calbs)){
          if (jCommon.empty(key)) {
            sensorsList.push(citem);
          } else {
            sensorsList.push(citem[key]);
          }
          // }
        })
        if (filterEmpty) {
          info[item.PN] = sensorsList.filter(function (citem) {
            return !jCommon.empty(citem.calbs);
          })
        } else {
          info[item.PN] = sensorsList;
        }

      })
      if (jCommon.empty(PN)) {
        return info;
      } else {
        return info[PN];
      }
    },
    getPyxisPNBaseInfo: function (PN, key) {
      var info = {};
      var probeTypeList = repeatAllPage.parameterData.probeTypes;
      probeTypeList.forEach(function (item) {
        if (item.PN == PN) {
          info = item;
        }
      })
      if (jCommon.empty(key)) {
        return info;
      } else {
        return info[key];
      }
    }
  }

  var dyGraphConfig = {
    getDyGraphColor: function () {
      return [
        "#A6CAED", "#179EBD", "#F5BF89", "#B295FC", "#FEE233", "#8BBDEB", "#D0ED85", "#FD7222", "#2BFD2F", "#99E8E7", "#DADBE3", "#8BBD02", "#38BA93", "#FCAEE9", "#E6CD9E", "#EF73FA"
      ];
    },
    getDyGraphConfig: function () {
      return {
        drawPoints: false,
        showRoller: false,
        valueRange: [], //minValue maxValue
        colors: dyGraphConfig.getDyGraphColor(),
        width: 1100, //chart width
        height: 570, //chart height
        labels: ['Time', 'Random1', 'Random2'],
        series: {},
        showLabelsOnHighlight: false,
        dateWindow: null,
        highlightCircleSize: 1,
        showRangeSelector: true,
        rangeSelectorHeight: 0,
        clickCallback: null,
        axes: {}
      };
    },
  }

  var trendPage = {
    dyGraphClickCallback: function (event, x, points) {
      jCommon.removeHtmlClass("#toolTipLine", "hide");
      jCommon.removeHtmlClass("#toolTipXValue", "hide");
      var scales = this.getOption("customScales");
      var minScales = this.getOption("customMinScales");
      var canvasWidth = this.canvas_.clientWidth;
      var canvasHeight = this.canvas_.clientHeight;
      var tooltipLine = document.getElementById("toolTipLine");
      tooltipLine.style.left = event.offsetX + "px";
      tooltipLine.style.height = canvasHeight + "px";
      var toolTipXValue = document.getElementById("toolTipXValue");
      var toolTipXValueRect = toolTipXValue.getBoundingClientRect();
      jCommon.setHtmlValue("clickCurrentIndex", points[0]["idx"]);
      toolTipXValue.innerHTML = jCommon.formatDate(x);
      if (event.offsetX > canvasWidth / 2) {
        toolTipXValue.style.left = event.offsetX - toolTipXValueRect.width + "px";
      } else {
        toolTipXValue.style.left = event.offsetX + "px";
      }
      var htmlList = [];
      var colorsMap_ = this.colorsMap_;
      if (this.getOption("isScales")) {
        for (var index = 0; index < points.length; index++) {
          var item = points[index];
          var labeledData = item.name.split("#")[0] + ': ' + jCommon.formatNumber(trendPage.getDyGraphRealData(scales[item["name"]], item.yval, minScales[item["name"]]));
          labeledData = '<div class="legend-item"><span style="color:' + colorsMap_[item["name"]] + '">' + labeledData + "</span></div>";
          htmlList.push(labeledData);
        }
      } else {
        for (var index = 0; index < points.length; index++) {
          var item = points[index];
          var labeledData = item.name.split("#")[0] + ': ' + jCommon.formatNumber(item.yval);
          labeledData = '<div class="legend-item"><span style="color:' + colorsMap_[item["name"]] + '">' + labeledData + "</span></div>";
          htmlList.push(labeledData);
        }
      }
      jCommon.setHtmlValue("trendItemList", htmlList.join(","));
      htmlList = null;
    },
    dyGraphFomateXAxis: function () {
      return {
        ticker: function (min, max, pixels, opts, dygraph, vals) {
          return [{
            v: min + 300,
            label: jCommon.formatDate(min)
          },
          {
            v: max - 300,
            label: jCommon.formatDate(max)
          },
          ]
        },
        axisLabelWidth: 300,
      }
    },
    getDyGraphScaled: function () {
      return {
        min: 0,
        max: 110
      };
    },
    getDyGraphScaledValue: function (min, max) {
      if (Number(min) === Number(max)) {
        return 0;
      } else {
        return Number((max - min) / 100);
      }
    },
    getDyGraphVirtualData: function (scaleValue, realValue, min) {
      if (scaleValue === 0) {
        return 0;
      } else {
        return Number((realValue - min) / scaleValue);
      }
    },
    getDyGraphRealData: function (scaleValue, virtualValue, min) {
      return Number(virtualValue * scaleValue + min);
    },
    initDyGraphChartView: function (message) {
      if (!message || !message["timestamp"] || message["timestamp"].length === 0 || !message["data"] || message["data"].length === 0) {
        jCommon.addHtmlClass("#chartview", "hide");
        jCommon.addHtmlClass("#chartviewLoading", "hide");
        jCommon.removeHtmlClass("#emptyData", "hide");
        return;
      }
      var allColorList = dyGraphConfig.getDyGraphColor();
      var timestamp = message["timestamp"];
      var trendData = message["data"];
      dygraphInstance = null;
      var scaled = !jCommon.checkBoolenValue(jCommon.getHtmlValue("unscaled"));
      var dyGraphConfigInstance = dyGraphConfig.getDyGraphConfig();
      var scaledRange = trendPage.getDyGraphScaled();
      var customScales = {};
      var customMinScales = {};
      dyGraphConfigInstance.width = document.getElementById("main-content").getBoundingClientRect().width - 20;
      dyGraphConfigInstance.clickCallback = trendPage.dyGraphClickCallback;
      dyGraphConfigInstance.axes.x = trendPage.dyGraphFomateXAxis();
      var labels = ["Time"];
      var data = [];
      var colorList = [];
      trendData.forEach(function (item, index) {
        if (!jCommon.empty(item.val)) {
          colorList.push(allColorList[index]);
          var key = item["name"] + "#" + index;
          labels.push(key);
          customScales[key] = trendPage.getDyGraphScaledValue(item["min"], item["max"]);
          customMinScales[key] = item["min"];
          item["val"].forEach(function (value, index) {
            if (jCommon.empty(data[index])) {
              data[index] = [new Date(timestamp[index])];
            }
            if (scaled) {
              data[index].push(trendPage.getDyGraphVirtualData(customScales[key], value, item["min"]));
            } else {
              data[index].push(value);
            }
          });
        }
      });
      dyGraphConfigInstance.colors = colorList;
      dyGraphConfigInstance.customScales = customScales;
      dyGraphConfigInstance.customMinScales = customMinScales;
      dyGraphConfigInstance.isScales = scaled;
      dyGraphConfigInstance.minValue = jCommon.getHtmlValue("ymin");
      dyGraphConfigInstance.maxValue = jCommon.getHtmlValue("ymax");
      jCommon.setHtmlValue("ymin", scaled ? scaledRange["min"] : jCommon.getHtmlValue("ymin"));
      jCommon.setHtmlValue("ymax", scaled ? scaledRange["max"] : jCommon.getHtmlValue("ymax"));
      dyGraphConfigInstance.valueRange = [jCommon.getHtmlValue("ymin"), jCommon.getHtmlValue("ymax")];
      dyGraphConfigInstance.labels = labels;
      dygraphInstance = new Dygraph(
        document.getElementById("chartview"),
        data,
        dyGraphConfigInstance
      );
      jCommon.removeHtmlClass("#chartview", "hide");
      jCommon.addHtmlClass("#emptyData", "hide");
      jCommon.addHtmlClass("#chartviewLoading", "hide");
    },
    setTrendZoomOut: function (flag) {
      var zoomValueList = [1, 2, 4, 8];
      var zoomValue = Number(jCommon.getHtmlValue("zoomValue"));
      var zoomPosition = zoomValueList.indexOf(zoomValue);
      if (flag === "in") {
        //larger
        zoomPosition++;
      } else {
        //smaller
        zoomPosition--;
      }
      jCommon.setHtmlValue("zoomValue", zoomValueList[zoomPosition]);
    },
    getTrendRealTimeData: function (trendIndex) {
      var initTrendTimeRage = constVar.trendTimeRange(trendIndex, "timeRange");
      var zoomValue = Number(jCommon.getHtmlValue("zoomValue"));
      var endDateTime = jCommon.getDifferCurrentDate();
      var startDateTime = jCommon.getDifferCurrentDate(0, 0, 0, 0, -initTrendTimeRage / zoomValue, 0);
      return {
        startTime: startDateTime,
        endTime: endDateTime,
        startTimeStamp: jCommon.formatTimeStamp(startDateTime),
        endTimeStamp: jCommon.formatTimeStamp(endDateTime)
      }
    },
    controlZoomBtnlist: function () {
      switch (Number(jCommon.getHtmlValue("zoomValue"))) {
        case 1:
          jCommon.setHtmlAttribute("zoom-in", "disabled", false);
          jCommon.setHtmlAttribute("zoom-out", "disabled", true);
          break;
        case 8:
          jCommon.setHtmlAttribute("zoom-in", "disabled", true);
          jCommon.setHtmlAttribute("zoom-out", "disabled", false);
          break;
        default:
          jCommon.setHtmlAttribute("zoom-in", "disabled", false);
          jCommon.setHtmlAttribute("zoom-out", "disabled", false);
          break;
      }
    }
  }

  var systemFeed = {
    getSystemName: function (systemId, systemName) {
      if (jCommon.empty(systemName)) {
        return "System " + systemId;
      } else {
        return systemName;
      }
    },
    getControlTypeUrl: function (ctrlType, systemIndex, feedIndex, LoopIndex) {
      var systemId = Number(systemIndex + 1);
      var feedId = Number(feedIndex + 1);
      var loopId = Number(LoopIndex + 1);
      var urlParams = '&system=' + systemId + '&Fd=' + feedId + '&Lp=' + loopId;
      var url = "";
      if (ctrlType === 1) {
        url = '#ratio' + urlParams;
      } else if (ctrlType === 2) {
        url = '#pid' + urlParams;
      } else if (ctrlType === 3) {
        url = '#schedule' + urlParams;
      } else if (ctrlType === 4) {
        url = '#interval' + urlParams;
      } else if (ctrlType === 5) {
        url = '#pfc' + urlParams;
      } else if (ctrlType === 6) {
        url = '#onoff' + urlParams;
      } else if (ctrlType === 7) {
        url = '#bppcboiler' + urlParams;
      } else if (ctrlType === 8) {
        url = '#apid1' + urlParams;
      }
      return url;
    },
    setLoopConfigUrl: function (ctrlType, feedIndex, loopIndex, loopList) {
      ctrlType = Number(ctrlType);
      var feedId = Number(feedIndex) + 1;
      var systemId = Number(jCommon.getUrlParams("system"));
      var loopId = Number(loopIndex + 1);
      var url = systemFeed.getControlTypeUrl(ctrlType, systemId - 1, feedIndex, loopIndex);
      var urlParams = '&system=' + systemId + '&Fd=' + feedId + '&Lp=' + loopId;
      if (!jCommon.empty(loopList) && !jCommon.empty(loopList[loopIndex])) {
        jCommon.setHtmlValue("row-" + feedIndex + "-enableReq", loopList[loopIndex]["enableReq"]);
      } else {
        jCommon.setHtmlValue("row-" + feedIndex + "-enableReq", false);
      }
      jCommon.setDataSaveProperty("row-" + feedIndex + "-enableReq", "/loops/" + loopIndex + "/enableReq");
      jCommon.setHtmlValue("row-" + feedIndex + "-loopId", "#" + loopId);
      jCommon.setHtmlAttribute("row-" + feedIndex + "-state", "data-loopIndex", loopIndex);
      jCommon.setHtmlAttribute("row-" + feedIndex + "-state", "href", "#interlock" + urlParams);
      jCommon.setHtmlAttribute("row-" + feedIndex + "-config", "href", url);
    },
    controlNextRowLoop: function (rowIndex, value) {
      var state = Number(value) === 7 ? true : false;
      jCommon.setHtmlValue("row-" + rowIndex + "-ctrlTypeEn", !state);
      jCommon.setDropDownMenuValueAndLabel("row-" + rowIndex + "-ctrlType", value);
      jCommon.setDropDownMenuDisabled("row-" + rowIndex + "-ctrlTypeLabel", state);
      jCommon.controlDOMShow("row-" + rowIndex + "-ctrlTypeEn");
    },
    setLoopTitleAndFeedName: function (systemsList) {
      var systemsId = Number(jCommon.getUrlParams("system"));
      var fdId = Number(jCommon.getUrlParams("Fd"));
      var lpId = Number(jCommon.getUrlParams("Lp"));
      var feedInfo = systemsList[systemsId - 1]["feeds"][fdId - 1];
      jCommon.setHtmlValue("feedName", feedInfo["name"]);
      jCommon.setHtmlValue("loopTitle", "Sys" + systemsId + "-Fd" + fdId + "-Lp" + lpId);
      jCommon.setHtmlValue("feed-control-Type", feedInfo["ctrlType"])
      jCommon.setHtmlAttribute("loop-state", "href", "#interlock&system=" + systemsId + "&Fd=" + fdId + "&Lp=" + lpId);
      jCommon.setHtmlAttribute("redirectFeed", "href", "#feeddevice&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
    },
    controlLoopStateAndConfigValid: function (message) {
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      var currentData = message["loop"][loopIndex];
      for (var key in currentData) {
        jCommon.setHtmlValue(key, currentData[key]);
        jCommon.setClassListValue(key, currentData[key]);
        jCommon.controlDOMShow(key);
      }
      var state = jCommon.getHtmlValue("enable");
      if (!jCommon.empty(state)) {
        jCommon.setHtmlValue("loop-state", "Enabled");
        jCommon.removeHtmlClass("#loop-state", "loop-state-disabled");
        jCommon.addHtmlClass("#loop-state", "loop-state-enabled");
      } else {
        jCommon.setHtmlValue("loop-state", "Disabled");
        jCommon.removeHtmlClass("#loop-state", "loop-state-enabled");
        jCommon.addHtmlClass("#loop-state", "loop-state-disabled");
      }
      systemFeed.controlLoopStatus("mode");
      systemFeed.setRateManualCcnst_OP();
      var controlType = repeatAllPage.parameterData.loops[loopIndex]["ctrlType"];
      if (controlType === 7) { // BPPC Type
        systemFeed.setupPercentCnst_OP();
      }
      if (currentData["signal"] == 1) {
        jCommon.setSvgStyle("signal-status", "fill:#09d309");
        jCommon.setSvgText("signal-text", "ON");
      } else {
        jCommon.setSvgStyle("signal-status", "fill:red");
        jCommon.setSvgText("signal-text", "OFF")
      }
    },
    getPredefinedLoopList: function (message, systemIndex, mode, noDownBppc) {
      var loopList = message["loops"];
      var feedList = [];
      if (typeof systemIndex === "undefined") {
        var systemList = message["systems"];
        systemList.forEach(function (item) {
          feedList.push.apply(feedList, item["feeds"]);
        })
      } else {
        var systemInfo = message["systems"][systemIndex];
        feedList = systemInfo["feeds"];
      }
      var loopConfigList = [{
        value: -1,
        ctrlType: 0,
        loopUrl: "",
        name: "None"
      }];
      loopList.forEach(function (item, index) {
        var downBppc = false;
        if (!jCommon.empty(item["ctrlType"])) {
          var configName = constVar.getControlTypeName(item["ctrlType"]);;
          for (var key = 0; key < feedList.length; key++) {
            if (feedList[key]["loopIndex"] === index && !jCommon.empty(feedList[key]["name"])) {
              configName = feedList[key]["name"];
              break;
            }
          }
          var loopUrl = systemFeed.getSystemLoopUrl(message, item["ctrlType"], index);
          if (item["ctrlType"] === 7 && loopList[index - 1] && loopList[index - 1]["ctrlType"] === 7) {//bppc
            downBppc = true;
          }
          loopConfigList.push({
            value: index,
            ctrlType: item["ctrlType"],
            loopUrl: loopUrl,
            name: Number(index + 1) + "-" + configName,
            downBppc: downBppc
          });
        } else {
          loopConfigList.push({
            value: index,
            ctrlType: 0,
            loopUrl: "",
            name: Number(index + 1) + "-Not Configured",
            downBppc: downBppc
          });
        }
      });
      if (jCommon.empty(mode)) {
        return loopConfigList.filter(function (item) {
          return item["name"].indexOf("-Not Configured") === -1;
        })
      } else {
        return loopConfigList;
      }
    },
    controlLoopLocalEnProperty: function () {
      var localEn = jCommon.getHtmlValue("localEn");
      var modeChn = jCommon.getHtmlValue("modeChn");
      var mode = jCommon.getHtmlValue("modeReq");
      if (jCommon.empty(localEn)) {
        if (modeChn > 0 && mode != 0) {
          jCommon.setDropDownMenuValueAndLabel("modeReq", "0");
          repeatAllPage.updateParameter("modeReq");
        }
        jCommon.setDropDownMenuDisabled("modeReqLabel", true);
        jCommon.setChannelInputDisabled("modeChnAnalogLabel", false);
      } else {
        jCommon.setDropDownMenuDisabled("modeReqLabel", false);
        jCommon.setChannelInputDisabled("modeChnAnalogLabel", true);
      }
    },
    swipeScheduleList: function (list, weekNum, number, baseNumber) {
      list = list.filter(function (item, index) {
        return index < weekNum * baseNumber;
      })
      var swapeIndex = (number % weekNum) * baseNumber;
      var beforeSplitArray = [];
      var afterSplitArray = [];
      for (var index = 0; index < list.length; index++) {
        if (typeof list[index] === "object") {
          list[index]["orginIndex"] = index;
        }
        if (index < swapeIndex) {
          beforeSplitArray.push(list[index]);
        } else {
          afterSplitArray.push(list[index]);
        }
      }
      return afterSplitArray.concat(beforeSplitArray);
    },
    getFeedDeviceChannelRange: function (keyType) {
      if (keyType === "OnOffCVOutputChannel") {
        return "5,8";
      } else if (keyType === "PulseCVOutputChannel") {
        return "5,7,8";
      } else if (keyType === "analogCVOutputChannel") {
        return "1,4";
      } else if (keyType === "TimeCVOutputChannel") {
        return "5,8";
      }
    },
    setPredefinedMode: function (loopkey) {
      var pdChn = loopkey + "Chn";
      var pdLoop = loopkey + "Loop";
      var ctrlType = jCommon.getHtmlAttriute(pdLoop + "Label", "select-ctrltype");
      jCommon.setHtmlAttribute(pdLoop, "data-value-name", jCommon.getHtmlValue(pdLoop) == -1 ? "loop-invalid" : "loop-valid")
      jCommon.dropDownMenu({
        element: document.getElementById(pdChn + 'Label'),
        choices: constVar.getPDModeList(ctrlType),
        defaultvalue: jCommon.getHtmlValue(pdChn),
        callback: systemFeed.preDefinedChSelectCallback
      })
    },
    predefinedLoopSelectCallback: function (value, id) {
      repeatAllPage.updateSelectValueData(value, id, function () {
        if (id.indexOf("-pdLoopLabel") > -1) {
          var key = id.replace("-pdLoopLabel", "");
          var predefinedLoopName = jCommon.getHtmlAttriute(id, "select-name");
          var predefinedLoopNameLoopId = predefinedLoopName.split("-")[0];
          jCommon.setHtmlValue(key + "-name", "Lp" + predefinedLoopNameLoopId + "-Mode");
          systemFeed.setPredefinedMode(key + "-pd");
          jCommon.setDropDownMenuValueAndLabel(key + "-pdChn", 0);
          jCommon.controlDOMShow(key + "-pdChn");
          repeatAllPage.updateParameter(key + "-pdChn");
        }
      });
    },
    preDefinedChSelectCallback: function (value, id) {
      var currentPage = jCommon.getCurrentPage();
      var key = id.replace("-pdChnLabel", "");
      var predefinedLoopName = jCommon.getHtmlAttriute(key + "-pdLoopLabel", "select-name");
      var predefinedLoopNameLoopId = predefinedLoopName.split("-")[0];
      jCommon.setHtmlValue(key + "-name", "Lp" + predefinedLoopNameLoopId + "-" + jCommon.getHtmlAttriute(id, "select-name"));
      jCommon.setHtmlValue(key + "-pdLoopName", predefinedLoopName + " " + jCommon.getHtmlAttriute(id, "select-name"));
      if (["aintchannel", "system"].indexOf(currentPage) > -1) {
        repeatAllPage.updateSelectValueData(value, id, systemFeed.getPreDefinedPDCUnits);
      } else {
        repeatAllPage.updateSelectValueData(value, id);
      }
    },
    getPreDefinedPDCUnits: function () {
      var inputPdDomList = document.getElementsByClassName("input-pd-type");
      var loopIndexList = [];
      for (var pdIndex = 0; pdIndex < inputPdDomList.length; pdIndex++) {
        var loopIndex = jCommon.getHtmlValue(inputPdDomList[pdIndex].id);
        if ([-1, 20].indexOf(loopIndex) === -1) {
          loopIndexList.push(loopIndex);
        }
      }
      cmdlist.getPDCUnits(loopIndexList, function (message) {
        var units = message["units"];
        for (var pdIndex = 0; pdIndex < inputPdDomList.length; pdIndex++) {
          var inputDomItem = inputPdDomList[pdIndex];
          var baseDomId = inputDomItem.id.replace("Loop", "");
          if (Number(inputDomItem.value) !== -1 && !jCommon.empty(units[inputDomItem.value])) {
            var pdChn = jCommon.getHtmlValue(baseDomId + "Chn");
            var currentUnitInfo = units[inputDomItem.value][pdChn];
            var unitLabel = channelPage.getChannelUnitLabel(currentUnitInfo);
            jCommon.setHtmlValue(baseDomId + "ValueUnit", unitLabel);
          }
        }
      })
    },
    positionTypeChannelCallback: function (value, id) {
      var domKey = id.replace("Analog", "").replace("Digital", "").replace("Label", "");
      channelPage.setChannelTypeAndValueAndConfig(domKey, value[0], value[1]);
      var channelName = channelPage.getChannelInfo(value[0], value[1], "name");
      var domNameKey = domKey.replace("-chn", "");
      jCommon.setHtmlValue(domNameKey + "-name", channelName);
      repeatAllPage.updateParameter(id);
    },
    controlPredefinedLoopStatus: function (message) {
      var loopList = message["loop"];
      var inputPdDomList = document.querySelectorAll('input[data-value-name="loop-valid"]')
      for (var pdIndex = 0; pdIndex < inputPdDomList.length; pdIndex++) {
        var inputPdDomItem = inputPdDomList[pdIndex];
        var baseId = inputPdDomItem.id.replace("Loop", "");
        var loopIndex = jCommon.getHtmlValue(baseId + "Loop");
        var loopInfo = loopList[loopIndex];
        var ModeDomId = baseId + "Mode";
        jCommon.setHtmlValue(ModeDomId, loopInfo["mode"]);
        systemFeed.controlLoopStatus(ModeDomId);
        var pdChn = jCommon.getHtmlValue(baseId + "Chn");
        if (Number(inputPdDomItem.value) !== -1 && !jCommon.empty(loopInfo) && pdChn > 0) {
          jCommon.setHtmlValue(baseId + "Value", loopInfo["pdcValues"][pdChn]);
        }
      }
    },
    controlLoopStatus: function (id) {
      var idLabel = id + "Label";
      var mode = jCommon.getHtmlValue(id);
      var modeList = constVar.getLoopMode();
      jCommon.removeHtmlClass("#" + idLabel, "local-status-Stop");
      jCommon.removeHtmlClass("#" + idLabel, "local-status-Auto");
      jCommon.removeHtmlClass("#" + idLabel, "local-status-Manual");
      modeList.forEach(function (item) {
        if (item["value"] === mode) {
          jCommon.setHtmlValue(idLabel, item["name"]);
          jCommon.addHtmlClass("#" + idLabel, "local-status-" + item["name"]);
        }
      });
      jCommon.controlDOMShow(id);
    },
    getLoopSetPointDomValueItem: function (loopInfo, loopIndex, itemCount, bppcCount) {
      var objectInfo = constVar.getChannelDataKey();
      var itemList = [];
      itemList.push('<div class="dom-container input-group">');
      //1,2,6
      if ([1, 2, 6, 8].indexOf(loopInfo["ctrlType"]) > -1) {
        var loopSpInfo = loopInfo["sp"];
        var channelType = loopSpInfo["chnType"];
        var channelId = loopSpInfo["chn"];
        if (loopSpInfo["dataType"] === 1) {
          //channel
          if (channelId > 0) {
            var channelInfo = channelPage.getChannelInfo(channelType, channelId);
            itemList.push('<input type="hidden" id="item-' + itemCount + '-sp-chn" value="' + channelId + '" data-type="int" class="input-analog-channel" data-value-name="value-name-analog">');
            itemList.push('<input type="hidden" id="item-' + itemCount + '-sp-chnType" value="' + channelType + '" data-type="int">');
            if (channelInfo["simEn"]) {
              itemList.push('<div class="input-div-enabled form-inline">');
              itemList.push('<input type="text" id="item-' + itemCount + '-sp-chn-simData" class="form-control keyboardnumberInput" data-save-property="/' + objectInfo[channelType] + '/' + Number(channelId - 1) + '/simData_OP" value="' + channelInfo["simData_OP"] + '" data-min="' + channelInfo["engMin"] + '" data-max="' + channelInfo["engMax"] + '"/>');
              itemList.push('</div>');
            } else {
              itemList.push('<div class="input-div-disabled form-inline">');
              itemList.push('<label id="item-' + itemCount + '-sp-chn-liveDataLabel" class="sp-cnst_OP"></label>');
              itemList.push('</div>');
            }
          } else {
            itemList.push('<div class="input-div-disabled form-inline">');
            itemList.push('<label>0</label>');
            itemList.push('</div>');
          }
        } else {
          //constant
          itemList.push('<div class="input-div-enabled form-inline">');
          itemList.push('<input type="text" id="item-' + itemCount + '-sp-cnst_OP" class="form-control keyboardnumberInput" data-save-property="/loops/' + loopIndex + '/sp/cnst_OP" value="' + loopSpInfo["cnst_OP"] + '"/>');
          itemList.push('</div>');
        }
      } else if ([5].indexOf(loopInfo["ctrlType"]) > -1) {
        //feed sp pfc
        itemList.push('<div class="input-div-disabled form-inline">');
        itemList.push('<label id="item-' + itemCount + '-feedSp"></label>');
        itemList.push('</div>');
      } else if ([7].indexOf(loopInfo["ctrlType"]) > -1) {
        //bppc
        if (bppcCount % 2 == 0) {
          //upPercent
          itemList.push('<input type="hidden" id="item-' + itemCount + '-upPercent-dataType" />');
          itemList.push('<input type="hidden" id="item-' + itemCount + '-upPercent-chn" data-type="int" class="input-analog-channel">');
          itemList.push('<input type="hidden" id="item-' + itemCount + '-upPercent-chnType" data-type="int">');
          itemList.push('<div v-show="item-' + itemCount + '-upPercent-dataType == 2" class="hide">');
          itemList.push('<div v-show="item-' + itemCount + '-mode == 1" class="input-div-enabled form-inline hide">');
          itemList.push('<input type="text" id="item-' + itemCount + '-upPercent-cnst_OP" class="form-control keyboardnumberInput" data-title="Up_Percent_Constant">');
          itemList.push('</div>');
          itemList.push('<div v-show="item-' + itemCount + '-mode != 1" class="input-div-disabled form-inline hide">');
          itemList.push(' <label id="item-' + itemCount + '-upPercent_SP"></label>');
          itemList.push('</div>');
          itemList.push('</div>');
        } else {
          //downPercent
          itemCount = itemCount - 1;
          itemList.push('<input type="hidden" id="item-' + itemCount + '-rateManual-dataType" />');
          itemList.push('<input type="hidden" id="item-' + itemCount + '-rateManual-chn" data-type="int" class="input-analog-channel">');
          itemList.push('<input type="hidden" id="item-' + itemCount + '-rateManual-chnType" data-type="int">');
          itemList.push('<div v-show="item-' + itemCount + '-rateManual-dataType == 2" class="hide">');
          itemList.push('<div v-show="item-' + itemCount + '-mode == 1" class="input-div-enabled form-inline hide">');
          itemList.push('<input type="text" id="item-' + itemCount + '-rateManual-cnst_OP" class="form-control keyboardnumberInput" data-title="Man_Rate_Constant">');
          itemList.push('</div>');
          itemList.push('<div v-show="item-' + itemCount + '-mode != 1" class="input-div-disabled form-inline hide">');
          itemList.push('<label class="item-' + itemCount + '-totalfeedRate_SP"></label>');
          itemList.push('</div>');
          itemList.push('</div>');
          itemList.push('<div v-show="item-' + itemCount + '-rateManual-dataType == 1 && item-' + itemCount + '-rateManual-chn > 0" class="hide">');
          itemList.push('<input type="hidden" id="item-' + itemCount + '-rateManual-chn-simEn">');
          itemList.push('<div v-show="item-' + itemCount + '-rateManual-chn-simEn == true" class="input-div-enabled form-inline hide">');
          itemList.push('<input type="text" class="form-control keyboardnumberInput" id="item-' + itemCount + '-rateManual-chn-simData" data-title="SP" />');
          itemList.push('</div>');
          itemList.push('<div v-show="item-' + itemCount + '-rateManual-chn-simEn == false" class="input-div-disabled form-inline hide">');
          itemList.push('<label id="item-' + itemCount + '-rateManual-chn-liveDataLabel" data-notation="true" ></label>');
          itemList.push('</div>');
          itemList.push('</div>');
          itemList.push('<div v-show="item-' + itemCount + '-rateManual-dataType == 1 && item-' + itemCount + '-rateManual-chn == 0" class="hide">');
          itemList.push('<div class="input-div-disabled form-inline">');
          itemList.push('<label>0</label>');
          itemList.push('</div>');
          itemList.push('</div>');
        }
      }
      itemList.push('</div>');
      return itemList.join("");
    },
    getLoopSetPointDomUnitItem: function (loopInfo, bppcCount, lastLoopInfo) {
      var processType = constVar.getProcessType();
      var unitLabel = "";
      //Ratio, PID ,PFC ,On/Off
      if ([1, 2, 5, 6, 8].indexOf(loopInfo["ctrlType"]) > -1) {
        var loopSpInfo = loopInfo["sp"];
        var channelType = loopSpInfo["chnType"];
        var channelId = loopSpInfo["chn"];
        if (loopSpInfo["dataType"] === 1) {
          if (channelId > 0) {
            //channel
            var channelInfo = channelPage.getChannelInfo(channelType, channelId);
            unitLabel = channelPage.getChannelUnitLabel(channelInfo);
          }
        } else {
          //constant
          if (loopInfo["ctrlType"] == 1) {
            //Ratio
            processType.forEach(function (processTypeInfo) {
              if (Number(processTypeInfo["value"]) === Number(loopInfo["processType"])) {
                unitLabel = processTypeInfo["name"];
              }
            })
          } else {
            //pid onoff
            var channelType = loopInfo["pvChnType"];
            var channelId = loopInfo["pvChn"];
            if (channelId > 0) {
              var channelInfo = channelPage.getChannelInfo(channelType, channelId);
              unitLabel = channelPage.getChannelUnitLabel(channelInfo);
            }
          }
        }
      } else if (loopInfo["ctrlType"] == 7) {
        //bppc
        if (bppcCount % 2 == 0) {
          //todo
        } else {
          if (lastLoopInfo["rateManual"]["dataType"] == 2) {
            unitLabel = systemFeed.getFeedDevicesUnit(lastLoopInfo["fdDevice"]);
          } else {
            if (lastLoopInfo["rateManual"]["dataType"] == 1 && lastLoopInfo["rateManual"]["chn"] > 0) {
              var flowmeterCtrlChannelInfo = channelPage.getChannelInfo(lastLoopInfo["rateManual"]["chnType"], lastLoopInfo["rateManual"]["chn"]);
              unitLabel = channelPage.getChannelUnitLabel(flowmeterCtrlChannelInfo)
            }
          }
        }
      }
      return unitLabel;
    },
    getLoopSetPointDomPVItem: function (loopInfo, loopIndex, itemCount) {
      if ([2, 6, 8].indexOf(loopInfo["ctrlType"]) > -1) {
        // PID On/Fff
        var itemList = [];
        itemList.push('<input type="hidden" id="item-' + itemCount + '-pvChn" value="' + loopInfo["pvChn"] + '" data-type="int" class="input-analog-channel" data-value-name="value-name-analog">');
        itemList.push('<input type="hidden" id="item-' + itemCount + '-pvChnType" value="' + loopInfo["pvChnType"] + '" data-type="int">');
        itemList.push('<div v-show="item-' + itemCount + '-pvChn > 0" class="hide">');
        itemList.push('<div class="dom-container input-group">');
        // itemList.push('<div class="dom-container">');
        itemList.push('<input type="hidden" id="item-' + itemCount + '-pvChn-simEn">');
        itemList.push('<div v-show="item-' + itemCount + '-pvChn-simEn == true" class="input-div-enabled form-inline hide">');
        // itemList.push('<div v-show="item-' + itemCount + '-pvChn-simEn == true" form-inline hide">');
        itemList.push('<input type="text" class="form-control keyboardnumberInput" id="item-' + itemCount + '-pvChn-simData" data-title="PV" />');
        itemList.push('</div>');
        itemList.push('<div v-show="item-' + itemCount + '-pvChn-simEn == false" class="input-div-disabled form-inline hide">');
        itemList.push('<label id="item-' + itemCount + '-pvChn-liveDataLabel" data-notation="true" ></label>');
        itemList.push('</div>');
        itemList.push('</div>');
        itemList.push('</div>');
        return itemList.join("");
      } else {
        return "";
      }
    },
    getLoopSetPointDomModeItem: function (loopInfo, loopIndex, itemCount) {
      var itemList = [];
      itemList.push('<div class="dom-container input-group">');
      itemList.push('<div v-show="item-' + itemCount + '-enable == false || item-' + itemCount + '-configValid == false" class="input-group hide">');
      itemList.push('<label class="local-status local-status-Stop">Stop</label>');
      itemList.push('</div>');
      itemList.push('<div v-show="item-' + itemCount + '-enable == true && item-' + itemCount + '-configValid == true" class="input-group hide">');
      itemList.push('<input type="hidden" id="item-' + itemCount + '-modeReq" value="' + loopInfo["modeReq"] + '" data-save-property="/loops/' + loopIndex + '/modeReq" data-type="int">');
      itemList.push('<div id="item-' + itemCount + '-modeReqLabel"></div>');
      itemList.push('</div>');
      itemList.push('</div>');
      return itemList.join("");
    },
    getLoopSetPointRateMan: function (loopInfo, loopIndex, itemCount, bppcCount) {
      var objectInfo = constVar.getChannelDataKey();
      var itemList = [];
      itemList.push('<div class="dom-container input-group">');
      itemList.push('<input type="hidden" id="item-' + itemCount + '-mode">');
      itemList.push('<div v-show="item-' + itemCount + '-mode == 1" class="hide">');
      if ([3, 4, 7].indexOf(loopInfo["ctrlType"]) === -1) {
        //except Schedule Interval BPPC
        var rateManualInfo = loopInfo["rateManual"];
        var channelType = rateManualInfo["chnType"];
        var channelId = rateManualInfo["chn"];
        if (rateManualInfo["dataType"] === 1) {
          if (channelId > 0) {
            var channelInfo = channelPage.getChannelInfo(channelType, channelId);
            itemList.push('<input type="hidden" id="item-' + itemCount + '-rateManual-chn" value="' + channelId + '" data-type="int" class="input-analog-channel" data-value-name="value-name-analog">');
            itemList.push('<input type="hidden" id="item-' + itemCount + '-rateManual-chnType" value="' + channelType + '" data-type="int">');
            if (channelInfo["simEn"]) {
              itemList.push('<div class="input-div-enabled form-inline">');
              itemList.push('<input type="text" id="item-' + itemCount + '-rateManual-chn-simData" class="form-control keyboardnumberInput" data-save-property="/' + objectInfo[channelType] + '/' + Number(channelId - 1) + '/simData_OP" value="' + channelInfo["simData_OP"] + '" data-min="' + channelInfo["engMin"] + '" data-max="' + channelInfo["engMax"] + '"/>');
              itemList.push('</div>');
            } else {
              itemList.push('<div class="input-div-disabled form-inline">');
              itemList.push('<label id="item-' + itemCount + '-rateManual-chn-liveDataLabel" class="sp-cnst_OP"></label>');
              itemList.push('</div>');
            }
          }
        } else {
          itemList.push('<div class="input-div-enabled form-inline">');
          itemList.push('<input type="text" id="item-' + itemCount + '-rateManual-cnst_OP" class="form-control keyboardnumberInput" data-save-property="/loops/' + loopIndex + '/rateManual/cnst_OP" value="' + rateManualInfo["cnst_OP"] + '"/>');
          itemList.push('</div>');
        }
      } else if (loopInfo["ctrlType"] === 7) {
        //bppc
        if (bppcCount % 2 == 0) {
          itemList.push('<div class="input-div-disabled form-inline">');
          itemList.push('<label class="item-' + itemCount + '-upfeedRate_ACT"></label>');
          itemList.push('</div>');
        } else {
          itemList.push('<div class="input-div-disabled form-inline">');
          itemList.push('<label class="item-' + Number(itemCount - 1) + '-downfeedRate_ACT"></label>');
          itemList.push('</div>');
        }
      } else {
        //schedule interval
        itemList.push('<div class="input-div-enabled form-inline">');
        itemList.push('<input type="text" id="item-' + itemCount + '-manVol" class="form-control keyboardnumberInput" data-save-property="/loops/' + loopIndex + '/manVol" value="' + loopInfo["manVol"] + '"/>');
        itemList.push('</div>');
      }
      itemList.push('</div>');
      itemList.push('<div v-show="item-' + itemCount + '-mode != 1" class="hide">');
      itemList.push('<div class="input-div-disabled form-inline">');
      if (loopInfo["ctrlType"] === 7) {
        if (bppcCount % 2 == 0) {
          itemList.push('<label class="item-' + itemCount + '-upfeedRate_ACT"></label>');
        } else {
          itemList.push('<label class="item-' + Number(itemCount - 1) + '-downfeedRate_ACT"></label>');
        }
      } else {
        itemList.push('<label id="item-' + itemCount + '-fdRateAC"></label>');
      }
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      return itemList.join("");
    },
    getLoopSetPointUnit: function (loopInfo) {
      var baseUnit = systemFeed.getFeedDevicesUnit(loopInfo["fdDevice"]);
      return '<label>' + baseUnit + '</label>';
    },
    getControlTypeTimeUrl: function (ctrlType, systemIndex, feedIndex, LoopIndex) {
      var systemId = Number(systemIndex + 1);
      var feedId = Number(feedIndex + 1);
      var loopId = Number(LoopIndex + 1);
      var urlParams = '&system=' + systemId + '&Fd=' + feedId + '&Lp=' + loopId;
      var url = "";
      if (ctrlType === 1) {
        url = '#ratiotime' + urlParams;
      } else if (ctrlType === 2) {
        url = '#pidtime' + urlParams;
      } else if (ctrlType === 3) {
        url = '#scheduletime' + urlParams;
      } else if (ctrlType === 4) {
        url = '#intervaltime' + urlParams;
      } else if (ctrlType === 5) {
        url = '#pfctime' + urlParams;
      } else if (ctrlType === 6) {
        url = '#onofftime' + urlParams;
      } else if (ctrlType === 7) {
        url = '#bppctime' + urlParams;
      } else if (ctrlType === 8) {
        url = '#apidrtime' + urlParams;
      }
      return url;
    },
    hanleScheduleTableData: function (message) {
      var loopIndex = jCommon.getUrlParams("Lp") - 1;
      var weekNum = jCommon.getHtmlValue("weekNum");
      var weekOffset = jCommon.getHtmlValue("weekOffset");
      var currentData = message["loop"][loopIndex];
      var oldSundayDate = jCommon.getHtmlValue('sundayDate');
      var currentSundayDate = jCommon.formatSundayDate(message["sunday"]);
      var list = ["#fff", "#00f8f8", "#f84040", "#00f800", "#787800", "#007800"];
      var currentIndex = jCommon.getHtmlValue("currentPage") - 1;
      var startIndex = currentIndex * 70;
      var endIndex = jCommon.getHtmlValue("currentPage") * 70;
      var statusSwipeList = systemFeed.swipeScheduleList(currentData["feedStatus"], weekNum, weekOffset, 70);
      var statusList = statusSwipeList.slice(startIndex, endIndex);
      statusList.forEach(function (item, index) {
        var row = Math.floor(index / 10) + 1;
        var colum = Math.floor(index % 10) + 1;
        jCommon.setHtmlStyleAttribute("row-" + row + "-" + colum, "background", list[item]);
      })
      if (oldSundayDate !== currentSundayDate) {
        jCommon.setHtmlValue("currentPage", 1);
        repeatAllPage.initCurrentPageData();
      }
    },
    hanleIntervalTableData: function (loopInfo) {
      var feedStatusList = loopInfo["feedStatus"];
      var list = ["#fff", "#00f8f8", "#f84040", "#00f800", "#787800", "#007800"];
      feedStatusList.forEach(function (item, index) {
        jCommon.setHtmlStyleAttribute("row-" + index, "background", list[item]);
      })
    },
    btnLocalEnTimeClick: function () {
      var ToolstipDialogMessage = jCommon.getHtmlValue("localEn") ? "Change to Remote?" : "Change to Local?";
      ToolstipDialog.showConfirmToolsTip("", ToolstipDialogMessage, function () {
        jCommon.setRadioButtonValue("localEn", function () {
          systemFeed.controlLoopLocalEnProperty();
          repeatAllPage.updateParameter("localEn");
        })
      })
    },
    initLoopMode: function (info) {
      jCommon.dropDownMenu({
        element: document.getElementById('modeReqLabel'),
        choices: constVar.getLoopMode(),
        defaultvalue: info["modeReq"],
        callback: systemFeed.updateManRateConstant
      });
      jCommon.controlDOMShow("modeReq");
      channelPage.initChannelInput("modeChn", info["modeChnType"], info["modeChn"], "analog", systemFeed.controlLoopLocalEnProperty);
      systemFeed.controlLoopLocalEnProperty();
    },
    updateManRateConstant: function (value, id) {
      var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
      repeatAllPage.updateSelectValueData(value, id, function () {
        var rateManual_cnst_OP = repeatAllPage.parameterData.loops[loopIndex]["rateManual"]["cnst_OP"];
        jCommon.setHtmlValue("rateManual-cnst_OP", rateManual_cnst_OP);
        var controlType = repeatAllPage.parameterData.loops[loopIndex]["ctrlType"];
        if (controlType === 7) { // BPPC Type
          var upPercent_cnst_OP = repeatAllPage.parameterData.loops[loopIndex]["upPercent"]["cnst_OP"];
          jCommon.setHtmlValue("upPercent-cnst_OP", upPercent_cnst_OP);
        }
      })
    },
    initConstantChannel: function (loopInfo) {
      var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
      if (!jCommon.empty(loopInfo["sp"])) {
        var spInfo = loopInfo["sp"];
        for (var key in spInfo) {
          jCommon.setHtmlValue("sp-" + key, spInfo[key]);
          jCommon.setClassListValue("sp-" + key, spInfo[key]);
          jCommon.setDataSaveProperty("sp-" + key, "/loops/" + loopIndex + "/sp/" + key);
        }
        channelPage.initChannelInput("sp-chn", spInfo["chnType"], spInfo["chn"], "analog");
        jCommon.controlDOMShow("sp-dataType");
      }
      if (!jCommon.empty(loopInfo["rateManual"])) {
        var rateManualInfo = loopInfo["rateManual"];
        for (var key in rateManualInfo) {
          jCommon.setHtmlValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setClassListValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setDataSaveProperty("rateManual-" + key, "/loops/" + loopIndex + "/rateManual/" + key);
        }
        channelPage.initChannelInput("rateManual-chn", rateManualInfo["chnType"], rateManualInfo["chn"], "analog");
        jCommon.controlDOMShow("rateManual-dataType");
      }
      if (!jCommon.empty(loopInfo["fallback"])) {
        var fallbackInfo = loopInfo["fallback"];
        for (var key in fallbackInfo) {
          jCommon.setHtmlValue("fallback-" + key, fallbackInfo[key]);
          jCommon.controlDOMShow("fallback-" + key);
          jCommon.setClassListValue("fallback-" + key, fallbackInfo[key]);
          jCommon.setDataSaveProperty("fallback-" + key, "/loops/" + loopIndex + "/fallback/" + key);
        }
        channelPage.initChannelInput("fallback-chn", fallbackInfo["chnType"], fallbackInfo["chn"], "analog");
        jCommon.controlDOMShow("fallback-dataType");
      }
      if (!jCommon.empty(loopInfo["deadband"])) {
        var deadbandInfo = loopInfo["deadband"];
        for (var key in deadbandInfo) {
          jCommon.setHtmlValue("deadband-" + key, deadbandInfo[key]);
          jCommon.controlDOMShow("deadband-" + key);
          jCommon.setClassListValue("deadband-" + key, deadbandInfo[key]);
          jCommon.setDataSaveProperty("deadband-" + key, "/loops/" + loopIndex + "/deadband/" + key);
        }
        channelPage.initChannelInput("deadband-chn", deadbandInfo["chnType"], deadbandInfo["chn"], "analog");
        jCommon.controlDOMShow("deadband-dataType");
      }
      if (!jCommon.empty(loopInfo["sg"])) {
        var sgInfo = loopInfo["sg"];
        for (var key in sgInfo) {
          jCommon.setHtmlValue("sg-" + key, sgInfo[key]);
          jCommon.controlDOMShow("sg-" + key);
          jCommon.setDataSaveProperty("sg-" + key, "/loops/" + loopIndex + "/sg/" + key);
        }
        channelPage.initChannelInput("sg-chn", sgInfo["chnType"], sgInfo["chn"], "analog");
        jCommon.controlDOMShow("sg-dataType");
      }
      if (!jCommon.empty(loopInfo["placeholder"])) {
        var placeholderInfo = loopInfo["placeholder"];
        for (var key in placeholderInfo) {
          jCommon.setHtmlValue("placeholder-" + key, placeholderInfo[key]);
          jCommon.setDataSaveProperty("placeholder-" + key, "/loops/" + loopIndex + "/placeholder/" + key);
        }
        channelPage.initChannelInput("placeholder-chn", placeholderInfo["chnType"], placeholderInfo["chn"], "analog");
        jCommon.controlDOMShow("placeholder-dataType");
      }
      jCommon.setClassListValue("fdDevice-unit", systemFeed.getFeedDevicesUnit(loopInfo["fdDevice"]));
    },
    initBPPCConstantChannel: function (loopInfo) {
      var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
      if (!jCommon.empty(loopInfo["bd"])) {
        var bdInfo = loopInfo["bd"];
        for (var key in bdInfo) {
          jCommon.setHtmlValue("bd-" + key, bdInfo[key]);
          jCommon.setClassListValue("bd-" + key, bdInfo[key]);
          jCommon.setDataSaveProperty("bd-" + key, "/loops/" + loopIndex + "/bd/" + key);
        }
        channelPage.initChannelInput("bd-chn", bdInfo["chnType"], bdInfo["chn"], "analog");
        jCommon.controlDOMShow("bd-dataType");
      }
      if (!jCommon.empty(loopInfo["po4"])) {
        var po4Info = loopInfo["po4"];
        for (var key in po4Info) {
          jCommon.setHtmlValue("po4-" + key, po4Info[key]);
          jCommon.setClassListValue("po4-" + key, po4Info[key]);
          jCommon.setDataSaveProperty("po4-" + key, "/loops/" + loopIndex + "/po4/" + key);
        }
        channelPage.initChannelInput("po4-chn", po4Info["chnType"], po4Info["chn"], "analog");
        jCommon.controlDOMShow("po4-dataType");
      }
      if (!jCommon.empty(loopInfo["nh3"])) {
        var nh3Info = loopInfo["nh3"];
        for (var key in nh3Info) {
          jCommon.setHtmlValue("nh3-" + key, nh3Info[key]);
          jCommon.controlDOMShow("nh3-" + key);
          jCommon.setClassListValue("nh3-" + key, nh3Info[key]);
          jCommon.setDataSaveProperty("nh3-" + key, "/loops/" + loopIndex + "/nh3/" + key);
        }
        channelPage.initChannelInput("nh3-chn", nh3Info["chnType"], nh3Info["chn"], "analog");
        jCommon.controlDOMShow("nh3-dataType");
      }
      if (!jCommon.empty(loopInfo["pH"])) {
        var pHInfo = loopInfo["pH"];
        for (var key in pHInfo) {
          jCommon.setHtmlValue("pH-" + key, pHInfo[key]);
          jCommon.controlDOMShow("pH-" + key);
          jCommon.setClassListValue("pH-" + key, pHInfo[key]);
          jCommon.setDataSaveProperty("pH-" + key, "/loops/" + loopIndex + "/pH/" + key);
        }
        channelPage.initChannelInput("pH-chn", pHInfo["chnType"], pHInfo["chn"], "analog");
        jCommon.controlDOMShow("pH-dataType");
      }
      if (!jCommon.empty(loopInfo["rateManual"])) {
        var rateManualInfo = loopInfo["rateManual"];
        for (var key in rateManualInfo) {
          jCommon.setHtmlValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setClassListValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setDataSaveProperty("rateManual-" + key, "/loops/" + loopIndex + "/rateManual/" + key);
        }
        channelPage.initChannelInput("rateManual-chn", rateManualInfo["chnType"], rateManualInfo["chn"], "analog");
        jCommon.controlDOMShow("rateManual-dataType");
      }
      if (!jCommon.empty(loopInfo["upPercent"])) {
        var upPercentInfo = loopInfo["upPercent"];
        for (var key in upPercentInfo) {
          jCommon.setHtmlValue("upPercent-" + key, upPercentInfo[key]);
          jCommon.setClassListValue("upPercent-" + key, upPercentInfo[key]);
          jCommon.setDataSaveProperty("upPercent-" + key, "/loops/" + loopIndex + "/upPercent/" + key);
        }
        channelPage.initChannelInput("upPercent-chn", upPercentInfo["chnType"], upPercentInfo["chn"], "analog");
        jCommon.controlDOMShow("upPercent-dataType");
      }
    },
    initBPPCTimeConstantChannel: function (loopInfo) {
      var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
      if (!jCommon.empty(loopInfo["bd"])) {
        var bdInfo = loopInfo["bd"];
        for (var key in bdInfo) {
          jCommon.setHtmlValue("bd-" + key, bdInfo[key]);
          jCommon.setClassListValue("bd-" + key, bdInfo[key]);
          jCommon.setDataSaveProperty("bd-" + key, "/loops/" + loopIndex + "/bd/" + key);
        }
        channelPage.setChannelConfig(bdInfo["chnType"], bdInfo["chn"], "bd-chn");
        jCommon.setHtmlValue("bd-chnLabel", channelPage.getChannelInputLabel(bdInfo["chnType"], bdInfo["chn"]));
        jCommon.controlDOMShow("bd-dataType");
      }
      if (!jCommon.empty(loopInfo["po4"])) {
        var po4Info = loopInfo["po4"];
        for (var key in po4Info) {
          jCommon.setHtmlValue("po4-" + key, po4Info[key]);
          jCommon.setClassListValue("po4-" + key, po4Info[key]);
          jCommon.setDataSaveProperty("po4-" + key, "/loops/" + loopIndex + "/po4/" + key);
        }
        channelPage.setChannelConfig(po4Info["chnType"], po4Info["chn"], "po4-chn");
        jCommon.setHtmlValue("po4-chnLabel", channelPage.getChannelInputLabel(po4Info["chnType"], po4Info["chn"]));
        jCommon.controlDOMShow("po4-dataType");
      }
      if (!jCommon.empty(loopInfo["nh3"])) {
        var nh3Info = loopInfo["nh3"];
        for (var key in nh3Info) {
          jCommon.setHtmlValue("nh3-" + key, nh3Info[key]);
          jCommon.controlDOMShow("nh3-" + key);
          jCommon.setClassListValue("nh3-" + key, nh3Info[key]);
          jCommon.setDataSaveProperty("nh3-" + key, "/loops/" + loopIndex + "/nh3/" + key);
        }
        channelPage.setChannelConfig(nh3Info["chnType"], nh3Info["chn"], "nh3-chn");
        jCommon.setHtmlValue("nh3-chnLabel", channelPage.getChannelInputLabel(nh3Info["chnType"], nh3Info["chn"]));
        jCommon.controlDOMShow("nh3-dataType");
      }
      if (!jCommon.empty(loopInfo["pH"])) {
        var pHInfo = loopInfo["pH"];
        for (var key in pHInfo) {
          jCommon.setHtmlValue("pH-" + key, pHInfo[key]);
          jCommon.controlDOMShow("pH-" + key);
          jCommon.setClassListValue("pH-" + key, pHInfo[key]);
          jCommon.setDataSaveProperty("pH-" + key, "/loops/" + loopIndex + "/pH/" + key);
        }
        channelPage.setChannelConfig(pHInfo["chnType"], pHInfo["chn"], "pH-chn");
        jCommon.setHtmlValue("pH-chnLabel", channelPage.getChannelInputLabel(pHInfo["chnType"], pHInfo["chn"]));
        jCommon.controlDOMShow("pH-dataType");
      }
      if (!jCommon.empty(loopInfo["rateManual"])) {
        var rateManualInfo = loopInfo["rateManual"];
        for (var key in rateManualInfo) {
          jCommon.setHtmlValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setClassListValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setDataSaveProperty("rateManual-" + key, "/loops/" + loopIndex + "/rateManual/" + key);
        }
        channelPage.setChannelConfig(rateManualInfo["chnType"], rateManualInfo["chn"], "rateManual-chn");
        jCommon.controlDOMShow("rateManual-dataType");
      }
    },
    getFeedDevicesUnit(feedDeviceInfo) {
      if (!jCommon.empty(feedDeviceInfo["baseUnit"])) {
        var baseUnitValue = feedDeviceInfo["metricFlag"] ? "M-" + feedDeviceInfo["baseUnit"] : "I-" + feedDeviceInfo["baseUnit"]
        var baseUnitList = constVar.getFeedDevicesBaseUnit();
        var timeUnitList = constVar.getFeedDevicesTimeUnit();
        var baseUnitLabel = "";
        var timeUnitLabel = ""
        baseUnitList.forEach(function (item) {
          if (item["value"] === baseUnitValue) {
            baseUnitLabel = item["name"];
          }
        })
        timeUnitList.forEach(function (item) {
          if (item["value"] === feedDeviceInfo["timeUnit"]) {
            timeUnitLabel = item["name"];
          }
        })
        if (jCommon.empty(feedDeviceInfo["timeUnit"])) {
          return baseUnitLabel;
        } else {
          return baseUnitLabel + "/" + timeUnitLabel;
        }
      } else {
        return "";
      }
    },
    initRunTimeConstantChannel: function (loopInfo) {
      var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
      if (!jCommon.empty(loopInfo["sp"])) {
        var spInfo = loopInfo["sp"];
        for (var key in spInfo) {
          jCommon.setHtmlValue("sp-" + key, spInfo[key]);
          jCommon.setClassListValue("sp-" + key, spInfo[key]);
          jCommon.setDataSaveProperty("sp-" + key, "/loops/" + loopIndex + "/sp/" + key);
        }
        channelPage.setChannelConfig(spInfo["chnType"], spInfo["chn"], "sp-chn");
        jCommon.controlDOMShow("sp-chn");
        jCommon.controlDOMShow("sp-dataType");
      }
      if (!jCommon.empty(loopInfo["rateManual"])) {
        var rateManualInfo = loopInfo["rateManual"];
        for (var key in rateManualInfo) {
          jCommon.setHtmlValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setClassListValue("rateManual-" + key, rateManualInfo[key]);
          jCommon.setDataSaveProperty("rateManual-" + key, "/loops/" + loopIndex + "/rateManual/" + key);
        }
        channelPage.setChannelConfig(rateManualInfo["chnType"], rateManualInfo["chn"], "rateManual-chn");
        jCommon.controlDOMShow("rateManual-chn");
        jCommon.controlDOMShow("rateManual-dataType");
      }
      if (!jCommon.empty(loopInfo["fallback"])) {
        var fallbackInfo = loopInfo["fallback"];
        for (var key in fallbackInfo) {
          jCommon.setHtmlValue("fallback-" + key, fallbackInfo[key]);
          jCommon.setClassListValue("fallback-" + key, fallbackInfo[key]);
          jCommon.setDataSaveProperty("fallback-" + key, "/loops/" + loopIndex + "/fallback/" + key);
        }
        channelPage.setChannelConfig(fallbackInfo["chnType"], fallbackInfo["chn"], "fallback-chn");
        jCommon.controlDOMShow("fallback-chn");
        jCommon.controlDOMShow("fallback-dataType");
      }
      if (!jCommon.empty(loopInfo["deadband"])) {
        var deadbandInfo = loopInfo["deadband"];
        for (var key in deadbandInfo) {
          jCommon.setHtmlValue("deadband-" + key, deadbandInfo[key]);
          jCommon.controlDOMShow("deadband-" + key);
          jCommon.setClassListValue("deadband-" + key, deadbandInfo[key]);
          jCommon.setDataSaveProperty("deadband-" + key, "/loops/" + loopIndex + "/deadband/" + key);
        }
        channelPage.initChannelInput("deadband-chn", deadbandInfo["chnType"], deadbandInfo["chn"], "analog");
        jCommon.controlDOMShow("deadband-dataType");
      }
      if (!jCommon.empty(loopInfo["sg"])) {
        var sgInfo = loopInfo["sg"];
        for (var key in sgInfo) {
          jCommon.setHtmlValue("sg-" + key, sgInfo[key]);
          jCommon.controlDOMShow("sg-" + key);
          jCommon.setDataSaveProperty("sg-" + key, "/loops/" + loopIndex + "/sg/" + key);
        }
        channelPage.initChannelInput("sg-chn", sgInfo["chnType"], sgInfo["chn"], "analog");
        jCommon.controlDOMShow("sg-dataType");
      }
      if (!jCommon.empty(loopInfo["placeholder"])) {
        var placeholderInfo = loopInfo["placeholder"];
        for (var key in placeholderInfo) {
          jCommon.setHtmlValue("placeholder-" + key, placeholderInfo[key]);
          jCommon.setDataSaveProperty("placeholder-" + key, "/loops/" + loopIndex + "/placeholder/" + key);
        }
        channelPage.initChannelInput("placeholder-chn", placeholderInfo["chnType"], placeholderInfo["chn"], "analog");
        jCommon.controlDOMShow("placeholder-dataType");
      }
      jCommon.setClassListValue("fdDevice-unit", systemFeed.getFeedDevicesUnit(loopInfo["fdDevice"]));
    },
    initRunTimeFeedDevice: function (feedDeviceInfo) {
      var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
      var fdvInfo = feedDeviceInfo["fdv"];
      jCommon.setHtmlValue("outputChnAnalogLabel", channelPage.getChannelInputLabel(feedDeviceInfo["outputChnType"], feedDeviceInfo["outputChn"]));
      jCommon.setHtmlValue("outputChnName", channelPage.getChannelInfo(feedDeviceInfo["outputChnType"], feedDeviceInfo["outputChn"], "name"));
      jCommon.setDomElementValue(feedDeviceInfo, "/loops/" + loopIndex + "/fdDevice/");
      if (feedDeviceInfo["fdvType"] === 2) {
        for (var key in fdvInfo) {
          jCommon.setHtmlValue("flowmeterCtrl-" + key, fdvInfo[key]);
          jCommon.setDataSaveProperty("flowmeterCtrl-" + key, "/loops/" + loopIndex + "/fdDevice/fdv/" + key);
        }
        jCommon.setHtmlValue("flowmeterCtrl-fmChnAnalogLabel", channelPage.getChannelInputLabel(fdvInfo["fmChnType"], fdvInfo["fmChn"]));
        var flowmeterCtrlChannelInfo = channelPage.getChannelInfo(fdvInfo["fmChnType"], fdvInfo["fmChn"]);
        if (!jCommon.empty(flowmeterCtrlChannelInfo)) {
          jCommon.setHtmlValue("flowmeterCtrl-fmChnName", flowmeterCtrlChannelInfo["name"]);
          jCommon.setClassListValue("flowmeterCtrl-fmChn-simDataUnit", channelPage.getChannelUnitLabel(flowmeterCtrlChannelInfo));
        }
        jCommon.showSvgDom("FMControl");
      } else {
        jCommon.showSvgDom("NoFMControl");
      }
    },
    initBPPCRunTimeFeedDevice: function (upFeedDeviceInfo, dnFeedDeviceInfo) {
      var upLoopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
      var upFdvInfo = upFeedDeviceInfo["fdv"];
      var upFlowmeterCtrlChannelInfo = channelPage.getChannelInfo(upFdvInfo["fmChnType"], upFdvInfo["fmChn"]);
      // jCommon.setDomElementValue(upFeedDeviceInfo, "/loops/" + upLoopIndex + "/fdDevice/");
      if (upFeedDeviceInfo["fdvType"] === 2) {
        for (var key in upFdvInfo) {
          jCommon.setHtmlValue("up-flowmeterCtrl-" + key, upFdvInfo[key]);
          jCommon.setDataSaveProperty("up-flowmeterCtrl-" + key, "/loops/" + upLoopIndex + "/fdDevice/fdv/" + key);
        }
        jCommon.setHtmlValue("up-flowmeterCtrl-fmChnAnalogLabel", channelPage.getChannelInputLabel(upFdvInfo["fmChnType"], upFdvInfo["fmChn"]));
        if (!jCommon.empty(upFlowmeterCtrlChannelInfo)) {
          jCommon.setHtmlValue("up-flowmeterCtrl-fmChnName", upFlowmeterCtrlChannelInfo["name"]);
          jCommon.setClassListValue("up-flowmeterCtrl-fmChn-simDataUnit", channelPage.getChannelUnitLabel(upFlowmeterCtrlChannelInfo));
        }
        jCommon.showSvgDom("up-FMControl");
      } else {
        jCommon.showSvgDom("up-NoFMControl");
      }
      var dnLoopIndex = Number(jCommon.getUrlParams("Lp"));
      var dnFdvInfo = dnFeedDeviceInfo["fdv"];
      var dnFlowmeterCtrlChannelInfo = channelPage.getChannelInfo(dnFdvInfo["fmChnType"], dnFdvInfo["fmChn"]);
      // jCommon.setDomElementValue(dnFeedDeviceInfo, "/loops/" + dnLoopIndex + "/fdDevice/");
      if (dnFeedDeviceInfo["fdvType"] === 2) {
        for (var key in dnFdvInfo) {
          jCommon.setHtmlValue("dn-flowmeterCtrl-" + key, dnFdvInfo[key]);
          jCommon.setDataSaveProperty("dn-flowmeterCtrl-" + key, "/loops/" + dnLoopIndex + "/fdDevice/fdv/" + key);
        }
        jCommon.setHtmlValue("dn-flowmeterCtrl-fmChnAnalogLabel", channelPage.getChannelInputLabel(dnFdvInfo["fmChnType"], dnFdvInfo["fmChn"]));
        if (!jCommon.empty(dnFlowmeterCtrlChannelInfo)) {
          jCommon.setHtmlValue("dn-flowmeterCtrl-fmChnName", dnFlowmeterCtrlChannelInfo["name"]);
          jCommon.setClassListValue("dn-flowmeterCtrl-fmChn-simDataUnit", channelPage.getChannelUnitLabel(dnFlowmeterCtrlChannelInfo));
        }
        jCommon.showSvgDom("dn-FMControl");
      } else {
        jCommon.showSvgDom("dn-NoFMControl");
      }
    },
    initPidData: function (pidsList, pidIndex, prefix) {
      var prefix = prefix ? prefix : "";
      jCommon.setHtmlValue(prefix + "pid-index", pidIndex);
      var pidInfo = pidsList[pidIndex];
      if (!jCommon.empty(pidInfo)) {
        for (var key in pidInfo) {
          jCommon.setHtmlValue(prefix + "pid-" + key, pidInfo[key]);
          jCommon.setDataSaveProperty(prefix + "pid-" + key, "/plc/pids/" + pidIndex + "/" + key);
          jCommon.controlDOMShow(prefix + "pid-" + key);
        }
      }
    },
    handlePidLiveData(message, prefix) {
      var pidIndex = jCommon.getHtmlValue(prefix + "pid-index");
      var pidInfo = message["plc"]["pid"][pidIndex];
      jCommon.setDomElementLiveValue(pidInfo, prefix + "pid-");
    },
    resetPreDiAnData: function (value, id) {
      var commonKeyId = id.replace("-typeLabel", "");
      jCommon.setHtmlValue(commonKeyId + "-type", value, function () {
        jCommon.controlDOMShow(commonKeyId + "-type");
        jCommon.setHtmlValue(commonKeyId + "-chn", 0);
        jCommon.setHtmlValue(commonKeyId + "-chnType", 0);
        jCommon.setChannelInputValue(commonKeyId + "-chnAnalogLabel", "");
        jCommon.setChannelInputValue(commonKeyId + "-chnDigitalLabel", "");
        jCommon.setHtmlValue(commonKeyId + "-name", "");
        jCommon.setHtmlValue(commonKeyId + "-trendEn", false);
        jCommon.setDropDownMenuValueAndLabel(commonKeyId + "-pdLoop", -1);
        jCommon.setDropDownMenuValueAndLabel(commonKeyId + "-pdChn", 0);
        repeatAllPage.updateParameter(commonKeyId + "-type");
      });
    },
    getSystemLoopUrl: function (message, ctrltype, loopIndex) {
      var systemList = message["systems"];
      var systemValue = -1;
      var feedValue = -1;
      systemList.forEach(function (systemItem, systemIndex) {
        if (!jCommon.empty(systemItem["feeds"])) {
          systemItem["feeds"].forEach(function (feedItem, feedIndex) {
            if (feedItem["ctrlType"] === ctrltype && feedItem["loopIndex"] === loopIndex) {
              systemValue = systemIndex;
              feedValue = feedIndex;
            }
          })
        }
      })
      return systemFeed.getControlTypeUrl(ctrltype, systemValue, feedValue, loopIndex);
    },
    setRateManualCcnst_OP: function () {
      if (jCommon.getHtmlValue("rateManual-dataType") == 2 && jCommon.getHtmlValue("mode") == 1) {
        var is_upload = jCommon.getHtmlAttriute("rateManual-dataType", "is_upload");
        if (is_upload == 0) {
          jCommon.setHtmlValue("rateManual-cnst_OP", jCommon.getHtmlValue("feedSp"));
          // repeatAllPage.updateParameter("rateManual-cnst_OP");
          jCommon.setHtmlAttribute("rateManual-dataType", "is_upload", 1);
        }
      } else {
        jCommon.setHtmlAttribute("rateManual-dataType", "is_upload", 0);
      }
    },
    setupPercentCnst_OP: function () {
      if (jCommon.getHtmlValue("upPercent-dataType") == 2 && jCommon.getHtmlValue("mode") == 1) {
        var is_upload = jCommon.getHtmlAttriute("upPercent-dataType", "is_upload");
        if (is_upload == 0) {
          jCommon.setHtmlValue("upPercent-cnst_OP", jCommon.getHtmlValue("upPercent_SP"));
          // repeatAllPage.updateParameter("upPercent-cnst_OP");
          jCommon.setHtmlAttribute("upPercent-dataType", "is_upload", 1);
        }
      } else {
        jCommon.setHtmlAttribute("upPercent-dataType", "is_upload", 0);
      }
    },
    updateSystemMonitorName: function () {
      var nameValue = jCommon.getHtmlValue("name")
      var monitorTypeInfo = constVar.getAnaDigMapPage();
      var stringInfo = {};
      repeatAllPage.parameterData.systems.forEach(function (systemInfo, systemIndex) {
        systemInfo["monitor"].forEach(function (monitorInfo, monitorIndex) {
          if (monitorInfo.type == monitorTypeInfo["type"] && monitorInfo.chnType == monitorTypeInfo["chnType"] && monitorInfo.chn == jCommon.getUrlParams("p")) {
            stringInfo["/systems/" + systemIndex + "/monitor/" + monitorIndex + "/name"] = nameValue
          }
        })
      })
      cmdlist.updateParameter(stringInfo);
    }
  }

  var curveConfig = {
    configInfo: [],
    setCurveConfigInfo: function (message) {
      curveConfig.configInfo = message;
    },
    setCurveConfigDomName: function (curveIndex) {
      var curveConfigName = "Config";
      if (!jCommon.empty(curveConfig["configInfo"][curveIndex]) && !jCommon.empty(curveConfig["configInfo"][curveIndex]["name"])) {
        curveConfigName = curveConfig["configInfo"][curveIndex]["name"];
      }
      jCommon.setHtmlAttribute("curveConfigName", "href", "#curve&p=" + Number(curveIndex + 1));
      jCommon.setHtmlValue("curveConfigName", curveConfigName);
    }
  }

  var toolsControl = {
    toggleFirstChild: function (event) {
      event.stopPropagation()
      var info = document.getElementById("more-tools").getBoundingClientRect();
      jCommon.setHtmlStyleAttribute("moreToolsDialog", "left", info.left + "px");
      jCommon.setHtmlStyleAttribute("moreToolsDialog", "top", Number(info.top + info.height) + "px");
      jCommon.removeHtmlClass(".btn-left-top-item", "menu-active")
      if (jCommon.checkClassNameExits("moreToolsDialog", "hide")) {
        jCommon.removeHtmlClass("#moreToolsDialog", "hide");
      } else {
        toolsControl.hideToolsDialog();
      }
    },
    toggleChild: function (event) {
      event.stopPropagation();
      var user_account = Number(jCommon.getLocalStorge("user_account"));
      if (event.target.id == "monitor-0" && user_account > 1) {
        monitorClick(event);
      }
      jCommon.removeHtmlClass(".btn-left-top-item", "menu-active")
      var hash = event.target.getAttribute("data-href");
      jCommon.addHtmlClass(".childNode", "hide");
      if (jCommon.empty(hash)) {
        var nextChild = event.target.nextElementSibling;
        if (nextChild) {
          if (nextChild.className.indexOf("hide") > -1) {
            jCommon.addDomClass(event.target, "menu-active");
            jCommon.removeDomClass(nextChild, "hide");
          } else {
            jCommon.addDomClass(nextChild, "hide");
          }
        }
      } else {
        userlogin.btnLoginClick(event.target);
      }
    },
    hideToolsDialog: function () {
      jCommon.addHtmlClass("#moreToolsDialog", "hide");
      jCommon.addHtmlClass(".childNode", "hide");
    }
  }


  var dialogObject = {
    show: function (list, keyName, callbackfun) {
      var domElement = document.getElementById("pyxis-common-dialog");
      domElement.querySelector('ul.dropdown-menu').innerHTML = "";
      domElement.onclick = callbackfun.bind(this);
      var rowNumber = 20;
      var allPage = Math.ceil(list.length / rowNumber);
      if (list.length > 10) {
        domElement.querySelector('ul.dropdown-menu').classList.add("wide");
      }
      list.forEach(function (opt, index) {
        var elementDataAttribute = "";
        for (var key in opt) {
          if (jCommon.isArray(opt[key]) || jCommon.isObject(opt[key])) {
            elementDataAttribute += " data-" + key + "='" + JSON.stringify(opt[key]) + "'";
          } else {
            elementDataAttribute += ' data-' + key + '="' + opt[key] + '"';
          }
        }
        var item = document.createElement("li");
        item.className = "select-item-" + Math.ceil((index + 1) / rowNumber);
        if (jCommon.empty(keyName)) {
          item.innerHTML = '<button class="btn btn-default select-item"' + elementDataAttribute + '>' + opt + '</button>';
        } else {
          item.innerHTML = '<button class="btn btn-default select-item"' + elementDataAttribute + '>' + opt[keyName] + '</button>';
        }
        domElement.querySelector('ul.dropdown-menu').appendChild(item);
      })
      domElement.querySelector('.currentPage').value = 1;
      domElement.querySelector('.allPage').value = allPage;
      domElement.classList.remove("hide")
      dialogObject.controlSelectPage();
    },
    hide: function () {
      var domElement = document.getElementById("pyxis-common-dialog");
      domElement.classList.add('hide');
    },
    controlSelectPage: function () {
      var domElement = document.getElementById("pyxis-common-dialog");
      var currentPage = Number(domElement.querySelector('.currentPage').value);
      if (currentPage === 1) {
        domElement.querySelector('.pre-select-page').classList.add("hide");
      } else {
        domElement.querySelector('.pre-select-page').classList.remove("hide");
      }
      var allPage = Number(domElement.querySelector('.allPage').value);
      if (currentPage === allPage) {
        domElement.querySelector('.next-select-page').classList.add("hide");
      } else {
        domElement.querySelector('.next-select-page').classList.remove("hide");
      }
      for (var index = 1; index <= allPage; index++) {
        var indexDomList = domElement.querySelectorAll("li.select-item-" + index);
        if (currentPage === index) {
          for (var key = 0; key < indexDomList.length; key++) {
            indexDomList[key].classList.remove("hide");
          }
        } else {
          for (var key = 0; key < indexDomList.length; key++) {
            indexDomList[key].classList.add("hide");
          }
        }
      }
    },
    dropdownElementClickCallback: function (event) {
      var domElement = document.getElementById("pyxis-common-dialog");
      event.stopPropagation();
      if (event.target.classList.contains("dropdown")) {
        domElement.classList.remove('hide');
      } else if (event.target.classList.contains("btn-close")) {
        domElement.classList.add('hide');
      } else if (event.target.classList.contains("pre-select-page") || event.target.classList.contains("pre-span-label")) {
        domElement.querySelector('.currentPage').value = Number(domElement.querySelector('.currentPage').value) - 1;
        dialogObject.controlSelectPage();
      } else if (event.target.classList.contains("next-select-page") || event.target.classList.contains("next-span-label")) {
        domElement.querySelector('.currentPage').value = Number(domElement.querySelector('.currentPage').value) + 1;
        dialogObject.controlSelectPage();
      } else if (event.target.classList.contains("select-item")) {
        domElement.classList.add('hide');
      }
    }
  }

  var pyxisControl = {
    handleProbeListConnect: function (message) {
      //probeOnline
      var onLineInfo = message["probes"]["connected"];
      // var onLineBrushInfo = message["probes"]["brushConnected"];
      var domList = document.getElementsByClassName("pyxis-probe");
      for (var index = 0; index < domList.length; index++) {
        var domItem = domList[index];
        if (!jCommon.empty(jCommon.getHtmlValue(domItem.id))) {
          jCommon.setHtmlValue("row-" + index + "-connected", onLineInfo[index]);
          // jCommon.setHtmlValue("row-"+index+"-brushConnected", onLineBrushInfo[index]);
          jCommon.controlDOMShow("row-" + index + "-connected");
          // jCommon.controlDOMShow("row-"+index+"-brushConnected");
        }
      }
    },
    handleProbeConnect: function (message) {
      //probeOnline
      var onLineInfo = message["probes"]["connected"];
      jCommon.setHtmlValue("probeOnline", onLineInfo[jCommon.getHtmlValue("idxProbe")]);
      jCommon.controlDOMShow("probeOnline");
      // var onLineBrushInfo = message["probes"]["brushConnected"];
      // jCommon.setHtmlValue("probeBrushOnline", onLineBrushInfo[jCommon.getHtmlValue("idxProbe")]);
      // jCommon.controlDOMShow("probeBrushOnline");
    }
  }
  window.selectDataAndTimeDialog = selectDataAndTimeDialog;
  window.repeatAllPage = repeatAllPage;
  window.hanleLiveDataObject = hanleLiveDataObject;
  window.ToolstipDialog = ToolstipDialog;
  window.userlogin = userlogin;
  window.pageNavigate = pageNavigate;
  window.channelPage = channelPage;
  window.dyGraphConfig = dyGraphConfig;
  window.trendPage = trendPage;
  window.systemFeed = systemFeed;
  window.curveConfig = curveConfig;
  window.toolsControl = toolsControl;
  window.dialogObject = dialogObject;
})()
