/**
 *  OGic constants and maps
 */


(function () {
  var constVar = {
    getImpUnits: function () {
      return [
        { "value": 0, "name": "base unit" },
        { "value": 41, "name": "Amps" },
        { "value": 1, "name": "bbl31" },
        { "value": 2, "name": "bbl315" },
        { "value": 3, "name": "bbl40" },
        { "value": 4, "name": "bbl42" },
        { "value": 44, "name": "Btu/hr" },
        { "value": 5, "name": "Cycles" },
        { "value": 6, "name": "℉" },
        { "value": 7, "name": "floz" },
        { "value": 8, "name": "ft" },
        { "value": 9, "name": "ft^3" },
        { "value": 10, "name": "galUK" },
        { "value": 11, "name": "galUS" },
        { "value": 43, "name": "hrft^2F/Btu" },
        { "value": 12, "name": "in" },
        { "value": 13, "name": "in^3" },
        { "value": 14, "name": "klb" },
        { "value": 15, "name": "lb" },
        { "value": 16, "name": "lbf" },
        { "value": 17, "name": "lb/gal" },
        { "value": 18, "name": "lb/ton" },
        { "value": 19, "name": "MG" },
        { "value": 20, "name": "MPY" },
        { "value": 21, "name": "µS" },
        { "value": 22, "name": "mV" },
        { "value": 23, "name": "NTU" },
        { "value": 24, "name": "oz" },
        { "value": 25, "name": "%" },
        { "value": 26, "name": "pH" },
        { "value": 27, "name": "PI" },
        { "value": 28, "name": "ppb" },
        { "value": 29, "name": "ppm" },
        { "value": 30, "name": "psi" },
        { "value": 31, "name": "psig" },
        { "value": 32, "name": "pt" },
        { "value": 33, "name": "qt" },
        { "value": 34, "name": "Rf" },
        { "value": 45, "name": "SCV" },
        { "value": 35, "name": "ton" },
        { "value": 36, "name": "" },
        { "value": 42, "name": "Volts" },
        { "value": 39, "name": "Watts" },
        { "value": 37, "name": "yd" },
        { "value": 38, "name": "yd^3" }
      ];
    },
    getMetricUnit: function () {
      return [
        { 'value': 0, 'name': 'base unit' },
        { 'value': 25, 'name': 'Amps' },
        { 'value': 1, 'name': 'cm' },
        { 'value': 2, 'name': '℃' },
        { 'value': 3, 'name': 'g' },
        { 'value': 4, 'name': 'g/L' },
        { 'value': 5, 'name': 'kg' },
        { 'value': 6, 'name': 'kg/MT' },
        { 'value': 7, 'name': 'km' },
        { 'value': 8, 'name': 'kPa' },
        { 'value': 9, 'name': 'kPag' },
        { 'value': 10, 'name': 'L' },
        { 'value': 11, 'name': 'm' },
        { 'value': 12, 'name': 'm^3' },
        { 'value': 27, 'name': 'm^2K/Watt' },
        { 'value': 28, 'name': 'mg/l' },
        { 'value': 13, 'name': 'mg/m^2' },
        { 'value': 14, 'name': 'micron' },
        { 'value': 15, 'name': 'mL' },
        { 'value': 16, 'name': 'mm' },
        { 'value': 17, 'name': 'MT' },
        { 'value': 18, 'name': 'N' },
        { 'value': 19, 'name': 'Pa' },
        { 'value': 20, 'name': '%' },
        { 'value': 21, 'name': 'pH' },
        { 'value': 22, 'name': 'ppb' },
        { 'value': 23, 'name': 'ppm' },
        { 'value': 29, 'name': 'SCV' },
        { 'value': 26, 'name': 'Volts' },
        { 'value': 24, 'name': 'Watts' }
      ];
    },
    getTimeUnits: function () {
      return [
        { "value": 0, "name": "Time Unit" },
        { "value": 1, "name": "Sec" },
        { "value": 2, "name": "Min" },
        { "value": 3, "name": "Hour" },
        { "value": 4, "name": "Day" },
        { "value": 5, "name": "Week" },
        { "value": 6, "name": "Year" }
      ]
    },
    getSignalType: function (inputType) {
      if (inputType === "aichannel") {
        return [{
          "value": 0,
          "name": "4-20mA"
        }, {
          "value": 1,
          "name": "0-20mA"
        }, {
          "value": 2,
          "name": "Thermocouple"
        }, {
          "value": 3,
          "name": "Pyxis Sensor"
        }];
      } else {
        return [{
          "value": 0,
          "name": "4-20mA"
        }, {
          "value": 1,
          "name": "0-20mA"
        }];
      }
    },
    getAlarmStatus: function () {
      return [
        { "value": 0, "name": "Alarm Disabled" },
        { "value": 1, "name": "Alarm Enabled" },
        { "value": 2, "name": "Channel" }
      ];
    },
    getNetRawMinAndMax: function () {
      return {
        0: {
          min: 0,
          max: 65535
        },
        1: {
          min: 0,
          max: 32767
        },
        2: {
          min: -32768,
          max: 32767
        },
        3: {
          min: -32768,
          max: 32767
        }
      }
    },
    getTrendType: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "Analog" },
        { "value": 2, "name": "Digital" },
        { "value": 3, "name": "Predefined" }
      ];
    },
    getMonitorType: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "Analog" },
        { "value": 2, "name": "Digital" },
        { "value": 3, "name": "Predefined" },
        { "value": 4, "name": "Header" }
      ];
    },
    getEmailAlarmAnalogType: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "Analog" },
        { "value": 3, "name": "Predefined" }
      ];
    },
    getEmailAlarmDigitalType: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 2, "name": "Digital" }
      ];
    },
    getSystemType: function () {
      return [
        { "value": 0, "name": "General" },
        { "value": 1, "name": "Boiler" },
        { "value": 2, "name": "Cooling Tower" },
      ];
    },
    getControlType: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "Ratio" },
        { "value": 2, "name": "PID" },
        { "value": 3, "name": "Schedule" },
        { "value": 4, "name": "Interval" },
        { "value": 5, "name": "PFC" },
        { "value": 6, "name": "OnOff" },
        { "value": 7, "name": "BPPC" },
        { "value": 8, "name": "Advanced PID" }
      ];
    },
    getControlTypeName: function (type) {
      if (type === 0) {
        return "Not Configured";
      } else {
        var list = constVar.getControlType();
        for (var index = 0; index < list.length; index++) {
          if (list[index]["value"] === type) {
            return list[index]["name"];
          }
        }
      }
    },
    getSchedulePreBleed: function () {
      return [
        { "value": 0, "name": "Not Used" },
        { "value": 1, "name": "Time Based" },
        { "value": 2, "name": "Conductivity Based" }
      ];
    },
    getScheduleWeek: function () {
      return [
        { "value": 1, "name": "One Week Schedule" },
        { "value": 2, "name": "Two Week Schedule" },
        { "value": 4, "name": "Four Week Schedule" }
      ];
    },
    getLoopMode: function () {
      return [
        { "value": 0, "name": "Stop" },
        { "value": 1, "name": "Manual" },
        { "value": 2, "name": "Auto" }
      ];
    },
    getProcessType: function () {
      return [
        { "value": 0, "name": "ppm" },
        { "value": 1, "name": "lb/ton" },
        { "value": 2, "name": "mg/m^2" },
        { "value": 3, "name": "kg/MT" }
      ];
    },
    getPlaceholderByProcessType: function (processType) {
      var objectInfo = {
        "0": "Concentration Channel,Concentration Constant",
        "1": "Consistency Channel,Consistency Constant",
        "2": "Prod Solids Channel,Prod Solids Constant",
        "3": "Consistency Channel,Consistency Constant"
      };
      return objectInfo[processType];
    },
    getFeedDevicesType: function (ctrlType) {
      if (ctrlType !== 2) {
        return [
          { "value": 0, "name": "None" },
          { "value": 1, "name": "Analog Output" },
          { "value": 2, "name": "Pulse Output" },
          { "value": 3, "name": "On/Off" }
        ];
      } else {
        return [
          { "value": 0, "name": "None" },
          { "value": 1, "name": "Analog Output" },
          { "value": 2, "name": "Pulse Output" },
          { "value": 3, "name": "On/Off" },
          { "value": 4, "name": "Time Proportional" }
        ];
      }
    },
    getFeedDevicesBaseUnit: function () {
      return [
        { "value": "I-0", "name": "base unit" },
        { "value": "M-15", "name": "mL" },
        { "value": "M-10", "name": "L" },
        { "value": "M-12", "name": "m^3" },
        { "value": "I-11", "name": "galUS" },
        { "value": "I-25", "name": "%" }
      ];
    },
    getFeedDevicesTimeUnit: function () {
      return [
        { "value": 0, "name": "Time Unit" },
        { "value": 1, "name": "Sec" },
        { "value": 2, "name": "Min" },
        { "value": 3, "name": "Hour" },
        { "value": 4, "name": "Day" }
      ];
    },
    getFeedDevicesFVType: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 2, "name": "Flow Meter Control" },
        { "value": 3, "name": "Flow Meter Monitor" }
      ];
    },
    getChannelDataKey: function () {
      return {
        1: "ais",
        2: "aos",
        3: "aitns",
        4: "afbs",
        5: "dis",
        6: "dos",
        7: "ditns",
        8: "dfbs"
      };
    },
    getRevertChannelThumbnail: function (key) {
      var list = {
        "ais": 1,
        "aos": 2,
        "aitns": 3,
        "afbs": 4,
        "dis": 5,
        "dos": 6,
        "ditns": 7,
        "dfbs": 8
      };
      if (key) {
        return list[key];
      } else {
        return list;
      }
    },
    getSystemCycle: function () {
      return [
        { "value": 0, "name": "Flow" },
        { "value": 1, "name": "Conductivity" },
        { "value": 2, "name": "Other" }
      ];
    },
    getSystemBlowDownType: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "On/Off" },
        { "value": 2, "name": "Mtr Valve" },
        { "value": 3, "name": "Analog" }
      ];
    },
    getFBAnalogOper: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "Sum" },
        { "value": 2, "name": "Subtract" },
        { "value": 3, "name": "Multiply" },
        { "value": 4, "name": "Divide" },
        { "value": 5, "name": "Log" },
        { "value": 6, "name": "NaturalLog" },
        { "value": 7, "name": "Exponential" },
        { "value": 8, "name": "Square" },
        { "value": 9, "name": "Square Root" },
        { "value": 10, "name": "Power" },
        { "value": 11, "name": "Modulo" },
        { "value": 12, "name": "Maximum" },
        { "value": 13, "name": "Minimum" },
        { "value": 14, "name": "Absolute" },
        { "value": 15, "name": "Integer" },
        { "value": 16, "name": "Round" },
        { "value": 17, "name": "Daily" },
        { "value": 18, "name": "Weekly" },
        { "value": 19, "name": "Monthly" },
        { "value": 20, "name": "Exp Moving Avg" },
        { "value": 21, "name": "Simple Moving Avg" },
        { "value": 22, "name": "Digital Switch" },
        { "value": 23, "name": "Tracker Calib" },
        { "value": 24, "name": "Random Number" },
        { "value": 25, "name": "Totalizer" },
        { "value": 26, "name": "Counter" },
        { "value": 27, "name": "DeadTime" },
        { "value": 28, "name": "Tank Level Volume" },
        { "value": 29, "name": "Trig" },
        // { "value": 30, "name": "Redundant Pump" },
        { "value": 31, "name": "Network Input" }
      ]
    },
    getFBAnalogTrigger: function () {
      return [
        { "value": 0, "name": "1 Second" },
        { "value": 1, "name": "10 Seconds" },
        { "value": 2, "name": "1 Minute" },
        { "value": 3, "name": "10 Minutes" },
        { "value": 4, "name": "1 Hour" },
        { "value": 5, "name": "Channel" },
      ];
    },
    getFBAnalogSampleRate: function () {
      return [
        { "value": 0, "name": "1 Sec - 1/2 hr" },
        { "value": 1, "name": "1 Secs - 5 hrs" },
        { "value": 2, "name": "1 Min - 5 hrs" },
        { "value": 3, "name": "1 Min - 10 hrs" },
      ];
    },
    getFBAnalogTrigFunc: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "acos" },
        { "value": 2, "name": "asin" },
        { "value": 3, "name": "atan" },
        { "value": 4, "name": "atan2" },
        { "value": 5, "name": "cos" },
        { "value": 6, "name": "Pi" },
        { "value": 7, "name": "sin" },
        { "value": 8, "name": "tan" },
      ];
    },
    getPDModeList: function (ctrlType) {
      ctrlType = Number(ctrlType);
      if (ctrlType === 1) {
        //Ratio
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 4, "name": "FRAct" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" }
        ];
      } else if (ctrlType === 2) {
        //PID
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 4, "name": "FRAct" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" }
        ];
      } else if (ctrlType === 3) {
        //Schedule
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 4, "name": "FRAct" },
          { "value": 6, "name": "FdVol" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" }
        ];
      } else if (ctrlType === 4) {
        //Interval
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 4, "name": "FRAct" },
          { "value": 6, "name": "FdVol" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" }
        ];
      } else if (ctrlType === 5) {
        //PFC
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 4, "name": "FRAct" },
          { "value": 32, "name": "PFC-Factor" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" }
        ];
      } else if (ctrlType === 6) {
        //OnOff
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 4, "name": "FRAct" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" }
        ];
      } else if (ctrlType === 7) {
        //BPPC
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 4, "name": "FRAct" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" },
          { "value": 14, "name": "% Upblend SP" },
          { "value": 15, "name": "% Upblend AC" },
          { "value": 16, "name": "NAPO4 SP" },
          { "value": 17, "name": "NAPO4" },
          { "value": 18, "name": "PO4 SP" },
          { "value": 19, "name": "PO4" },
          { "value": 20, "name": "pH SP" },
          { "value": 21, "name": "pH" },
          { "value": 22, "name": "NH3" },
          { "value": 23, "name": "InBox" },
          { "value": 24, "name": "DayPIB" },
          { "value": 25, "name": "PDayPIB" },
          { "value": 26, "name": "WkPIB" },
          { "value": 27, "name": "PWkPIB" },
          { "value": 28, "name": "MthPIB" },
          { "value": 29, "name": "PMthPIB" },
          { "value": 33, "name": "FR BPPC TL" }
        ];
      } else {
        return [
          { "value": 0, "name": "Mode" },
          { "value": 1, "name": "StPtVal" },
          { "value": 2, "name": "ActPump" },
          { "value": 3, "name": "PumpCV" },
          { "value": 4, "name": "FRAct" },
          { "value": 5, "name": "Crtn" },
          { "value": 6, "name": "FdVol" },
          { "value": 7, "name": "DayFd" },
          { "value": 8, "name": "PDayFd" },
          { "value": 9, "name": "WkFd" },
          { "value": 10, "name": "PWkFd" },
          { "value": 11, "name": "MthFd" },
          { "value": 12, "name": "PMthFd" },
          { "value": 13, "name": "COC" },
          { "value": 14, "name": "% Upblend SP" },
          { "value": 15, "name": "% Upblend AC" },
          { "value": 16, "name": "NAPO4 SP" },
          { "value": 17, "name": "NAPO4" },
          { "value": 18, "name": "PO4 SP" },
          { "value": 19, "name": "PO4" },
          { "value": 20, "name": "pH SP" },
          { "value": 21, "name": "pH" },
          { "value": 22, "name": "NH3" },
          { "value": 23, "name": "InBox" },
          { "value": 24, "name": "DayPIB" },
          { "value": 25, "name": "PDayPIB" },
          { "value": 26, "name": "WkPIB" },
          { "value": 27, "name": "PWkPIB" },
          { "value": 28, "name": "MthPIB" },
          { "value": 29, "name": "PMthPIB" },
          { "value": 30, "name": "LoopCV" },
          { "value": 31, "name": "FRSP" },
          { "value": 32, "name": "PFC-Factor" },
          { "value": 33, "name": "FR BPPC TL" }
        ];
      }
    },
    getFBDigitalOper: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "IF State Logic" },
        { "value": 2, "name": "Boolean Logic" },
        { "value": 3, "name": "Timer" },
        { "value": 4, "name": "Network Input" },
        { "value": 5, "name": "Internal Channel" },
      ]
    },
    getFBDigitalTrigger: function () {
      return [
        { "value": 0, "name": "1 Second" },
        { "value": 1, "name": "10 Seconds" },
        { "value": 2, "name": "1 Minute" },
        { "value": 3, "name": "10 Minutes" },
        { "value": 4, "name": "1 Hour" }
      ];
    },
    getFBDigitalComprOps: function () {
      return [
        { "value": 0, "name": ">" },
        { "value": 1, "name": ">=" },
        { "value": 2, "name": "=" },
        { "value": 3, "name": "<=" },
        { "value": 4, "name": "<" },
        { "value": 5, "name": "<>" },
      ];
    },
    getFBDigitalBoolnOps: function () {
      return [
        { "value": 0, "name": "AND" },
        { "value": 1, "name": "OR" },
        { "value": 2, "name": "XOR" },
        { "value": 3, "name": "NOT AND" },
        { "value": 4, "name": "NOT OR" },
        { "value": 5, "name": "NOT" },
        { "value": 6, "name": "LATCH" },
        { "value": 7, "name": "TRIGGER" },
      ];
    },
    getModbusRS485BaudRate: function () {
      return [
        { "value": 300, "name": 300 },
        { "value": 600, "name": 600 },
        { "value": 1200, "name": 1200 },
        { "value": 4800, "name": 4800 },
        { "value": 9600, "name": 9600 },
        { "value": 19200, "name": 19200 },
        { "value": 38400, "name": 38400 },
        { "value": 57600, "name": 57600 },
        { "value": 115200, "name": 115200 },
      ];
    },
    getModbusRS485Parity: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "Odd" },
        { "value": 2, "name": "Even" }
      ];
    },
    getMonitorExceptionType: function () {
      return [
        { "value": 1, "name": "No Exceptions" },
        { "value": 2, "name": "Unusually Small" },
        { "value": 3, "name": "Unusually Large" },
        { "value": 4, "name": "Unusually Extreme" },
        { "value": 5, "name": "Below Spec Limit" },
        { "value": 6, "name": "Above Spec Limit" },
        { "value": 7, "name": "Outside Spec Limits" },
      ]
    },
    getMonitorGroupOrder: function () {
      return [
        { "value": 0, "name": "1 first" },
        { "value": 1, "name": "2 Second" },
        { "value": 2, "name": "3 third" },
        { "value": 3, "name": "4 fourth" },
        { "value": 4, "name": "5 fifth" },
        { "value": 5, "name": "6 sixth" },
        { "value": 6, "name": "7 seventh" },
        { "value": 7, "name": "8 eighth" },
        { "value": 8, "name": "9 ninth" },
        { "value": 9, "name": "10 tenth" },
      ]
    },
    getMonitorProcessType: function () {
      return [
        { "value": 0, "name": "WMB Water Mass Balance" },
        { "value": 1, "name": "CMB Chemical Mass Balance" },
        { "value": 2, "name": "GS1 Generic Statistic 1" },
        { "value": 3, "name": "GS2 Generic Statistic 2" },
        { "value": 4, "name": "GS3 Generic Statistic 3" },
        { "value": 5, "name": "GS4 Generic Statistic 4" },
        { "value": 6, "name": "GS5 Generic Statistic 5" }
      ]
    },
    getBppcControlProgram: function () {
      return [
        { "value": 0, "name": "None" },
        { "value": 1, "name": "Molar Ratio - CPT" },
        { "value": 2, "name": "Molar Ratio - PT" },
        { "value": 4, "name": "Molar Ratio - Custom" },
      ]
    },
    getBppcControlSpMode: function () {
      return [
        { "value": 0, "name": "Man PO4 - Man pH SP" },
        { "value": 1, "name": "Man PO4 - Auto pH SP" },
        { "value": 2, "name": "Auto PO4 - Auto pH SP" },
      ]
    },
    getDefaultDisplayList: function () {
      return [
        { value: "overview", name: "Overview" },
        { value: "monitor", name: "OV Monitor" },
        // { value: "overview", name: "CX3400 OV" },//to do
        { value: "analogdisplay&p=ais", name: "Analog Input Display" },
        { value: "analogdisplay&p=aos", name: "Analog Output Display" },
        { value: "analogdisplay&p=aitns", name: "Analog Internal Display" },
        { value: "analogdisplay&p=afbs", name: "Analog Function Block Display" },
      ]
    },
    getMonitorGroupSampleAndWindowPencent: function () {
      return 15.25;
    },
    getOgolanalogFreq: function () {
      return [
        { value: "5", name: "5s" },
        { value: "10", name: "10s" },
        { value: "30", name: "30s" },
        { value: "60", name: "1min" },
        { value: "600", name: "10min" },
      ]
    },
    distinguishAnalogOrDigital: function (value) {
      var info = {
        "1": "value-name-analog",
        "2": "value-name-analog",
        "3": "value-name-analog",
        "4": "value-name-analog",
        "5": "value-name-digital",
        "6": "value-name-digital",
        "7": "value-name-digital",
        "8": "value-name-digital",
      }
      return info[value]
    },
    getAnaDigMapPage: function () {
      var channelPageInfo = {
        "aichannel": {
          type: 1,
          chnType: 1
        },
        "aochannel": {
          type: 1,
          chnType: 2
        },
        "aintchannel": {
          type: 1,
          chnType: 3
        },
        "afbchannel": {
          type: 1,
          chnType: 4
        },
        "dichannel": {
          type: 2,
          chnType: 5
        },
        "dochannel": {
          type: 2,
          chnType: 6
        },
        "dintchannel": {
          type: 2,
          chnType: 7
        },
        "dfbchannel": {
          type: 2,
          chnType: 8
        },
      };
      return channelPageInfo[jCommon.getCurrentPage()]
    },
    getCR300AlloyFactor: function () {
      return [
        { value: "Aluminum AA1100 / A91100", factor: "0.94", name: "Aluminum AA1100 / A91100" },
        { value: "Mild Steel C1010 / G10100", factor: "1", name: "Mild Steel C1010 / G10100" },
        { value: "Aluminum Alloy AA6061 / A96061", factor: "0.94", name: "Aluminum Alloy AA6061 / A96061" },
        { value: "Stainless Steel 304 / S30400", factor: "0.89", name: "Stainless Steel 304 / S30400" },
        { value: "Aluminum AA2024/A92024", factor: "0.86", name: "Aluminum AA2024/A92024" },
        { value: "Pipe Grade Carbon Steel/A135", factor: "1", name: "Pipe Grade Carbon Steel/A135" },
        { value: "CDA 687 Aluminum Brass Arsenical/C68700", factor: "1.62", name: "CDA 687 Aluminum Brass Arsenical/C68700" },
        { value: "Mild Steel C1015/G10150", factor: "1", name: "Mild Steel C1015/G10150" },
        { value: "CDA 642 Aluminum Silicon Bronze/C64200", factor: "1.48", name: "CDA 642 Aluminum Silicon Bronze/C64200" },
        { value: "Mild Steel C1018-C1020/G10180", factor: "1", name: "Mild Steel C1018-C1020/G10180" },
        { value: "Copper CDA110 / C11000", factor: "2", name: "Copper CDA110 / C11000" },
        { value: "Mild Steel C1080/G10800", factor: "1", name: "Mild Steel C1080/G10800" },
        { value: "CDA 706 90/10 Copper/Nickel / C70610", factor: "1.8", name: "CDA 706 90/10 Copper/Nickel / C70610" },
        { value: "Stainless Steel 304L/S30403", factor: "0.89", name: "Stainless Steel 304L/S30403" },
        { value: "Cu/Ni - 70/30/C71500", factor: "1.5", name: "Cu/Ni - 70/30/C71500" },
        { value: "Stainless Steel 316/S31600", factor: "0.9", name: "Stainless Steel 316/S31600" },
        { value: "Arsenical Admiralty Brass CDA443 / C44300", factor: "1.67", name: "Arsenical Admiralty Brass CDA443 / C44300" },
        { value: "Stainless Steel 316L/S31603", factor: "0.9", name: "Stainless Steel 316L/S31603" },
        { value: "Phosphorized Admiralty Brass CDA445/C44500", factor: "1.68", name: "Phosphorized Admiralty Brass CDA445/C44500" },
        { value: "Customize", factor: "", name: "Customize" }
      ]
    },
    trendTimeRange: function (index,key) {
      //timeRange min dataFrequency s
      var trendTime = {
        1: {
          timeRange:14,
          dataFrequency:1
        },
        2:{
          timeRange:140,
          dataFrequency:10
        },
        3:{
          timeRange:140,
          dataFrequency:10
        },
        4:{
          timeRange:140,
          dataFrequency:10
        },
        5:{
          timeRange:140,
          dataFrequency:10
        },
        6:{
          timeRange:140,
          dataFrequency:10
        },
        7:{
          timeRange:840,
          dataFrequency:60
        },
        8:{
          timeRange:840,
          dataFrequency:60
        },
        9:{
          timeRange:840,
          dataFrequency:60
        },
        10:{
          timeRange:840,
          dataFrequency:60
        },
        11:{
          timeRange:840,
          dataFrequency:60
        },
        12:{
          timeRange:840,
          dataFrequency:60
        },
        13:{
          timeRange:840,
          dataFrequency:60
        },
        14:{
          timeRange:8400,
          dataFrequency:600
        },
        15:{
          timeRange:8400,
          dataFrequency:600
        },
        16:{
          timeRange:8400,
          dataFrequency:600
        },
        17:{
          timeRange:8400,
          dataFrequency:600
        },
        18:{
          timeRange:8400,
          dataFrequency:600
        },
        19:{
          timeRange:8400,
          dataFrequency:600
        },
        20:{
          timeRange:8400,
          dataFrequency:600
        }
      };
      return trendTime[index + 1][key]
    },
    getNetWorkTypeList: function () {
      return [
        { "value": 0, "name": "RS485" },
        { "value": 1, "name": "TCP-1" },
        { "value": 2, "name": "TCP-2" },
        { "value": 3, "name": "TCP-3" },
        { "value": 4, "name": "TCP-4" }
      ];
    },
    getAnalogNetRawTypeList: function () {
      return [
        { "value": 0, "name": "Unsigned Integer" },
        { "value": 1, "name": "Half Signed Int" },
        { "value": 2, "name": "Signed Integer" },
        { "value": 3, "name": "Custom Signed Int" },
        { "value": 4, "name": "Float 32 Bit" }
      ];
    },
    getDigitalNetRawTypeList: function () {
      return [
        { "value": 0, "name": "Unsigned Integer" },
        { "value": 2, "name": "Signed Integer" },
        { "value": 5, "name": "Discrete IO" }
      ];
    },
    getAPidEquationList: function () {
      return [
        { "value": 0, "name": "A: PD on Error" },
        { "value": 1, "name": "B: P on Error D on PV" },
        { "value": 2, "name": "C: PD on PV" }
      ];
    },
    getAPidAntiwindupList: function () {
      return [
        { "value": 0, "name": "Anti Reset (A-Bradley)" },
        { "value": 1, "name": "Back Calculation" },
        { "value": 2, "name": "Conditional Integration" },
        { "value": 3, "name": "Tracking Mode" }
      ];
    },
    getPBCStateList: function () {
      return [
        { "value": 0, "name": "0 None" },
        { "value": 1, "name": "1 Corrosion Rate" },
        { "value": 2, "name": "2 ORP State" },
        { "value": 3, "name": "3 Corrosion Inhibitor" },
        { "value": 4, "name": "4 Fouling Increase" },
        { "value": 5, "name": "5 Contamination Alert" },
        { "value": 6, "name": "6 Contamination Response" },
        { "value": 7, "name": "7 ORP OX Feed" },
        { "value": 8, "name": "8 Corrosion State" },
        { "value": 9, "name": "9 Corrosion Response" },
        { "value": 10, "name": "10 Corrosion Fouling Detect" },
        { "value": 11, "name": "11 Passivation" },
        { "value": 12, "name": "12 Corrosion Fouling Sequence" },
        { "value": 13, "name": "13 Fouling Response 1" },
        { "value": 14, "name": "14 Fouling Response 2" },
        { "value": 15, "name": "15 Safe Mode" },
        { "value": 16, "name": "16 Exit" }
      ];
    }
  }
  window.constVar = constVar;
})()
