
(function () {
  var jCommon = {
    /**
     * it's a string ?
     * @param str
     * @returns {boolean}
     */
    isString: function (str) {
      return Object.prototype.toString.call(str) === "[object String]";
    },
    /**
     * Delete the left and right Spaces
     * @param str
     * @returns {string}
     */
    strTrim: function (str) {
      return str.replace(/(^\s*)|(\s*$)/g, "");
    },
    /**
     * it's a array ?
     * @param o
     * @returns {boolean}
     */
    isArray: function (o) {
      return Object.prototype.toString.call(o) === '[object Array]';
    },

    /**
     * it's a object ?
     * @param o
     * @returns {boolean}
     */
    isObject: function (o) {
      return typeof o == 'object';
    },
    /**
     * it's a Number ?
     * @param {*} val 
     * @returns 
     */
    isNumber: function (val) {
      var regPos = /^\d+(\.\d+)?$/; //非负浮点数
      var regNeg = /^(-(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*)))$/; //负浮点数
      if (regPos.test(val) || regNeg.test(val)) {
        return true;
      } else {
        return false;
      }
    },
    /**
     * it's a empty ?
     * @param {} str
     */
    empty: function (str) {
      if (typeof (str) == "undefined" || str == 0 || str == '' || str == '0' || str == null || str == false || str == undefined || (jCommon.isString(str) && (new String(jCommon.strTrim(str))).length == 0) || (jCommon.isArray(str) && str.length == 0)) {
        return true;
      } else if (jCommon.isObject(str)) {
        var is_empty = true;
        var prop;
        for (prop in str) {
          is_empty = false;
          break;
        }
        return is_empty;
      } else {
        return false;
      }
    },
    /**
     * get cookie Value
     * @param name
     * @returns {*}
     */
    cookieGet: function (name) {
      var cookieArray = document.cookie.split("; ");
      for (var i = 0; i < cookieArray.length; i++) {
        var arr = cookieArray[i].split("=");
        if (arr[0] == name) {
          return decodeURI(arr[1]);
        }
      }
      return "";
    },
    /**
     * 
     */
    goHistory: function (operation) {
      switch (operation) {
        case "back":
          history.go(-1);
          break;

        case "forward":
          history.go(1);
          break;

        case "reload":
          window.parent.location.reload();
      }
    },
    /**
     * delete cookie Value
     * @param name
     */
    cookieDel: function (name) {
      document.cookie = name + "=; expires=" + (new Date(0)).toGMTString();
    },

    /**
     * set cookie Value
     * @param name
     * @param value
     * @param seconds
     */
    cookieAdd: function (name, value, seconds) {
      var str = name + "=" + encodeURI(value);
      if (seconds > 0) {
        var date = new Date();
        seconds = seconds * 1000;
        date.setTime(date.getTime() + seconds);
        str += "; expires=" + date.toGMTString();
      }
      document.cookie = str + ";path=/";
    },
    /**
     * [checkLocalStorage check browser localstorage]
     * @return {[type]} [description]
     */
    checkLocalStorage: function () {
      if (typeof window.localStorage === 'object') {
        try {
          window.localStorage.setItem('localStorage', 1);
          window.localStorage.removeItem('localStorage');
        } catch (e) {
          return false;
        }
        return true;
      } else {
        return false;
      }
    },
    /**
     * [setLocalStorge  set localstorge]
     * @param {[type]} name  [description]
     * @param {[string]} value [description]
     */
    setLocalStorge: function (name, value) {
      if (jCommon.checkLocalStorage()) {
        window.localStorage.setItem(name, value);
      } else {
        jCommon.cookieAdd(name, value);
      }
    },
    /**
     * [getLocalStorge get localstorge]
     * @param  {[type]} name [description]
     * @return {[type]}      [description]
     */
    getLocalStorge: function (name) {
      if (jCommon.checkLocalStorage()) {
        return window.localStorage.getItem(name);
      } else {
        return jCommon.cookieGet(name);
      }
    },
    /**
     * [removeLocalStorge delete localstorge]
     * @param  {[type]} name [description]
     * @return {[type]}      [description]
     */
    removeLocalStorge: function (name) {
      if (jCommon.empty(name)) {
        var cookieArray = document.cookie.split("; ");
        for (var i = 0; i < cookieArray.length; i++) {
          var arr = cookieArray[i].split("=");
          switch (arr[0]) {
            case 'PHPSESSID':
            case 'username':
            case 'password':
              break;
            default:
              jCommon.cookieAdd(arr[0], null);
          }
        }
        if (typeof (window.localStorage) != "undefined") {
          if (jCommon.checkLocalStorage()) {
            //window.localStorage.clear();
            var tmp = window.localStorage;
            for (var k in tmp) {
              if (['username', 'password'].indexOf(k) == -1) {
                localStorage.removeItem(k)
              }
            }
          }
        }
      } else {
        if (typeof (window.localStorage) != "undefined") {
          if (jCommon.checkLocalStorage()) {
            window.localStorage.removeItem(name);
          } else {
            if (!jCommon.empty(jCommon.cookieGet(name))) {
              if (name != "PHPSESSID") {
                jCommon.cookieAdd(name, null);
              }
            }
          }
        } else {
          if (!jCommon.empty(jCommon.cookieGet(name))) {
            if (name != "PHPSESSID") {
              jCommon.cookieAdd(name, null);
            }
          }
        }
      }
    },
    requesthttp: function (method, url, pdata, callbackfun) {
      if (window.XMLHttpRequest) {
        var xhr = new XMLHttpRequest();
      } else {
        var xhr = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xhr.onreadystatechange = function () {
        if (xhr.readyState === XMLHttpRequest.DONE) {
          callbackfun(JSON.parse(xhr.responseText));
        }
      }
      xhr.timeout = 60000;
      xhr.open(method, url, true);
      xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
      xhr.send(pdata);
    },
    formatDate: function (d) {
      var hourdatetime = 60 * 60 * 1000;
      if (String(d).length === 10) {
        d = d * 1000;
      }
      if (String(d).length === 13) {
        if (jCommon.isDaylightSavingTime()) {
          d = d - hourdatetime;
        }
      }
      var date = new Date(d);
      var yyyy = date.getFullYear(),
        mm = date.getMonth() + 1,
        dd = date.getDate(),
        h = date.getHours(),
        m = date.getMinutes(),
        s = date.getSeconds();
      return yyyy + '-' + jCommon.formatExceptYYYY(mm) + '-' + jCommon.formatExceptYYYY(dd) + " " + jCommon.formatExceptYYYY(h) + ":" + jCommon.formatExceptYYYY(m) + ":" + jCommon.formatExceptYYYY(s);
    },
    formatTimeStamp: function (d) {
      //d String 2024-01-01 01:01:01
      var dTimeStamp = (new Date(d)).getTime();
      var hourdatetime = 60 * 60 * 1000;
      if (jCommon.isDaylightSavingTime()) {
        dTimeStamp = dTimeStamp + hourdatetime;
      }
      return dTimeStamp;
    },
    formatExceptYYYY: function (value) {
      return Number(value) < 10 ? "0" + Number(value) : Number(value);
    },
    deepCopy: function (value) {
      return JSON.parse(JSON.stringify(value));
    },
    strToBinary: function (str) {
      var result = [];
      var list = str.split("");
      for (var i = 0; i < list.length; i++) {
        if (i != 0) {
          result.push(" ");
        }
        var item = list[i];
        var binaryStr = item.charCodeAt().toString(2);
        result.push(binaryStr);
      }
      return result.join("");
    },
    binaryToStr(str) {
      var result = [];
      var list = str.split(" ");
      for (var i = 0; i < list.length; i++) {
        var item = list[i];
        var asciiCode = parseInt(item, 2);
        var charValue = String.fromCharCode(asciiCode);
        result.push(charValue);
      }
      return result.join("");
    },
    formatSundayDate: function (value) {
      var startSunday = jCommon.formatDate(value).split(" ");
      return startSunday[0].replaceAll("-", "");
    },
    calculateSundayOffset: function (currentSunday, creatSunday) {
      var currentSundayDate = currentSunday.split(" ")[0] + " 00:00:00";
      var creatSundayDate = creatSunday.split(" ")[0] + " 00:00:00";
      var timestampSunday = new Date(currentSundayDate).getTime();
      var createdSunday = new Date(creatSundayDate).getTime();
      return Math.floor((timestampSunday - createdSunday) / (24 * 60 * 60 * 1000 * 7));
    },
    formatUSDateHour: function (hour) {
      hour = Number(hour);
      var solot = "";
      var formateHour;
      if (hour < 12) {
        solot = "AM";
        formateHour = hour;
      } else {
        solot = "PM";
        formateHour = hour - 12;
      }
      if (formateHour === 0) {
        formateHour = 12;
      }
      return {
        "hour": jCommon.formatExceptYYYY(formateHour),
        "solot": solot
      }
    },
    formateUTCHour: function (solot, hour) {
      hour = Number(hour);
      if (hour === 12) {
        hour = 0;
      }
      if (solot === "PM") {
        hour = hour + 12;
      }
      return jCommon.formatExceptYYYY(hour);
    },
    getDateWeekDayList: function (value, number) {
      var list = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
      var dayNumber = number * 7;
      var valueArray = value.toString().split("");
      valueArray.splice(4, 0, "/");
      valueArray.splice(7, 0, "/");
      var valueString = valueArray.join("");
      var valueTime = (new Date(valueString)).getTime();
      var onDayTime = 86400000; //ms
      var dateList = [];
      if (dayNumber > 0) {
        for (var index = 0; index < dayNumber; index++) {
          var endTime = new Date(valueTime + index * onDayTime);
          var dayIndex = endTime.getDay();
          var month = endTime.getMonth() + 1;
          month = jCommon.formatExceptYYYY(month);
          var date = endTime.getDate();
          date = jCommon.formatExceptYYYY(date);
          dateList.push(list[dayIndex] + " " + month + "/" + date);
        }
      } else {
        var endTime = new Date(valueTime);
        var dayIndex = endTime.getDay();
        var month = endTime.getMonth() + 1;
        month = jCommon.formatExceptYYYY(month);
        var date = endTime.getDate();
        date = jCommon.formatExceptYYYY(date);
        dateList.push(list[dayIndex] + " " + month + "/" + date);
      }
      return dateList;
    },
    getHeaderFormatTime: function (datastring) {
      var arr = datastring.split(" ");
      var date = arr[0].split("-");
      var day = arr[1].split(":");
      var data = jCommon.formatUSDateHour(Number(day[0]));
      return data.hour + ":" + day[1] + ":" + day[2] + " " + data.solot + " " + date[1] + "/" + date[2] + "/" + date[0];
    },
    addClass: function (nodes, cls) {
      if (nodes == undefined) return;
      for (var index = 0; index < nodes.length; index++) {
        var dom = nodes[index];
        jCommon.addDomClass(dom, cls);
      };
    },
    addDomClass: function (dom, cls) {
      var classes = dom.className.split(" ");
      var list = [];
      if (classes.indexOf(cls) === -1) {
        cls = cls.replace(/^\s/g, '');
        cls = cls.replace(/\s$/g, '');
        list = cls.replace(/^\s/g, '').replace(/\s$/g, '').split(' ');
        for (var index = 0; index < list.length; index++) {
          var name = list[index];
          classes.indexOf(name) == -1 && classes.push(name);
        }
        dom.className = classes.join(' ');
      }
    },
    removeClass: function (nodes, cls) {
      if (nodes == undefined) return;
      for (var index = 0; index < nodes.length; index++) {
        var dom = nodes[index];
        jCommon.removeDomClass(dom, cls);
      }
    },
    removeDomClass: function (dom, cls) {
      var classes = dom.className.split(" ");
      var list = [];
      if (classes.indexOf(cls) > -1) {
        cls = cls.replace(/^\s/g, '');
        cls = cls.replace(/\s$/g, '');
        list = cls.replace(/^\s/g, '').replace(/\s$/g, '').split(' ');
        for (var index = 0; index < list.length; index++) {
          var name = list[index];
          classes.indexOf(name) == -1 || classes.splice(classes.indexOf(name), 1);
        }
        dom.className = classes.join(' ');
      }
    },
    addHtmlClass: function (keyId, className) {
      if (document.querySelectorAll(keyId)) {
        jCommon.addClass(document.querySelectorAll(keyId), className);
      }
    },
    removeHtmlClass: function (keyId, className) {
      if (document.querySelectorAll(keyId)) {
        jCommon.removeClass(document.querySelectorAll(keyId), className);
      }
    },
    checkClassNameExits: function (elementId, className) {
      if (document.getElementById(elementId) && document.getElementById(elementId).className.indexOf(className) > -1) {
        return true;
      } else {
        return false;
      }
    },
    checkBoolenValue: function (value) {
      if (value === "True" || value === true || value === "true") {
        return true;
      } else if (value === "False" || value === false || value === "false") {
        return false;
      } else {
        return value;
      }
    },
    getDifferCurrentDate: function (year_diff, month_diff, date_diff, hour_diff, minu_diff, sec_diff, reference_time) {
      var origintime;
      var yeardatetime = 1 * 365 * 24 * 60 * 60 * 1000;
      var monthdatetime = 30 * 24 * 60 * 60 * 1000;
      var daydatetime = 24 * 60 * 60 * 1000;
      var hourdatetime = 60 * 60 * 1000;
      var mindatetime = 60 * 1000;
      var secdatetime = 1 * 1000;
      var endtime = 0;
      var current_server_time = Number(jCommon.getHtmlValue("header-server-timestamp"));
      if (jCommon.empty(reference_time)) {
        origintime = current_server_time;
      } else {
        origintime = (new Date(reference_time)).getTime();
      }
      if (jCommon.empty(year_diff) && jCommon.empty(month_diff) && jCommon.empty(date_diff) && jCommon.empty(hour_diff) && jCommon.empty(minu_diff) && jCommon.empty(sec_diff)) {
        endtime = current_server_time;
      } else {
        if (!jCommon.empty(year_diff)) {
          if (year_diff > 0) {
            endtime = origintime + yeardatetime * year_diff;
          } else {
            endtime = origintime - yeardatetime * Math.abs(year_diff);
          }
        }
        if (!jCommon.empty(month_diff)) {
          if (month_diff > 0) {
            endtime = origintime + monthdatetime * month_diff;
          } else {
            endtime = origintime - monthdatetime * Math.abs(month_diff);
          }
        }
        if (!jCommon.empty(date_diff)) {
          if (date_diff > 0) {
            endtime = origintime + daydatetime * date_diff;
          } else {
            endtime = origintime - daydatetime * Math.abs(date_diff);
          }
        }
        if (!jCommon.empty(hour_diff)) {
          if (hour_diff > 0) {
            endtime = origintime + hourdatetime * hour_diff;
          } else {
            endtime = origintime - hourdatetime * Math.abs(hour_diff);
          }
        }
        if (!jCommon.empty(minu_diff)) {
          if (minu_diff > 0) {
            endtime = origintime + mindatetime * minu_diff;
          } else {
            endtime = origintime - mindatetime * Math.abs(minu_diff);
          }
        }
        if (!jCommon.empty(sec_diff)) {
          if (sec_diff > 0) {
            endtime = origintime + secdatetime * sec_diff;
          } else {
            endtime = origintime - secdatetime * Math.abs(sec_diff);
          }
        }
      }
      return jCommon.formatDate(endtime);
    },
    evil: function (compareKeyChar, compareKeyValue, expressValue) {
      var resultItem = "false";
      if (compareKeyChar === "==" && compareKeyValue === expressValue) {
        resultItem = "true";
      } else if (compareKeyChar === "!=" && compareKeyValue !== expressValue) {
        resultItem = "true";
      } else if (compareKeyChar === ">=" && Number(compareKeyValue) >= Number(expressValue)) {
        resultItem = "true";
      } else if (compareKeyChar === "<=" && Number(compareKeyValue) <= Number(expressValue)) {
        resultItem = "true";
      } else if (compareKeyChar === ">" && Number(compareKeyValue) > Number(expressValue)) {
        resultItem = "true";
      } else if (compareKeyChar === "<" && Number(compareKeyValue) < Number(expressValue)) {
        resultItem = "true";
      }
      return resultItem;
    },
    evilBoolen: function (result) {
      if (result.indexOf("&&") === -1 && result.indexOf("||") === -1) {
        return result;
      } else if (result.indexOf("&&") > -1 && result.indexOf("||") == -1) {
        if (result.indexOf("false") > -1) {
          return "false";
        } else {
          return "true";
        }
      } else if (result.indexOf("||") > -1 && result.indexOf("&&") == -1) {
        if (result.indexOf("true") > -1) {
          return "true";
        } else {
          return "false";
        }
      }
    },
    checkExpressValid: function (vShowReg) {
      var regExp = new RegExp("[(||)|(&&)]")
      var compareRegExp = new RegExp("[=|!|>|<]");
      var orList = vShowReg.split("||");
      var regList = []
      for (var index = 0; index < orList.length; index++) {
        if (index != orList.length - 1) {
          orList[index] = orList[index] + "||";
        }
        var andList = orList[index].split("&&");
        if (andList.length == 1) {
          regList.push(orList[index])
        } else {
          andList.forEach((item, cindex) => {
            if (cindex < andList.length - 1) {
              regList.push(item + "&&")
            } else {
              regList.push(item)
            }
          })
        }
      }
      var stringInfo = "";
      for (var index = 0; index < regList.length; index++) {
        var info = regList[index];
        var position = info.search(compareRegExp);
        var positionEnd = info.search(regExp);
        var endString = positionEnd > -1 ? info.substring(positionEnd) : "";
        var compareKeyChar = jCommon.strTrim(info.substring(position, position + 2));
        var compareKeyValue = jCommon.getHtmlValue(jCommon.strTrim(info.substring(0, position))).toString();
        var expressValue = jCommon.strTrim(info.substring(position + 2).replace(endString, ""));
        stringInfo += jCommon.evil(compareKeyChar, compareKeyValue, expressValue) + endString
      }
      var orPosition = stringInfo.indexOf("||");
      var andPosition = stringInfo.indexOf("&&");
      if (orPosition > -1 && andPosition > -1) {
        var resultArr = stringInfo.split("||");
        var list = [];
        for (var index = 0; index < resultArr.length; index++) {
          list.push(jCommon.evilBoolen(resultArr[index]));
        }
        return jCommon.evilBoolen(list.join("||"));
      } else if (orPosition == -1 && andPosition == -1) {
        return stringInfo;
      } else {
        return jCommon.evilBoolen(stringInfo);
      }
    },
    setHtmlValue: function (elementId, value, callbackfun) {
      if (document.getElementById(elementId) && value !== undefined) {
        var dom = document.getElementById(elementId);
        value = jCommon.formatNumber(value, dom.getAttribute("data-notation"), dom.getAttribute("data-precision"));
        var tagName = dom.tagName;
        if (["LABEL", "SPAN"].indexOf(tagName) > -1) {
          dom.innerText = value;
        } else if (tagName === "INPUT") {
          if (["text", "hidden"].indexOf(dom.type) > -1) {
            dom.value = value;
            jCommon.setHtmlValue(elementId + "InputLabel", value);
          } else if (["checkbox"].indexOf(dom.type) > -1) {
            dom.checked = value;
          }
        } else if (["DIV", "A"].indexOf(tagName) > -1) {
          if (dom.getAttribute("data-type") === "boolen") {
            jCommon.switchState(elementId, value);
          } else {
            dom.innerHTML = value;
          }
        } else if (tagName === "BUTTON") {
          //similar radio
          var dataValueRange = jCommon.getHtmlAttriute(elementId, "data-value-range");
          if (dataValueRange) {
            var dataLabelRange = jCommon.getHtmlAttriute(elementId, "data-label-range");
            jCommon.setHtmlAttribute(elementId, "data-value", value);
            var valueRange = dataValueRange.split(",");
            var labelRange = dataLabelRange.split(",");
            document.getElementById(elementId).innerHTML = labelRange[valueRange.indexOf(value.toString())];
          } else {
            document.getElementById(elementId).innerHTML = value;
          }
        }
        if (callbackfun) {
          callbackfun();
        }
      }
    },
    switchState: function (domId, state) {
      jCommon.setHtmlAttribute(domId, "data-value", state);
      var switchBackground = document.getElementById(domId).querySelector(".switch-background");
      var btnSwitchDom = document.getElementById(domId).querySelector(".switch-background").querySelector(".btn-switch");
      if (btnSwitchDom.className.indexOf("btn-switch-disabled") == -1) {
        if (jCommon.checkBoolenValue(state)) {
          jCommon.removeDomClass(switchBackground, "switch-disabled");
          jCommon.addDomClass(switchBackground, "switch-enabled");
        } else {
          jCommon.removeDomClass(switchBackground, "switch-enabled");
          jCommon.addDomClass(switchBackground, "switch-disabled");
        }
      }
    },
    toogleSwitch: function (elementId) {
      jCommon.switchState(elementId, jCommon.toggleRadioButtonValue(elementId));
    },
    controlDOMShow: function (elementId) {
      if (!jCommon.empty(elementId)) {
        var vIfList = document.querySelectorAll('div[v-show*="' + elementId + '"]');
      } else {
        var vIfList = document.querySelectorAll("div[v-show]");
      }
      for (var index = 0; index < vIfList.length; index++) {
        var item = vIfList[index];
        var vShowReg = item.getAttribute("v-show");
        var boolValue = jCommon.checkExpressValid(vShowReg);
        if (jCommon.checkBoolenValue(boolValue)) {
          jCommon.removeDomClass(item, "hide");
        } else {
          jCommon.addDomClass(item, "hide");
        }
      }
    },
    toggleRadioButtonValue: function (elementId) {
      var dataValueRange = jCommon.getHtmlAttriute(elementId, "data-value-range").split(",");
      var value = jCommon.getHtmlValue(elementId);
      var switchIndex = dataValueRange.indexOf(value.toString());
      if (switchIndex === dataValueRange.length - 1) {
        switchIndex = 0;
      } else {
        switchIndex++;
      }
      return jCommon.checkBoolenValue(dataValueRange[switchIndex]);
    },
    setRadioButtonValue: function (domId, callbackfun) {
      jCommon.setHtmlValue(domId, jCommon.toggleRadioButtonValue(domId));
      jCommon.controlDOMShow(domId);
      if (callbackfun) {
        callbackfun();
      }
    },
    getHtmlValue: function (elementId) {
      var dom = document.getElementById(elementId);
      if (dom) {
        var tagName = dom.tagName;
        if (["LABEL", "SPAN"].indexOf(tagName) > -1) {
          if (dom.getAttribute("data-type") === "int") {
            return Number(dom.innerText);
          } else {
            return dom.innerText;
          }
        } else if (tagName === "INPUT") {
          if (["text", "hidden"].indexOf(dom.type) > -1) {
            if (dom.className.indexOf("keyboardnumberInput") > -1 || dom.getAttribute("data-type") === "int") {
              return Number(dom.value);
            } else {
              if (dom.getAttribute("data-type") === "boolen") {
                return jCommon.checkBoolenValue(dom.value);
              } else {
                return dom.value;
              }
            }
          } else if (["checkbox"].indexOf(dom.type) > -1) {
            return dom.checked
          }
        } else if (tagName === "DIV") {
          if (dom.getAttribute("data-type") === "boolen") {
            return jCommon.checkBoolenValue(dom.getAttribute("data-value"));
          } else {
            return dom.innerHTML;
          }
        } else if (tagName === "BUTTON") {
          if (jCommon.getHtmlAttriute(elementId, "data-value-range")) {
            if (typeof jCommon.checkBoolenValue(jCommon.getHtmlAttriute(elementId, "data-value")) === "boolean") {
              return jCommon.checkBoolenValue(jCommon.getHtmlAttriute(elementId, "data-value"));
            } else {
              if (jCommon.isNumber(jCommon.getHtmlAttriute(elementId, "data-value"))) {
                return Number(jCommon.getHtmlAttriute(elementId, "data-value"));
              } else {
                return jCommon.getHtmlAttriute(elementId, "data-value");
              }
            }
          } else {
            return dom.innerHTML;
          }
        }
      }
    },
    setHtmlAttribute: function (itemid, key, value) {
      if (document.getElementById(itemid)) {
        if (key === "disabled") {
          document.getElementById(itemid).disabled = value;
        } else {
          document.getElementById(itemid).setAttribute(key, value);
        }
      }
    },
    setHtmlClassAttribute: function (className, key, value) {
      var classList = document.getElementsByClassName(className);
      for (var index = 0; index < classList.length; index++) {
        if (key === "disabled") {
          classList[index].disabled = value;
        } else {
          classList[index].setAttribute(key, value);
        }
      }
    },
    setHtmlStyleAttribute: function (itemid, key, value) {
      if (document.getElementById(itemid)) {
        document.getElementById(itemid).style[key] = value
      }
    },
    getHtmlStyleAttribute: function (itemid, key) {
      if (document.getElementById(itemid)) {
        return document.getElementById(itemid).style[key];
      } else {
        return null;
      }
    },
    getHtmlAttriute: function (itemid, key) {
      if (document.getElementById(itemid)) {
        if (key === "disabled") {
          return document.getElementById(itemid).disabled;
        } else {
          return document.getElementById(itemid).getAttribute(key);
        }
      } else {
        return "";
      }
    },
    setClassListValue: function (className, value) {
      if (typeof value === "undefined") {
        return;
      }
      var classList = document.getElementsByClassName(className);
      for (var index = 0; index < classList.length; index++) {
        var type = classList[index].getAttribute("data-notation");
        var precision = classList[index].getAttribute("data-precision");
        classList[index].innerHTML = jCommon.formatNumber(value, type, precision);
      }
    },
    getCurrentPage: function (url) {
      var hash = "";
      var urlHash = new String(window.location.hash)  // '#overview'
      if (jCommon.empty(url)) {       // function called without url to get current page
        if (jCommon.empty(urlHash)) {
          hash = "overview";
        } else {
          hash = urlHash.substring(1, urlHash.length); // removes #
        }
      } else {                        // function called with url when page changed to get old/new pages.
        var tempArray = url.split("#");
        hash = tempArray[1];
      }
      hash = new String(hash);
      var hash_arr = hash.substring(0, hash.length).split("&"); // array version
      return hash_arr[0]; // overview
    },
    getUrlParams: function (name, hash) {
      var result = {};
      if (jCommon.empty(hash)) {
        hash = new String(window.location.hash);
        hash = hash.substring(1, hash.length);
      }
      if (!hash) {
        var search = new String(window.location.search);
        hash = search.substring(1, search.length);
      }
      var args = hash.split("&");
      args.forEach(function (arg) {
        var kv = arg.split('=');
        result[kv[0]] = kv[1];
      });
      return result[name];
    },
    setPagetTitleByHash: function (hash) {
      var pattern = /{[^}]*}/g;
      var arr = {
        "menu": "Menu",
        "menuconfig": "Controller Configuration",
        "aichannel": "Analog Input Configuration",
        "aochannel": "Analog Output Configuration",
        "aintchannel": "Analog Internal Configuration",
        "afbchannel": "Analog Function Block Configuration",
        "dichannel": "Digital Input Configuration",
        "dochannel": "Digital Output Configuration",
        "dintchannel": "Digital Internal Configuration",
        "dfbchannel": "Digital Function Block Configuration",
        "system": "{name}",
        "systemconfig": "{name} Configuration",
        "chemicalfeed": "{name} Chemical Feeds",
        "systemcycle": "{name} Cycles Configuration",
        "systemblowdown": "{name} Blowdown Configuration",
        "trend": "Trend {p} View",
        "trendconfig": "Trend {p} Config",
        "trendoverview": "Trend Display",
        "trendconfigoverview": "Trending & Logging",
        "interlock": "InterLock Configuration",
        "interval": "Interval Control Configuration",
        "bppcboiler": "BPPC Boiler Properties Configuration",
        "bppcprocess": "BPPC Process & Control Variable Configuration",
        "bppchemical": "BPPC Chemical Properties Configuration",
        "bppccontrol": "BPPC Control Properties Configuration",
        "onoff": "OnOff Control Configuration",
        "ratio": "Ratio Control Configuration",
        "pid": "PID Control Configuration",
        "pfc": "Primary Following Control Configuration",
        "schedule": "Schedule Control Configuration",
        "schedulesetup": "Schedule Setup",
        "alarmsumary": "Alarm Summary",
        "eventsumary": "Event Summary",
        "recipe": "Recipe Utility",
        "setup": "Setting",
        "ogicstatis": "OGic Statistics",
        "plcstatus": "PLC Status",
        "feeddevice": "Feed Device Configuration",
        "digitaldisplay": "Digital Display",
        "analogdisplay": "Analog Display",
        "modbus": "Modbus Setup",
        "modbusdv": "DCS Modbus OV",
        "channeloverview": "Channel Configuration",
        "curve": "Curve Configuration",
        "curvegraph": "Curve Graph",
        "note": "Notes",
        "pidloop": "PID Loops",
        "pidauto": "PID Auto Tune",
        "remotesetup": "Remote Alarming Setup",
        "remoteanalog": "Remote Alarming Analog",
        "remotedigital": "Remote Alarming Digital",
        "remoteloop": "Remote Alarming - Sys/Loop",
        "guardonline": "Solenis Cloud Setup",
        "ogolanalog": "Iot - Analog & Predefined",
        "ogoldigital": "Iot - Digital & Alarms",
        "monitorprocess": "Input Data Streams for Monitor #{p}",
        "monitorgroup": "Group #{p}",
        "smtp": "SMTP Server Config",
        "rtdisplayconfig": "RT Display Config",
        "ratiotime": "{sysname}",
        "bppctime": "{sysname}",
        "bppctimechemical": "{sysname}",
        "bppctimefd": "{sysname}",
        "pfctime": "{sysname}",
        "pidtime": "{sysname}",
        "scheduletime": "{sysname}",
        "intervaltime": "{sysname}",
        "onofftime": "{sysname}",
        "display": "Channel Display",
        "curveruntime": "Curve Menu",
        "statmonconfig": "Statistic Monitor Configuration",
        "statmonov": "Statistic Monitor Overview",
        "3b3hconfig": "3B3H Setup",
        "3bconfig": "3B Setup",
        "3bconfig2": "3B Setup-2",
        "3brtime": "3B Overview",
        "3bdiagresult": "3B Diagnotic Result",
        "3hconfig": "3H Setup",
        "3hconfig2": "3H Setup-2",
        "3hrtime": "3H Overview",
        "3b3hrtime": "3B3H Overview",
        "probe": "Pyxis Sensor Setup",
        "pyxissensorcal": "Pyxis Sensor Calibration",
        "factoryconfig": "Factory Config",
        "moxaio": "Moxa IO Setup",
        "export": "Export Trend Data",
        "pbc1": "PBC Process Setup",
        "pbc2": "PBC Channel Setup 1",
        "pbc3": "PBC Guard Rail Setup",
        "pbc4": "PBC Channel Setup 2",
        "pyxissensorlog": "Pyxis Sensor Calibration Log ",
        "apid1": "Advanced PID Setup 1",
        "apid2": "Advanced PID Setup 2",
        "apidrtime": "{sysname}"
      };
      if (pattern.test(arr[hash])) {
        var urlHash = window.location.hash.split("&");
        urlHash.forEach(function (item, index) {
          if (index > 0) {
            var keyValue = item.split("=");
            arr[hash] = arr[hash].replace("{" + keyValue[0] + "}", keyValue[1].replaceAll("%20", " "));
          }
        })
      }
      jCommon.setHtmlValue("page-header-title", arr[hash]);
    },
    getNoLoginPages: function () {
      return ["overview", "menu", "alarmsumary", "eventsumary", "trend", "trendoverview",
        "system", "digitaldisplay", "analogdisplay", "ratiotime", "scheduletime",
        "intervaltime", "onofftime", "pdc", "pidtime", "pfctime", "bppctime", "apidrtime",
        "monitor", "display", "bppctimefd", "bppctimechemical", "curveruntime",
        "curveview", "statmonov", "3b3hrtime", "3brtime", "3hrtime", "demo", "probetime", "pyxissensorcaltime"];
    },
    setSystemTheme: function (hash) {
      var themeList = {
        "loginTheme": "config-background",
        "noLoginTheme": "runtime-background"
      };
      var unLoginPage = jCommon.getNoLoginPages();
      if (unLoginPage.indexOf(hash) > -1) {
        document.body.className = themeList["noLoginTheme"];
      } else {
        document.body.className = themeList["loginTheme"];
      }
    },
    setDomElementValue: function (dataList, savePropertyString) {
      for (var key in dataList) {
        if (typeof dataList[key] !== "object") {
          jCommon.setHtmlValue(key, dataList[key]);
          if (!jCommon.empty(savePropertyString)) {
            jCommon.setDataSaveProperty(key, savePropertyString + key);
          }
        }
      }
      jCommon.controlDOMShow();
    },
    setDomElementLiveValue: function (dataList, prefix) {
      for (var key in dataList) {
        if (typeof dataList[key] !== "object") {
          jCommon.setLiveDataValue(prefix + key, dataList[key]);
        }
      }
    },
    setDomElementItemValue: function (dataInfo, callbackfun) {
      for (var key in dataInfo) {
        jCommon.setHtmlValue(key, dataInfo[key]);
        jCommon.controlDOMShow(key);
      }
      if (callbackfun) {
        callbackfun();
      }
    },
    setDataSaveProperty: function (key, value) {
      jCommon.setHtmlAttribute(key, "data-save-property", value);
    },
    getSaveProperty: function (elementId) {
      if (elementId.toUpperCase().endsWith("ANALOGLABEL") || elementId.toUpperCase().endsWith("DIGITALLABEL")) {
        var channlDomId = elementId.replace("Analog", "").replace("Digital", "").replace("Label", "");
        var channlDomIdName = channlDomId.replace("chn", "").replace("Chn", "");
        return [channlDomId, channlDomId + "Type", channlDomIdName + "name"];
      } else {
        var rowId = "";
        var currentPage = jCommon.getCurrentPage();
        var objectInfo = {};
        if (["aichannel", "aochannel", "dichannel", "dochannel", "aintchannel", "afbchannel", "dfbchannel", "dintchannel"].indexOf(currentPage) > -1) {
          objectInfo = {
            "netRawType": ["netRawType", "netRawMin", "netRawMax"],
            "signalType": ["signalType", "signalMin", "signalMax"],
            "engMinMax": ["engMin", "engMax"],
            "curveNum": ["curveNum", "yChnType", "yChn"],
            "input1-chnAnalogLabel": ["input1-chnType", "input1-chn"],
            "input1-chnDigitalLabel": ["input1-chnType", "input1-chn"],
            "input2-chnAnalogLabel": ["input2-chnType", "input2-chn"],
            "input2-chnDigitalLabel": ["input2-chnType", "input2-chn"],
            "tankOperation": ["operation", "baseUnit"],
            "pyxis-sensor": ["idxProbe", "idxSensor"]
          };
        } else if (currentPage === "trendconfig") {
          if (/-type$/.test(elementId)) {
            rowId = elementId.replace("-type", "");
          } else if (/-pdChn$/.test(elementId)) {
            rowId = elementId.replace("-pdChn", "");
          }
          objectInfo[rowId + "-type"] = [rowId + "-chn", rowId + "-chnType", rowId + "-name", rowId + "-pdChn", rowId + "-pdLoop", rowId + "-trendEn", rowId + "-type", rowId + "-pdLoopName"];
          objectInfo[rowId + "-pdChn"] = [rowId + "-name", rowId + "-pdChn", rowId + "-pdLoopName"];
        } else if (currentPage === "system") {
          if (/-type$/.test(elementId)) {
            rowId = elementId.replace("-type", "");
          } else if (/-pdChn$/.test(elementId)) {
            rowId = elementId.replace("-pdChn", "");
          }
          objectInfo[rowId + "-type"] = [rowId + "-chn", rowId + "-chnType", rowId + "-name", rowId + "-pdChn", rowId + "-pdLoop", rowId + "-trendEn", rowId + "-type"];
          objectInfo[rowId + "-pdChn"] = [rowId + "-name", rowId + "-pdChn"];
        } else if (currentPage === "chemicalfeed") {
          if (/-bppc-ctrlType$/.test(elementId)) {
            rowId = elementId.replace("-bppc-ctrlType", "");
          } else if (/-ctrlType$/.test(elementId)) {
            rowId = elementId.replace("-ctrlType", "");
          } else if (/-bppc-enableReq$/.test(elementId)) {
            rowId = elementId.replace("-bppc-enableReq", "");
          } else if (/-bppc-display$/.test(elementId)) {
            rowId = elementId.replace("-bppc-display", "");
          }
          var rowList = rowId.split("-");
          var index = Number(rowList[1]);
          objectInfo[rowId + "-ctrlType"] = [rowId + "-ctrlType", rowId + "-ctrlTypeEn"];
          objectInfo[rowId + "-bppc-ctrlType"] = [rowId + "-ctrlType", rowId + "-ctrlTypeEn", "row-" + Number(index + 1) + "-ctrlType", "row-" + Number(index + 1) + "-ctrlTypeEn"];
          objectInfo[rowId + "-bppc-enableReq"] = [rowId + "-enableReq", "row-" + Number(index + 1) + "-enableReq"];
          objectInfo[rowId + "-bppc-display"] = [rowId + "-display", "row-" + Number(index + 1) + "-display"];
        } else if (currentPage === "ratio") {
          objectInfo["processTypeLabel"] = ["processType", "placeholder-chn", "placeholder-dataType", "placeholder-chnType", "placeholder-cnst_OP"];
        } else if (currentPage === "feeddevice") {
          objectInfo["baseUnitLabel"] = ["baseUnit", "metricFlag", "timeUnit"];
        } else if (currentPage === "interlock") {
          objectInfo[elementId] = [elementId.replace("Label", "")];
        } else if (currentPage === "systemblowdown") {
          objectInfo["deviceTypeLabel"] = ["deviceType", "analogCfg-aoChnType", "analogCfg-aoChn", "timeCfg-openDOChnType", "timeCfg-openDOChn", "timeCfg-closeDOChnType", "timeCfg-closeDOChn"];
        } else if (currentPage === "monitor") {
          if (/-type$/.test(elementId)) {
            rowId = elementId.replace("-type", "");
          } else if (/-pdChn$/.test(elementId)) {
            rowId = elementId.replace("-pdChn", "");
          }
          objectInfo[rowId + "-pdChn"] = [rowId + "-name", rowId + "-pdChn"];
          objectInfo[rowId + "-type"] = [rowId + "-chn", rowId + "-chnType", rowId + "-name", rowId + "-pdChn", rowId + "-pdLoop", rowId + "-trendEn", rowId + "-type"];
        } else if (currentPage === "smtp") {
          var idxSel = jCommon.getHtmlValue("idxSel");
          objectInfo["idxSel"] = ["hosts-" + idxSel + "-host", "idxSel"];
        } else if (currentPage === "monitorgroup") {
          objectInfo["sampleAndOk"] = ["sampleInterval", "okFractionWindow"];
        } else if (currentPage === "ogolanalog") {
          if (/-type$/.test(elementId)) {
            rowId = elementId.replace("-type", "");
          } else if (/-pdChn$/.test(elementId)) {
            rowId = elementId.replace("-pdChn", "");
          }
          objectInfo[rowId + "-pdChn"] = [rowId + "-name", rowId + "-pdChn"]
          objectInfo[rowId + "-type"] = [rowId + "-chn", rowId + "-chnType", rowId + "-name", rowId + "-pdChn", rowId + "-pdLoop", rowId + "-type"];
        } else if (currentPage === "probe") {
          if (/-PN$/.test(elementId)) {
            rowId = elementId.replace("-PN", "");
          }
          objectInfo[rowId + "-PN"] = [rowId + "-PN", rowId + "-customName", rowId + "-ModbusAddr", rowId + "-brushAddr", rowId + "-enable"];
        } else if (currentPage === "factoryconfig") {
          objectInfo["hmiSerial_SYS"] = ["hmiSerial_SYS", "projectNum_SYS", "serialNum_SYS"];
        }
        return jCommon.empty(objectInfo[elementId]) ? [elementId] : objectInfo[elementId];
      }
    },
    clearallObject: function () {
      if (dygraphInstance) {
        dygraphInstance.destroy();
        dygraphInstance = null;
      }
    },
    dropDownMenu: function (dropdown) {
      if (dropdown && dropdown.element) {
        var nameFormate = dropdown.element.getAttribute("name-substring");
        var fixedName = dropdown.element.getAttribute("fixed-name");
        if (nameFormate) {
          var formateArr = nameFormate.split(",");
          var startIndex = formateArr[0];
          var endIndex = formateArr[1];
        }
        var rowNumber = 20;
        var allPage = Math.ceil(dropdown.choices.length / rowNumber);
        var htmlList = [];
        if (jCommon.empty(dropdown.defaultClass)) {
          dropdown.defaultClass = "";
        }
        htmlList.push('<button class="btn btn-default dropdown ' + dropdown.defaultClass + '" type="button"></button>');
        htmlList.push('<input type="hidden" class="currentPage" value="1">');
        htmlList.push('<input type="hidden" class="allPage" value="' + allPage + '">');
        htmlList.push('<div class="dialog-content hide">');
        htmlList.push('<div class="fade-mask"></div>');
        htmlList.push('<div class="modal-body select-dropdown-Content">');
        htmlList.push('<div class="pre-select-page"><span class="pre-span-label"><</span></div>');
        htmlList.push('<ul class="dropdown-menu">');
        htmlList.push('</ul>');
        htmlList.push('<div class="next-select-page"><span class="next-span-label">></span></div>');
        htmlList.push('<div><button class="btn btn-default btn-close" type="button">Close</button></div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        dropdown.element.innerHTML = htmlList.join("");
        htmlList = null;
        dropdown.element.onclick = dropdownElementClickCallback;
        dropdown.list = dropdown.element.querySelector('ul.dropdown-menu');
        if (dropdown.choices.length > 10) {
          dropdown.element.querySelector(".select-dropdown-Content").classList.add("select-dropdown-Content-wide");
          dropdown.list.classList.add("wide");
        }
        dropdown.choices.forEach(function (opt, index) {
          if (dropdown.defaultvalue == opt["value"]) {
            var selectName = "";
            if (dropdown.defaultInfo) {
              selectName = opt[dropdown.defaultInfo.key] + dropdown.defaultInfo.offset;
            } else {
              selectName = fixedName ? fixedName : opt["name"];
              if (nameFormate) {
                selectName = selectName.substring(startIndex, endIndex);
              }
            }
            dropdown.element.querySelector("button.dropdown").innerHTML = selectName;
            for (var key in opt) {
              dropdown.element.setAttribute("select-" + key, opt[key]);
            }
          }
          var elementDataAttribute = "";
          for (var key in opt) {
            elementDataAttribute += ' data-' + key + '="' + opt[key] + '"';
          }
          var item = document.createElement("li");
          item.className = "select-item-" + Math.ceil((index + 1) / rowNumber);
          item.innerHTML = '<button class="btn btn-default select-item"' + elementDataAttribute + '>' + opt["name"] + '</button>';
          dropdown.list.appendChild(item);
        })
        if (dropdown.defaultName) {
          dropdown.element.querySelector("button.dropdown").innerHTML = dropdown.defaultName;
        }
        controlSelectPage();

        function controlSelectPage() {
          var currentPage = Number(dropdown.element.querySelector('.currentPage').value);
          if (currentPage === 1) {
            dropdown.element.querySelector('.pre-select-page').classList.add("hide");
          } else {
            dropdown.element.querySelector('.pre-select-page').classList.remove("hide");
          }
          var allPage = Number(dropdown.element.querySelector('.allPage').value);
          if (currentPage === allPage) {
            dropdown.element.querySelector('.next-select-page').classList.add("hide");
          } else {
            dropdown.element.querySelector('.next-select-page').classList.remove("hide");
          }
          for (var index = 1; index <= allPage; index++) {
            var indexDomList = dropdown.element.querySelectorAll("li.select-item-" + index);
            if (currentPage === index) {
              for (var key = 0; key < indexDomList.length; key++) {
                indexDomList[key].classList.remove("hide");
              }
            } else {
              for (var key = 0; key < indexDomList.length; key++) {
                indexDomList[key].classList.add("hide");
              }
            }

          }
        }

        function dropdownElementClickCallback(event) {
          if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id, "noLoginState")) {
            userlogin.showLoginDialog();
            return false;
          }
          event.stopPropagation();
          if (event.target.classList.contains("dropdown")) {
            dropdown.element.querySelector("div.dialog-content").classList.remove('hide');
          } else if (event.target.classList.contains("select-item")) {
            var oldValue = dropdown.element.getAttribute("select-value");
            var detail = event.target.getAttribute("data-value");
            var attributeList = event.target.attributes;
            var name = event.target.innerHTML;
            var selectName = fixedName ? fixedName : name;
            if (nameFormate) {
              selectName = selectName.substring(startIndex, endIndex);
            }
            if (dropdown.defaultInfo) {
              selectName = Number(detail) + Number(dropdown.defaultInfo.offset);
            }
            var currentItem = {};
            for (var attributeIndex = 0; attributeIndex < attributeList.length; attributeIndex++) {
              var attributeValue = attributeList[attributeIndex]["name"];
              if (attributeValue.startsWith("data-")) {
                currentItem[attributeValue.replace("data-", "")] = event.target.getAttribute(attributeValue);
              }
            }
            dropdown.element.querySelector("div.dialog-content").classList.add('hide');
            if (detail !== oldValue || dropdown.equalCallBack) {
              if (dropdown.confirm && (typeof dropdown.confirm.value === "undefined" && dropdown.confirm.message || typeof dropdown.confirm.value !== "undefined" && detail === dropdown.confirm.value && dropdown.confirm.message)) {
                ToolstipDialog.showConfirmToolsTip("Warning!", dropdown.confirm.message, function () {
                  dropdown.element.querySelector("button.dropdown").innerHTML = selectName;
                  for (var currentItemKey in currentItem) {
                    dropdown.element.setAttribute("select-" + currentItemKey, currentItem[currentItemKey]);
                  }
                  if (dropdown.callback) {
                    dropdown.callback(detail, dropdown.element.id, oldValue);
                  }
                });
              } else {
                dropdown.element.querySelector("button.dropdown").innerHTML = selectName;
                for (var currentItemKey in currentItem) {
                  dropdown.element.setAttribute("select-" + currentItemKey, currentItem[currentItemKey]);
                }
                if (dropdown.callback) {
                  dropdown.callback(detail, dropdown.element.id, oldValue);
                }
              }
            }
          } else if (event.target.classList.contains("btn-close")) {
            dropdown.element.querySelector("div.dialog-content").classList.add('hide');
          } else if (event.target.classList.contains("pre-select-page") || event.target.classList.contains("pre-span-label")) {
            dropdown.element.querySelector('.currentPage').value = Number(dropdown.element.querySelector('.currentPage').value) - 1;
            controlSelectPage();
          } else if (event.target.classList.contains("next-select-page") || event.target.classList.contains("next-span-label")) {
            dropdown.element.querySelector('.currentPage').value = Number(dropdown.element.querySelector('.currentPage').value) + 1;
            controlSelectPage();
          }
        }
      }
    },
    setDropDownMenuValueAndLabel: function (id, value) {
      jCommon.setHtmlValue(id, value);
      jCommon.setDropDownMenuValue(id + "Label", value);
      jCommon.controlDOMShow(id);
    },
    setDropDownMenuValue: function (idLabel, value) {
      var itemList = document.getElementById(idLabel).querySelectorAll(".select-item");
      for (var index = 0; index < itemList.length; index++) {
        var elementItem = itemList[index];
        var attributeList = elementItem.attributes;
        var dataValue = elementItem.getAttribute("data-value");
        if (dataValue == value) {
          for (var attributeIndex = 0; attributeIndex < attributeList.length; attributeIndex++) {
            var attributeValue = attributeList[attributeIndex]["name"];
            if (attributeValue.startsWith("data-")) {
              jCommon.setHtmlAttribute(idLabel, "select-" + attributeValue.replace("data-", ""), elementItem.getAttribute(attributeValue));
            }
          }
          document.getElementById(idLabel).querySelector(".dropdown").innerHTML = elementItem.innerHTML;
        }
      }
    },
    setDropDownMenuDisabled: function (idLabel, state) {
      if (document.getElementById(idLabel).querySelector(".dropdown")) {
        document.getElementById(idLabel).querySelector(".dropdown").disabled = state;
      }
    },
    channelInput: function (channelFrom, type, disabled) {
      if (channelFrom && channelFrom.element) {
        var channelFromChId = channelFrom.element.id.replace("Analog", "").replace("Digital", "").replace("Label", "")
        var title = jCommon.empty(type) ? "Digital" : type;
        var selectValue = [];
        var htmlList = [];
        var channelValue = 0;
        var channelType = 0;
        if (channelFrom.defaultvalue) {
          selectValue = channelFrom.defaultvalue.split("-");
          channelType = selectValue[0];
          channelValue = selectValue[1];
        }
        var defaultValueString = channelPage.getChannelInputLabel(channelType, channelValue);
        if (disabled) {
          htmlList.push('<button class="btn btn-default channelform" type="button" data-channelType="' + channelType + '" data-channel="' + channelValue + '" disabled>' + defaultValueString + '</button>');
        } else {
          htmlList.push('<button class="btn btn-default channelform" type="button" data-channelType="' + channelType + '" data-channel="' + channelValue + '">' + defaultValueString + '</button>');
        }
        htmlList.push('<div class="dialog-content hide">');
        htmlList.push('<div class="fade-mask"></div>');
        htmlList.push('<div class="channelInputDialog-Content modal-body">');
        htmlList.push('<div class="modal-header">' + title + '<button class="btn btn-default btn-close" type="button">Close</button></div>');
        htmlList.push('<div class="modal-content">');
        htmlList.push('<div class="row">');
        htmlList.push('<label class="control-label">type</label>');
        htmlList.push('<div class="channel-typelist"></div>');
        htmlList.push('</div>');
        htmlList.push('<div class="row form-inline">');
        htmlList.push('<label class="control-label channel-input-title">channel</label>');
        htmlList.push('<input id="' + channelFrom.element.id + '-ch" type="text" class="form-control keyboardnumberInput channelChn" data-max="0" data-min="0" value="' + channelValue + '">');
        if (!jCommon.empty(jCommon.getHtmlAttriute(channelFromChId, "data-config"))) {
          var configName = channelPage.getChannelInfo(channelType, channelValue, "name");
          htmlList.push('<div v-show="' + channelFrom.element.id + '-ch > 0" class="row form-inline hide">');
          htmlList.push('<a href="" class="btn btn-default channelChConfig" id="' + channelFrom.element.id + '-ch-ConfigName">' + configName + '</a>');
          htmlList.push('</div>');
        }
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('<div class="modal-footer text-center">');
        htmlList.push('<button type="button" class="btn btn-default btn-channel-ok">Ok</button>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        channelFrom.element.innerHTML = htmlList.join("");
        htmlList = null;
        if (type === "analog") {
          var list = [{
            "value": "1",
            "name": "Input"
          }, {
            "value": "2",
            "name": "Output"
          }, {
            "value": "3",
            "name": "Internal"
          }, {
            "value": "4",
            "name": "Function Block"
          }];
        } else {
          var list = [{
            "value": "5",
            "name": "Input"
          }, {
            "value": "6",
            "name": "Output"
          }, {
            "value": "7",
            "name": "Internal"
          }, {
            "value": "8",
            "name": "Function Block"
          }];
        }
        var typeItemList = [];
        var typeItem = [];
        list.forEach(function (item) {
          typeItem = [];
          var selectItemId = channelFrom.element.id + '-' + item["value"];
          typeItem.push('<div class="col-md-6 channel-typelist-row">');
          typeItem.push('<div class="radio-container">');
          typeItem.push('<div class="radio">');
          typeItem.push('<input name="' + channelFrom.element.id + '-chType" type="radio" class="inputradio" id="' + selectItemId + '" value="' + item["value"] + '" >');
          typeItem.push('<label for="' + selectItemId + '"></label>');
          typeItem.push('</div>');
          typeItem.push('<label class="radio-label">' + item["name"] + '</label>');
          typeItem.push('</div>');
          typeItem.push('</div>');
          typeItemList.push(typeItem.join(""));
        })
        channelFrom.element.querySelector("div.channel-typelist").innerHTML = typeItemList.join("");
        typeItem = null;
        typeItemList = null;
        channelFrom.element.onclick = channelFromElementCallback;

        function channelFromElementCallback(event) {
          event.stopPropagation();
          if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id, "noLoginState")) {
            userlogin.showLoginDialog();
            return false;
          }
          if (event.target.classList.contains("channelform")) {
            var currentChannelType = channelFrom.element.querySelector(".channelform").getAttribute("data-channeltype");
            var currentChannel = channelFrom.element.querySelector(".channelform").getAttribute("data-channel");
            if (!jCommon.empty(currentChannelType)) {
              channelFrom.element.querySelector(".channelChn").value = currentChannel;
              channelFrom.element.querySelector(".channelChn").setAttribute("data-max", channelPage.getChannelKeyLength(currentChannelType));
              if (channelFrom.element.querySelector(".inputradio[value='" + currentChannelType + "']")) {
                channelFrom.element.querySelector(".inputradio[value='" + currentChannelType + "']").checked = true;
              }
            }
            if (channelFrom.element.getAttribute("data-disabled")) {
              var inputradioList = channelFrom.element.querySelectorAll(".inputradio");
              var channelDisableList = channelFrom.element.getAttribute("data-disabled").split(",");
              for (var index = 0; index < inputradioList.length; index++) {
                var radioItem = inputradioList[index];
                if (channelDisableList.indexOf(radioItem.value) > -1) {
                  radioItem.disabled = true;
                } else {
                  radioItem.disabled = false;
                }
              }
            }
            //listen keydown
            document.addEventListener("keydown", enterKeyboardCallback);
            channelFrom.element.querySelector("div.dialog-content").classList.remove('hide');
            event.target.blur();
          } else if (event.target.classList.contains("inputradio")) {
            channelFrom.element.querySelector(".channelChn").setAttribute("data-max", channelPage.getChannelKeyLength(event.target.value))
            channelFrom.element.querySelector(".channelChn").value = 0;
          } else if (event.target.classList.contains("btn-close")) {
            document.removeEventListener("keydown", enterKeyboardCallback);
            channelFrom.element.querySelector("div.dialog-content").classList.add('hide');
          } else if (event.target.classList.contains("btn-channel-ok")) {
            if (jCommon.empty(channelFrom.element.querySelector(".inputradio:checked"))) {
              ToolstipDialog.showAlertToolsTip("Warning", "Please Select Type");
              return;
            }
            var channelTypeValue = channelFrom.element.querySelector(".inputradio:checked").value;
            var channelCh = Number(channelFrom.element.querySelector(".channelChn").value);
            if (channelCh === 0) {
              channelFrom.element.querySelector(".inputradio[value='" + channelTypeValue + "']").checked = false;
              channelTypeValue = 0;
            }
            channelFrom.element.querySelector(".channelform").innerHTML = channelPage.getChannelInputLabel(channelTypeValue, channelCh);
            channelFrom.element.querySelector(".channelform").setAttribute("data-channeltype", channelTypeValue);
            channelFrom.element.querySelector(".channelform").setAttribute("data-channel", channelCh);
            if (channelFrom.callback) {
              channelFrom.callback([Number(channelTypeValue), channelCh], channelFrom.element.id);
            }
            channelFrom.element.querySelector(".btn-close").click();
          }
        }

        function enterKeyboardCallback(event) {
          var e = event || window.event || arguments.callee.caller.arguments[0];
          e.stopPropagation();
          if (e && e.keyCode == 13 && jCommon.getHtmlStyleAttribute("keyboardContainer", "display") === "none") {
            channelFrom.element.querySelector(".btn-channel-ok").click();
          }
        }
      }
    },
    setChannelInputValue: function (id, value) {
      if (document.getElementById(id)) {
        var valueArr = value.split("-");
        var channelType = 0;
        var channelCh = 0;
        if (valueArr.length === 2) {
          channelType = valueArr[0];
          channelCh = valueArr[1];
        }
        if (document.getElementById(id).querySelector(".channelform")) {
          document.getElementById(id).querySelector(".channelform").setAttribute("data-channeltype", channelType);
          document.getElementById(id).querySelector(".channelform").setAttribute("data-channel", channelCh);
          document.getElementById(id).querySelector(".channelform").innerHTML = channelPage.getChannelInputLabel(channelType, channelCh);
        }
      }
    },
    resetChannelInputValue: function (id) {
      jCommon.setHtmlValue(id + "Type", 0);
      jCommon.setHtmlValue(id, 0);
      jCommon.setChannelInputValue(id + "Label", "");
      jCommon.controlDOMShow(id);
    },
    setChannelInputDisabled: function (id, state) {
      if (document.getElementById(id) && document.getElementById(id).querySelector(".channelform")) {
        document.getElementById(id).querySelector(".channelform").disabled = state;
      }
    },
    calculateHHMMSS: function (value, isSecond) {
      var hour = 0;
      var minute = 0;
      var second = 0;
      if (isSecond) {
        hour = jCommon.formatExceptYYYY(Math.floor(value / 10000));
        var minutesecond = value % 10000;
        minute = jCommon.formatExceptYYYY(Math.floor(minutesecond / 100));
        second = jCommon.formatExceptYYYY(minutesecond % 100);
      } else {
        hour = jCommon.formatExceptYYYY(Math.floor(value / 100));
        minute = jCommon.formatExceptYYYY(value % 100);
      }
      return {
        hour: hour,
        minute: minute,
        second: second
      }
    },
    pickerTime: function (dropdown) {
      if (dropdown && dropdown.element) {
        var timeInfo = jCommon.calculateHHMMSS(dropdown.defaultvalue, dropdown.secondsShow);
        var hour = timeInfo.hour;
        var minute = timeInfo.minute;
        var second = timeInfo.second;
        var formateHour = jCommon.formatUSDateHour(hour);
        var htmlList = [];
        htmlList.push('<div>');
        var labelString = "";
        if (dropdown.timeZone === 24) {
          labelString = hour + ':' + minute;
        } else {
          labelString = formateHour.hour + ':' + minute;
        }
        if (dropdown.secondsShow) {
          labelString += ':' + second;
        }
        if (dropdown.timeZone !== 24) {
          labelString += ' ' + formateHour.solot;
        }
        htmlList.push('<label class="timedropdown">' + labelString + '</label>');
        htmlList.push('<div class="dialog-content hide">');
        htmlList.push('<div class="fade-mask"></div>');
        htmlList.push('<div class="modal-body picker-select-dialog-Content">');
        htmlList.push('<div class="modal-content">');
        htmlList.push('<div class="row">');
        htmlList.push('<div class="col-md-12">');
        htmlList.push('<div class="col-md-3">');
        if (dropdown.timeZone !== 24) {
          htmlList.push('<div class="row time-row"></div>');
          htmlList.push('<div class="row time-row margin-top-10"><button class="time-solot solt-value">' + formateHour.solot + '</button></div>');
          htmlList.push('<div class="row time-row margin-top-10"></div>');
        }
        htmlList.push('</div>');
        htmlList.push('<div class="col-md-9">');
        htmlList.push('<div class="col-md-12">');
        htmlList.push('<div class="row time-row">');
        htmlList.push('<div class="col-md-12">');
        htmlList.push('<div class="col-md-3">');
        htmlList.push('<div class="dom-container input-group"><button class="btn btn-default up-hour btn-opTime">▲</button></div>');
        htmlList.push('</div>');
        htmlList.push('<div class="col-md-offset-1 col-md-3">');
        htmlList.push('<div class="dom-container input-group"><button class="btn btn-default up-minute btn-opTime">▲</button></div>');
        htmlList.push('</div>');
        if (dropdown.secondsShow) {
          htmlList.push('<div class="col-md-offset-1 col-md-3">');
          htmlList.push('<div class="dom-container input-group"><button class="btn btn-default up-second btn-opTime">▲</button></div>');
          htmlList.push('</div>');
        }
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('<div class="row time-row margin-top-10">');
        htmlList.push('<div class="col-md-12">');
        htmlList.push('<div class="col-md-3 text-center">');
        htmlList.push('<div class="hour-value">' + formateHour.hour + '</div>');
        htmlList.push('</div>');
        htmlList.push('<div class="col-md-1 text-center">:</div>');
        htmlList.push('<div class="col-md-3 text-center">');
        htmlList.push('<div class="minute-value">' + minute + '</div>');
        htmlList.push('</div>');
        if (dropdown.secondsShow) {
          htmlList.push('<div class="col-md-1 text-center">:</div>');
          htmlList.push('<div class="col-md-3 text-center">');
          htmlList.push('<div class="second-value">' + second + '</div>');
          htmlList.push('</div>');
        }
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('<div class="row time-row margin-top-10">');
        htmlList.push('<div class="col-md-12">');
        htmlList.push('<div class="col-md-3">');
        htmlList.push('<div class="dom-container input-group"><button class="btn btn-default down-hour btn-opTime">▼</button></div>');
        htmlList.push('</div>');
        htmlList.push('<div class="col-md-offset-1 col-md-3">');
        htmlList.push('<div class="dom-container input-group"><button class="btn btn-default down-minute btn-opTime">▼</button></div>');
        htmlList.push('</div>');
        if (dropdown.secondsShow) {
          htmlList.push('<div class="col-md-offset-1 col-md-3">');
          htmlList.push('<div class="dom-container input-group"><button class="btn btn-default down-second btn-opTime">▼</button></div>');
          htmlList.push('</div>');
        }
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('<div class="row margin-top-20">');
        htmlList.push('<div class="col-md-12">');
        htmlList.push('<div class="col-md-offset-2 col-md-4">');
        htmlList.push('<div class="dom-container input-group"><button class="btn btn-default confirm-time">Ok</button></div>');
        htmlList.push('</div>');
        htmlList.push('<div class="col-md-4">');
        htmlList.push('<div class="dom-container input-group"><button class="btn btn-default btn-close">Close</button></div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        dropdown.element.innerHTML = htmlList.join("");
        htmlList = null;
        dropdown.element.onclick = dropdownElementClickCallback;
        var btnOPTimeList = dropdown.element.querySelectorAll(".btn-opTime");
        var timeOut = null;
        for (var opTimeIndex = 0; opTimeIndex < btnOPTimeList.length; opTimeIndex++) {
          var domItem = btnOPTimeList[opTimeIndex];
          domItem.onmousedown = mousedownCallback;
          domItem.onmouseup = mouseUpCallback;
        }

        function mousedownCallback(event) {
          event.stopPropagation();
          var opFlag = "";
          if (event.target.classList.contains("up-hour")) {
            opFlag = "up-hour";
          } else if (event.target.classList.contains("down-hour")) {
            opFlag = "down-hour";
          } else if (event.target.classList.contains("up-minute")) {
            opFlag = "up-minute";
          } else if (event.target.classList.contains("down-minute")) {
            opFlag = "down-minute";
          } else if (event.target.classList.contains("up-second")) {
            opFlag = "up-second";
          } else if (event.target.classList.contains("down-second")) {
            opFlag = "down-second";
          }
          timeOut = setInterval(function () {
            modifyTimeValue(opFlag);
          }, 500);
        }

        function mouseUpCallback(event) {
          clearInterval(timeOut);
          timeOut = null;
        }

        function modifyTimeValue(opFlag) {
          var currentHourDom = dropdown.element.querySelector(".hour-value");
          var currentMinuteDom = dropdown.element.querySelector(".minute-value");
          var currentSecondDom = dropdown.element.querySelector(".second-value");
          if (opFlag === "up-hour") {
            var hourValue = Number(currentHourDom.innerHTML) + 1;
            currentHourDom.innerHTML = jCommon.formatExceptYYYY(hourValue);
            controlHourAndMinuteAvalible();
          } else if (opFlag === "down-hour") {
            var hourValue = Number(currentHourDom.innerHTML) - 1;
            currentHourDom.innerHTML = jCommon.formatExceptYYYY(hourValue);
            controlHourAndMinuteAvalible();
          } else if (opFlag === "up-minute") {
            var minuValue = Number(currentMinuteDom.innerHTML) + 1;
            currentMinuteDom.innerHTML = jCommon.formatExceptYYYY(minuValue);
            controlHourAndMinuteAvalible();
          } else if (opFlag === "down-minute") {
            var minuValue = Number(currentMinuteDom.innerHTML) - 1;
            currentMinuteDom.innerHTML = jCommon.formatExceptYYYY(minuValue);
            controlHourAndMinuteAvalible();
          } else if (opFlag === "up-second") {
            var sencondValue = Number(currentSecondDom.innerHTML) + 1;
            currentSecondDom.innerHTML = jCommon.formatExceptYYYY(sencondValue);
            controlHourAndMinuteAvalible();
          } else if (opFlag === "down-second") {
            var sencondValue = Number(currentSecondDom.innerHTML) - 1;
            currentSecondDom.innerHTML = jCommon.formatExceptYYYY(sencondValue);
            controlHourAndMinuteAvalible();
          }
        }

        function dropdownElementClickCallback(event) {
          event.stopPropagation();
          if (event.target.classList.contains("timedropdown")) {
            dropdown.element.querySelector("div.dialog-content").classList.remove('hide');
            controlHourAndMinuteAvalible();
          } else if (event.target.classList.contains("btn-close")) {
            dropdown.element.querySelector("div.dialog-content").classList.add('hide');
          }
          if (event.target.classList.contains("up-hour")) {
            modifyTimeValue("up-hour");
          } else if (event.target.classList.contains("down-hour")) {
            modifyTimeValue("down-hour");
          } else if (event.target.classList.contains("up-minute")) {
            modifyTimeValue("up-minute");
          } else if (event.target.classList.contains("down-minute")) {
            modifyTimeValue("down-minute");
          } else if (event.target.classList.contains("up-second")) {
            modifyTimeValue("up-second");
          } else if (event.target.classList.contains("down-second")) {
            modifyTimeValue("down-second");
          } else if (event.target.classList.contains("solt-value")) {
            var soltValue = dropdown.element.querySelector(".solt-value").innerHTML === "PM" ? "AM" : "PM";
            dropdown.element.querySelector(".solt-value").innerHTML = soltValue;
          } else if (event.target.classList.contains("confirm-time")) {
            var selectHour = dropdown.element.querySelector(".hour-value").innerHTML;
            var selectMinute = dropdown.element.querySelector(".minute-value").innerHTML;
            var resultString = selectHour + ":" + selectMinute;
            if (dropdown.element.querySelector(".second-value")) {
              var selectSecond = dropdown.element.querySelector(".second-value").innerHTML;
              resultString += ":" + selectSecond;
            }
            if (dropdown.timeZone !== 24) {
              var selectSolot = dropdown.element.querySelector(".solt-value").innerHTML;
              resultString += " " + selectSolot;
              selectHour = jCommon.formateUTCHour(selectSolot, selectHour);
            }
            dropdown.element.querySelector(".timedropdown").innerHTML = resultString;
            dropdown.element.querySelector("div.dialog-content").classList.add('hide');
            if (dropdown.callback) {
              if (dropdown.secondsShow) {
                dropdown.callback(selectHour + selectMinute + selectSecond, dropdown.element.id);
              } else {
                dropdown.callback(selectHour + selectMinute, dropdown.element.id);
              }
            }
          }
        }

        function controlHourAndMinuteAvalible() {
          var hourValue = Number(dropdown.element.querySelector(".hour-value").innerHTML);
          var minuValue = Number(dropdown.element.querySelector(".minute-value").innerHTML);
          dropdown.element.querySelector(".up-hour").disabled = false;
          dropdown.element.querySelector(".down-hour").disabled = false;
          dropdown.element.querySelector(".up-minute").disabled = false;
          dropdown.element.querySelector(".down-minute").disabled = false;
          var hourMax = dropdown.timeZone === 24 ? 23 : 12;
          var hourMin = dropdown.timeZone === 24 ? 0 : 1;
          if (hourValue >= hourMax) {
            dropdown.element.querySelector(".up-hour").disabled = true;
          } else if (hourValue <= hourMin) {
            dropdown.element.querySelector(".down-hour").disabled = true;
          }
          if (minuValue >= 59) {
            dropdown.element.querySelector(".up-minute").disabled = true;
          } else if (minuValue <= 0) {
            dropdown.element.querySelector(".down-minute").disabled = true;
          }
          if (dropdown.element.querySelector(".second-value")) {
            dropdown.element.querySelector(".up-second").disabled = false;
            dropdown.element.querySelector(".down-second").disabled = false;
            var secondValue = Number(dropdown.element.querySelector(".second-value").innerHTML);
            if (secondValue >= 59) {
              dropdown.element.querySelector(".up-second").disabled = true;
            } else if (secondValue <= 0) {
              dropdown.element.querySelector(".down-second").disabled = true;
            }
          }
        }
      }
    },
    sensorChannelInput: function (channelFrom) {
      if (channelFrom && channelFrom.element) {
        var elementChannelId = channelFrom.element.id.replace("AnalogLabel", "");
        var newElementChannelId = "dialogChn-" + elementChannelId;
        var selectValue = [];
        var htmlList = [];
        var channelValue = "";
        var channelType = "";
        var dataMax = 0;
        if (channelFrom.defaultvalue) {
          selectValue = channelFrom.defaultvalue.split("-");
          channelType = selectValue[0];
          channelValue = selectValue[1];
          dataMax = channelPage.getChannelKeyLength(selectValue[1]);
        }
        htmlList.push('<div class="row">');
        htmlList.push('<div class="dom-container">');
        htmlList.push('<div class="input-div-disabled">');
        htmlList.push('<label id="' + elementChannelId + '-liveDataLabel" class="dialogClick alarm-status"></label>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('<div class="dialog-content hide">');
        htmlList.push('<div class="fade-mask"></div>');
        htmlList.push('<div class="sensorChannelInputDialog-Content modal-body">');
        htmlList.push('<div class="modal-header">' + channelFrom.element.getAttribute("data-title") + '<button class="btn btn-default btn-close" type="button">Close</button></div>');
        htmlList.push('<div class="modal-content">');
        htmlList.push('<div class="row">');
        htmlList.push('<label class="control-label">type</label>');
        htmlList.push('<input type="hidden" id="' + newElementChannelId + '-simEn">');
        htmlList.push('<input type="hidden" class="channelTypeValue" id="' + newElementChannelId + 'Type" data-type="int" value="' + channelType + '">');
        htmlList.push('<div class="channel-typelist"></div>');
        htmlList.push('</div>');
        htmlList.push('<div class="row form-inline">');
        htmlList.push('<label class="control-label channel-input-title">channel</label>');
        htmlList.push('<input type="text" id="' + newElementChannelId + '" class="input-analog-channel keyboardnumberInput channelChn" data-max="' + dataMax + '" data-min="0" value="' + channelValue + '">');
        htmlList.push('<div v-show="' + newElementChannelId + ' > 0" class="hide"><a href="" class="btn btn-default channelChConfig" id="' + newElementChannelId + '-ConfigName"></a></div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('<input type="hidden" id="' + newElementChannelId + '-configValid">');
        htmlList.push('<input type="hidden" id="' + newElementChannelId + '-isConfigName">');
        htmlList.push('<div v-show="' + newElementChannelId + '-configValid == true && ' + newElementChannelId + '-isConfigName == true || ' + newElementChannelId + ' == 0" class="modal-footer text-center hide">');
        htmlList.push('<button type="button" class="btn btn-default btn-channel-ok">Ok</button>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        htmlList.push('</div>');
        channelFrom.element.innerHTML = htmlList.join("");
        channelPage.setChannelTypeAndValueAndConfig(elementChannelId, channelType, channelValue);
        htmlList = null;
        var list = [{
          "value": "1",
          "name": "Input"
        }, {
          "value": "2",
          "name": "Output"
        }, {
          "value": "3",
          "name": "Internal"
        }, {
          "value": "4",
          "name": "Function Block"
        }];
        var typeItemList = [];
        var typeItem = [];
        var channelDisableList = [];
        if (channelFrom.element.getAttribute("data-disabled")) {
          channelDisableList = channelFrom.element.getAttribute("data-disabled").split(",");
        }
        list.forEach(function (item) {
          typeItem = [];
          var checkbox = "";
          var selectItemId = channelFrom.element.id + '-' + item["value"];
          var disabled = "";
          if (channelType === item["value"]) {
            checkbox = "checked";
          }
          if (channelDisableList.indexOf(item["value"]) > -1) {
            disabled = "disabled";
          }
          typeItem.push('<div class="col-md-6 channel-typelist-row">');
          typeItem.push('<div class="radio-container">');
          typeItem.push('<div class="radio">');
          typeItem.push('<input name="' + channelFrom.element.id + '-chType" type="radio" class="inputradio" id="' + selectItemId + '" value="' + item["value"] + '"' + checkbox + ' ' + disabled + '>');
          typeItem.push('<label for="' + selectItemId + '"></label>');
          typeItem.push('</div>');
          typeItem.push('<label class="radio-label">' + item["name"] + '</label>');
          typeItem.push('</div>');
          typeItem.push('</div>');
          typeItemList.push(typeItem.join(""));
        })
        channelFrom.element.querySelector("div.channel-typelist").innerHTML = typeItemList.join("");
        typeItem = null;
        typeItemList = null;
        channelFrom.element.onclick = channelFromElementCallback;

        function channelFromElementCallback(event) {
          event.stopPropagation();
          if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id, "noLoginState")) {
            userlogin.showLoginDialog();
            return false;
          }
          if (event.target.classList.contains("dialogClick")) {
            var selectChannelType = jCommon.getHtmlValue(elementChannelId + "Type");
            var selectChannel = jCommon.getHtmlValue(elementChannelId);
            var radioList = channelFrom.element.querySelectorAll("input[type='radio']");
            radioList.forEach(function (radioItem) {
              radioItem.checked = false;
              if (Number(radioItem.value) === selectChannelType) {
                radioItem.checked = true;
              }
            })
            channelPage.setChannelTypeAndValueAndConfig(newElementChannelId, selectChannelType, selectChannel);
            channelFrom.element.querySelector("div.dialog-content").classList.remove('hide');
          } else if (event.target.classList.contains("inputradio")) {
            channelFrom.element.querySelector(".channelChn").setAttribute("data-max", channelPage.getChannelKeyLength(event.target.value))
            channelFrom.element.querySelector(".channelTypeValue").value = event.target.value;
            channelFrom.element.querySelector(".channelChn").value = 0;
            channelFrom.element.querySelector(".channelChConfig").innerHTML = "Config";
            channelFrom.element.querySelector(".channelChConfig").setAttribute("href", "");
          } else if (event.target.classList.contains("btn-close")) {
            channelFrom.element.querySelector("div.dialog-content").classList.add('hide');
          } else if (event.target.classList.contains("btn-channel-ok")) {
            var channelTypeValue = Number(channelFrom.element.querySelector(".channelTypeValue").value);
            var channelCh = Number(channelFrom.element.querySelector(".channelChn").value);
            if (channelCh === 0) {
              channelTypeValue = 0;
            }
            if (channelFrom.callback) {
              channelFrom.callback([channelTypeValue, channelCh], channelFrom.element.id);
            }
            channelFrom.element.querySelector("div.dialog-content").classList.add('hide');
          }
        }
      }
    },
    sizeTostr: function (size) {
      var data = "";
      if (size < 0.1 * 1024) {
        data = jCommon.formatNumber(size) + "B";
      } else if (size < 0.1 * 1024 * 1024) {
        data = jCommon.formatNumber(size / 1024) + "KB";
      } else if (size < 0.1 * 1024 * 1024 * 1024) {
        data = jCommon.formatNumber(size / (1024 * 1024)) + "MB";
      } else {
        data = jCommon.formatNumber(size / (1024 * 1024 * 1024)) + "GB";
      }
      var sizestr = data + "";
      var len = sizestr.indexOf("\.");
      var dec = sizestr.substr(len + 1, 2);
      if (dec == "00") {
        return sizestr.substring(0, len) + sizestr.substr(len + 3, 2);
      }
      return sizestr;
    },
    showSvgDom: function (keyClassName) {
      var domList = document.getElementsByClassName(keyClassName);
      for (var index = 0; index < domList.length; index++) {
        domList[index].style.setProperty("display", "block");
      }
    },
    setSvgStyle: function (domId, styleString) {
      if (document.getElementById(domId)) {
        document.getElementById(domId).setAttribute("style", styleString);
      }
    },
    setSvgText: function (domId, value) {
      if (document.getElementById(domId)) {
        document.getElementById(domId).textContent = value;
      }
    },
    hideSvgDom: function (keyClassName) {
      var domList = document.getElementsByClassName(keyClassName);
      for (var index = 0; index < domList.length; index++) {
        domList[index].style.setProperty("display", "none");
      }
    },
    getSvgLoopItem: function (loopInfo, item, itemCount, bppcCount, lastLoopInfo) {
      var inputValueHtml = systemFeed.getLoopSetPointDomValueItem(loopInfo, item["loopIndex"], itemCount, bppcCount);
      var labelUnitHtml = systemFeed.getLoopSetPointDomUnitItem(loopInfo, bppcCount, lastLoopInfo);
      var modeHtml = systemFeed.getLoopSetPointDomModeItem(loopInfo, item["loopIndex"], itemCount);
      var itemList = [];
      // svg loop animation
      itemList.push('<div class="svg-loopItem-container">');
      // svg graphics
      itemList.push('<div class="svg-background">');
      itemList.push('<svg xmlns="http://www.w3.org/2000/svg" version="1.1" style="width: 100%;height: 282px">');
      itemList.push('<rect x="204" y="0" width="8" height="120" fill="#80B0F0" />');
      itemList.push('<circle cx="208" cy="50" r="10" stroke="black" stroke-width="1" fill="red" id="item-' + itemCount + '-loop-svgstatus"/>');
      itemList.push('<rect x="198" y="120" width="20" height="10" fill="#000" />');
      itemList.push('<rect x="200" y="130" width="16" height="8" fill="#fff" stroke-width="2" stroke="#848484" />');
      itemList.push('<rect x="205" y="138" width="5" height="5" fill="#fff" stroke-width="2" stroke="#848484" />');
      itemList.push('<rect x="200" y="143" width="16" height="92" fill="#fff" stroke-width="2" stroke="#848484" />');
      itemList.push('<rect x="205" y="235" width="5" height="5" fill="#fff" stroke-width="2" stroke="#848484" />');
      itemList.push('<rect x="200" y="240" width="16" height="8" fill="#fff" stroke-width="2" stroke="#848484" />');
      itemList.push('<path d="M203 248 H213 Q213 279 178 279 V269 Q203 269 203 248" fill="#cecece" stroke="#232323" stroke-width="2" />');
      itemList.push('<rect x="78" y="269" width="100" height="10" fill="#cecece" stroke-width="1" stroke="#232323" />');
      itemList.push('<rect x="30" y="270" width="38" height="8" fill="#80B0F0" />');
      itemList.push('<rect x="68" y="265" width="10" height="18" fill="#000" />');
      itemList.push('<rect x="195" y="190" width="5" height="40" fill="#000" />');
      itemList.push('<rect x="110" y="183" width="65" height="65" fill="#000" />');
      itemList.push('<rect x="120" y="183" width="75" height="75" fill="#0000f8" />');
      itemList.push('<rect x="150" y="183" width="45" height="5" fill="#fff" />');
      itemList.push('<rect x="150" y="187" width="45" height="45" fill="red" id="item-' + itemCount + '-signal-status"/>');
      itemList.push('<text x="155" y="218" id="item-' + itemCount + '-signal-text">OFF</text>');
      itemList.push('</svg>');
      itemList.push('</div>');
      // Loop Data
      itemList.push('<div class="control-type-data">');
      // Title
      itemList.push('<div class="row svg-feed-title-row">');
      itemList.push('<input class="loop-item" type="hidden" id="item-' + itemCount + '" value="' + item["loopIndex"] + '" data-type="int">');
      itemList.push('<input type="hidden" id="item-' + itemCount + '-enable">');
      itemList.push('<input type="hidden" id="item-' + itemCount + '-configValid"/>');
      itemList.push('<div v-show="item-' + itemCount + '-enable == true" class="col-md-offset-07 col-md-12 svg-feed-title hide">' + item["name"] + '</div>');
      itemList.push('<div v-show="item-' + itemCount + '-enable == false" class="col-md-offset-07 col-md-12 text-center loop-state-disabled hide">Loop Disabled</div>');
      itemList.push('</div>');
      // Mode
      itemList.push('<div class="row text-center margin-top-2">');
      itemList.push('<div class="col-md-12">');
      itemList.push('<div class="col-md-offset-3 col-md-8">');
      itemList.push('<div class="dom-container">');
      itemList.push(modeHtml);
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      // SP and Units
      if ([1, 2, 6, 8].indexOf(item["ctrlType"]) > -1) {
        // Sp Ratio, PID, On/Off
        itemList.push('<div class="loop-sp-container">');
        itemList.push('<div class="row">');
        itemList.push('<label>Loop SP:</label >');
        itemList.push('</div>');
        itemList.push('<div class="row system-Cooling-row">');
        itemList.push('<div class="col-md-12">');
        itemList.push('<div class="col-md-7">');
        itemList.push(inputValueHtml);
        itemList.push('</div>');
        itemList.push('<div class="col-md-4">');
        itemList.push('<label>' + labelUnitHtml + '</label>');
        itemList.push('</div>');
        itemList.push('</div>');
        itemList.push('</div>');
        itemList.push('</div>');
      } else if ([5, 7].indexOf(item["ctrlType"]) > -1) {
        // SP pfc bppc
        itemList.push('<div class="feed-sp-container">');
        itemList.push('<div class="row">');
        itemList.push('<label>Feed SP:</label >');
        itemList.push('</div>');
        itemList.push('<div class="row system-Cooling-row">');
        itemList.push('<div class="col-md-12">');
        itemList.push('<div class="col-md-7">');
        itemList.push(inputValueHtml);
        itemList.push('</div>');
        itemList.push('<div class="col-md-4">');
        itemList.push('<label>' + labelUnitHtml + '</label>');
        itemList.push('</div>');
        itemList.push('</div>');
        itemList.push('</div>');
        itemList.push('</div>');
      } else {
        itemList.push('<div class="none-container">');
        itemList.push('</div>');
      }
      // Feed Rate and Units
      itemList.push('<div class="row">');
      itemList.push('<label>Feed Rate:</label>');
      itemList.push('</div>');
      itemList.push('<div class="row system-Cooling-row">');
      itemList.push('<div class="col-md-12">');
      itemList.push('<div class="col-md-7">');
      itemList.push(systemFeed.getLoopSetPointRateMan(loopInfo, item["loopIndex"], itemCount, bppcCount));
      itemList.push('</div>');
      itemList.push('<div class="col-md-5">');
      itemList.push(systemFeed.getLoopSetPointUnit(loopInfo));
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      // CV and Units
      itemList.push('<div class="row system-Cooling-row margin-top-20">');
      itemList.push('<div class="col-md-12">');
      itemList.push('<div class="col-md-2">');
      itemList.push('<label>CV</label>');
      itemList.push('</div>');
      itemList.push('<div class="col-md-4">');
      itemList.push('<div class="dom-container input-group">');
      itemList.push('<div class="input-div-disabled">');
      itemList.push('<label class="text-right" id="item-' + itemCount + '-cv"></label>');
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('<div class="col-md-1">');
      itemList.push('<label>%</label>');
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      itemList.push('</div>');
      return itemList.join("");
    },
    getAnalogDisplayItem: function (itemData, index) {
      var item = [];
      var rowIndex = Number(index) + 1;
      var channelInfo = channelPage.getChannelInfo(itemData["channelType"], itemData["channel"]);
      var channelInfoName = typeof channelInfo === "undefined" ? "" : channelInfo["name"];
      var channelInfoUnit = typeof channelInfo === "undefined" ? "" : channelPage.getChannelUnitLabel(channelInfo);
      item.push('<div class="row analog-display-row">');
      item.push('<div class="col-md-12">');
      item.push('<div class="col-md-1 text-center">');
      item.push('<label>' + rowIndex + '</label>');
      item.push('</div>');
      item.push('<div class="col-md-2">');
      item.push('<div class="dom-container input-group">');
      item.push('<input type="hidden" id="row-' + rowIndex + '-Chn" value="' + itemData["channel"] + '" data-type="int" class="input-analog-channel" data-value-name="value-name-analog">');
      item.push('<input type="hidden" id="row-' + rowIndex + '-ChnType" value="' + itemData["channelType"] + '" data-type="int">');
      item.push('<div id="row-' + rowIndex + '-ChnAnalogLabel"></div>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-4">');
      item.push('<div class="dom-container input-group">');
      item.push('<div class="input-div-disabled">');
      item.push('<label id="row-' + rowIndex + '-Chn-ConfigName">' + channelInfoName + '</label>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-1"><input type="hidden" id="row-' + rowIndex + '-Chn-simEn">');
      item.push('<div v-show="row-' + rowIndex + '-Chn-simEn == true && row-' + rowIndex + '-Chn > 0 " class="input-div-enabled form-inline hide">');
      item.push('<input type="text" class="form-control keyboardnumberInput alarm-status" id="row-' + rowIndex + '-Chn-simData" data-title="simData" />');
      item.push('</div>');
      item.push('<div v-show="row-' + rowIndex + '-Chn-simEn == false || row-' + rowIndex + '-Chn == 0 " class="input-div-disabled form-inline hide">');
      item.push('<label id="row-' + rowIndex + '-Chn-liveDataLabel" class="alarm-status"></label>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-2">');
      item.push('<div class="dom-container input-group">');
      item.push('<div class="input-div-disabled">');
      item.push('<label class="row-' + rowIndex + '-Chn-simDataUnit">' + channelInfoUnit + '</label>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-2">');
      item.push('<div class="dom-container input-group">');
      item.push('<div class="progressbar html">');
      item.push('<div class="filled" id="row-' + rowIndex + '-Chn-progress"></div>');
      item.push(' </div>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      return item.join("");
    },
    getDigitalDisplayItem: function (itemData, index) {
      var item = [];
      var rowIndex = Number(index) + 1;
      var channelInfo = channelPage.getChannelInfo(itemData["channelType"], itemData["channel"]);
      var channelInfoName = typeof channelInfo === "undefined" ? "" : channelInfo["name"];
      item.push('<div class="row digital-display-row">');
      item.push('<div class="col-md-12">');
      item.push('<div class="col-md-offset-2 col-md-1">');
      item.push('<div class="col-md-12 text-center">');
      item.push('<label>' + rowIndex + '</label>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-2">');
      item.push('<div class="dom-container input-group">');
      item.push('<input type="hidden" id="row-' + rowIndex + '-chn" data-type="int" class="input-digital-channel">');
      item.push('<input type="hidden" id="row-' + rowIndex + '-chnType" data-type="int">');
      item.push('<div id="row-' + rowIndex + '-chnDigitalLabel"></div>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-4">');
      item.push('<div class="dom-container input-group">');
      item.push('<div class="input-div-disabled">');
      item.push('<label id="row-' + rowIndex + '-chn-ConfigName">' + channelInfoName + '</label>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-1">');
      item.push('<div class="dom-container input-group">');
      item.push('<input type="hidden" id="row-' + rowIndex + '-chnState">');
      item.push('<input type="hidden" id="row-' + rowIndex + '-simEn">');
      item.push('<div v-show="row-' + rowIndex + '-simEn == true" class="hide">');
      item.push('<button type="button" id="row-' + rowIndex + '-simData_OP" class="btn digital-status" data-value="" data-label-range="OFF,ON" data-value-range="0,1"></button>');
      item.push('</div>');
      item.push('<div v-show="row-' + rowIndex + '-simEn == false && row-' + rowIndex + '-chnState == false && row-' + rowIndex + '-chn > 0 || row-' + rowIndex + '-chn == 0" class="hide">');
      item.push('<label class="digital-status digital-Off">OFF</label>');
      item.push('</div>');
      item.push('<div v-show="row-' + rowIndex + '-simEn == false && row-' + rowIndex + '-chnState == true && row-' + rowIndex + '-chn > 0" class="hide">');
      item.push('<label class="digital-status digital-On">ON</label>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      item.push('<div class="col-md-1">');
      item.push('<div class="dom-container input-group">');
      item.push('<input type="hidden" id="row-' + rowIndex + '-chn-alarmWarning">');
      item.push('<div v-show="row-' + rowIndex + '-chnState == true && row-' + rowIndex + '-chn-alarmWarning == 2"><label class="display-status message-alarm">Alarm</label></div>');
      item.push('<div v-show="row-' + rowIndex + '-chnState == true && row-' + rowIndex + '-chn-alarmWarning == 1"><label class="display-status message-warning">Warning</label></div>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      item.push('</div>');
      return item.join("");
    },
    setInputTextDisabled: function (domId, value) {
      if (jCommon.empty(value)) {
        jCommon.setHtmlAttribute(domId, "disabled", false);
        jCommon.removeHtmlClass("#" + domId, "disabled-background");
      } else {
        jCommon.setHtmlAttribute(domId, "disabled", true);
        jCommon.addHtmlClass("#" + domId, "disabled-background");
      }
    },
    setSwitchEnabled: function (keyId, state) {
      var domItem = document.getElementById(keyId).querySelector(".btn-switch");
      if (state) {
        jCommon.removeDomClass(domItem, "btn-switch-disabled");
      } else {
        jCommon.addDomClass(domItem, "btn-switch-disabled");
      }
    },
    getPreAnalogDigitalHtml: function (number) {
      var htmlArr = [];
      for (var index = 0; index < number; index++) {
        htmlArr.push('<div class="row ogolanalogconfig-row">');
        htmlArr.push('<div class="col-md-12">');
        htmlArr.push('<div class="col-md-offset-1 col-md-1 text-center">#' + Number(index + 1) + '</div>');
        htmlArr.push('<div class="col-md-2">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<input type="hidden" data-type="int" id="row-' + index + '-type" />');
        htmlArr.push('<div id="row-' + index + '-typeLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-5">');
        htmlArr.push('<div class="col-md-12">');
        htmlArr.push('<div v-show="row-' + index + '-type == 2 || row-' + index + '-type == 1" class="col-md-3 hide">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<input type="hidden" id="row-' + index + '-chn" data-type="int" class="input-analog-channel input-digital-channel" />');
        htmlArr.push('<input type="hidden" id="row-' + index + '-chnType" data-type="int">');
        htmlArr.push('<div v-show="row-' + index + '-type == 1" class="hide">');
        htmlArr.push('<div id="row-' + index + '-chnAnalogLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div v-show="row-' + index + '-type == 1" class="col-md-9 hide">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<div class="input-div-disabled">');
        htmlArr.push('<label id="row-' + index + '-name"></label>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div v-show="row-' + index + '-type == 3" class="dom-container input-group hide">');
        htmlArr.push('<input type="hidden" id="row-' + index + '-pdLoop" data-type="int">');
        htmlArr.push('<div id="row-' + index + '-pdLoopLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-2">');
        htmlArr.push('<div v-show="row-' + index + '-type == 3" class="dom-container input-group hide">');
        htmlArr.push('<input type="hidden" id="row-' + index + '-pdChn" data-type="int">');
        htmlArr.push('<div id="row-' + index + '-pdChnLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-1">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<input type="hidden" data-type="int" id="row-' + index + '-analogFreq" />');
        htmlArr.push('<div id="row-' + index + '-analogFreqLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
      }
      return htmlArr.join("");
    },
    getEmailAnalogAndDigital: function (index, item) {
      var htmlArr = [];
      htmlArr.push('<div class="row email-header-row">');
      htmlArr.push('<div class="col-md-12">');
      htmlArr.push('<div class="col-md-1">');
      htmlArr.push('<div class="dom-container input-div-disabled input-group">');
      htmlArr.push('<label>#' + Number(index + 1) + '</label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-1">');
      htmlArr.push('<div class="dom-container input-div-disabled input-group">');
      if (item["chnType"] === 0) {
        htmlArr.push('<label>' + item["chn"] + '</label>');
      } else {
        htmlArr.push('<label>' + channelPage.getChannelInputLabel(item["chnType"], item["chn"]) + '</label>');
      }
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-2">');
      htmlArr.push('<div class="dom-container input-div-disabled input-group">');
      htmlArr.push('<label>' + channelPage.getChannelInfo(item["chnType"], item["chn"], "name") + '</label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-5">');
      htmlArr.push('<div class="dom-container input-div-disabled input-group">');
      htmlArr.push('<label>' + item["rmtAlarmMsg"] + '</label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-1 text-center">');
      htmlArr.push('<div class="switch-container">');
      htmlArr.push('<div class="switch-touch" data-type="boolen" data-value-range="true,false" data-value="" id = "row-' + index + '-emailEn" data-save-property="/remoteAlarm/uuid' + item["uuid"] + '/emailEn">');
      htmlArr.push('<div class="switch-background">');
      htmlArr.push('<label class="btn-switch"></label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-1">')
      htmlArr.push('<div class="dom-container input-div-disabled input-group">');
      htmlArr.push('<label id = "uuid' + item["uuid"] + '-Mins"></label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-1 text-center">');
      htmlArr.push('<div class="switch-container">');
      htmlArr.push('<div class="switch-touch" data-type="boolen" data-value-range="true,false" data-value="" id="row-' + index + '-ogolEn" data-save-property="/remoteAlarm/uuid' + item["uuid"] + '/ogolEn">');
      htmlArr.push('<div class="switch-background">');
      htmlArr.push('<label class="btn-switch disabled"></label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      return htmlArr.join("");
    },
    getMonitorProcessItem: function (item, index) {
      var htmlArr = [];
      if (item["name"].startsWith("CMB_In")) {
        htmlArr.push('<div class="row monitor-process-row">');
        htmlArr.push('<div class="col-md-12">');
        htmlArr.push('<div class="col-md-2 text-center">');
        htmlArr.push('<div class="input-div-disabled">');
        htmlArr.push('<label>' + item["name"] + '</label>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-1 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<button type="button" class="btn btn-default monitorInputType" id="row-' + index + '-inputType" data-label-range="Channel,Loop" data-value-range="0,1" data-value="" ></button >');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-4">');
        htmlArr.push('<div class="col-md-4">');
        htmlArr.push('<div v-show="row-' + index + '-inputType == 0" class="dom-container input-group hide">');
        htmlArr.push('<input type="hidden" id="row-' + index + '-inputChannel" data-type="int" ><input type="hidden" id="row-' + index + '-inputChannelType" data-type="int">');
        htmlArr.push('<div id="row-' + index + '-inputChannelAnalogLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('<div v-show="row-' + index + '-inputType == 1" class="dom-container input-group hide">');
        htmlArr.push('<input type="hidden" id="row-' + index + '-inputLoop" class="input-pd-type" data-type="int">');
        htmlArr.push('<div id="row-' + index + '-inputLoopLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-8">');
        htmlArr.push('<div v-show="row-' + index + '-inputType == 0" class="dom-container input-group hide">');
        htmlArr.push('<a id="row-' + index + '-inputChannel-ConfigName" class="btn btn-default btn-redirect"></a>');
        htmlArr.push('</div>');
        htmlArr.push('<div v-show="row-' + index + '-inputType == 1" class="dom-container input-group hide">');
        htmlArr.push('<a id="row-' + index + '-inputLoop-ConfigName" class="btn btn-default btn-redirect"></a>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-3">');
        htmlArr.push('<div class="col-md-6 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<div class="input-div-enabled form-inline">');
        htmlArr.push('<input type="text" id="row-' + index + '-lowerLimit" class="form-control keyboardnumberInput" value="' + item["lowerLimit"] + '" data-title="lowerLimit">');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-6 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<div class="input-div-enabled form-inline">');
        htmlArr.push('<input type="text" id="row-' + index + '-upperLimit" class="form-control keyboardnumberInput" value="' + item["upperLimit"] + '" data-title="upperLimit">');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-2 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<div class="input-div-disabled">');
        htmlArr.push('<label class="row-' + index + '-inputChannel-simDataUnit"></label>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
      } else {
        htmlArr.push('<div class="row monitor-process-row">');
        htmlArr.push('<div class="col-md-12">');
        htmlArr.push('<div class="col-md-2 text-center">');
        htmlArr.push('<div class="input-div-disabled">');
        htmlArr.push('<label>' + item["name"] + '</label>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-1 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<button type="button" disabled class="btn btn-default">Channel</button>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-4">');
        htmlArr.push('<div class="col-md-4">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<input type="hidden" id="row-' + index + '-inputChannel" data-type="int">');
        htmlArr.push('<input type="hidden" id="row-' + index + '-inputChannelType" data-type="int">');
        htmlArr.push('<div id="row-' + index + '-inputChannelAnalogLabel"></div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-8">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<a id="row-' + index + '-inputChannel-ConfigName" class="btn btn-default btn-redirect"></a>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-3">');
        htmlArr.push('<div class="col-md-6 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<div class="input-div-enabled form-inline">');
        htmlArr.push('<input type="text" id="row-' + index + '-lowerLimit" class="form-control keyboardnumberInput" value="' + item["lowerLimit"] + '" data-title="lowerLimit">');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-6 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<div class="input-div-enabled form-inline">');
        htmlArr.push('<input type="text" id="row-' + index + '-upperLimit" class="form-control keyboardnumberInput" value="' + item["upperLimit"] + '" data-title="upperLimit">');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('<div class="col-md-2 text-center">');
        htmlArr.push('<div class="dom-container input-group">');
        htmlArr.push('<div class="input-div-disabled">');
        htmlArr.push('<label class="row-' + index + '-inputChannel-simDataUnit"></label>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
        htmlArr.push('</div>');
      }
      return htmlArr.join("");
    },
    getMonitorItem: function (index) {
      var htmlArr = [];
      htmlArr.push('<div class="row statis-monitor-row">');
      htmlArr.push('<div class="col-md-12">');
      htmlArr.push('<div class="col-md-4 text-center">');
      htmlArr.push('<div class="col-md-7 text-right">');
      htmlArr.push('<div class="dom-container input-group">');
      htmlArr.push('<div class="input-div-disabled">');
      htmlArr.push('<label id="row-' + index + '-name" class="monitors-' + index + '-name"></label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-5 text-right">');
      htmlArr.push('<div class="dom-container input-group">');
      htmlArr.push('<button type="button" class="btn btn-default" id="row-' + index + '-monitorproperty">...</button>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-5 text-center">');
      htmlArr.push('<div class="col-md-4">');
      htmlArr.push('<div class="dom-container input-group">');
      htmlArr.push('<input type="hidden" id="row-' + index + '-processId" data-type="int">');
      htmlArr.push('<div id="row-' + index + '-processIdLabel" name-substring="0,3"></div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-4">');
      htmlArr.push('<div class="dom-container input-group">');
      htmlArr.push('<input type="hidden" id="row-' + index + '-monitoringType" data-type="int">');
      htmlArr.push('<div id="row-' + index + '-monitoringTypeLabel" name-substring="0,3"></div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-4">');
      htmlArr.push('<div class="dom-container input-group">');
      htmlArr.push('<a class="btn btn-default btn-redirect" href="#monitorprocess&p=' + Number(index + 1) + '">...</a>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-3 text-center">');
      htmlArr.push('<div class="col-md-6 text-right">');
      htmlArr.push('<div class="dom-container input-group">');
      htmlArr.push('<input type="hidden" id="row-' + index + '-groupId" data-type="int">');
      htmlArr.push('<div id="row-' + index + '-groupIdLabel"></div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-6 text-right">');
      htmlArr.push('<div class="dom-container input-group">');
      htmlArr.push('<a class="btn btn-default btn-redirect" id="row-' + index + '-groupUrl">...</a>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      return htmlArr.join("");
    },
    getProbeConfigItem: function (index) {
      var disabled = jCommon.getCurrentPage() == "probetime" ? true : false;
      var htmlArr = [];
      htmlArr.push('<div class="row trendconfig-row">');
      htmlArr.push('<div class="col-md-12">');
      htmlArr.push('<div class="col-md-05 text-center">#' + (index + 1) + '</div>');
      htmlArr.push('<div class="col-md-2">');
      htmlArr.push('<div class="dom-container input-group">');
      // brush Address
      htmlArr.push('<input type="hidden" data-type="int" id="row-' + index + '-brushAddr" />');
      htmlArr.push('<input type="hidden" class="pyxis-probe" data-type="int" id="row-' + index + '-PN" />');
      htmlArr.push('<div id="row-' + index + '-PNLabel"></div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-4">');
      if (disabled) {
        htmlArr.push('<div class="input-div-disabled form-inline dom-container">');
        htmlArr.push('<label id="row-' + index + '-customName"></label>');
        htmlArr.push('</div>');
      } else {
        htmlArr.push('<div class="input-div-enabled form-inline dom-container">');
        htmlArr.push('<input type="text" class="form-control keyboardinternationalInput" id="row-' + index + '-customName" data-title="Custom Name">');
        htmlArr.push('</div>');
      }
      htmlArr.push('</div>');
      htmlArr.push('<div class="col-md-1-5">');
      if (disabled) {
        htmlArr.push('<div class="input-div-disabled form-inline dom-container">');
        htmlArr.push('<label id="row-' + index + '-ModbusAddr"></label>');
        htmlArr.push('</div>');
      } else {
        htmlArr.push('<div class="input-div-enabled form-inline dom-container">');
        htmlArr.push('<input type="text" class="form-control keyboardnumberInput" id="row-' + index + '-ModbusAddr" data-title="Modbus Address" data-min="1" data-max="255">');
        htmlArr.push('</div>');
      }
      htmlArr.push('</div>');
      //enable
      htmlArr.push('<div class="col-md-07">');
      htmlArr.push('<div v-show="row-' + index + '-PN > 0" class="switch-touch hide" data-type="boolen" data-value-range="true,false" data-value="" id="row-' + index + '-enable">');
      htmlArr.push('<div class="switch-background">');
      if (disabled) {
        htmlArr.push('<label class="btn-switch disabled"></label>');
      } else {
        htmlArr.push('<label class="btn-switch"></label>');
      }
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      //status
      htmlArr.push('<div class="col-md-08">');
      htmlArr.push('<div v-show="row-' + index + '-PN > 0" class="hide">');
      htmlArr.push('<input type="hidden" id="row-' + index + '-connected"/>');
      // htmlArr.push('<input type="hidden" id="row-' + index + '-brushConnected"/>');
      //brushAddr > 0 start
      // htmlArr.push('<div v-show="row-' + index + '-brushAddr > 0" class="hide"/>');
      // htmlArr.push('<div v-show="row-' + index + '-connected == 2 || row-' + index + '-brushConnected == 2" class="hide text-center">');
      // htmlArr.push('<label class="connect-status connect-Off">Offline</label>');
      // htmlArr.push('</div>');
      // htmlArr.push('<div v-show="row-' + index + '-connected == 0 && row-' + index + '-brushConnected == 0" class="hide text-center">');
      // htmlArr.push('<label class="connect-status connect-On">Online</label>');
      // htmlArr.push('</div>');
      // htmlArr.push('<div v-show="row-' + index + '-connected == 1 && row-' + index + '-brushConnected == 1" class="hide text-center">');
      // htmlArr.push('<label class="connect-status connect-checking">Checking</label>');
      // htmlArr.push('</div>');
      // htmlArr.push('</div>');
      //brushAddr > 0 end
      //brushAddr < 0 v-show="row-' + index + '-brushAddr <= 0" class="hide"start
      htmlArr.push('<div>');
      htmlArr.push('<div v-show="row-' + index + '-connected == 2" class="hide text-center">');
      htmlArr.push('<label class="width-100-percent connect-status connect-Off">Offline</label>');
      htmlArr.push('</div>');
      htmlArr.push('<div v-show="row-' + index + '-connected == 0" class="hide text-center">');
      htmlArr.push('<label class="width-100-percent connect-status connect-On">Online</label>');
      htmlArr.push('</div>');
      htmlArr.push('<div v-show="row-' + index + '-connected == 1" class="hide text-center">');
      htmlArr.push('<label class="width-100-percent connect-status connect-checking">Checking</label>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      //brushAddr < 0 end
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('<div v-show="row-' + index + '-PN > 0" class="col-md-2">');
      htmlArr.push('<div class="dom-container input-group">');
      if (disabled) {
        htmlArr.push('<button type="button" class="btn btn-default btn-login" id="row-' + index + '-display">Display</button>');
      } else {
        htmlArr.push('<button type="button" class="btn btn-default btn-login" id="row-' + index + '-ProbeConfig">Config</button>');
      }
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      htmlArr.push('</div>');
      return htmlArr.join("");
    },
    checkDomVisible: function (dom) {
      if (dom.tagName === "BODY") {
        return true;
      }
      if (dom.type === "hidden" || dom.className && dom.className.indexOf("hide") > -1 || dom.style.display === 'none') {
        return false;
      } else {
        if (dom.parentElement) {
          return jCommon.checkDomVisible(dom.parentElement);
        }
      }
    },
    checkBtnLoginDisabled: function () {
      var btnDomLogin = document.querySelectorAll(".btn-login");
      var user_account = jCommon.getLocalStorge("user_account");
      if (btnDomLogin.length > 0) {
        if (jCommon.empty(user_account) || user_account == 1) {
          // no login and oper
          for (var index = 0; index < btnDomLogin.length; index++) {
            var btnDomLoginItem = btnDomLogin[index];
            btnDomLoginItem.setAttribute("login-disable", true);
          }
        } else {
          //removeDisable
          for (var index = 0; index < btnDomLogin.length; index++) {
            var btnDomLoginItem = btnDomLogin[index];
            btnDomLoginItem.setAttribute("login-disable", false);
          }
        }
      }
    },
    setLiveDataValue: function (elementId, value) {
      if (document.getElementById(elementId) && value !== undefined) {
        if (jCommon.isNumber(value)) {
          value = jCommon.formatNumber(value);
        }
        var dom = document.getElementById(elementId);
        var tagName = dom.tagName;
        if (["LABEL", "SPAN", "DIV"].indexOf(tagName) > -1) {
          dom.innerText = value;
        } else if (tagName === "INPUT") {
          if (["hidden"].indexOf(dom.type) > -1) {
            dom.value = value;
          }
        }
        jCommon.controlDOMShow(elementId);
      }
    },
    calCarcLength: function (roate, r) {
      return (roate * 3.14 * r) / 180;
    },
    mergeLiveData: function (initData, currentData, callbackfun) {
      if (initData == null) {
        initData = {};
      }
      for (var path in currentData) {
        var k = initData;
        var steps = path.split('/');
        var last = steps.pop();
        for (var index = 0; index < steps.length; index++) {
          var e = steps[index];
          var nextE = steps[index + 1];
          if (k[e] == null) {
            if (typeof nextE != undefined) {
              if (jCommon.isNumber(nextE)) {
                k[e] = [];
              } else {
                k[e] = {};
              }
            }
            if (nextE == undefined) {
              if (jCommon.isNumber(last)) {
                k[e] = [];
              }
            }
          }
          if (k[e] && jCommon.isArray(k[e]) || jCommon.isObject(k[e])) {
            k = k[e];
          } else {
            k = Object.assign(k[e], []);
          }
        }
        k[last] = currentData[path];
      }
      if (callbackfun) {
        callbackfun(initData);
      }
    },
    ObjectToArray: function (objectInfo) {
      if (jCommon.isObject(objectInfo)) {
        var list = [];
        for (var key in objectInfo) {
          list.push(objectInfo[key]);
        }
        return list;
      } else {
        return objectInfo;
      }
    },
    formatNumber: function (value, type, precision) {
      if (jCommon.isNumber(value)) {
        value = Number(value);
        if (value % 1 === 0) {
          return value.toFixed(0);
        } else {
          var num = Math.log10(Math.abs(value) + 1e-7);
          if (num >= 5 || num < -4) {
            return value.toExponential(3);
          } else if (num >= 2) {
            return value.toFixed(2);
          } else if (num >= -1) {
            return value.toFixed(3);
          } else {
            return value.toFixed(5);
          }
        }
      } else {
        return value;
      }
    },
    s4: function () {
      return Math.floor((1 + Math.random()) * 0x10000)
        .toString(16)
        .substring(1)
    },
    keyId: function () {
      return jCommon.s4() + jCommon.s4() + '-' + jCommon.s4() + '-' + jCommon.s4() + '-' +
        jCommon.s4() + '-' + jCommon.s4() + jCommon.s4() + jCommon.s4() + '-' + (new Date()).getTime();
    },
    setDocumentTitle: function (item) {
      if (jCommon.empty(item)) {
        document.title = "OGiC2"
      } else {
        document.title = item
      }
    },
    translatePyxisSensor: function (value) {
      value = value.toLowerCase();
      if (jCommon.empty(PYXIS_SENSOR_TRANSLATE_EN) || jCommon.empty(PYXIS_SENSOR_TRANSLATE_EN[value])) {
        return value;
      } else {
        return PYXIS_SENSOR_TRANSLATE_EN[value];
      }
    },
    isDaylightSavingTime: function () {
      var date = new Date()
      var january = new Date(
        date.getFullYear(),
        0,
        1,
      ).getTimezoneOffset();
      var july = new Date(
        date.getFullYear(),
        6,
        1,
      ).getTimezoneOffset();
      return Math.max(january, july) !== date.getTimezoneOffset();
    },
    contorlBtnStatus: function (className, status) {
      var btnExportList = document.getElementsByClassName(className);
      for (var index = 0; index < btnExportList.length; index++) {
        var elementItem = btnExportList[index];
        elementItem.disabled = status;
      }
    }
  };
  window.jCommon = jCommon;
})()
