(function () {
  var CMDSOCKET = {
    commandSocket: null,
    liveData: null,
    protocol: window.location.protocol,
    // clientName: "192.168.174.129",
    clientId:jCommon.keyId(),
    sendMessageClient:"",
    clientName: window.location.hostname,   // "192.168.126.131" ,"192.168.174.128","10.0.10.222" window.location.hostname  
    initCommandSocket: function (callback) {
      CMDSOCKET.commandSocket = null;
      var port = 6688;
      if (CMDSOCKET.protocol.indexOf("https") > -1) { 
        port = 6699;
      }
      CMDSOCKET.commandSocket = initWebSocket(CMDSOCKET.protocol + "//" + CMDSOCKET.clientName, port, null, true, null, callback);
      //every 3min send message to C++
      setInterval(CMDSOCKET.handshake, 5000);
    },
    closeWebsocket:function(){
      cmdlist.commandSocket.closeRemoteSocket();
      cmdlist.commandSocket = null;
    },
    initLiveDataSocket: function (callback) {
      CMDSOCKET.liveData = null;
      var port = 6688;
      if (CMDSOCKET.protocol.indexOf("https") > -1) { 
        port = 6699;
      }
      CMDSOCKET.liveData = initWebSocket(CMDSOCKET.protocol+"//"+ CMDSOCKET.clientName, port, null, true, null, callback);
    },
    handshake: function () {
      if (!repeatAllPage.isUpdating && !CMDSOCKET.commandSocket.sendState && !repeatAllPage.clientUpdating && !repeatAllPage.acknowledgeUpdateing) {
        // console.log("set handshake cmd",repeatAllPage.parameterData.liveSampleCount); 
        CMDSOCKET.commandSocket.sendMessage({
          "cmd": "handshake",
          clientId:cmdlist.clientId,
          liveSampleCount:repeatAllPage.parameterData.liveSampleCount
        })
      }
    },
    login: function (pdata,callback) { 
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "auth",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "auth" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    loadParameters: function (callback) {
      var version = "";
      if (typeof repeatAllPage != "undefined" && !jCommon.empty(repeatAllPage.parameterData)) { 
        version = repeatAllPage.parameterData.version;
      }
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "loadParameters",
        "clientId":cmdlist.clientId,
        "payload": {
          "version": version,
        }
      }, function (message) {
        if (message["cmd"] === "loadParameters" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      })
    },
    getParamersExt: function (callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "getParamersExt",
      }, function (message) {
        if (message["cmd"] === "getParamersExt" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      })
    },
    setLiveData: function (callback) {
      CMDSOCKET.liveData.sendMessage({
        "cmd": "register",
        "payload": "livedata",
        "clientId":cmdlist.clientId
      }, function (message) {
        if (callback) {
          callback(message["payload"]);
        }
      })
    },
    updateParameter: function (pdata, callback) {
      jCommon.setLocalStorge("loginstart", (new Date()).getTime());
      CMDSOCKET.sendMessageClient = cmdlist.clientId;
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "updateParameter",
         payload: pdata
      }, function (message) {
        if (message["cmd"] === "updateParameter" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    loadDCSInfo: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "loadDCSInfo",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "loadDCSInfo" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    startRealtimeLiveData: function (callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "enableRealtimeLiveData",
        payload: {
          enable: true
        }
      }, function (message) {
        if (message["cmd"] === "enableRealtimeLiveData" && callback) {
          hanleLiveDataObject.trendLiveDataCount = 0;
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    stopRealtimeLiveData: function (callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "enableRealtimeLiveData",
        payload: {
          enable: false
        }
      }, function (message) {
        if (message["cmd"] === "enableRealtimeLiveData" && callback) {
          hanleLiveDataObject.trendLiveDataCount = 0;
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    getTrendData: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "getTrendData",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "getTrendData" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    getRealtimeData: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "getRealtimeData",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "getRealtimeData" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    createFeeds: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "createFeeds",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "createFeeds" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    getAlarmAndEventData: function (pdata, callback) {
      pdata.maxCountInPage = 17;
      pdata.type = jCommon.getHtmlValue("event") ? "Event" : "Alarm";
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "getAlarm",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "getAlarm" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    acknowledgeAlarmData: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "acknowledge",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "acknowledge" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    getRecipeList: function (callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "listRecipes",
        payload: null
      }, function (message) {
        if (message["cmd"] === "listRecipes" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    backUpRecipe: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "backupRecipe",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "backupRecipe" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    restoreRecipe: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "restoreRecipe",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "restoreRecipe" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    createRecipe: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "newRecipe",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "newRecipe" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    deleteRecipe: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "deleteRecipe",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "deleteRecipe" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    getPDCUnits: function (loopIndex, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "getPDCUnits",
        payload: {
          loopIndex: loopIndex
        }
      }, function (message) {
        if (message["cmd"] === "getPDCUnits" && callback && message["payload"]) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    getEmailAlarmData: function (pdata, callback) {
      pdata.maxCountInPage = 13;
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "getRemoteAlarm",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "getRemoteAlarm" && callback) {
          callback(message["payload"]);
          callback = null;
        }
      });
    },
    setInputMessage: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage(pdata, function (message) {
        if (callback) {
          callback(message["payload"]);
        }
      });
    },
    calibrateSensorInfo: function (pdata, callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "calibrate",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "calibrate" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    breakDiagnose: function (idxP,callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "diagnose",
        payload: {
          enable: false,
          idxProbe:Number(idxP)
        }
      }, function (message) {
        if (message["cmd"] === "diagnose" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    startDiagnose: function (callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "diagnose",
        payload: {
          enable: true,
          idxProbe:Number(jCommon.getUrlParams("idxP"))
        }
      }, function (message) {
        if (message["cmd"] === "diagnose" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    listPortName: function (callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "listPortName",
        payload: null
      }, function (message) {
        if (message["cmd"] === "listPortName" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    restoreProbe: function (idxProbe,callback) {
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "restoreProbe",
        payload: {
          idxProbe:idxProbe
        }
      }, function (message) {
        if (message["cmd"] === "restoreProbe" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    pingProbe: function (idxProbe,callback) { 
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "pingProbe",
        payload: {
          idxProbe:idxProbe
        }
      }, function (message) {
        if (message["cmd"] === "pingProbe" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    configProbe: function (pdata,callback) { 
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "configProbe",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "configProbe" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    operation3H: function (pdata,callback) { 
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "operation3H",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "operation3H" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    operation3B: function (pdata,callback) { 
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "operation3B",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "operation3B" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    setDatetime: function (pdata,callback) { 
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "setDatetime",
        payload: {
          datetime:pdata
        }
      }, function (message) {
        if (message["cmd"] === "setDatetime" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    updateFactory:function(pdata){
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "updateFactory",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "updateFactory" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    changeAddrProbe:function(pdata,callback){
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "changeAddrProbe",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "changeAddrProbe" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    setAlloyFactor:function(pdata,callback){
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "setAlloyFactor",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "setAlloyFactor" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    exportCSV:function(pdata,callback){
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "exportCSV",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "exportCSV" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    },
    getCalibLog:function(pdata,callback){
      CMDSOCKET.commandSocket.sendMessage({
        "cmd": "getCalibLog",
        payload: pdata
      }, function (message) {
        if (message["cmd"] === "getCalibLog" && callback && message["payload"]) {
          callback(message["payload"]);
        }
      });
    }
  }
  window.onbeforeunload = function(e) {
  };
  window.cmdlist = CMDSOCKET;
})()
