'use strict'
var dygraphInstance = null;

window.redirect = function (event) {
  repeatAllPage.clearEventClick(event);
  var currentHash = "";
  if (["aichannel", "aochannel", "dichannel", "dochannel", "afbchannel", "aintchannel", "dintchannel", "dfbchannel"].indexOf(event.target.id) > -1) {
    var page = jCommon.getHtmlValue(event.target.id + "page");
    currentHash += event.target.id + "&p=" + page;
    window.location.hash = currentHash;
  } else {
    window.location.hash = event.target.id;
  }
}
// header end

// menu.html start
window.initMenuPage = function (message) {
  var controlOverview = userlogin.initSystemAndRtDisplay(message, "");
  if (controlOverview) {
    jCommon.setHtmlAttribute("overview", "disabled", false);
  } else {
    jCommon.setHtmlAttribute("overview", "disabled", true);
  }
  jCommon.checkBtnLoginDisabled();
}
window.menuPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  userlogin.btnLoginClick(event.target)
}

// menu.html end


//menuconfig.html start
window.initMenuConfigPage = function (message) {
  jCommon.setHtmlValue("factorymode", jCommon.getUrlParams("factorymode"));
  jCommon.controlDOMShow("factorymode")
  var systemList = message["systems"];
  var controllerInfo = message["controller"];
  jCommon.setDomElementValue(controllerInfo, "/controller/");
  jCommon.setHtmlValue("revision", message["revision"]);
  jCommon.setHtmlValue("serialNum_SYS_label", controllerInfo["serialNum_SYS"]);
  jCommon.setHtmlValue("projectNum_SYS_label", controllerInfo["projectNum_SYS"]);
  systemList.forEach(function (item, index) {
    var systemId = Number(index + 1);
    var systemName = jCommon.empty(item["name"]) ? "Config" : item["name"] + " Config";
    var systemTitle = jCommon.empty(item["name"]) ? "System" + systemId : item["name"];
    jCommon.setHtmlValue("systemconfig-" + systemId, systemName);
    jCommon.setHtmlAttribute("systemconfig-" + systemId, "href", "#systemconfig&sys=" + systemId + "&name=" + systemTitle);
  })
  jCommon.setHtmlValue("current-recepe", message["other"]["recipeName"]);
}
//menuconfig.html end


//channeloverview.html start
window.initChannelView = function (message) {
  var channelList = ["aichannel", "aochannel", "aintchannel", "afbchannel", "dichannel", "dochannel", "dintchannel", "dfbchannel"];
  var channelInfo = {
    "aichannel": "ais",
    "aochannel": "aos",
    "aintchannel": "aitns",
    "afbchannel": "afbs",
    "dichannel": "dis",
    "dochannel": "dos",
    "dintchannel": "ditns",
    "dfbchannel": "dfbs"
  };
  var channelId = 0;
  channelList.forEach(function (item) {
    channelId = !jCommon.empty(jCommon.getLocalStorge(item)) ? jCommon.getLocalStorge(item) : 1;
    jCommon.setHtmlValue(item + "page", channelId);
    jCommon.setHtmlAttribute(item + "page", "data-max", message[channelInfo[item]].length);
  })
}
//channeloverview.html end


//common channel start
window.initAnalogSelectDomAndDigitalInput = function (currentChannelData) {
  var currentPage = jCommon.getCurrentPage();
  jCommon.dropDownMenu({
    element: document.getElementById("dcsIndexLabel"),
    choices: constVar.getNetWorkTypeList(),
    defaultvalue: currentChannelData["dcsIndex"],
    callback: repeatAllPage.updateSelectValueData
  });
  if (["aichannel", "aochannel", "aintchannel", "afbchannel"].indexOf(currentPage) > -1) {
    jCommon.dropDownMenu({
      element: document.getElementById("netRawTypeLabel"),
      choices: constVar.getAnalogNetRawTypeList(),
      defaultvalue: currentChannelData["netRawType"],
      callback: updateChannelNetRawType
    });
  } else {
    jCommon.dropDownMenu({
      element: document.getElementById("netRawTypeLabel"),
      choices: constVar.getDigitalNetRawTypeList(),
      defaultvalue: currentChannelData["netRawType"],
      callback: repeatAllPage.updateSelectValueData
    });
  }

  var dropDowList = channelPage.getDropDownDataConfig();
  for (var key in dropDowList) {
    var defaultValueKey = dropDowList[key]["defaultkey"].split("/");
    var defaultValue = currentChannelData;
    defaultValueKey.forEach(function (item) {
      if (typeof defaultValue[item] !== "undefined") {
        defaultValue = defaultValue[item];
      }
    })
    if (document.getElementById(key + 'Label')) {
      new jCommon.dropDownMenu({
        element: document.getElementById(key + 'Label'),
        choices: dropDowList[key]["data"],
        class: dropDowList[key]["class"],
        defaultvalue: defaultValue,
        callback: channelSelectCallback,
        equalCallBack: key == "signalType" ? true : false,
      });
    }
  }
  var digitalArr = ["loAlarmChn", "loWarningChn", "hiWarningChn", "hiAlarmChn", "alarmEnChn", "doChn"];
  digitalArr.forEach(function (item) {
    channelPage.initChannelInput(item, currentChannelData["alarm"][item + "Type"], currentChannelData["alarm"][item]);
  })
}

window.updateChannelNetRawType = function (value, id) {
  repeatAllPage.updateSelectValueData(value, id, function () {
    setAnalogNetworkRawTypeProperty();
    setChannelDCSReadAndWrite();
  });
}

window.setChannelDCSReadAndWrite = function (callbackfun) {
  var currentKeyIndex = channelPage.getChannelKeyIndex();
  var rawType = jCommon.getHtmlValue("netRawType");
  cmdlist.loadDCSInfo({
    "type": currentKeyIndex["pageKey"],
    "channelIndex": currentKeyIndex["currentIndex"],
    "netRawType": rawType
  }, function (message) {
    jCommon.setHtmlValue("dcsReadFrom", message["dcsReadFrom"]);
    jCommon.setHtmlValue("dcsWriteTo", message["dcsWriteTo"]);
    if (callbackfun) {
      callbackfun();
    }
  })
}
//common channel end

// aichannel.html start
window.initAiChannel = function (aiList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentChannelData = aiList[currentIndex];
  jCommon.setDomElementValue(currentChannelData, "/ais/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/ais/" + currentIndex + "/alarm/");
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  channelPage.initChannelInput("brushChn", currentChannelData["brushChnType"], currentChannelData["brushChn"], 'digital');
  setAnalogSignalRangeProperty();
  controlAISignalRangeProperty();
  setAnalogSimDataBaseUnit();
  setAnalogSimDataMinAndMax();
  setAnalogNetworkRawTypeProperty();
  setChannelDCSReadAndWrite();
  controlProbeBrush();
}

window.channelSelectCallback = function (value, id) {
  if (id === "signalTypeLabel") {
    jCommon.setDomElementItemValue({
      "signalType": value
    }, function () {
      controlAISignalRangeProperty();
      repeatAllPage.updateParameter("signalType", function () {
        if (value == 3) {
          showProbesDialog();
        } else {
          setAnalogSignalRangeProperty();
        }
      })
    });
  } else if (id === "timeUnitLabel") {
    jCommon.setDomElementItemValue({
      "timeUnit": value
    }, function () {
      repeatAllPage.updateParameter("timeUnit");
      setAnalogSimDataBaseUnit();
    });
  } else if (["metricUnitLabel", "imperialUnitLabel"].indexOf(id) > -1) {
    jCommon.setDomElementItemValue({
      "baseUnit": value
    }, function () {
      repeatAllPage.updateParameter("baseUnit");
      setAnalogSimDataBaseUnit();
    });
  } else if (id === "alarmEnLabel") {
    jCommon.setDomElementItemValue({
      "alarmEn": value
    }, function () {
      repeatAllPage.updateParameter("alarmEn");
    })
  }
}

window.showProbesDialog = function () {
  var probeList = [];
  var info = channelPage.getPyxisSensorInfoByPN("", "name");
  repeatAllPage.parameterData.probes["onlines"].forEach(function (item, index) {
    if (!jCommon.empty(item.PN)) {
      item.index = index;
      item.sensors = info[item.PN];
      probeList.push(item);
    }
  });
  dialogObject.show(probeList, "customName", probSelectFun);
}

window.probSelectFun = function (event) {
  if (event.target.classList.contains("select-item")) {
    var list = JSON.parse(event.target.getAttribute("data-sensors"));
    var sensorList = [];
    list.forEach(function (item, index) {
      sensorList.push({
        index: index,
        name: item
      });
    })
    jCommon.setHtmlValue("idxProbe", event.target.getAttribute("data-index"));
    controlProbeBrush();
    if (sensorList.length == 1) {
      jCommon.setHtmlValue("idxSensor", 0);
      repeatAllPage.updateParameter("pyxis-sensor");
      setProbSensorName();
      dialogObject.hide();
    } else {
      dialogObject.dropdownElementClickCallback(event);
      dialogObject.show(sensorList, "name", sensorSelectFun);
    }
  } else {
    dialogObject.dropdownElementClickCallback(event);
  }
}

window.controlProbeBrush = function () {
  var idxProbe = jCommon.getHtmlValue("idxProbe");
  var onLineInfo = channelPage.getPyxisOnlineInfo(idxProbe);
  jCommon.setHtmlValue("brushAddr", channelPage.getPyxisPNBaseInfo(onLineInfo["PN"], "brushAddr"));
  jCommon.controlDOMShow("brushAddr");
}

window.sensorSelectFun = function (event) {
  if (event.target.classList.contains("select-item")) {
    jCommon.setHtmlValue("idxSensor", event.target.getAttribute("data-index"));
    dialogObject.dropdownElementClickCallback(event);
    repeatAllPage.updateParameter("pyxis-sensor");
    setProbSensorName();
  } else {
    dialogObject.dropdownElementClickCallback(event);
  }
}

window.setProbSensorName = function () {
  var idxProbe = jCommon.getHtmlValue("idxProbe");
  var idxSensor = jCommon.getHtmlValue("idxSensor");
  if (idxProbe > -1 && idxSensor > -1) {
    var name = "Pyxis Sensor";
    var PNInfo = channelPage.getPyxisOnlineInfo(idxProbe);
    name = name + ">" + PNInfo.customName;
    var sensorList = channelPage.getPyxisSensorInfoByPN(PNInfo.PN, "name");
    sensorList.forEach(function (item, index) {
      if (idxSensor == index) {
        name = name + ">" + item;
      }
    })
    document.getElementById("signalTypeLabel").querySelector(".dropdown").innerHTML = name;
  }
}

window.controlAISignalRangeProperty = function () {
  var value = jCommon.getHtmlValue("signalType");
  if (Number(value) === 2) {
    jCommon.setHtmlAttribute("sqRoot", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("sqRoot", "disabled", false);
  }
}

window.checkAnalogValue = function () {
  var currentPage = jCommon.getCurrentPage();
  if (arguments[0] === "pageNum") {
    window.location.hash = currentPage + "&p=" + arguments[1];
  } else if (["engMin", "engMax", "loAlarmSP", "loWarningSP", "hiWarningSP", "hiAlarmSP"].indexOf(arguments[0]) > -1) {
    setAnalogSimDataMinAndMax();
    repeatAllPage.updateParameter(arguments[0]);
  } else if (arguments[0] === "curveNum") {
    jCommon.controlDOMShow(arguments[0]);
    setCurveYChnTypeAndYChn();
    repeatAllPage.updateParameter(arguments[0]);
  } else if (arguments[0] === "name") {
    repeatAllPage.updateParameter(arguments[0], function () {
      systemFeed.updateSystemMonitorName()
    });
  } else {
    jCommon.controlDOMShow(arguments[0]);
    repeatAllPage.updateParameter(arguments[0]);
  }
}

window.setCurveYChnTypeAndYChn = function () {
  var curveNumber = jCommon.getHtmlValue("curveNum");
  if (curveNumber == 0) {
    jCommon.setHtmlValue("yChnType", 0);
    jCommon.setHtmlValue("yChn", 0);
  } else {
    var curveIndex = curveNumber - 1;
    jCommon.setDataSaveProperty("yChnType", "/curves/" + curveIndex + "/yChnType");
    jCommon.setDataSaveProperty("yChn", "/curves/" + curveIndex + "/yChn");
    jCommon.setHtmlValue("yChnType", constVar.getRevertChannelThumbnail(channelPage.getChannelKeyIndex("pageKey")));
    curveConfig.setCurveConfigDomName(curveIndex);
    jCommon.setHtmlValue("yChn", jCommon.getUrlParams("p"));
  }
}

window.analogChannelClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var radioButton = ["sqRoot", "pdcEn", "curveOn", "filterEn", "input1-dataType", "input2-dataType", "input3-dataType", "input4-dataType", "input1-state", "input2-state", "input3-state", "input4-state", "rad2DegEn"];
  if (radioButton.indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      channelPage.controlDigitalState(event.target.id);
      repeatAllPage.updateParameter(event.target.id, function () {
        if (event.target.id == "curveOn" && jCommon.empty(jCommon.getHtmlValue("curveOn"))) {
          jCommon.setHtmlValue("yChnType", 0);
          jCommon.setHtmlValue("yChn", 0);
          jCommon.setHtmlValue("curveNum", 0);
          repeatAllPage.updateParameter("curveNum");
        }
      });
    })
  } else if (event.target.id === "metricFlag") {
    var metricFlag = jCommon.checkBoolenValue(jCommon.getHtmlValue(event.target.id)) ? false : true;
    jCommon.setDomElementItemValue({
      "metricFlag": metricFlag
    }, function () {
      repeatAllPage.updateParameter(event.target.id, function () {
        setAFBOperationTankBaseUnit();
        setAnalogSimDataBaseUnit();
      });
    });
  } else if (event.target.id === "ResetData") {
    ToolstipDialog.showConfirmToolsTip("", "Reset Analog Configuration?");
  } else if (["netRcvEn", "simEn", "displayEn", "loAlarmEn", "loWarningEn", "hiWarningEn", "hiAlarmEn"].indexOf(event.target.id) > -1) {
    jCommon.toogleSwitch(event.target.id);
    if (event.target.id == "simEn" && jCommon.getHtmlValue("simEn")) {
      jCommon.setHtmlValue("simData_OP", jCommon.getHtmlValue("simData"));
    }
    jCommon.controlDOMShow(event.target.id);
    repeatAllPage.updateParameter(event.target.id);
  } else if (event.target.id.startsWith("tankType")) {
    if (event.target.id === "tankType") {
      jCommon.removeHtmlClass("#tankTypeDialog", "hide");
      jCommon.controlDOMShow("tankType");
    } else if (event.target.id.startsWith("tankTypeItem")) {
      jCommon.setHtmlValue("tankType", event.target.id.replace("tankTypeItem", ""));
      repeatAllPage.updateParameter("tankType");
      jCommon.controlDOMShow("tankType");
    } else if (event.target.id === "tankTypeMask") {
      jCommon.addHtmlClass("#tankTypeDialog", "hide");
    }
  } else if (event.target.id == "pyxissensorcal") {
    var idxProbe = jCommon.getHtmlValue("idxProbe");
    var idxSensor = jCommon.getHtmlValue("idxSensor");
    var PNInfo = channelPage.getPyxisOnlineInfo(idxProbe);
    jCommon.setHtmlAttribute("pyxissensorcal", "data-href", "pyxissensorcal&pn=" + PNInfo["PN"] + "&sindex=" + idxSensor + "&idxP=" + idxProbe);
    userlogin.btnLoginClick(event.target)
  }
}

window.setAnalogSimDataBaseUnit = function () {
  var metricFlag = jCommon.getHtmlValue("metricFlag");
  var baseUnit = 0;
  var baseUnitLabel = "";
  var timeUnit = jCommon.getHtmlAttriute("timeUnitLabel", "select-value");
  var timeUnitLabel = jCommon.getHtmlAttriute("timeUnitLabel", "select-name");
  if (metricFlag) {
    baseUnit = jCommon.getHtmlAttriute("metricUnitLabel", "select-value");
    baseUnitLabel = jCommon.getHtmlAttriute("metricUnitLabel", "select-name");
  } else {
    baseUnit = jCommon.getHtmlAttriute("imperialUnitLabel", "select-value");
    baseUnitLabel = jCommon.getHtmlAttriute("imperialUnitLabel", "select-name");
  }
  if (Number(baseUnit) != 0 && Number(timeUnit) == 0) {
    jCommon.setClassListValue("baseUnitLabel", baseUnitLabel);
    jCommon.setClassListValue("timeUnitLabel", "");
  } else {
    jCommon.setClassListValue("baseUnitLabel", baseUnitLabel);
    jCommon.setClassListValue("timeUnitLabel", "/" + timeUnitLabel);
  }
}

window.setAnalogSimDataMinAndMax = function () {
  var engMin = jCommon.getHtmlValue("engMin");
  var engMax = jCommon.getHtmlValue("engMax");
  var loAlarmSP = jCommon.getHtmlValue("loAlarmSP");
  var loWarningSP = jCommon.getHtmlValue("loWarningSP");
  var hiWarningSP = jCommon.getHtmlValue("hiWarningSP");
  var hiAlarmSP = jCommon.getHtmlValue("hiAlarmSP");
  jCommon.setHtmlAttribute("simData_OP", "data-min", engMin);
  jCommon.setHtmlAttribute("simData_OP", "data-max", engMax);
  jCommon.setHtmlAttribute("loAlarmSP", "data-min", engMin);
  jCommon.setHtmlAttribute("loAlarmSP", "data-max", loWarningSP);
  jCommon.setHtmlAttribute("loWarningSP", "data-min", loAlarmSP);
  jCommon.setHtmlAttribute("loWarningSP", "data-max", hiWarningSP);
  jCommon.setHtmlAttribute("hiWarningSP", "data-min", loWarningSP);
  jCommon.setHtmlAttribute("hiWarningSP", "data-max", hiAlarmSP);
  jCommon.setHtmlAttribute("hiAlarmSP", "data-min", hiWarningSP);
  jCommon.setHtmlAttribute("hiAlarmSP", "data-max", engMax);
}

window.setAnalogNetworkRawTypeProperty = function () {
  var netRawType = jCommon.getHtmlValue("netRawType");
  var rawMinAndMax = constVar.getNetRawMinAndMax();
  var channelInfo = channelPage.getChannelInfo(constVar.getRevertChannelThumbnail(channelPage.getChannelKeyIndex("pageKey")), jCommon.getHtmlValue("pageNum"));
  if (netRawType === 3) {
    jCommon.setHtmlAttribute("netRawMin", "disabled", false);
    jCommon.setHtmlAttribute("netRawMax", "disabled", false);
    jCommon.setHtmlValue("netRawMin", channelInfo["netRawMin"]);
    jCommon.setHtmlValue("netRawMax", channelInfo["netRawMax"]);
  } else {
    jCommon.setHtmlAttribute("netRawMin", "disabled", true);
    jCommon.setHtmlAttribute("netRawMax", "disabled", true);
    if (!jCommon.empty(rawMinAndMax[netRawType])) {
      jCommon.setHtmlValue("netRawMin", rawMinAndMax[netRawType]["min"]);
      jCommon.setHtmlValue("netRawMax", rawMinAndMax[netRawType]["max"]);
    }
  }
}

window.setAnalogSignalRangeProperty = function () {
  var signalType = jCommon.getHtmlValue("signalType");
  if (signalType === 0) {
    jCommon.setHtmlValue("signalMin", 20);
    jCommon.setHtmlValue("signalMax", 100);
  } else if (signalType === 1) {
    jCommon.setHtmlValue("signalMin", 0);
    jCommon.setHtmlValue("signalMax", 100);
  } else if (signalType === 3) {
    setProbSensorName();
  }
}
// aichannel.html end


// aochannel.html start
window.initAoChannel = function (aoList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentChannelData = aoList[currentIndex];
  jCommon.setDomElementValue(currentChannelData, "/aos/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/aos/" + currentIndex + "/alarm/");
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  //handel Signal Range Label
  setAnalogSignalRangeProperty();
  setAnalogNetworkRawTypeProperty();
  setChannelDCSReadAndWrite();
  setCurveYChnTypeAndYChn();
}
// aochannel.html end


//aintchannel.html start
window.initAIntChannel = function (message) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var pdList = systemFeed.getPredefinedLoopList(message);
  pdList.push({
    "value": 20,
    "name": "System and Loop Alarms"
  });
  var aintList = message["aitns"];
  var currentChannelData = aintList[currentIndex];
  jCommon.setDomElementValue(currentChannelData, "/aitns/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/aitns/" + currentIndex + "/alarm/");
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  jCommon.dropDownMenu({
    element: document.getElementById("pdLoopLabel"),
    choices: pdList,
    defaultvalue: currentChannelData["pdLoop"],
    callback: systemFeed.predefinedLoopSelectCallback
  });
  setAnalogSimDataBaseUnit();
  setAnalogSimDataMinAndMax();
  setAnalogNetworkRawTypeProperty();
  setChannelDCSReadAndWrite(systemFeed.getPreDefinedPDCUnits);
  jCommon.setClassListValue("simData", jCommon.getHtmlValue("simData_OP"));
  systemFeed.setPredefinedMode("pd");
  setCurveYChnTypeAndYChn();
}
//aintchannel.html end


//afbchannel.html start
window.initAFbChannel = function (afbsList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentChannelData = afbsList[currentIndex];
  var inputList = currentChannelData["inputs"];
  channelPage.setAFBOperationConfig(currentChannelData["operation"]);
  jCommon.setDomElementValue(currentChannelData, "/afbs/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/afbs/" + currentIndex + "/alarm/");
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  setAnalogSimDataBaseUnit();
  setAnalogSimDataMinAndMax();
  jCommon.dropDownMenu({
    element: document.getElementById('operationLabel'),
    choices: constVar.getFBAnalogOper(),
    defaultvalue: currentChannelData["operation"],
    confirm: {
      message: "Changing Operation will Clear All Inputs"
    },
    callback: afbchannelSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('triggerLabel'),
    choices: constVar.getFBAnalogTrigger(),
    defaultvalue: currentChannelData["trigger"],
    callback: afbchannelSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('sampleRateLabel'),
    choices: constVar.getFBAnalogSampleRate(),
    defaultvalue: "",
    callback: afbchannelSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('trigFuncLabel'),
    choices: constVar.getFBAnalogTrigFunc(),
    defaultvalue: currentChannelData["trigFunc"],
    callback: afbchannelSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('priFDLabel'),
    choices: constVar.getFeedDevicesType(2),
    defaultvalue: "",
    callback: afbchannelSelectCallback
  });
  channelPage.initChannelInput("trigChn", currentChannelData["trigChnType"], currentChannelData["trigChn"]);
  channelPage.initChannelInput("AO2Chn", currentChannelData["AO2ChnType"], currentChannelData["AO2Chn"], "analog");
  for (var index = 0; index < inputList.length; index++) {
    var inputItem = inputList[index];
    for (var key in inputItem) {
      jCommon.setHtmlValue("input" + Number(index + 1) + "-" + key, inputItem[key]);
      jCommon.setDataSaveProperty("input" + Number(index + 1) + "-" + key, "/afbs/" + currentIndex + "/inputs/" + index + "/" + key);
    }
    channelPage.controlDigitalState("input" + Number(index + 1) + "-state");
    jCommon.controlDOMShow("input" + Number(index + 1) + "-chn");
    jCommon.controlDOMShow("input" + Number(index + 1) + "-dataType");
  }
  channelPage.initChannelInput("input1-chn", inputList[0]["chnType"], inputList[0]["chn"], "analog", setDWMlyEngineeringUnit);
  channelPage.initChannelInput("input2-chn", inputList[1]["chnType"], inputList[1]["chn"], "analog", setDWMlyEngineeringUnit);
  channelPage.initChannelInput("input3-chn", inputList[2]["chnType"], inputList[2]["chn"], "analog-digital");
  channelPage.initChannelInput("input4-chn", inputList[3]["chnType"], inputList[3]["chn"], "analog-digital");
  channelPage.initChannelInput("DOChn", currentChannelData["DOChnType"], currentChannelData["DOChn"]);
  channelPage.initChannelInput("pFDAOutChn", 0, 0, "analog");
  channelPage.initChannelInput("pFDDOutChn", 0, 0);
  channelPage.initChannelInput("pFDDiChn", 0, 0);
  channelPage.initChannelInput("pFDActiveChn", 0, 0);
  channelPage.initChannelInput("pFDInputChn", 0, 0);
  channelPage.initChannelInput("sFDAOutChn", 0, 0, "analog");
  channelPage.initChannelInput("sFDDOutChn", 0, 0);
  channelPage.initChannelInput("sFDDiChn", 0, 0);
  channelPage.initChannelInput("sFDActiveChn", 0, 0);
  channelPage.initChannelInput("sFDInputChn", 0, 0);
  jCommon.pickerTime({
    element: document.getElementById('cycle-start-timeLabel'),
    defaultvalue: 0,
    timeZone: 24,
    callback: repeatAllPage.updateSelectValueData
  });
  setDWMlyEngineeringUnit();
  setChannelDCSReadAndWrite();
}

window.afbchannelSelectCallback = function (value, id) {
  var key = id.replace("Label", "");
  jCommon.setHtmlValue(key, value);
  jCommon.controlDOMShow(key);
  if (id === "operationLabel") {
    repeatAllPage.updateParameter(key, function () {
      setAFBOperationTankBaseUnit(true);
    });
  } else {
    repeatAllPage.updateParameter(key);
  }
}

window.setAFBOperationTankBaseUnit = function (type) {
  var currentPage = jCommon.getCurrentPage();
  var operation = jCommon.getHtmlValue("operation");
  var metricFlag = jCommon.getHtmlValue("metricFlag");
  if (currentPage === "afbchannel") {
    if (operation === 28) {
      if (metricFlag) {
        //10
        jCommon.setHtmlValue("baseUnit", 10);
        jCommon.setDropDownMenuValueAndLabel("metricUnit", 10);
        jCommon.setDropDownMenuDisabled("metricUnitLabel", true);
      } else {
        //11
        jCommon.setHtmlValue("baseUnit", 11);
        jCommon.setDropDownMenuValueAndLabel("imperialUnit", 11);
        jCommon.setDropDownMenuDisabled("imperialUnitLabel", true);
      }
      repeatAllPage.updateParameter("baseUnit", repeatAllPage.setParameterData);
    } else {
      if (type) {
        if (operation == 25) {
          jCommon.setHtmlValue("input3-dataType", 3);
          repeatAllPage.updateParameter("input3-dataType", function () {
            jCommon.setHtmlValue("input4-dataType", 3);
            repeatAllPage.updateParameter("input4-dataType", repeatAllPage.setParameterData);
          });
        } else {
          repeatAllPage.setParameterData();
        }
      }
    }
  }
}

window.setDWMlyEngineeringUnit = function () {
  var operation = jCommon.getHtmlValue("operation");
  var input1ChnType = jCommon.getHtmlValue("input1-chnType");
  var input1Chn = jCommon.getHtmlValue("input1-chn");
  if ([17, 18, 19].indexOf(operation) > -1) {
    var sourceChannelInfo = channelPage.getChannelInfo(input1ChnType, input1Chn);
    if (!jCommon.empty(sourceChannelInfo)) {
      jCommon.setDomElementItemValue({
        "metricFlag": sourceChannelInfo["metricFlag"]
      }, function () {
        repeatAllPage.updateParameter("metricFlag");
      });
      jCommon.setHtmlValue("baseUnit", sourceChannelInfo["baseUnit"], function () {
        repeatAllPage.updateParameter("baseUnit");
      });
      if (sourceChannelInfo["metricFlag"]) {
        jCommon.setDropDownMenuValueAndLabel("metricUnit", sourceChannelInfo["baseUnit"]);
      } else {
        jCommon.setDropDownMenuValueAndLabel("imperialUnit", sourceChannelInfo["baseUnit"]);
      }
      setAnalogSimDataBaseUnit();
    }
  }
}
//afbchannel.html end


//dichannel.html start
window.initDiChannel = function (diList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentChannelData = diList[currentIndex];
  currentChannelData["alarm"]["alarmType"] = currentChannelData["alarm"]["alarmType"] == 0 ? 1 : currentChannelData["alarm"]["alarmType"];
  jCommon.setDomElementValue(currentChannelData, "/dis/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/dis/" + currentIndex + "/alarm/");
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  channelPage.controlDigitalState("simData_OP");
  setChannelDCSReadAndWrite();
}

window.digitalChannelClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var radioButton = ["normallyClosed", "alarmState", "alarmType", "simData_OP", "pulseEn", "input1-dataType", "input2-dataType", "input3-dataType", "input4-dataType", "input1-state", "input2-state", "input3-state", "input4-state", "preset-dataType", "enable-dataType", "reset-dataType", "enable-state", "reset-state", "enableFlag"];
  if (radioButton.indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      channelPage.controlDigitalState(event.target.id);
      repeatAllPage.updateParameter(event.target.id);
    });
  } else if (event.target.id === "ResetData") {
    ToolstipDialog.showConfirmToolsTip("", "Reset Analog Configuration?");
  } else if (event.target.id.endsWith("ChConfig")) {
    var configKey = event.target.id.replace("Config", "");
    window.location.hash = channelPage.getChannelPageUrl(jCommon.getHtmlValue(configKey + "Type"), jCommon.getHtmlValue(configKey));
  } else if (["netRcvEn", "simEn", "displayEn"].indexOf(event.target.id) > -1) {
    jCommon.toogleSwitch(event.target.id);
    jCommon.controlDOMShow(event.target.id);
    if (event.target.id == "simEn" && jCommon.getHtmlValue("simEn")) {
      var state = jCommon.checkBoolenValue(jCommon.getHtmlValue("state")) ? 1 : 0;
      jCommon.setHtmlValue("simData_OP", state);
      channelPage.controlDigitalState("simData_OP");
      repeatAllPage.updateParameter("simData_OP", function () {
        repeatAllPage.updateParameter(event.target.id);
      });
    } else {
      repeatAllPage.updateParameter(event.target.id);
    }
  }
}

window.checkDigitalValue = function () {
  var currentPage = jCommon.getCurrentPage();
  if (arguments[0] === "pageNum") {
    window.location.hash = currentPage + "&p=" + arguments[1];
  } else if (arguments[0] === "name") {
    repeatAllPage.updateParameter(arguments[0], function () {
      systemFeed.updateSystemMonitorName()
    });
  } else {
    jCommon.controlDOMShow(arguments[0]);
    repeatAllPage.updateParameter(arguments[0]);
  }
}
//dichannel.html end


//dochannel.html start
window.initDoChannel = function (doList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentChannelData = doList[currentIndex];
  currentChannelData["alarm"]["alarmType"] = currentChannelData["alarm"]["alarmType"] == 0 ? 1 : currentChannelData["alarm"]["alarmType"];
  jCommon.setDomElementValue(currentChannelData, "/dos/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/dos/" + currentIndex + "/alarm/");
  // freq_simData_OP
  jCommon.setHtmlValue("freq_simData_OP", currentChannelData["simData_OP"]);
  jCommon.setDataSaveProperty("freq_simData_OP", "/dos/" + currentIndex + "/simData_OP");
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  channelPage.controlDigitalState("simData_OP");
  setChannelDCSReadAndWrite();
}
//dochannel.html end


//dintchannel.html start
window.initDIntChannel = function (dintList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentChannelData = dintList[currentIndex];
  currentChannelData["alarm"]["alarmType"] = currentChannelData["alarm"]["alarmType"] == 0 ? 1 : currentChannelData["alarm"]["alarmType"];
  jCommon.setDomElementValue(currentChannelData, "/ditns/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/ditns/" + currentIndex + "/alarm/");
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  channelPage.controlDigitalState("simData_OP");
  setChannelDCSReadAndWrite();
}
//dintchannel.html end


//dfbchannel.html start
window.initDfbChannel = function (dfbList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentChannelData = dfbList[currentIndex];
  currentChannelData["alarm"]["alarmType"] = currentChannelData["alarm"]["alarmType"] == 0 ? 1 : currentChannelData["alarm"]["alarmType"];
  jCommon.setDomElementValue(currentChannelData, "/dfbs/" + currentIndex + "/");
  jCommon.setDomElementValue(currentChannelData["alarm"], "/dfbs/" + currentIndex + "/alarm/");
  channelPage.setDFBOperationConfig();
  initAnalogSelectDomAndDigitalInput(currentChannelData);
  var inputList = currentChannelData["inputs"];
  setDfbInputsValueAndLabelRange();
  jCommon.dropDownMenu({
    element: document.getElementById('operationLabel'),
    choices: constVar.getFBDigitalOper(),
    defaultvalue: currentChannelData["operation"],
    confirm: {
      message: "Changing Operation will Clear All Inputs"
    },
    callback: dfbchannelSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('triggerLabel'),
    choices: constVar.getFBDigitalTrigger(),
    defaultvalue: currentChannelData["trigger"],
    callback: dfbchannelSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('comprOpsLabel'),
    choices: constVar.getFBDigitalComprOps(),
    defaultvalue: currentChannelData["comprOps"],
    confirm: {
      message: "Changing Boolean Operation will Clear All Inputs"
    },
    callback: dfbchannelSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('boolnOpsLabel'),
    choices: constVar.getFBDigitalBoolnOps(),
    defaultvalue: currentChannelData["boolnOps"],
    confirm: {
      message: "Changing Boolean Operation will Clear All Inputs"
    },
    callback: dfbchannelSelectCallback
  });
  for (var index = 0; index < inputList.length; index++) {
    var inputItem = inputList[index];
    for (var key in inputItem) {
      jCommon.setHtmlValue("input" + Number(index + 1) + "-" + key, inputItem[key]);
      jCommon.setDataSaveProperty("input" + Number(index + 1) + "-" + key, "/dfbs/" + currentIndex + "/inputs/" + index + "/" + key);
    }
    if ([0, 1].indexOf(index) > -1) {
      channelPage.initChannelInput("input" + Number(index + 1) + "-chn", inputItem["chnType"], inputItem["chn"], "analog-digital");
    } else {
      channelPage.initChannelInput("input" + Number(index + 1) + "-chn", inputItem["chnType"], inputItem["chn"]);
    }
    jCommon.controlDOMShow("input" + Number(index + 1) + "-chn");
    jCommon.controlDOMShow("input" + Number(index + 1) + "-dataType");
    channelPage.controlDigitalState("input" + Number(index + 1) + "-state");
  }
  channelPage.initChannelInput("input3-chn", inputItem["chnType"], inputItem["chn"]);
  channelPage.initChannelInput("input4-chn", inputItem["chnType"], inputItem["chn"]);
  channelPage.initChannelInput("DO2Chn", currentChannelData["DO2ChnType"], currentChannelData["DO2Chn"]);
  channelPage.controlDigitalState("simData_OP");
  setChannelDCSReadAndWrite();
  var timeInfo = currentChannelData["timerPack"];
  jCommon.setDomElementValue(timeInfo, "/dfbs/" + currentIndex + "/timerPack/");
  for (var index in timeInfo) {
    if (["enable", "preset", "reset"].indexOf(index) > -1) {
      var inputItem = timeInfo[index];
      for (var key in inputItem) {
        jCommon.setHtmlValue(index + "-" + key, inputItem[key]);
        jCommon.setDataSaveProperty(index + "-" + key, "/dfbs/" + currentIndex + "/timerPack/" + index + "/" + key);
      }
      if (index === "preset") {
        channelPage.initChannelInput(index + "-chn", inputItem["chnType"], inputItem["chn"], "analog");
      } else {
        channelPage.initChannelInput(index + "-chn", inputItem["chnType"], inputItem["chn"]);
      }
      jCommon.controlDOMShow(index + "-chn");
      jCommon.controlDOMShow(index + "-dataType");
      channelPage.controlDigitalState(index + "-state");
    }
  }
  jCommon.setDataSaveProperty("clockHHMMSS", "/dfbs/" + currentIndex + "/timerPack/clockHHMMSS");
  jCommon.pickerTime({
    element: document.getElementById('clockHHMMSSLabel'),
    defaultvalue: timeInfo["clockHHMMSS"],
    secondsShow: true,
    callback: repeatAllPage.updateSelectValueData
  })
}

window.dfbchannelSelectCallback = function (value, id) {
  var key = id.replace("Label", "");
  jCommon.setHtmlValue(key, value);
  jCommon.controlDOMShow(key);
  if (["operationLabel", "boolnOpsLabel", "comprOpsLabel"].indexOf(id) > -1) {
    repeatAllPage.updateParameter(key, repeatAllPage.setParameterData);
  } else {
    repeatAllPage.updateParameter(key);
  }
}

window.setDfbInputsValueAndLabelRange = function () {
  var operation = jCommon.getHtmlValue("operation");
  for (var index = 0; index < 4; index++) {
    if (operation === 1) {
      jCommon.setHtmlAttribute("input" + Number(index + 1) + "-dataType", "data-label-range", "Channel,Constant");
      jCommon.setHtmlAttribute("input" + Number(index + 1) + "-dataType", "data-value-range", "1,2");
    } else if (operation === 2) {
      jCommon.setHtmlAttribute("input" + Number(index + 1) + "-dataType", "data-label-range", "Disabled,Channel,State");
      jCommon.setHtmlAttribute("input" + Number(index + 1) + "-dataType", "data-value-range", "0,1,3");
    }
  }
}
//dfbchannel.html end


//systemconfig.html start
window.initSystemConfigPage = function (systemList) {
  var currentPage = jCommon.getUrlParams("sys");
  var currentIndex = currentPage - 1;
  var systemInfo = systemList[currentIndex];
  jCommon.setHtmlValue("systemName", "System" + currentPage + " Name");
  jCommon.setDomElementValue(systemInfo, "/systems/" + currentIndex + "/");
  jCommon.setHtmlAttribute("cyclesConfig", "href", "#systemcycle&system=" + currentPage + "&name=" + jCommon.getUrlParams("name"));
  jCommon.setHtmlAttribute("blowdownConfig", "href", "#systemblowdown&system=" + currentPage + "&name=" + jCommon.getUrlParams("name"));
  // setFeedsNumber
  jCommon.dropDownMenu({
    element: document.getElementById("runGraphicLabel"),
    choices: constVar.getSystemType(),
    defaultvalue: systemInfo["runGraphic"],
    confirm: {
      message: "Changing to General Runtime Graphics will reset Cycles and Blowdown Configuration",
      value: "0"
    },
    callback: runGraphicSelectCallback
  });
  var digitalArr = ["EStopChn", "sysInterChn"];
  digitalArr.forEach(function (item) {
    channelPage.initChannelInput(item, systemInfo[item + "Type"], systemInfo[item]);
  })
}

window.checkSystemConfigInputValue = function () {
  var newValue = arguments[1];
  var oldValue = arguments[2];
  if (oldValue === newValue) {
    return false;
  }
  if (arguments[0] === "feedNum") {
    if (newValue === 0) {
      ToolstipDialog.showConfirmToolsTip("Warning!", "Reducing number of chemical feeds may delete active feed(s) configuration from this system", function () {
        repeatAllPage.updateParameter("feedNum");
        jCommon.controlDOMShow("feedNum");
      }, function () {
        jCommon.setHtmlValue("feedNum", oldValue);
        jCommon.controlDOMShow("feedNum");
      });
    } else {
      repeatAllPage.updateParameter(arguments[0]);
      jCommon.controlDOMShow("feedNum");
    }
  } else {
    repeatAllPage.updateParameter(arguments[0]);
  }
}

window.systemClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.tagName === "INPUT") {
    return false;
  }
  if (event.target.id === "feedNumConfig") {
    window.location.hash = "chemicalfeed&system=" + jCommon.getUrlParams("sys") + "&name=" + jCommon.getUrlParams("name");
  } else if (["cycleEn", "blowdownEn", "interLockOverride"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}

window.runGraphicSelectCallback = function (value, id) {
  var key = id.replace("Label", "");
  jCommon.setHtmlValue(key, value);
  jCommon.controlDOMShow(key);
  repeatAllPage.updateParameter("runGraphic");
}
//systemconfig.html end

//chemicalfeed.html start
window.initSystemChemicalFeedData = function (message) {
  var systemData = message["systems"];
  var currentIndex = jCommon.getUrlParams("system") - 1;
  var feedData = systemData[currentIndex]["feeds"];
  var saveString = "";
  var bppcControlTypeRow = [];
  for (var index = 0; index < systemData[currentIndex]["feedNum"]; index++) {
    var feedItem = feedData[index];
    for (var key in feedItem) {
      jCommon.setHtmlValue("row-" + index + "-" + key, feedItem[key]);
      saveString = "/systems/" + currentIndex + "/feeds/" + index + "/" + key;
      jCommon.setDataSaveProperty("row-" + index + "-" + key, saveString);
    }
    jCommon.setHtmlValue("row-" + index + "-loopId", "#" + Number(feedItem["loopIndex"] + 1));
    systemFeed.setLoopConfigUrl(feedItem["ctrlType"], index, feedItem["loopIndex"], message["loops"]);
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-ctrlTypeLabel'),
      choices: constVar.getControlType(),
      defaultvalue: feedItem["ctrlType"],
      confirm: {
        message: "Changing Control Type will reset configuration to default for this loop."
      },
      callback: chemicalFeedControlTypeSelectCallback
    });
    jCommon.setDropDownMenuDisabled("row-" + index + '-ctrlTypeLabel', !feedItem["ctrlTypeEn"]);
    jCommon.controlDOMShow("row-" + index + '-ctrlType');
    if (feedItem["ctrlType"] === 7) {
      bppcControlTypeRow.push(index);
    } else {
      jCommon.setHtmlValue("row-" + index + "-downbppc", false);
      jCommon.controlDOMShow("row-" + index + '-downbppc');
    }
  }
  bppcControlTypeRow.forEach(function (item, index) {
    if (index % 2 === 0) {
      jCommon.setHtmlValue("row-" + item + "-downbppc", false);
      jCommon.setDropDownMenuDisabled("row-" + item + "-ctrlTypeLabel", false);
    } else {
      jCommon.setHtmlValue("row-" + item + "-downbppc", true);
      jCommon.setDropDownMenuDisabled("row-" + item + "-ctrlTypeLabel", true);
    }
    jCommon.controlDOMShow("row-" + item + '-downbppc');
  })
  jCommon.setDomElementItemValue({ "feedNum": systemData[currentIndex]["feedNum"] });
}

window.chemicalfeedPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var currentEvent = event.target.id.split("-");
  var currentIndex = Number(currentEvent[1]);
  var ctrlType = jCommon.getHtmlValue("row-" + currentIndex + "-ctrlType");
  if (event.target.id.endsWith("-enableReq")) {
    if (ctrlType === 7) {
      jCommon.setRadioButtonValue(event.target.id);
      var nextCurrentIndex = currentIndex + 1;
      jCommon.setHtmlValue("row-" + nextCurrentIndex + "-enableReq", jCommon.getHtmlValue(event.target.id));
      repeatAllPage.updateParameter("row-" + currentIndex + "-bppc-enableReq");
    } else {
      jCommon.setRadioButtonValue(event.target.id, function () {
        repeatAllPage.updateParameter(event.target.id);
      });
    }
  } else if (event.target.id.endsWith("-display")) {
    if (ctrlType === 7) {
      jCommon.toogleSwitch(event.target.id);
      var nextCurrentIndex = currentIndex + 1;
      jCommon.setHtmlValue("row-" + nextCurrentIndex + "-display", jCommon.getHtmlValue(event.target.id));
      repeatAllPage.updateParameter("row-" + currentIndex + "-bppc-display");
    } else {
      jCommon.toogleSwitch(event.target.id);
      repeatAllPage.updateParameter(event.target.id);
    }
  }
}

window.chemicalFeedControlTypeSelectCallback = function (value, id, oldValue) {
  value = Number(value);
  oldValue = Number(oldValue);
  var key = id.replace("Label", "");
  var feedNum = Number(jCommon.getHtmlValue("feedNum"));
  var idArr = id.split("-");
  var rowKey = Number(idArr[1]);
  var nextRowKey = rowKey + 1;
  var nextControlType = rowKey < feedNum - 1 ? Number(jCommon.getHtmlValue("row-" + nextRowKey + "-ctrlType")) : -1;
  jCommon.setHtmlValue(key, value);
  if (value === 7) { //BPPC
    if (nextControlType !== 0) {
      jCommon.setHtmlValue(key, oldValue);
      jCommon.setDropDownMenuValueAndLabel("row-" + rowKey + "-ctrlType", oldValue);
      ToolstipDialog.showAlertToolsTip("Loop Assignment Error", "Next loop/feed in order is unavalible for the 2nd BPPC feed");
    } else {
      jCommon.setHtmlValue("row-" + nextRowKey + "-ctrlType", 7);
      jCommon.setHtmlValue("row-" + nextRowKey + "-ctrlTypeEn", jCommon.getHtmlValue("row-" + rowKey + "-ctrlTypeEn"));
      repeatAllPage.updateParameter("row-" + rowKey + "-bppc-ctrlType", repeatAllPage
        .initFunction);
    }
  } else {
    if (oldValue !== 7) {
      repeatAllPage.updateParameter(key, repeatAllPage
        .initFunction)
    } else {
      jCommon.setHtmlValue("row-" + nextRowKey + "-ctrlType", 0);
      jCommon.setHtmlValue("row-" + nextRowKey + "-ctrlTypeEn", true);
      repeatAllPage.updateParameter("row-" + rowKey + "-bppc-ctrlType", repeatAllPage
        .initFunction)
    }
  }
}
//chemicalfeed.html end

// ratio.html start
window.initRatioData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  systemFeed.initConstantChannel(loopInfo);
  channelPage.initChannelInput("pvChn", loopInfo["pvChnType"], loopInfo["pvChn"], "analog");
  jCommon.dropDownMenu({
    element: document.getElementById('processTypeLabel'),
    choices: constVar.getProcessType(),
    defaultvalue: loopInfo["processType"],
    confirm: {
      message: "Changing Process Type will reset the related configurations"
    },
    callback: ratioModeSelectCallback
  });
  setProcessTypeRelatedConfiguration();
  var systemIndex = Number(jCommon.getUrlParams("system")) - 1;
  var systemInfo = message["systems"][systemIndex];
  jCommon.setDomElementItemValue({
    "cycleEn": systemInfo["cycleEn"]
  });
  jCommon.setDataSaveProperty("cycleEn", "/systems/" + systemIndex + "/cycleEn");
  jCommon.setHtmlAttribute("cycleEn-Config", "href", "#systemcycle&system=" + jCommon.getUrlParams("system") + "&name=" + systemFeed.getSystemName(jCommon.getUrlParams("system"), systemInfo["name"]));
}

window.ratioModeSelectCallback = function (value, id) {
  if (id === "processTypeLabel") {
    jCommon.setDomElementItemValue({
      "processType": value
    });
    jCommon.setHtmlValue("placeholder-chn", 0);
    jCommon.setHtmlValue("placeholder-dataType", 2);
    jCommon.controlDOMShow("placeholder-dataType");
    jCommon.setHtmlValue("placeholder-chnType", 0);
    jCommon.setHtmlValue("placeholder-cnst_OP", 0);
    repeatAllPage.updateParameter("processTypeLabel");
    setProcessTypeRelatedConfiguration();
  }
}

window.setProcessTypeRelatedConfiguration = function () {
  var processType = jCommon.getHtmlValue("processType");
  jCommon.setHtmlAttribute("placeholder-dataType", "data-label-range", constVar.getPlaceholderByProcessType(processType))
  jCommon.setHtmlValue("placeholder-dataType", jCommon.getHtmlValue("placeholder-dataType"));
  jCommon.setClassListValue("processTypeLabel", jCommon.getHtmlAttriute("processTypeLabel", "select-name"));
}

window.systemRatioControlClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (["fallback-dataType", "sg-dataType", "rateManual-dataType", "placeholder-dataType", "localEn", "sp-dataType", "cycleEn"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
// ratio.html end

//feeddevice.html start
window.initFeedDeviceData = function (message) {
  var loopList = message["loops"];
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("control-monitor", "href", window.location.hash.replace("feeddevice", "fvcontrolmonitor"))
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  jCommon.setHtmlAttribute("rdtPumpEnLink", "href", "#redundantpump&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setDomElementItemValue({
    "feedDeviceType": loopInfo["feedDeviceType"]
  });
  jCommon.setDataSaveProperty("feedDeviceType", "/loops/" + loopIndex + "/feedDeviceType");
  var fdDeviceInfo = loopInfo["fdDevice"];
  jCommon.setDomElementValue(fdDeviceInfo, "/loops/" + loopIndex + "/fdDevice/");
  jCommon.dropDownMenu({
    element: document.getElementById('feedDeviceTypeLabel'),
    choices: constVar.getFeedDevicesType(jCommon.getHtmlValue("feed-control-Type")),
    defaultvalue: loopInfo["feedDeviceType"],
    confirm: {
      message: "Changing Feed Device Type will reset current Feed Device Configuration"
    },
    callback: feedDeviceSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('baseUnitLabel'),
    choices: constVar.getFeedDevicesBaseUnit(),
    defaultvalue: jCommon.empty(fdDeviceInfo["metricFlag"]) ? "I-" + fdDeviceInfo["baseUnit"] : "M-" + fdDeviceInfo["baseUnit"],
    callback: feedDeviceSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('timeUnitLabel'),
    choices: constVar.getFeedDevicesTimeUnit(),
    defaultvalue: fdDeviceInfo["timeUnit"],
    callback: feedDeviceSelectCallback
  });
  channelPage.initChannelInput("outputChn", fdDeviceInfo["outputChnType"], fdDeviceInfo["outputChn"], "analog-digital");
  setFeedDeviceTypeProperty();
  jCommon.dropDownMenu({
    element: document.getElementById('fdvTypeLabel'),
    choices: constVar.getFeedDevicesFVType(),
    defaultvalue: fdDeviceInfo["fdvType"],
    callback: feedDeviceSelectCallback
  });
  channelPage.initChannelInput("doChn", fdDeviceInfo["doChnType"], fdDeviceInfo["doChn"]);
  setFeedDeviceEngineeringUnits();
  var fdvInfo = fdDeviceInfo["fdv"];
  var fdvKey = "";
  if (fdDeviceInfo["fdvType"] === 2) {
    fdvKey = "flowmeterCtrl";
  } else if (fdDeviceInfo["fdvType"] === 3) {
    fdvKey = "flowmeterMonitor";
  }
  if (!jCommon.empty(fdvKey)) {
    for (var key in fdvInfo) {
      jCommon.setHtmlValue(fdvKey + "-" + key, fdvInfo[key]);
      jCommon.setDataSaveProperty(fdvKey + "-" + key, "/loops/" + loopIndex + "/fdDevice/fdv/" + key);
    }
    channelPage.initChannelInput(fdvKey + "-fmChn", fdvInfo["fmChnType"], fdvInfo["fmChn"], "analog");
    jCommon.controlDOMShow(fdvKey + "-fmChn");
    systemFeed.initPidData(message["plc"]["pids"], loopInfo["pid4FV"]["pidIndex"], fdvKey + "-");
  }
}

window.checkFeeddeviceInputValue = function () {
  jCommon.controlDOMShow(arguments[0]);
  repeatAllPage.updateParameter(arguments[0]);
  if (arguments[0] === "size") {
    //to do on/off set point
  }
}

window.feedDevicePageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return;
  }
  if (["rdtPumpEn", "flowmeterCtrl-correctOn"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}

window.feedDeviceSelectCallback = function (value, id) {
  if (id === "feedDeviceTypeLabel") {
    jCommon.setDomElementItemValue({
      "feedDeviceType": value
    });
    repeatAllPage.updateParameter("feedDeviceType", repeatAllPage.initFunction);
  } else if (id === "baseUnitLabel") {
    if (value.startsWith("M-")) {
      jCommon.setHtmlValue("metricFlag", true);
      jCommon.setHtmlValue("baseUnit", value.replace("M-", ""));
    } else {
      jCommon.setHtmlValue("metricFlag", false);
      jCommon.setHtmlValue("baseUnit", value.replace("I-", ""));
    }
    jCommon.controlDOMShow("baseUnit");
    jCommon.setDropDownMenuValueAndLabel("timeUnit", 0);
    setFeedDeviceEngineeringUnits();
    repeatAllPage.updateParameter(id);
  } else if (id === "timeUnitLabel") {
    jCommon.setHtmlValue("timeUnit", value);
    jCommon.controlDOMShow("timeUnit");
    setFeedDeviceEngineeringUnits();
    repeatAllPage.updateParameter("timeUnit");
  } else if (id === "fdvTypeLabel") {
    jCommon.setDomElementItemValue({
      "fdvType": value
    });
    repeatAllPage.updateParameter("fdvType", repeatAllPage.initFunction);
  }
}

window.setFeedDeviceEngineeringUnits = function () {
  jCommon.setClassListValue("baseUnitLabel", jCommon.getHtmlAttriute("baseUnitLabel", "select-name"));
  jCommon.setClassListValue("timeUnitLabel", jCommon.getHtmlAttriute("timeUnitLabel", "select-name"));
}

window.setFeedDeviceTypeProperty = function () {
  var feedDeviceType = jCommon.getHtmlValue("feedDeviceType");
  if (feedDeviceType === 0) {
    jCommon.setDropDownMenuDisabled("baseUnitLabel", true);
    jCommon.setDropDownMenuDisabled("timeUnitLabel", true);
  } else {
    jCommon.setDropDownMenuDisabled("baseUnitLabel", false);
    jCommon.setDropDownMenuDisabled("timeUnitLabel", false);
  }
  if (feedDeviceType === 3) {
    jCommon.setHtmlAttribute("outputChnDigitalLabel", "data-disabled", systemFeed.getFeedDeviceChannelRange("OnOffCVOutputChannel"));
  } else if (feedDeviceType === 2) {
    jCommon.setHtmlAttribute("outputChnDigitalLabel", "data-disabled", systemFeed.getFeedDeviceChannelRange("PulseCVOutputChannel"));
  } else if (feedDeviceType === 1) {
    jCommon.setHtmlAttribute("outputChnAnalogLabel", "data-disabled", systemFeed.getFeedDeviceChannelRange("analogCVOutputChannel"));
  } else if (feedDeviceType === 4) {
    jCommon.setHtmlAttribute("outputChnDigitalLabel", "data-disabled", systemFeed.getFeedDeviceChannelRange("TimeCVOutputChannel"));
  }
}
//feeddevice.html end

//fvcontrolmonitor.html start
window.initFVControlMonitorData = function (message) {
  var loopList = message["loops"];
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var fdvInfo = loopInfo["fdv"];
  var flowmeterCtrlInfo = fdvInfo["flowmeterCtrl"];
  for (var key in flowmeterCtrlInfo) {
    jCommon.setHtmlValue("flowmeterCtrl-" + key, flowmeterCtrlInfo[key]);
    jCommon.setDataSaveProperty("flowmeterCtrl-" + key, "/loops/" + loopIndex + "/fdv/flowmeterCtrl/" + key);
  }
}

window.FVControlMonitorPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return;
  }
  if (event.target.id === "flowmeterCtrl-correctOn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//fvcontrolmonitor.html end

//interlock.html start
window.initInterlockData = function (message) {
  var loopList = message["loops"];
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  channelPage.initChannelInput("fwFallbackLockChn", loopInfo["fwFallbackLockChnType"], loopInfo["fwFallbackLockChn"]);
  channelPage.initChannelInput("fwLockChn", loopInfo["fwLockChnType"], loopInfo["fwLockChn"]);
  var systemIndex = jCommon.getUrlParams("system") - 1;
  var systemInfo = message["systems"][systemIndex];
  jCommon.setDomElementValue(systemInfo);
  channelPage.initChannelInput("EStopChn", systemInfo["EStopChnType"], systemInfo["EStopChn"]);
  channelPage.initChannelInput("sysInterChn", systemInfo["sysInterChnType"], systemInfo["sysInterChn"]);
  var predefinedList = systemFeed.getPredefinedLoopList(message, systemIndex, "all");
  jCommon.dropDownMenu({
    element: document.getElementById('SI_LoopNumLabel'),
    choices: predefinedList,
    defaultvalue: loopInfo["SI_LoopNum"],
    callback: interlockSelectCallback
  });
  jCommon.dropDownMenu({
    element: document.getElementById('SI_LoopModeLabel'),
    choices: constVar.getLoopMode(),
    defaultvalue: loopInfo["SI_LoopMode"],
    callback: interlockSelectCallback
  });
}

window.interlockSelectCallback = function (value, id) {
  var key = id.replace("Label", "")
  jCommon.setHtmlValue(key, value);
  repeatAllPage.updateParameter(id);
}

window.interlockPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return;
  }
  if (event.target.id === "enableReq") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}
//interlock.html end

// schedule.html start
window.initScheduleData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var systemIndex = Number(jCommon.getUrlParams("system")) - 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlValue("blowdownEn", message["systems"][systemIndex]["blowdownEn"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.dropDownMenu({
    element: document.getElementById("prebleedLabel"),
    choices: constVar.getSchedulePreBleed(),
    defaultvalue: loopInfo["prebleed"],
    callback: repeatAllPage.updateSelectValueData
  })
  channelPage.initChannelInput("condChn", loopInfo["condChnType"], loopInfo["condChn"], "analog");
  var predefinedList = systemFeed.getPredefinedLoopList(message, systemIndex);
  jCommon.dropDownMenu({
    element: document.getElementById('preFeedLoopIndexLabel'),
    choices: predefinedList,
    defaultvalue: loopInfo["preFeedLoopIndex"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById('postFeedLoopIndexLabel'),
    choices: predefinedList,
    defaultvalue: loopInfo["postFeedLoopIndex"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.setHtmlAttribute("schedulesetup", "href", "#schedulesetup&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
}
// schedule.html end

// interval.html start
window.initIntervalData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var systemIndex = Number(jCommon.getUrlParams("system")) - 1;
  jCommon.setHtmlValue("blowdownEn", message["systems"][systemIndex]["blowdownEn"]);
  jCommon.setHtmlAttribute("redirectBlowdown", "system-name", systemFeed.getSystemName(jCommon.getUrlParams("system"), message["systems"][systemIndex]["name"]))
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.dropDownMenu({
    element: document.getElementById("prebleedLabel"),
    choices: constVar.getSchedulePreBleed(),
    defaultvalue: loopInfo["prebleed"],
    callback: repeatAllPage.updateSelectValueData
  })
  channelPage.initChannelInput("condChn", loopInfo["condChnType"], loopInfo["condChn"], "analog");
  initIntervalTableData(loopInfo);
  var predefinedList = systemFeed.getPredefinedLoopList(message, systemIndex);
  jCommon.dropDownMenu({
    element: document.getElementById('preFeedLoopIndexLabel'),
    choices: predefinedList,
    defaultvalue: loopInfo["preFeedLoopIndex"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById('postFeedLoopIndexLabel'),
    choices: predefinedList,
    defaultvalue: loopInfo["postFeedLoopIndex"],
    callback: repeatAllPage.updateSelectValueData
  });
}

window.initIntervalTableData = function (loopInfo) {
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var timeList = loopInfo["time"];
  var volumList = loopInfo["volum"];
  timeList.forEach(function (item, index) {
    jCommon.pickerTime({
      element: document.getElementById(index + '-timeLabel'),
      defaultvalue: item,
      callback: repeatAllPage.updateSelectValueData
    })
    jCommon.setHtmlValue(index + "-time", item);
    jCommon.setDataSaveProperty(index + "-time", "/loops/" + loopIndex + "/time/" + index);
    jCommon.setHtmlValue(index + "-volum", volumList[index]);
    jCommon.setDataSaveProperty(index + "-volum", "/loops/" + loopIndex + "/volum/" + index);
  })
}

window.scheduleAndIntervalPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (["localEn"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    });
  } else if (event.target.id === "redirectBlowdown") {
    var blowdownEn = jCommon.getHtmlValue("blowdownEn");
    if (jCommon.empty(blowdownEn)) {
      ToolstipDialog.showAlertToolsTip("", "BlowDown not Selected for this System");
    } else {
      window.location.hash = "systemblowdown&system=" + jCommon.getUrlParams("system") + "&name=" + jCommon.getHtmlAttriute("systemblowdown", "system-name");
    }
  }
}
// interval.html end

//2021-11-17 11:10:41  2021-11-17 11:10:36  2021-11-17 11:10:31 
// schedulesetup.html start
window.initScheduleSetupData = function (message, data) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  jCommon.setHtmlValue("weekNum", loopInfo["weekNum"]);
  jCommon.setDataSaveProperty("weekNum", "/loops/" + loopIndex + "/weekNum");
  jCommon.dropDownMenu({
    element: document.getElementById('weekNumLabel'),
    choices: constVar.getScheduleWeek(),
    defaultvalue: loopInfo["weekNum"],
    callback: scheduleSetupSelectCallback
  });
  initScheduleTableData(loopInfo, data);
}

window.initScheduleTableData = function (loopInfo, data) {
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var startSundayDate = jCommon.formatSundayDate(data["sunday"]);
  jCommon.setHtmlValue("startYear", startSundayDate.substring(0, 4));
  jCommon.setHtmlValue("sundayDate", startSundayDate);
  var currentPage = jCommon.getHtmlValue("currentPage");
  jCommon.setHtmlValue("pageNum", "Week" + currentPage);
  jCommon.setHtmlValue("marginLeftNum", 0);
  var startItem = (currentPage - 1) * 7;
  var endItem = currentPage * 7 - 1;
  var weekOffset = jCommon.calculateSundayOffset(data["sunday"], loopInfo["sundayCreated"]);
  jCommon.setHtmlValue("weekOffset", weekOffset);
  var loopScheduleList = systemFeed.swipeScheduleList(loopInfo["daysSchedules"], loopInfo["weekNum"], weekOffset, 7);
  var dateList = jCommon.getDateWeekDayList(startSundayDate, loopInfo["weekNum"]);
  var row = 1;
  for (var index = 0; index < loopScheduleList.length; index++) {
    if (index >= startItem && index <= endItem) {
      jCommon.setHtmlValue("date-" + row, dateList[index]);
      var loopScheduleInfo = loopScheduleList[index];
      var itemList = loopScheduleInfo["time"];
      var volumList = loopScheduleInfo["volum"];
      for (var key = 0; key < itemList.length; key++) {
        var columnId = key + 1;
        jCommon.pickerTime({
          element: document.getElementById('time-' + row + '-' + columnId + "Label"),
          defaultvalue: itemList[key],
          callback: repeatAllPage.updateSelectValueData
        })
        jCommon.setHtmlValue("time-" + row + "-" + columnId, itemList[key]);
        jCommon.setDataSaveProperty("time-" + row + "-" + columnId, "/loops/" + loopIndex + "/daysSchedules/" + loopScheduleInfo["orginIndex"] + "/time/" + key);
        jCommon.setHtmlValue("value-" + row + "-" + columnId, volumList[key]);
        jCommon.setDataSaveProperty("value-" + row + "-" + columnId, "/loops/" + loopIndex + "/daysSchedules/" + loopScheduleInfo["orginIndex"] + "/volum/" + key);
      }
      row++;
    }
  }
  controlScheduleSetupPage();
  controlScheduleSetupColumnPage();
}

window.scheduleSetupPageClick = function (event) {
  // repeatAllPage.clearEventClick(event);
  if (["btnFirstPage", "btnLastPage", "btnPrePage", "btnNextPage"].indexOf(event.target.id) > -1) {
    if (event.target.id === "btnFirstPage") {
      jCommon.setHtmlValue("currentPage", 1);
    } else if (event.target.id === "btnLastPage") {
      jCommon.setHtmlValue("currentPage", jCommon.getHtmlValue("weekNum"));
    } else if (event.target.id === "btnPrePage") {
      var currentPage = jCommon.getHtmlValue("currentPage");
      jCommon.setHtmlValue("currentPage", --currentPage);
    } else if (event.target.id === "btnNextPage") {
      var currentPage = jCommon.getHtmlValue("currentPage");
      jCommon.setHtmlValue("currentPage", ++currentPage);
    }
    repeatAllPage.initFunction();
  } else if (["preColumn", "nextColumn"].indexOf(event.target.id) > -1) {
    var currentNumber = jCommon.getHtmlValue("marginLeftNum");
    if (event.target.id === "preColumn") {
      currentNumber++;
    } else if (event.target.id === "nextColumn") {
      currentNumber--;
    }
    jCommon.setHtmlValue("marginLeftNum", currentNumber);
    controlScheduleSetupColumnPage();
  }
}

window.scheduleSetupSelectCallback = function (value, id) {
  jCommon.setHtmlValue("currentPage", 1);
  var domId = id.replace("Label", "");
  jCommon.setHtmlValue(domId, value);
  repeatAllPage.updateParameter(domId);
}

window.controlScheduleSetupPage = function () {
  var currentPage = jCommon.getHtmlValue("currentPage");
  var allPage = jCommon.getHtmlValue("weekNum");
  if (currentPage === 1) {
    jCommon.setHtmlAttribute("btnFirstPage", "disabled", true);
    jCommon.setHtmlAttribute("btnPrePage", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("btnFirstPage", "disabled", false);
    jCommon.setHtmlAttribute("btnPrePage", "disabled", false);
  }
  if (currentPage === allPage) {
    jCommon.setHtmlAttribute("btnNextPage", "disabled", true);
    jCommon.setHtmlAttribute("btnLastPage", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("btnNextPage", "disabled", false);
    jCommon.setHtmlAttribute("btnLastPage", "disabled", false);
  }
}

window.controlScheduleSetupColumnPage = function () {
  var currentColum = jCommon.getHtmlValue("marginLeftNum");
  jCommon.setHtmlStyleAttribute("schedule-item-list", "marginLeft", currentColum * 250 + "px");
  if (currentColum === 0) {
    jCommon.setHtmlAttribute("preColumn", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("preColumn", "disabled", false);
  }
  if (currentColum === -6) {
    jCommon.setHtmlAttribute("nextColumn", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("nextColumn", "disabled", false);
  }
}
// schedulesetup.html end

//systemcycle.html start
window.initSystemcycleData = function (message) {
  var systemIndex = jCommon.getUrlParams("system") - 1;
  var cycleInfo = message["systems"][systemIndex]["cycle"];
  jCommon.setDomElementValue(cycleInfo, "/systems/" + systemIndex + "/cycle/");
  systemFeed.initLoopMode(cycleInfo);
  channelPage.initChannelInput("aoChn", cycleInfo["aoChnType"], cycleInfo["aoChn"], "analog");
  jCommon.dropDownMenu({
    element: document.getElementById('formulaLabel'),
    choices: constVar.getSystemCycle(),
    defaultvalue: cycleInfo["formula"],
    confirm: {
      message: "Conductivity based equation is not recommend to be used in high purity boiler application.Best practice is to use the flow based equation",
      value: "1"
    },
    callback: systemCycleEquationSelectCallback
  })
  setEquationProperty();
  var var1Info = cycleInfo["var1"];
  for (var key in var1Info) {
    jCommon.setHtmlValue("var1-" + key, var1Info[key]);
    jCommon.setDataSaveProperty("var1-" + key, "/systems/" + systemIndex + "/cycle/var1/" + key);
    jCommon.controlDOMShow("var1-" + key);
  }
  channelPage.initChannelInput("var1-chn", var1Info["chnType"], var1Info["chn"], "analog");
  jCommon.controlDOMShow("var1-dataType");
  var var2Info = cycleInfo["var2"];
  for (var key in var2Info) {
    jCommon.setHtmlValue("var2-" + key, var2Info[key]);
    jCommon.setDataSaveProperty("var2-" + key, "/systems/" + systemIndex + "/cycle/var2/" + key);
    jCommon.controlDOMShow("var2-" + key);
  }
  channelPage.initChannelInput("var2-chn", var2Info["chnType"], var2Info["chn"], "analog");
  jCommon.controlDOMShow("var2-dataType");
}

window.systemCycleEquationSelectCallback = function (value, id) {
  repeatAllPage.updateSelectValueData(value, id, function () {
    setEquationProperty();
    jCommon.setHtmlValue("var1-dataType", jCommon.getHtmlValue("var1-dataType"));
    jCommon.setHtmlValue("var2-dataType", jCommon.getHtmlValue("var2-dataType"));
  });
}

window.setEquationProperty = function () {
  var formula = jCommon.getHtmlValue("formula");
  if (formula === 1) {
    jCommon.setHtmlAttribute("var1-dataType", "data-label-range", "Sys Conductivity Ch,Sys Conductivity Const");
    jCommon.setHtmlAttribute("var2-dataType", "data-label-range", "MU Conductivity Ch,MU Conductivity Const");
  } else if (formula === 0) {
    jCommon.setHtmlAttribute("var1-dataType", "data-label-range", "MU/FW Flow Ch,MU/FW Flow Const");
    jCommon.setHtmlAttribute("var2-dataType", "data-label-range", "BD Flow Channel,BD Flow Constant");
  } else if (formula === 2) {
    jCommon.setHtmlAttribute("var1-dataType", "data-label-range", "Variable1 Ch,Variable1 Const");
    jCommon.setHtmlAttribute("var2-dataType", "data-label-range", "Variable2 Ch,Variable2 Const");
  }
}

window.systemCycleClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return false;
  }
  if (event.target.id.endsWith("-dataType") || event.target.id === "localEn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//systemcycle.html end

//systemblowdown.html start
window.initSystemBlowdownData = function (message) {
  var systemIndex = jCommon.getUrlParams("system") - 1;
  var systemInfo = message["systems"][systemIndex];
  jCommon.setDomElementValue(systemInfo);
  jCommon.setHtmlAttribute("cycleConfig", "href", "#systemcycle&system=" + jCommon.getUrlParams("system") + "&name=" + systemFeed.getSystemName(jCommon.getUrlParams("system"), systemInfo["name"]));
  var blowdownInfo = systemInfo["blowdown"];
  jCommon.setDomElementValue(blowdownInfo, "/systems/" + systemIndex + "/blowdown/");
  jCommon.dropDownMenu({
    element: document.getElementById('modeLabel'),
    choices: constVar.getLoopMode(),
    defaultvalue: blowdownInfo["mode"],
    callback: systemBlowdownCycleSelectCallback
  })
  channelPage.initChannelInput("modeChn", blowdownInfo["modeChnType"], blowdownInfo["modeChn"]);
  controlSystemBlowdownLocalEnProperty();
  jCommon.dropDownMenu({
    element: document.getElementById('deviceTypeLabel'),
    choices: constVar.getSystemBlowDownType(),
    defaultvalue: blowdownInfo["deviceType"],
    callback: systemBlowdownCycleSelectCallback
  })
  channelPage.initChannelInput("pvChn", blowdownInfo["pvChnType"], blowdownInfo["pvChn"], "analog");
  var dbInfo = blowdownInfo["db"];
  for (var key in dbInfo) {
    jCommon.setHtmlValue("db-" + key, dbInfo[key]);
    jCommon.setDataSaveProperty("db-" + key, "/systems/" + systemIndex + "/blowdown/db/" + key);
    jCommon.controlDOMShow("db-" + key);
  }
  channelPage.initChannelInput("db-chn", dbInfo["chnType"], dbInfo["chn"], "analog");
  jCommon.controlDOMShow("db-dataType");
  var spInfo = blowdownInfo["sp"];
  for (var key in spInfo) {
    jCommon.setHtmlValue("sp-" + key, spInfo[key]);
    jCommon.setDataSaveProperty("sp-" + key, "/systems/" + systemIndex + "/blowdown/sp/" + key);
    jCommon.controlDOMShow("sp-" + key);
  }
  channelPage.initChannelInput("sp-chn", spInfo["chnType"], spInfo["chn"], "analog");
  jCommon.controlDOMShow("sp-dataType");
  var timeCfgInfo = blowdownInfo["timeCfg"];
  for (var key in timeCfgInfo) {
    jCommon.setHtmlValue("timeCfg-" + key, timeCfgInfo[key]);
    jCommon.setDataSaveProperty("timeCfg-" + key, "/systems/" + systemIndex + "/blowdown/timeCfg/" + key);
    jCommon.controlDOMShow("timeCfg-" + key);
  }
  channelPage.initChannelInput("timeCfg-openDOChn", timeCfgInfo["openDOChnType"], timeCfgInfo["openDOChn"]);
  channelPage.initChannelInput("timeCfg-closeDOChn", timeCfgInfo["closeDOChnType"], timeCfgInfo["closeDOChn"]);
  var analogCfgInfo = blowdownInfo["analogCfg"];
  for (var key in analogCfgInfo) {
    jCommon.setHtmlValue("analogCfg-" + key, analogCfgInfo[key]);
    jCommon.setDataSaveProperty("analogCfg-" + key, "/systems/" + systemIndex + "/blowdown/analogCfg/" + key);
    jCommon.controlDOMShow("analogCfg-" + key);
  }
  channelPage.initChannelInput("analogCfg-aoChn", analogCfgInfo["aoChnType"], analogCfgInfo["aoChn"], "analog");
}

window.systemBlowdownCycleSelectCallback = function (value, id, oldValue) {
  var key = id.replace("Label", "");
  if (id === "deviceTypeLabel") {
    if (Number(value) === 1 && [2, 3].indexOf(Number(oldValue)) > -1 && jCommon.getHtmlValue("timeCfg-timeSampleEn")) {
      jCommon.setDropDownMenuValueAndLabel(key, oldValue);
      ToolstipDialog.showAlertToolsTip("", "Can not Select Analog Device while Time Sample is On");
      return false;
    }
    jCommon.resetChannelInputValue("analogCfg-aoChn");
    jCommon.resetChannelInputValue("timeCfg-openDOChn");
    jCommon.resetChannelInputValue("timeCfg-closeDOChn");
    jCommon.setHtmlValue(key, value);
    jCommon.controlDOMShow(key);
    repeatAllPage.updateParameter("deviceTypeLabel");
  } else {
    jCommon.setHtmlValue(key, value);
    jCommon.controlDOMShow(key);
    repeatAllPage.updateParameter(key);
  }
}

window.systemblowdownPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return false;
  }
  if (event.target.id.endsWith("-dataType") || ["localEn", "pvType", "direct", "timeCfg-timeSampleEn", "timeCfg-timeoutEn"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        controlSystemBlowdownLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}

window.controlSystemBlowdownLocalEnProperty = function () {
  var localEn = jCommon.getHtmlValue("localEn");
  if (jCommon.empty(localEn)) {
    jCommon.setDropDownMenuDisabled("modeLabel", true);
    jCommon.setChannelInputDisabled("modeChnAnalogLabel", false);
  } else {
    jCommon.setDropDownMenuDisabled("modeLabel", false);
    jCommon.setChannelInputDisabled("modeChnAnalogLabel", true);
  }
}
//systemblowdown.html end

// alarmsumary.html start
window.initAlarmEventSumaryData = function () {
  var startDateTime = jCommon.getDifferCurrentDate(0, 0, -1, 0, 0, 0);
  var endDateTime = jCommon.getDifferCurrentDate();
  selectDataAndTimeDialog.setStartAndEndDateTime(startDateTime, endDateTime);
  jCommon.setHtmlValue("clickNumber", 0);
  getFirstPageData();
}

window.alarmSumaryPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.setHtmlValue("opPage", event.target.id);
  var currentPage = jCommon.getHtmlValue("currentPage");
  if (event.target.id === "firstPage") {
    getFirstPageData();
  } else if (event.target.id === "prePage") {
    jCommon.setHtmlValue("action", "pre");
    if (currentPage > 1) {
      currentPage--;
    }
    jCommon.setHtmlValue("currentPage", currentPage);
    handleAlarmAndEventData();
  } else if (event.target.id === "nextPage") {
    jCommon.setHtmlValue("action", "next");
    currentPage++;
    jCommon.setHtmlValue("currentPage", currentPage);
    handleAlarmAndEventData();
  } else if (event.target.id === "LastPage") {
    jCommon.setHtmlValue("action", "last");
    var allRecordList = repeatAllPage.alarmInfo.msg;
    var merchant = Number(allRecordList / 17);
    var currentPage = allRecordList % 17 === 0 ? merchant : merchant + 1
    jCommon.setHtmlValue("currentPage", currentPage);
    handleAlarmAndEventData();
  } else if (event.target.id === "select-date") {
    selectDataAndTimeDialog.show(getFirstPageData);
  } else {
    var selectRow = document.querySelector(".select-current");
    var rowList = document.querySelectorAll(".alarm-item");
    var currentRow = Number(selectRow.getAttribute("data-row"));
    var rowCount = Number(rowList.length);
    var currentRowID = Number(selectRow.getAttribute("data-item-id"));
    var currentRowMessage = selectRow.querySelector(".label-content").innerHTML;
    var currentRowState = Number(selectRow.getAttribute("data-item-state"));
    var preRow = currentRow === 1 ? 1 : currentRow - 1;
    var nextRow = currentRow === rowCount ? rowCount : currentRow + 1;
    if (event.target.id === "preRow") {
      jCommon.removeHtmlClass('div[data-row="' + currentRow + '"]', "select-current");
      jCommon.addHtmlClass('div[data-row="' + preRow + '"]', "select-current");
      var selectRowId = document.querySelector('div[data-row="' + preRow + '"]').getAttribute("data-item-id");
      jCommon.setHtmlValue("selectRowId", selectRowId);
      jCommon.setHtmlAttribute("nextRow", "disabled", false);
      if (preRow === 1) {
        jCommon.setHtmlAttribute("preRow", "disabled", true);
      } else {
        jCommon.setHtmlAttribute("preRow", "disabled", false);
      }
    } else if (event.target.id === "nextRow") {
      jCommon.removeHtmlClass('div[data-row="' + currentRow + '"]', "select-current");
      jCommon.addHtmlClass('div[data-row="' + nextRow + '"]', "select-current");
      var selectRowId = document.querySelector('div[data-row="' + nextRow + '"]').getAttribute("data-item-id");
      jCommon.setHtmlValue("selectRowId", selectRowId);
      jCommon.setHtmlAttribute("preRow", "disabled", false);
      if (nextRow === rowCount) {
        jCommon.setHtmlAttribute("nextRow", "disabled", true);
      } else {
        jCommon.setHtmlAttribute("nextRow", "disabled", false);
      }
    } else if (event.target.id === "acknowledge-all") {
      var pdata = {};
      pdata.ids = [];
      pdata.msgs = [];
      pdata.states = [];
      for (var index = 0; index < rowList.length; index++) {
        pdata.ids.push(Number(rowList[index].getAttribute("data-item-id")));
        pdata.states.push(Number(rowList[index].getAttribute("data-item-state")));
        pdata.msgs.push(rowList[index].querySelector(".label-content").innerHTML);
      }
      repeatAllPage.acknowledgeUpdateing = true;
      cmdlist.acknowledgeAlarmData(pdata, function () {
        repeatAllPage.acknowledgeUpdateing = false;
        jCommon.setHtmlValue("action", "next");
        getAlarmAndEventData();
      })
    } else if (event.target.id === "acknowledge") {
      var pdata = {};
      pdata.ids = [currentRowID];
      pdata.msgs = [currentRowMessage];
      pdata.states = [currentRowState];
      repeatAllPage.acknowledgeUpdateing = true;
      cmdlist.acknowledgeAlarmData(pdata, function () {
        repeatAllPage.acknowledgeUpdateing = false;
        jCommon.setHtmlValue("action", "current");
        getAlarmAndEventData();
      })
    }
  }
}

window.handleAlarmAndEventData = function () {
  var isEvent = jCommon.getHtmlValue("event");
  if (isEvent) {
    getAlarmAndEventData();
  } else {
    var currentPage = jCommon.getHtmlValue("currentPage");
    var startIndex = (currentPage - 1) * 17;
    var endIndex = (currentPage) * 17;
    setAlarmAndEventList({
      color: repeatAllPage.alarmInfo.color.slice(startIndex, endIndex),
      datetime: repeatAllPage.alarmInfo.datetime.slice(startIndex, endIndex),
      id: repeatAllPage.alarmInfo.id.slice(startIndex, endIndex),
      msg: repeatAllPage.alarmInfo.msg.slice(startIndex, endIndex),
      type: repeatAllPage.alarmInfo.type.slice(startIndex, endIndex),
      hasNext: repeatAllPage.alarmInfo.hasNext,
      hasPrev: repeatAllPage.alarmInfo.hasPrev
    })
  }
}

window.getAlarmAndEventData = function () {
  var isEvent = jCommon.getHtmlValue("event");
  var dateTime = selectDataAndTimeDialog.getDateDialogData();
  var clickNumber = jCommon.getHtmlValue("clickNumber");
  var minID = jCommon.getHtmlValue("minID");
  var maxID = jCommon.getHtmlValue("maxID");
  var action = jCommon.getHtmlValue("action");
  var pdata = {};
  pdata.starttime = clickNumber === 0 ? "" : dateTime.startTime;
  pdata.endtime = clickNumber === 0 ? "" : dateTime.endTime;
  if (action == "next") {
    pdata.maxID = minID - 1;
    pdata.minID = minID - 17;
  } else if (action == "pre") {
    pdata.minID = maxID + 1;
    pdata.maxID = maxID + 17;
  } else {
    pdata.minID = minID;
    pdata.maxID = maxID
  }
  pdata.action = action;
  cmdlist.getAlarmAndEventData(pdata, function (resMessage) {
    if (isEvent) {
      setAlarmAndEventList(resMessage)
    } else {
      repeatAllPage.alarmInfo = resMessage;
      handleAlarmAndEventData()
    }
  });
}

window.getFirstPageData = function () {
  jCommon.setHtmlValue("maxID", -1);
  jCommon.setHtmlValue("minID", -1);
  jCommon.setHtmlValue("action", "first");
  jCommon.setHtmlValue("currentPage", 1);
  getAlarmAndEventData();
}

window.setAlarmAndEventList = function (message) {
  var currentPage = jCommon.getHtmlValue("currentPage");
  var isEvent = jCommon.getHtmlValue("event");
  if (jCommon.empty(message["id"])) {
    return;
  }
  var datetime = message["datetime"];
  var arr = ["alarm-red", "alarm-black", "alarm-blue", "alarm-yellow", "alarm-green"];
  var ids = message["id"];
  var colorList = message["color"];
  var typeList = message["type"];
  jCommon.setHtmlValue("minID", Math.min.apply(null, ids));
  jCommon.setHtmlValue("maxID", Math.max.apply(null, ids));
  var msg = message["msg"];
  var alarmItem = [];
  var alarmList = [];
  if (isEvent) {
    jCommon.setHtmlAttribute("prePage", "disabled", !message["hasPrev"]);
    jCommon.setHtmlAttribute("nextPage", "disabled", !message["hasNext"]);
  } else {
    if (currentPage == 1) {
      jCommon.setHtmlAttribute("prePage", "disabled", true);
    } else {
      jCommon.setHtmlAttribute("prePage", "disabled", false);
    }
    var currentPageList = currentPage * 17;
    if (currentPageList >= repeatAllPage.alarmInfo.id.length) {
      jCommon.setHtmlAttribute("nextPage", "disabled", true);
    } else {
      jCommon.setHtmlAttribute("nextPage", "disabled", false);
    }
  }
  datetime.forEach(function (item, index) {
    alarmItem = [];
    alarmItem.push('<div data-item-id="' + ids[index] + '" class="row alarm-item ' + arr[colorList[index]] + '" data-row="' + (index + 1) + '" data-item-state="' + colorList[index] + '">');
    alarmItem.push('<div class="label-left pull-left time">' + item + '</div>');
    if (isEvent) {
      alarmItem.push('<div class="label-content pull-left">' + typeList[index] + '</div>');
    }
    alarmItem.push('<div class="label-content pull-left desc">' + msg[index] + '</div>');
    alarmItem.push('</div>');
    alarmList.push(alarmItem.join(""));
  })
  if (!jCommon.empty(alarmList)) {
    jCommon.setHtmlValue("alarm-list", alarmList.join(""));
    if (jCommon.empty(jCommon.getHtmlValue("selectRowId"))) {
      jCommon.setHtmlValue("selectRowId", ids[0]);
    } else {
      if (ids.indexOf(jCommon.getHtmlValue("selectRowId")) == -1) {
        jCommon.setHtmlValue("selectRowId", ids[0]);
      }
    }
    var selectRowId = jCommon.getHtmlValue("selectRowId");
    if (selectRowId == ids[0]) {
      jCommon.setHtmlAttribute("preRow", "disabled", true);
    } else {
      jCommon.setHtmlAttribute("preRow", "disabled", false);
    }
    if (selectRowId == ids[ids.length - 1]) {
      jCommon.setHtmlAttribute("nextRow", "disabled", true);
    } else {
      jCommon.setHtmlAttribute("nextRow", "disabled", false);
    }
    jCommon.addDomClass(document.querySelector('div[data-item-id="' + selectRowId + '"]'), "select-current");
  }
}
// alarmsumary.html end

//trendconfig.html start
window.initTrendConfigPage = function (message) {
  var predefinedList = systemFeed.getPredefinedLoopList(message);
  var trendsData = message["trends"];
  var list = constVar.getTrendType();
  var trendIndex = jCommon.getUrlParams("p") - 1;
  jCommon.setHtmlAttribute("trend-view", "href", "#trend&p=" + jCommon.getUrlParams("p"));
  jCommon.setDomElementValue(trendsData[trendIndex], "/trends/" + trendIndex + "/");
  trendsData[trendIndex]["pens"].forEach(function (item, index) {
    for (var key in item) {
      jCommon.setHtmlValue("row-" + index + "-" + key, item[key]);
      jCommon.setDataSaveProperty("row-" + index + "-" + key, "/trends/" + trendIndex + "/pens/" + index + "/" + key);
    }
    jCommon.setDataSaveProperty("row-" + index + "-pdLoopName", "/trends/" + trendIndex + "/pens/" + index + "/name");
    jCommon.controlDOMShow("row-" + index + "-type");
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-typeLabel'),
      choices: list,
      defaultvalue: item["type"],
      callback: systemFeed.resetPreDiAnData
    });
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-pdLoopLabel'),
      choices: predefinedList,
      defaultvalue: item["pdLoop"],
      callback: systemFeed.predefinedLoopSelectCallback
    });
    systemFeed.setPredefinedMode("row-" + index + '-pd');
    channelPage.initChannelInput("row-" + index + "-chn", item["chnType"], item["chn"], "analog-digital");
  })
}

window.checkTrendConfigInputValue = function () {
  if (arguments[0] === "pageNum") {
    window.location.hash = "trendconfig&p=" + arguments[1];
  } else {
    repeatAllPage.updateParameter(arguments[0]);
  }
}

window.trendConfigPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id.endsWith("-trendEn")) {
    jCommon.toogleSwitch(event.target.id);
    jCommon.controlDOMShow(event.target.id);
    repeatAllPage.updateParameter(event.target.id);
  }
}
//trendconfig.html end

//trend.html start
window.initTrendData = function (message) {
  var trendsData = message["trends"];
  var trendIndex = jCommon.getUrlParams("p") - 1;
  var trendKey = trendIndex + "_trend_zoomValue";
  jCommon.setHtmlValue("zoomValue", jCommon.getLocalStorge(trendKey) ? jCommon.getLocalStorge(trendKey) : 1);
  calculateTrendIntermediateTime();
  var trendInfo = trendsData[trendIndex];
  if (!jCommon.empty(trendInfo)) {
    jCommon.setDomElementValue(trendInfo, "/trends/" + trendIndex + "/");
    getTrendData();
  }
  realTimeControlStatus();
  controlTrendMinAndMaxInputEnable();
}

window.calculateTrendIntermediateTime = function () {
  var startDateTime = jCommon.getLocalStorge("trend_start_time") ? jCommon.getLocalStorge("trend_start_time") : jCommon.getDifferCurrentDate(0, 0, -1, 0, 0, 0);
  var endDateTime = jCommon.getLocalStorge("trend_end_time") ? jCommon.getLocalStorge("trend_end_time") : jCommon.getDifferCurrentDate();
  selectDataAndTimeDialog.setStartAndEndDateTime(startDateTime, endDateTime);
  selectDataAndTimeDialog.calculateIntermediateTime();
}

window.changeDyGraphMinAndMax = function () {
  var scaled = !jCommon.checkBoolenValue(jCommon.getHtmlValue("unscaled"));
  var scaledRange = trendPage.getDyGraphScaled();
  if (scaled) {
    var maxValue = scaledRange["max"];
    var minValue = scaledRange["min"];
  } else {
    var maxValue = dygraphInstance.getOption("maxValue");
    var minValue = dygraphInstance.getOption("minValue");
  }
  if (jCommon.empty(jCommon.getHtmlValue("manual"))) {
    jCommon.setHtmlValue("ymax", maxValue);
    jCommon.setHtmlValue("ymin", minValue);
  }
}

window.getTrendData = function () {
  var realTimeValue = jCommon.getHtmlValue("realtime");
  var trendIndex = jCommon.getUrlParams("p") - 1;
  var pdata = {};
  pdata.trendIndex = trendIndex;
  jCommon.addHtmlClass("#chartview", "hide");
  jCommon.removeHtmlClass("#chartviewLoading", "hide");
  if (realTimeValue) {
    cmdlist.stopRealtimeLiveData(function () {
      var realTimeRange = trendPage.getTrendRealTimeData(trendIndex);
      var trendKey = trendIndex + "_trend_zoomValue";
      jCommon.setLocalStorge(trendKey, jCommon.getHtmlValue("zoomValue"));
      pdata.startTime = realTimeRange.startTime;
      pdata.endTime = realTimeRange.endTime;
      pdata.startTimeStamp = realTimeRange.startTimeStamp;
      pdata.endTimeStamp = realTimeRange.endTimeStamp;
      trendPage.controlZoomBtnlist();
      cmdlist.getTrendData(pdata, function (message) {
        trendPage.initDyGraphChartView(message);
        cmdlist.startRealtimeLiveData();
      })
    })
  } else {
    var dateObjectInfo = selectDataAndTimeDialog.getDateDialogData();
    pdata.startTime = dateObjectInfo.startTime;
    pdata.endTime = dateObjectInfo.endTime;
    pdata.startTimeStamp = dateObjectInfo.startTimeStamp;
    pdata.endTimeStamp = dateObjectInfo.endTimeStamp;
    jCommon.setLocalStorge("trend_start_time", dateObjectInfo.startTime);
    jCommon.setLocalStorge("trend_end_time", dateObjectInfo.endTime);
    cmdlist.getTrendData(pdata, function (message) {
      trendPage.initDyGraphChartView(message);
    })
  }
}

window.checkTrendInputValue = function () {
  if (arguments[0] === "pageNum") {
    window.location.hash = "trend&p=" + arguments[1];
  } else if (["ymin", "ymax"].indexOf(arguments[0]) > -1) {
    repeatAllPage.updateParameter(arguments[0])
    dygraphInstance.updateOptions({
      valueRange: [jCommon.getHtmlValue("ymin"), jCommon.getHtmlValue("ymax")]
    })
  }
}

window.trendPageClickEvent = function (event) {
  var pageChannel = ["btnFirstPage", "btnPrePage", "btnNextPage", "btnLastPage"];
  if (event.target.tagName !== "CANVAS") {
    jCommon.addHtmlClass("#toolTipLine", "hide");
    jCommon.addHtmlClass("#toolTipXValue", "hide");
  }
  repeatAllPage.clearEventClick(event);
  if (event.target.className.indexOf("btn-chart-resize") > -1) {
    var dateRange = selectDataAndTimeDialog.getDateDialogData();
    var startTime = dateRange.startTimeStamp;
    var endTime = dateRange.endTimeStamp;
    var centerTime = jCommon.formatTimeStamp(jCommon.getHtmlValue("middleDate"));
    var diff_start_end = endTime - startTime;
    if (event.target.id === "left-half-data") {
      var half_range = diff_start_end / 2;
      startTime = jCommon.formatDate(startTime - half_range);
      endTime = jCommon.formatDate(endTime - half_range);
    } else if (event.target.id === "left-square-data") {
      var half_range = diff_start_end / 4;
      startTime = jCommon.formatDate(startTime - half_range);
      endTime = jCommon.formatDate(endTime - half_range);
    } else if (event.target.id === "right-square-data") {
      var half_range = diff_start_end / 4;
      startTime = jCommon.formatDate(startTime + half_range);
      endTime = jCommon.formatDate(endTime + half_range);
    } else if (event.target.id === "right-half-data") {
      var half_range = diff_start_end / 2;
      startTime = jCommon.formatDate(startTime + half_range);
      endTime = jCommon.formatDate(endTime + half_range);
    } else if (event.target.id === "zoom-in") {
      if (jCommon.getHtmlValue("realtime")) {
        trendPage.setTrendZoomOut("in");
      } else {
        diff_start_end = diff_start_end / 2
        var half_range = diff_start_end / 2;
        startTime = jCommon.formatDate(centerTime - half_range);
        endTime = jCommon.formatDate(centerTime + half_range);
      }
    } else if (event.target.id === "zoom-out") {
      if (jCommon.getHtmlValue("realtime")) {
        trendPage.setTrendZoomOut("out");
      } else {
        var half_range = diff_start_end;
        startTime = jCommon.formatDate(centerTime - half_range);
        endTime = jCommon.formatDate(centerTime + half_range);
      }
    }
    selectDataAndTimeDialog.setStartAndEndDateTime(startTime, endTime);
    selectDataAndTimeDialog.calculateIntermediateTime();
    if (jCommon.getHtmlValue("realtime")) {
      getTrendData();
    } else {
      getTrendData();
    }
  } else if (event.target.id === "manual") {
    var state = jCommon.checkBoolenValue(jCommon.getHtmlValue(event.target.id));
    jCommon.setHtmlValue(event.target.id, !state, function () {
      repeatAllPage.updateParameter(event.target.id);
      controlTrendMinAndMaxInputEnable();
    });
  } else if (event.target.id === "unscaled") {
    if (!jCommon.getHtmlValue("manual")) {
      jCommon.toogleSwitch(event.target.id);
      jCommon.controlDOMShow(event.target.id);
      repeatAllPage.updateParameter(event.target.id);
      scaleTrendData();
    }
  } else if (event.target.id === "realtime") {
    calculateTrendIntermediateTime();
    jCommon.toogleSwitch(event.target.id);
    jCommon.controlDOMShow(event.target.id);
    realTimeControlStatus();
    repeatAllPage.updateParameter(event.target.id, function () {
      if (jCommon.getHtmlValue("realtime")) {
        getTrendData();
      } else {
        cmdlist.stopRealtimeLiveData();
      }
    });
  } else if (event.target.id === "trendoverview") {
    window.location.hash = "trendoverview";
  } else if (event.target.id === "select-data") {
    selectDataAndTimeDialog.show(getTrendData);
  } else if (pageChannel.indexOf(event.target.id) > -1) {
    var channelId = pageNavigate.getPage(event.target.id);
    window.location.hash = "trend&p=" + channelId;
  }
}

window.getDyGraphIndexScale = function () {
  var indexNameMap = {};
  var scaleList = dygraphInstance.getOption("customScales");
  var scaleMinList = dygraphInstance.getOption("customMinScales");
  for (var key in dygraphInstance.setIndexByName_) {
    if (typeof scaleList[key] !== "undefined") {
      indexNameMap[dygraphInstance.setIndexByName_[key]] = {};
      indexNameMap[dygraphInstance.setIndexByName_[key]]["scale"] = scaleList[key];
      indexNameMap[dygraphInstance.setIndexByName_[key]]["min"] = scaleMinList[key];
    }
  }
  return indexNameMap;
}

window.getScaleVirtualData = function (rowList) {
  var indexNameMap = getDyGraphIndexScale();
  rowList.forEach(function (item, index) {
    item.forEach(function (value, key) {
      if (key > 0) {
        rowList[index][key] = trendPage.getDyGraphVirtualData(indexNameMap[key]["scale"], value, indexNameMap[key]["min"]);
      }
    });
  });
  return rowList;
}

window.getScaleRevertData = function (rowList) {
  if (jCommon.empty(rowList)) {
    return;
  }
  var indexNameMap = getDyGraphIndexScale();
  rowList.forEach(function (item, index) {
    item.forEach(function (value, key) {
      if (key > 0) {
        rowList[index][key] = trendPage.getDyGraphRealData(indexNameMap[key]["scale"], value, indexNameMap[key]["min"]);
      }
    });
  });
  return rowList;
}

window.scaleTrendData = function () {
  var scaled = !jCommon.checkBoolenValue(jCommon.getHtmlValue("unscaled"));
  var selfScaled = jCommon.checkBoolenValue(dygraphInstance.getOption("isScales"));
  var rowList = [];
  if (scaled) {
    if (!selfScaled) {
      rowList = getScaleVirtualData(dygraphInstance.rawData_);
    }
  } else {
    //revert data
    if (selfScaled) {
      rowList = getScaleRevertData(dygraphInstance.rawData_);
    }
  }
  changeDyGraphMinAndMax();
  dygraphInstance.updateOptions({
    isScales: scaled,
    'file': rowList,
    valueRange: [jCommon.getHtmlValue("ymin"), jCommon.getHtmlValue("ymax")]
  });
}

window.controlTrendMinAndMaxInputEnable = function () {
  jCommon.controlDOMShow("manual");
  if (jCommon.checkBoolenValue(jCommon.getHtmlValue("manual"))) {
    //Manual
    jCommon.setHtmlValue("unscaled", true, function () {
      if (!jCommon.empty(dygraphInstance) && jCommon.checkBoolenValue(dygraphInstance.getOption("isScales"))) {
        scaleTrendData();
      }
    });
    jCommon.setSwitchEnabled("unscaled", false);
    jCommon.setHtmlAttribute("ymax", "disabled", false);
    jCommon.setHtmlAttribute("ymin", "disabled", false);
  } else {
    //Auto
    jCommon.setSwitchEnabled("unscaled", true);
    jCommon.setHtmlAttribute("ymax", "disabled", true);
    jCommon.setHtmlAttribute("ymin", "disabled", true);
  }
}

window.realTimeControlStatus = function () {
  if (jCommon.checkBoolenValue(jCommon.getHtmlValue("realtime"))) {
    jCommon.setHtmlAttribute("select-data", "disabled", true);
    jCommon.setHtmlAttribute("left-half-data", "disabled", true);
    jCommon.setHtmlAttribute("left-square-data", "disabled", true);
    jCommon.setHtmlAttribute("right-square-data", "disabled", true);
    jCommon.setHtmlAttribute("right-half-data", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("select-data", "disabled", false);
    jCommon.setHtmlAttribute("left-half-data", "disabled", false);
    jCommon.setHtmlAttribute("left-square-data", "disabled", false);
    jCommon.setHtmlAttribute("right-square-data", "disabled", false);
    jCommon.setHtmlAttribute("right-half-data", "disabled", false);
  }
}
//trend.html end

//trendoverview.html start
window.initTrendOverveiwData = function (list) {
  list.forEach(function (item, index) {
    var id = Number(index + 1);
    jCommon.setHtmlValue("trend&p=" + id, jCommon.empty(item["name"]) ? "Trend " + id + " View" : item["name"]);
  })
}
//trendoverview.html end

//trendconfigoverview.html start
window.initTrendConfigOverveiwData = function (list) {
  list.forEach(function (item, index) {
    var id = Number(index + 1);
    jCommon.setHtmlValue("trendconfig&p=" + id, jCommon.empty(item["name"]) ? "Trend " + id + " Config" : item["name"]);
  })
}
//trendconfigoverview.html end

// feedmonitor.html start
window.initFeedMonitorData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
}
// feedmonitor.html end

//recipe.html start
window.initRecipeData = function (message) {
  var otherInfo = message["other"];
  jCommon.setDomElementValue(otherInfo);
  jCommon.setDataSaveProperty("recipeDesc", "/other/recipeDesc");
  getRecipeList();
}

window.getRecipeList = function () {
  var currentFile = jCommon.getHtmlValue("recipeName");
  var preFileNumber = 0;
  cmdlist.getRecipeList(function (fileList) {
    var fileString = [];
    if (jCommon.empty(fileList)) {
      setRecipeFileDetail();
      setRecipeFilePage();
    } else {
      fileList.forEach(function (item, index) {
        fileString.push('<div class="row file-row font-white" data-detail="' + JSON.stringify(item).replace(/"/g, "'") + '">' + item["name"] + '</div>');
        if (currentFile === item["name"]) {
          preFileNumber = index;
          jCommon.setHtmlValue("currentNumber", index);
        }
      })
      var marginTop = Number(168 - preFileNumber * 42);
      jCommon.setHtmlValue("file-list", fileString.join(""));
      jCommon.setHtmlValue("marginTop", marginTop);
      setRecipeFileDetail();
      jCommon.setHtmlStyleAttribute("file-list", "marginTop", marginTop + "px");
      setRecipeFilePage();
    }
  })
}

window.recipePageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var marginTop = jCommon.getHtmlValue("marginTop");
  var currentNumber = jCommon.getHtmlValue("currentNumber");
  var currentSelectFile = jCommon.getHtmlValue("currentFileName");
  var newFile = jCommon.getHtmlValue("fileName");
  var description = jCommon.getHtmlValue("recipeDesc");
  var intervel = 0;
  if (["btn-pre-file", "btn-next-file"].indexOf(event.target.id) > -1) {
    if (event.target.id === "btn-pre-file") {
      currentNumber--;
      intervel = marginTop + 42;
    } else if (event.target.id === "btn-next-file") {
      currentNumber++;
      intervel = marginTop - 42;
    }
    jCommon.setHtmlValue("marginTop", intervel);
    jCommon.setHtmlValue("currentNumber", currentNumber);
    setRecipeFileDetail();
    jCommon.setHtmlStyleAttribute("file-list", "marginTop", intervel + "px");
    setRecipeFilePage();
  } else if (event.target.id === "delete") {
    ToolstipDialog.showConfirmToolsTip("Warning!", "Are you sure you want to delete?", function () {
      cmdlist.deleteRecipe({
        name: currentSelectFile
      }, getRecipeList);
    })
  } else if (event.target.id === "create") {
    cmdlist.createRecipe({
      name: newFile + ".json",
      description: description
    }, getRecipeList);
  } else if (event.target.id === "restore") {
    ToolstipDialog.showConfirmToolsTip("", "Are you sure you want to restore from " + currentSelectFile, function () {
      cmdlist.restoreRecipe({
        name: currentSelectFile
      }, function (message) {
        jCommon.setHtmlValue("errmsg", message["errorcode"] === 0 ? "Restore from " + currentSelectFile + " Success" : "Restore from " + currentSelectFile + " falied :" + message["errmsg"]);
        repeatAllPage.initCurrentPageData();
      });
    })
  } else if (event.target.id === "backup") {
    ToolstipDialog.showConfirmToolsTip("", "Are you sure you want to backup data to " + currentSelectFile, function () {
      jCommon.setHtmlAttribute("backup", "disabled", true);
      jCommon.setHtmlAttribute("restore", "disabled", true);
      cmdlist.backUpRecipe({
        name: currentSelectFile,
        description: description
      }, function (message) {
        jCommon.setHtmlAttribute("backup", "disabled", false);
        jCommon.setHtmlAttribute("restore", "disabled", false);
        jCommon.setHtmlValue("errmsg", message["errorcode"] === 0 ? "Backup to " + currentSelectFile + " Success" : "Backup to " + currentSelectFile + " falied :" + message["errmsg"]);
        repeatAllPage.initCurrentPageData();
      });
    })
  }
}

window.setRecipeFileDetail = function () {
  var currentNumber = jCommon.getHtmlValue("currentNumber");
  if (document.querySelectorAll("#file-list .file-row").length === 0) {
    jCommon.setHtmlValue("currentFileName", "No file");
  } else {
    var fileDomInfo = document.querySelectorAll("#file-list .file-row")[currentNumber];
    jCommon.setHtmlValue("currentFileName", fileDomInfo.innerHTML);
    var dataDetail = JSON.parse(fileDomInfo.getAttribute("data-detail").replace(/'/g, '"'));
    jCommon.setHtmlValue("select_file_size", jCommon.sizeTostr(dataDetail["size"]));
    jCommon.setHtmlValue("select_file_time", dataDetail["lastmodified"]);
    jCommon.setHtmlValue("select_file_desc", dataDetail["desc"]);
  }
}

window.setRecipeFilePage = function () {
  var currentRecipeName = jCommon.getHtmlValue("recipeName");
  var currentSelectFile = jCommon.getHtmlValue("currentFileName");
  var currentNumber = jCommon.getHtmlValue("currentNumber");
  var countNumber = document.querySelectorAll("#file-list .file-row").length;
  jCommon.setHtmlAttribute("btn-pre-file", "disabled", true);
  jCommon.setHtmlAttribute("btn-next-file", "disabled", true);
  if (currentRecipeName === currentSelectFile) {
    jCommon.setHtmlAttribute("delete", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("delete", "disabled", false);
  }
  if (currentNumber > 0) {
    jCommon.setHtmlAttribute("btn-pre-file", "disabled", false);
  }
  if (currentNumber < countNumber - 1) {
    jCommon.setHtmlAttribute("btn-next-file", "disabled", false);
  }
}
//recipe.html end

// system.html start
window.initSystemData = function (message) {
  jCommon.setHtmlValue("loopDomList", "");
  var systemList = message["systems"];
  var systemIndex = jCommon.getUrlParams("sys") - 1;
  var currentSystemData = systemList[systemIndex];
  var loopList = message["loops"];
  if (!jCommon.empty(currentSystemData["cycleEn"])) {
    jCommon.showSvgDom("system-cycles");
  } else {
    jCommon.hideSvgDom("system-cycles");
  }
  if (!jCommon.empty(currentSystemData["blowdownEn"])) {
    jCommon.showSvgDom("system-blowdown");
  } else {
    jCommon.hideSvgDom("system-blowdown");
  }
  jCommon.setHtmlValue("runGraphic", currentSystemData["runGraphic"]);
  jCommon.controlDOMShow("runGraphic");
  //svg
  if (currentSystemData["runGraphic"] === 0) {
    var generalSensorList = currentSystemData["runtime"]["sens"];
    var predefinedList = systemFeed.getPredefinedLoopList(message);
    var list = constVar.getTrendType();
    for (var index = 0; index < generalSensorList.length; index++) {
      var item = generalSensorList[index];
      for (var key in item) {
        jCommon.setHtmlValue("row-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("row-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/sens/" + index + "/" + key);
        jCommon.controlDOMShow("row-" + index + "-" + key);
      }
      jCommon.setHtmlValue("row-" + index + "-name", channelPage.getChannelInfo(item["chnType"], item["chn"], "name"));
      jCommon.controlDOMShow("row-" + index + "-type");
      jCommon.dropDownMenu({
        element: document.getElementById("row-" + index + '-typeLabel'),
        choices: list,
        defaultvalue: item["type"],
        callback: systemPageSelectCallback
      });
      jCommon.dropDownMenu({
        element: document.getElementById("row-" + index + '-pdLoopLabel'),
        choices: predefinedList,
        defaultvalue: item["pdLoop"],
        callback: systemFeed.predefinedLoopSelectCallback
      });
      systemFeed.setPredefinedMode("row-" + index + '-pd');
      channelPage.initChannelInput("row-" + index + "-chn", item["chnType"], item["chn"], "analog-digital");
    }
    systemFeed.getPreDefinedPDCUnits();
  } else if (currentSystemData["runGraphic"] === 1) {
    var boilerSensorList = currentSystemData["runtime"];
    //blowdown sensor
    var chnsBD = boilerSensorList["chnsBD"];
    chnsBD.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtBoiler-chnsBD-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtBoiler-chnsBD-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsBD/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtBoiler-chnsBD-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtBoiler-chnsBD-" + index + "-chn");
    })
    //FeedWater sensor
    var chnsFeedWater = boilerSensorList["chnsFeedWater"];
    chnsFeedWater.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtBoiler-chnsFeedWater-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtBoiler-chnsFeedWater-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsFeedWater/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtBoiler-chnsFeedWater-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtBoiler-chnsFeedWater-" + index + "-chn");
    })
    //Condensate sensor
    var chnsCondensate = boilerSensorList["chnsCondensate"];
    chnsCondensate.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtBoiler-chnsCondensate-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtBoiler-chnsCondensate-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsCondensate/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtBoiler-chnsCondensate-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtBoiler-chnsCondensate-" + index + "-chn");
    })
    //Steam
    var chnsSteam = boilerSensorList["chnsSteam"];
    chnsSteam.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtBoiler-chnsSteam-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtBoiler-chnsSteam-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsSteam/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtBoiler-chnsSteam-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtBoiler-chnsSteam-" + index + "-chn");
    })
    //make up
    var makeup = boilerSensorList["makeup"];
    for (var key in makeup) {
      jCommon.setHtmlValue("rtBoiler-makeup-" + key, makeup[key]);
      jCommon.setDataSaveProperty("rtBoiler-makeup-" + key, "/systems/" + systemIndex + "/runtime/makeup/" + key);
    }
    jCommon.sensorChannelInput({
      element: document.getElementById("rtBoiler-makeup-chnAnalogLabel"),
      defaultvalue: makeup["chnType"] + '-' + makeup["chn"],
      callback: systemSensorChannelInputCallback
    })
    setSystemSensorTitle("rtBoiler-makeup-chn");
  } else if (currentSystemData["runGraphic"] === 2) {
    var coolingSensorList = currentSystemData["runtime"];
    //return sensor
    var chnsRet = coolingSensorList["chnsRet"];
    chnsRet.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtCool-chnsRet-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtCool-chnsRet-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsRet/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtCool-chnsRet-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtCool-chnsRet-" + index + "-chn");
    })
    //supply sensor
    var chnsSupply = coolingSensorList["chnsSupply"];
    chnsSupply.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtCool-chnsSupply-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtCool-chnsSupply-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsSupply/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtCool-chnsSupply-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtCool-chnsSupply-" + index + "-chn");
    })
    //blowdown
    var chnsBD = coolingSensorList["chnsBD"];
    chnsBD.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtCool-chnsBD-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtCool-chnsBD-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsBD/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtCool-chnsBD-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtCool-chnsBD-" + index + "-chn");
    })
    //make up
    var chnsMakeup = coolingSensorList["chnsMakeup"];
    chnsMakeup.forEach(function (item, index) {
      for (var key in item) {
        jCommon.setHtmlValue("rtCool-chnsMakeup-" + index + "-" + key, item[key]);
        jCommon.setDataSaveProperty("rtCool-chnsMakeup-" + index + "-" + key, "/systems/" + systemIndex + "/runtime/chnsMakeup/" + index + "/" + key);
      }
      jCommon.sensorChannelInput({
        element: document.getElementById("rtCool-chnsMakeup-" + index + "-chnAnalogLabel"),
        defaultvalue: item["chnType"] + '-' + item["chn"],
        callback: systemSensorChannelInputCallback
      })
      setSystemSensorTitle("rtCool-chnsMakeup-" + index + "-chn");
    })
  }
  //loop item
  var feedList = currentSystemData["feeds"];
  if (!jCommon.empty(feedList)) {
    var itemList = [];
    var itemCount = 0;
    var bppcCount = 0;
    feedList.forEach(function (item) {
      if (!jCommon.empty(item["ctrlType"]) && item["display"]) {
        itemList.push(jCommon.getSvgLoopItem(loopList[item["loopIndex"]], item, itemCount, bppcCount, loopList[item["loopIndex"] - 1]));
        if (item["ctrlType"] == 7) {
          //bppc
          bppcCount++
        }
        itemCount++;
      }
    })
    jCommon.setHtmlValue("currentLoop", 0);
    jCommon.setHtmlValue("allNumber", itemCount);
    jCommon.setHtmlValue("loopDomList", itemList.join("") + '<div style="clear: both;"></div>');
    var domList = document.querySelectorAll(".loop-item");
    for (var index = 0; index < domList.length; index++) {
      var loopIndex = jCommon.getHtmlValue(domList[index].id);
      var defaultClass = "";
      var modeReq = jCommon.getHtmlValue(domList[index].id + "-modeReq");
      if (modeReq == 0) {
        defaultClass = "local-status local-status-Stop btn-enable"
      } else if (modeReq == 1) {
        defaultClass = "local-status local-status-Manual btn-enable"
      } else {
        defaultClass = "local-status local-status-Auto btn-enable"
      }
      jCommon.dropDownMenu({
        element: document.getElementById("item-" + index + '-modeReqLabel'),
        defaultClass: defaultClass,
        choices: constVar.getLoopMode(),
        defaultvalue: modeReq,
        callback: repeatAllPage.updateSelectValueData
      })
      var loopInfo = loopList[loopIndex];
      if (!jCommon.empty(loopInfo["upPercent"])) {
        var upPercentInfo = loopInfo["upPercent"];
        for (var key in upPercentInfo) {
          jCommon.setHtmlValue('item-' + index + '-upPercent-' + key, upPercentInfo[key]);
          jCommon.setClassListValue('item-' + index + '-upPercent-' + key, upPercentInfo[key]);
          jCommon.setDataSaveProperty('item-' + index + '-upPercent-' + key, "/loops/" + loopIndex + "/upPercent/" + key);
        }
        channelPage.setChannelConfig(upPercentInfo["chnType"], upPercentInfo["chn"], "upPercent-chn");
        jCommon.controlDOMShow('item-' + index + '-upPercent-dataType');
      }
      jCommon.controlDOMShow('item-' + index + '-upPercent-dataType');
      if (!jCommon.empty(loopInfo["rateManual"])) {
        var rateManualInfo = loopInfo["rateManual"];
        for (var key in rateManualInfo) {
          jCommon.setHtmlValue('item-' + index + '-rateManual-' + key, rateManualInfo[key]);
          jCommon.setClassListValue('item-' + index + '-rateManual-' + key, rateManualInfo[key]);
          jCommon.setDataSaveProperty('item-' + index + '-rateManual-' + key, "/loops/" + loopIndex + "/rateManual/" + key);
        }
        channelPage.setChannelConfig(rateManualInfo["chnType"], rateManualInfo["chn"], "rateManual-chn");
        jCommon.controlDOMShow('item-' + index + '-rateManual-dataType');
      }
      jCommon.controlDOMShow('item-' + index + '-rateManual-dataType');
    }
    controlSystemLoopPage();
  }
}

window.systemPageSelectCallback = function (value, id) {
  var splitArray = id.split("-");
  jCommon.setHtmlValue("row-" + splitArray[1] + "-type", value, function () {
    jCommon.controlDOMShow("row-" + splitArray[1] + "-type");
    jCommon.setHtmlValue("row-" + splitArray[1] + "-chn", 0);
    jCommon.setHtmlValue("row-" + splitArray[1] + "-chnType", 0);
    jCommon.setChannelInputValue("row-" + splitArray[1] + "-chnAnalogLabel", "");
    jCommon.setChannelInputValue("row-" + splitArray[1] + "-chnDigitalLabel", "");
    jCommon.setHtmlValue("row-" + splitArray[1] + "-name", "");
    jCommon.setDropDownMenuValueAndLabel("row-" + splitArray[1] + "-pdLoop", -1);
    jCommon.setDropDownMenuValueAndLabel("row-" + splitArray[1] + "-pdChn", 0);
    repeatAllPage.updateParameter("row-" + splitArray[1] + "-type");
  });
}

window.controlSystemLoopPage = function () {
  var currentLoop = jCommon.getHtmlValue("currentLoop");
  var allCount = jCommon.getHtmlValue("allNumber") - 5;
  if (currentLoop > 0) {
    jCommon.removeHtmlClass("#loopLeftPage", "hide");
  } else {
    jCommon.addHtmlClass("#loopLeftPage", "hide");
  }
  if (currentLoop < allCount) {
    jCommon.removeHtmlClass("#loopNextPage", "hide");
  } else {
    jCommon.addHtmlClass("#loopNextPage", "hide");
  }
  var loopOffsetDistance = 0 - currentLoop * 236;
  jCommon.setHtmlStyleAttribute("loopDomList", "marginLeft", loopOffsetDistance + "px");
}

window.systemPageClickPage = function (event) {
  repeatAllPage.clearEventClick(event);
  var currentLoop = jCommon.getHtmlValue("currentLoop");
  if (event.target.id === "loopNextPage") {
    jCommon.setHtmlValue("currentLoop", ++currentLoop);
    controlSystemLoopPage();
  } else if (event.target.id === "loopLeftPage") {
    jCommon.setHtmlValue("currentLoop", --currentLoop);
    controlSystemLoopPage();
  }
}

window.checkSystemInputValue = function () {
  if (arguments[0].startsWith("dialogChn-")) {
    var valueType = jCommon.getHtmlValue(arguments[0] + "Type");
    channelPage.setChannelTypeAndValueAndConfig(arguments[0], valueType, arguments[1]);
  }
  repeatAllPage.updateParameter(arguments[0]);
}

window.systemSensorChannelInputCallback = function (channel, keyId) {
  var domId = keyId.replace("AnalogLabel", "");
  jCommon.removeHtmlClass("#" + domId + "-liveDataLabel", "message-warning");
  jCommon.removeHtmlClass("#" + domId + "-liveDataLabel", "message-alarm");
  channelPage.setChannelTypeAndValueAndConfig(domId, channel[0], channel[1]);
  repeatAllPage.updateParameter(keyId);
  setSystemSensorTitle(domId);
}

window.setSystemSensorTitle = function (domChanId) {
  var chanType = jCommon.getHtmlValue(domChanId + "Type");
  var chan = jCommon.getHtmlValue(domChanId);
  var channelName = channelPage.getChannelInfo(chanType, chan, "name");
  if (channelName) {
    jCommon.setHtmlValue(domChanId + "-SensorTitle", channelName.substring(0, 4) + ":");
  } else {
    jCommon.setHtmlValue(domChanId + "-SensorTitle", jCommon.getHtmlAttriute(domChanId + "-SensorTitle", "default-title"));
  }
}
//system.html end

//analogdisplay.html start
window.initAnalogDisplayData = function (message) {
  jCommon.setHtmlValue("topCurrentIndex", 0);
  jCommon.setHtmlStyleAttribute("channeldisplaylist", "marginTop", "0px");
  var keyMap = constVar.getRevertChannelThumbnail();
  var list = [];
  var key = jCommon.getUrlParams("p");
  message[key].forEach(function (item, index) {
    if (item["displayEn"]) {
      list.push({
        channelType: keyMap[key],
        channel: index + 1
      })
    }
  })
  jCommon.setHtmlValue("allRowNumber", list.length);
  var listString = [];
  list.forEach(function (item, index) {
    listString.push(jCommon.getAnalogDisplayItem(item, index));
  })
  jCommon.setHtmlValue("channeldisplaylist", listString.join(""));
  list.forEach(function (item, index) {
    channelPage.initChannelInput("row-" + Number(index + 1) + "-Chn", item["channelType"], item["channel"], "analog", null, true);
    jCommon.controlDOMShow("row-" + Number(index + 1) + "-Chn");
  })
}

window.channeldisplayPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var lastCurrentIndex = jCommon.getHtmlValue("allRowNumber") - 12;
  var marginPosition = pageNavigate.rowAndPageClick(event.target.id, 12, lastCurrentIndex, 50);
  jCommon.setHtmlStyleAttribute("channeldisplaylist", "marginTop", marginPosition);
}
//analogdisplay.html end

//digitaldisplay.html start
window.initDigitalDisplayData = function (message) {
  jCommon.setHtmlValue("topCurrentIndex", 0);
  jCommon.setHtmlStyleAttribute("channeldisplaylist", "marginTop", "0px");
  var keyMap = constVar.getRevertChannelThumbnail();
  var list = [];
  var key = jCommon.getUrlParams("p");
  message[key].forEach(function (item, index) {
    if (item["displayEn"]) {
      list.push({
        chnType: keyMap[key],
        chn: index + 1,
        simEn: item["simEn"],
        simData_OP: item["simData_OP"],
      })
    }
  })
  jCommon.setHtmlValue("allRowNumber", list.length);
  var listString = [];
  list.forEach(function (item, index) {
    listString.push(jCommon.getDigitalDisplayItem(item, index));
  })
  jCommon.setHtmlValue("channeldisplaylist", listString.join(""));
  for (var index = 0; index < list.length; index++) {
    var item = list[index];
    for (var ckey in item) {
      jCommon.setHtmlValue("row-" + Number(index + 1) + "-" + ckey, item[ckey]);
    }
    jCommon.setDataSaveProperty("row-" + Number(index + 1) + "-simData_OP", "/" + key + "/" + Number(item["chn"] - 1) + "/simData_OP");
    channelPage.initChannelInput("row-" + Number(index + 1) + "-chn", item["chnType"], item["chn"], null, null, true);
    jCommon.controlDOMShow("row-" + Number(index + 1) + "-chn");
    jCommon.controlDOMShow("row-" + Number(index + 1) + "-simEn");
    channelPage.controlDigitalState("row-" + Number(index + 1) + "-simData_OP");
  }
}
window.digitalDisplayPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id.endsWith("simData_OP")) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      channelPage.controlDigitalState(event.target.id);
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}
//digitaldisplay.html end

//curveconfig.html curveruntime.html start
window.initCurveOverveiwData = function (list) {
  list.forEach(function (item, index) {
    var id = Number(index + 1);
    jCommon.setHtmlValue("curve&p=" + id, jCommon.empty(item["name"]) ? "Curve " + id + " Config" : item["name"]);
  })
}
//curveconfig.html curveruntime.html end

//curve.html curveview.html start
window.initCurveData = function (curvesList) {
  var currentPage = jCommon.getCurrentPage();
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentData = curvesList[currentIndex];
  jCommon.setDomElementValue(currentData, "/curves/" + currentIndex + "/");
  jCommon.setHtmlValue("yChnAnalogLabel", channelPage.getChannelInputLabel(currentData["yChnType"], currentData["yChn"]));
  if (currentPage === "curveview") {
    channelPage.setChannelConfig(currentData["xChnType"], currentData["xChn"], "xChn");
  } else {
    channelPage.initChannelInput("xChn", currentData["xChnType"], currentData["xChn"], "analog");
  }
  channelPage.setChannelConfig(currentData["yChnType"], currentData["yChn"], "yChn");
  var xysList = currentData["xys"];
  xysList.forEach(function (item, index) {
    var currentRow = index + 1;
    jCommon.setHtmlValue(currentRow + "-xs", item["x"]);
    jCommon.setDataSaveProperty(currentRow + "-xs", "/curves/" + currentIndex + "/xys/" + index + "/x");
    jCommon.setHtmlValue(currentRow + "-ys", item["y"]);
    jCommon.setDataSaveProperty(currentRow + "-ys", "/curves/" + currentIndex + "/xys/" + index + "/y");
  })
  jCommon.setHtmlAttribute("curveGraph", "href", "#curvegraph&p=" + Number(currentIndex + 1))
}
//curve.html curveview.html end

//curvegraph.html start
window.initCurveGraphData = function (curvesList) {
  var currentIndex = channelPage.getChannelKeyIndex("currentIndex");
  var currentData = curvesList[currentIndex];
  channelPage.setChannelConfig(currentData["xChnType"], currentData["xChn"], "xChn");
  channelPage.setChannelConfig(currentData["yChnType"], currentData["yChn"], "yChn");
  var xysList = currentData["xys"];
  var data = [];
  var dyGraphConfigInstance = dyGraphConfig.getDyGraphConfig();
  dyGraphConfigInstance.labels = ["X", "Y"];
  dyGraphConfigInstance.valueRange = [jCommon.getHtmlValue("yChn-min"), jCommon.getHtmlValue("yChn-max")];
  xysList.forEach(function (item) {
    data.push([item["x"], item["y"]]);
  })
  data.push([jCommon.getHtmlValue("xChn-max"), null]);
  new Dygraph(
    document.getElementById("dygraph-container"),
    data,
    dyGraphConfigInstance
  );
}
//curvegraph.html end

//modbus.html start
window.initModbusData = function (modbusList) {
  var DCSsList = modbusList["DCSs"];
  var rs485Info = modbusList["rs485"];
  jCommon.setHtmlValue("netType", modbusList["netType"]);
  jCommon.setDataSaveProperty("netType", "/modbus/netType");
  jCommon.setDomElementValue(rs485Info, "/modbus/rs485/");
  jCommon.dropDownMenu({
    element: document.getElementById("baudRateLabel"),
    choices: constVar.getModbusRS485BaudRate(),
    defaultvalue: rs485Info["baudRate"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("parityLabel"),
    choices: constVar.getModbusRS485Parity(),
    defaultvalue: rs485Info["parity"],
    callback: repeatAllPage.updateSelectValueData
  });
  for (var index = 0; index < DCSsList.length; index++) {
    var item = DCSsList[index];
    for (var key in item) {
      jCommon.setHtmlValue("DCS-" + index + "-" + key, item[key]);
      jCommon.controlDOMShow("DCS-" + index + "-" + key);
      jCommon.setDataSaveProperty("DCS-" + index + "-" + key, "/modbus/DCSs/" + index + "/" + key);
    }
    channelPage.initChannelInput("DCS-" + index + "-coLostDOChn", item["coLostDOChnType"], item["coLostDOChn"]);
    channelPage.initChannelInput("DCS-" + index + "-lostDOChn", item["lostDOChnType"], item["lostDOChn"]);
  }
  cmdlist.loadDCSInfo({
    "type": "ais",
    "channelIndex": 0,
    "netRawType": jCommon.getHtmlValue("dscValue")
  }, function (res) {
    var beatFromDCSList = res["beatFromDCS"];
    var beatToDCSList = res["beatToDCS"];
    beatFromDCSList.forEach(function (item, index) {
      jCommon.setHtmlValue("DCS-" + index + "-beatFromDCSValue", item);
      jCommon.setHtmlValue("DCS-" + index + "-beatToDCSValue", beatToDCSList[index]);
    })
  })
  jCommon.setHtmlValue("dscValue", 0);
  jCommon.controlDOMShow("dscValue");
  getListPortName(repeatAllPage.parameterData.probes.rs485.portName);
}

window.modbusPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var radioButton = ["netType", "stopBits", "portMode", "dataBits"];
  if (event.target.id.startsWith("btn-DCS-")) {
    var btnDSCList = document.getElementsByClassName("btn-dcslist");
    for (var index = 0; index < btnDSCList.length; index++) {
      var targetId = btnDSCList[index].getAttribute("id");
      jCommon.removeHtmlClass("#" + targetId, "active");
      if (targetId === event.target.id) {
        jCommon.addHtmlClass("#" + targetId, "active");
      }
    }
    jCommon.setHtmlValue("dscValue", event.target.id.replace("btn-DCS-", ""));
    jCommon.controlDOMShow("dscValue");
  } else if (event.target.id.endsWith("-coLostEnable") || event.target.id.endsWith("-lostEnabled") || radioButton.indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  } else if (event.target.id.endsWith("-keepLastState")) {
    jCommon.toogleSwitch(event.target.id);
    jCommon.controlDOMShow(event.target.id);
    repeatAllPage.updateParameter(event.target.id);
  } else if (event.target.id == "listProbe") {
    getListPortName(repeatAllPage.parameterData.probes.rs485.portName);
  }
}
//modbus.html end

//modbusdv.html start
window.initModbusDVData = function () {
  cmdlist.loadDCSInfo({
    "type": "ais",
    "channelIndex": 0,
    "netRawType": 0
  }, function (res) {
    var beatFromDCSList = res["beatFromDCS"];
    var beatToDCSList = res["beatToDCS"];
    beatFromDCSList.forEach(function (item, index) {
      jCommon.setHtmlValue("DCS-" + index + "-beatFromDCSValue", item);
      jCommon.setHtmlValue("DCS-" + index + "-beatToDCSValue", beatToDCSList[index]);
    })
  })
}
//modbusdv.html end

//overview.html start
window.initOverveiwData = function (message) {
  repeatAllPage.setControlTitle(message["controller"]);
  var systemList = message["systems"];
  var loopList = message["loops"];
  var html = [];
  var itemCount = 0;
  var modeBppc = [];
  var bppcCount = 0;
  systemList.forEach(function (systemItem, systemIndex) {
    if (!jCommon.empty(systemItem["feeds"])) {
      systemItem["feeds"].forEach(function (feedItem, feedIndex) {
        if (feedItem["ctrlType"] > 0 && feedItem["display"]) {
          var loopIndex = feedItem["loopIndex"];
          var loopInfo = loopList[loopIndex];
          // Start Row config and info
          html.push('<div class="row system-overview-row">');
          html.push('<input class="loop-item" type="hidden" id="item-' + itemCount + '" value="' + loopIndex + '" data-type="int">');
          html.push('<input type="hidden" id="item-' + itemCount + '-enable">');
          html.push('<input type="hidden" id="item-' + itemCount + '-configValid"/>');
          html.push('<div class="col-md-12">');
          // Loop Status Light
          html.push('<div class="col-md-04 text-center">')
          html.push('<span id="item-' + itemCount + '-loopstatus" class="iconfont font-size-30">&#xe669;</span>');
          html.push('</div>');
          // System name
          html.push('<div class="col-md-2-1">');
          html.push('<div class="input-group">');
          html.push('<a class="btn btn-default btn-redirect" href="#system&sys=' + Number(systemIndex + 1) + '&name=' + systemItem["name"] + '">');
          html.push(systemItem["name"]);
          html.push('</a>');
          html.push('</div>');
          html.push('</div>');
          // Deed name
          html.push('<div class="col-md-3-5">');
          html.push('<div class="dom-container input-group">');
          html.push('<a class="btn btn-default btn-redirect" id="item-' + itemCount + '-feedname" href="' + systemFeed.getControlTypeTimeUrl(feedItem["ctrlType"], systemIndex, feedIndex, loopIndex) + '&sysname=' + systemItem["name"] + '">');
          html.push(feedItem["name"]);
          html.push('</a>');
          html.push('</div>');
          html.push('</div>');
          // Loop Set-Point Input
          html.push('<div class="col-md-1">');
          var inputValueClass = '<div>';
          if (loopInfo["ctrlType"] !== 7 && loopInfo["sp"] && loopInfo["sp"]["dataType"] === 1 && loopInfo["sp"]["chn"] === 0) {
            inputValueClass = '<div class="hide">';
          }
          html.push(inputValueClass);
          html.push(systemFeed.getLoopSetPointDomValueItem(loopInfo, loopIndex, itemCount, bppcCount));
          html.push('</div>');
          html.push('</div>');
          // Loop Set-Point Unit
          html.push('<div class="col-md-1">');
          html.push(systemFeed.getLoopSetPointDomUnitItem(loopInfo, bppcCount, loopList[loopIndex - 1]));
          html.push('</div>');
          // PV
          html.push('<div class="col-md-1">');
          html.push(systemFeed.getLoopSetPointDomPVItem(loopInfo, loopIndex, itemCount));
          html.push('</div>');
          // Mode
          html.push('<div class="col-md-1">');
          html.push('<div id="item-' + itemCount + '-modeContainer">');
          html.push(systemFeed.getLoopSetPointDomModeItem(loopInfo, loopIndex, itemCount));
          html.push('</div>');
          html.push('</div>');
          // Manual Rate
          html.push('<div class="col-md-1 tttt">');
          html.push(systemFeed.getLoopSetPointRateMan(loopInfo, loopIndex, itemCount, bppcCount));
          html.push('</div>');
          // feedDevice Unit
          html.push('<div class="col-md-1">');
          html.push(systemFeed.getLoopSetPointUnit(loopInfo));
          html.push('</div>');
          html.push('</div>'); // End Row config and info
          html.push('</div>'); // End Row config and info
          if (feedItem["ctrlType"] === 7) {
            modeBppc.push(itemCount);
          }
          itemCount++;
          if (feedItem["ctrlType"] == 7) {
            bppcCount++;
          }
        }
      })
    }
  })
  jCommon.setHtmlValue("topCurrentIndex", 0);
  jCommon.setHtmlStyleAttribute("system-config-list", "marginTop", "0px");
  jCommon.setHtmlValue("system-config-list", html.join(""));
  if (document.getElementsByClassName("system-overview-row").length > 0) {
    jCommon.removeHtmlClass("#page-container", "hide");
  } else {
    jCommon.addHtmlClass("#page-container", "hide");
  }
  jCommon.setHtmlValue("lastIndex", Math.floor(document.getElementsByClassName("system-overview-row").length / 16) * 16);
  modeBppc.forEach(function (item, index) {
    if (index % 2 === 1) {
      jCommon.addHtmlClass("#item-" + item + "-modeContainer", "hide");
      jCommon.addHtmlClass("#item-" + item + "-feedname", "btn-disabled");
      jCommon.setHtmlAttribute("item-" + item + "-feedname", "href", "javascript:void(0)");
    }
  })
  itemCount = 0;
  systemList.forEach(function (systemItem) {
    if (!jCommon.empty(systemItem["feeds"])) {
      systemItem["feeds"].forEach(function (feedItem) {
        if (feedItem["ctrlType"] > 0 && feedItem["display"]) {
          var loopIndex = feedItem["loopIndex"];
          var loopInfo = loopList[loopIndex];
          var defaultClass = "";
          if (loopInfo["modeReq"] == 0) {
            defaultClass = "local-status local-status-Stop btn-enable"
          } else if (loopInfo["modeReq"] == 1) {
            defaultClass = "local-status local-status-Manual btn-enable"
          } else {
            defaultClass = "local-status local-status-Auto btn-enable"
          }
          jCommon.dropDownMenu({
            element: document.getElementById('item-' + itemCount + '-modeReqLabel'),
            defaultClass: defaultClass,
            choices: constVar.getLoopMode(),
            defaultvalue: loopInfo["modeReq"],
            callback: changeOverviewMode
          })
          channelPage.initChannelInput('item-' + itemCount + '-pvChn', loopInfo["pvChnType"], loopInfo["pvChn"], "analog");
          if (!jCommon.empty(loopInfo["upPercent"])) {
            var upPercentInfo = loopInfo["upPercent"];
            for (var key in upPercentInfo) {
              jCommon.setHtmlValue('item-' + itemCount + '-upPercent-' + key, upPercentInfo[key]);
              jCommon.setClassListValue('item-' + itemCount + '-upPercent-' + key, upPercentInfo[key]);
              jCommon.setDataSaveProperty('item-' + itemCount + '-upPercent-' + key, "/loops/" + loopIndex + "/upPercent/" + key);
            }
            channelPage.setChannelConfig(upPercentInfo["chnType"], upPercentInfo["chn"], "upPercent-chn");
            jCommon.controlDOMShow('item-' + itemCount + '-upPercent-dataType');
          }
          jCommon.controlDOMShow('item-' + itemCount + '-upPercent-dataType');
          if (!jCommon.empty(loopInfo["rateManual"])) {
            var rateManualInfo = loopInfo["rateManual"];
            for (var key in rateManualInfo) {
              jCommon.setHtmlValue('item-' + itemCount + '-rateManual-' + key, rateManualInfo[key]);
              jCommon.setClassListValue('item-' + itemCount + '-rateManual-' + key, rateManualInfo[key]);
              jCommon.setDataSaveProperty('item-' + itemCount + '-rateManual-' + key, "/loops/" + loopIndex + "/rateManual/" + key);
            }
            channelPage.setChannelConfig(rateManualInfo["chnType"], rateManualInfo["chn"], "rateManual-chn");
            jCommon.controlDOMShow('item-' + itemCount + '-rateManual-dataType');
          }
          jCommon.controlDOMShow('item-' + itemCount + '-rateManual-dataType');
          itemCount++;
        }
      })
    }
  })
  // 3b3h
  var analyzer_3CInfo = message["analyzer_3C"];
  jCommon.setHtmlValue("installed", analyzer_3CInfo["installed"])
  jCommon.controlDOMShow("installed");
  window.init3b3hrtimePage(message["analyzer_3C"]);
}
window.changeOverviewMode = function (detail, id) {
  var dom = document.getElementById(id).querySelector(".local-status");
  jCommon.removeDomClass(dom, "local-status-Stop");
  jCommon.removeDomClass(dom, "local-status-Auto");
  jCommon.removeDomClass(dom, "local-status-Manual");
  if (detail == 0) {
    jCommon.addDomClass(dom, "local-status-Stop");
  } else if (detail == 1) {
    jCommon.addDomClass(dom, "local-status-Manual");
  } else {
    jCommon.addDomClass(dom, "local-status-Auto");
  }
  repeatAllPage.updateSelectValueData(detail, id);
}

window.controlOverviewListPosition = function (event) {
  repeatAllPage.clearEventClick(event);
  var marginPosition = pageNavigate.rowAndPageClick(event.target.id, 16, jCommon.getHtmlValue("lastIndex"), 45);
  jCommon.setHtmlStyleAttribute("system-config-list", "marginTop", marginPosition);
}
//overview.html end

//ratiotime.html start
window.initRatioTimeData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var processTypeList = constVar.getProcessType();
  processTypeList.forEach(function (item) {
    if (item["value"] === loopInfo["processType"]) {
      jCommon.setClassListValue("processTypeLabel", item["name"]);
    }
  })
  var feedDeviceInfo = loopInfo["fdDevice"];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  jCommon.setHtmlValue("actionLabel", loopInfo["action"] ? "Reverse" : "Direct");
  systemFeed.initRunTimeConstantChannel(loopInfo);
  channelPage.setChannelConfig(loopInfo["pvChnType"], loopInfo["pvChn"], "pvChn");
  jCommon.setHtmlValue("pvChnAnalogLabel", channelPage.getChannelInputLabel(loopInfo["pvChnType"], loopInfo["pvChn"]));
  jCommon.setHtmlValue("pvChnName", channelPage.getChannelInfo(loopInfo["pvChnType"], loopInfo["pvChn"], "name"));
  systemFeed.initRunTimeFeedDevice(feedDeviceInfo);
}

window.ratiotimePageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id === "localEn") {
    systemFeed.btnLocalEnTimeClick();
  } else if (event.target.id === "flowmeterCtrl-correctOn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//ratiotime.html end

//pidtime.html start
window.initPidTimeData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var feedDeviceInfo = loopInfo["fdDevice"];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  var pidInfo = message["plc"]["pids"][loopInfo["pid4Ctrl"]["pidIndex"]];
  jCommon.setHtmlValue("actionLabel", pidInfo["direct"] ? "Reverse" : "Direct");
  systemFeed.initRunTimeConstantChannel(loopInfo);
  channelPage.setChannelConfig(loopInfo["pvChnType"], loopInfo["pvChn"], "pvChn");
  jCommon.setHtmlValue("pvChnAnalogLabel", channelPage.getChannelInputLabel(loopInfo["pvChnType"], loopInfo["pvChn"]));
  jCommon.setHtmlValue("pvChnName", channelPage.getChannelInfo(loopInfo["pvChnType"], loopInfo["pvChn"], "name"));
  systemFeed.initRunTimeFeedDevice(feedDeviceInfo);
}

window.pidtimePageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id === "localEn") {
    systemFeed.btnLocalEnTimeClick();
  } else if (event.target.id === "flowmeterCtrl-correctOn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//pidtime.html end

//scheduletime.html start
window.initScheduleTimeData = function (message, data) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var systemIndex = Number(jCommon.getUrlParams("system")) - 1;
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  var predefinedList = systemFeed.getPredefinedLoopList(message, systemIndex);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  var preBleedList = constVar.getSchedulePreBleed();
  preBleedList.forEach(function (item) {
    if (item["value"] === loopInfo["prebleed"]) {
      jCommon.setHtmlValue("prebleedLabel", item["name"]);
    }
  })
  jCommon.setHtmlValue("condChnAnalogLabel", channelPage.getChannelInputLabel(loopInfo["condChnType"], loopInfo["condChn"]));
  predefinedList.forEach(function (item) {
    if (item["value"] === loopInfo["postFeedLoopIndex"]) {
      jCommon.setHtmlValue("postFeedLoopIndexLabel", item["name"]);
    }
    if (item["value"] === loopInfo["preFeedLoopIndex"]) {
      jCommon.setHtmlValue("preFeedLoopIndexLabel", item["name"]);
    }
  })
  var weekNumList = constVar.getScheduleWeek();
  weekNumList.forEach(function (item) {
    if (item["value"] === loopInfo["weekNum"]) {
      jCommon.setHtmlValue("weekNumLabel", item["name"]);
    }
  })
  initScheduleTableData(loopInfo, data);
}
//scheduletime.html end

//intervaltime.html start
window.initIntervalTimeData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var systemIndex = Number(jCommon.getUrlParams("system")) - 1;
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  var predefinedList = systemFeed.getPredefinedLoopList(message, systemIndex);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  var preBleedList = constVar.getSchedulePreBleed();
  preBleedList.forEach(function (item) {
    if (item["value"] === loopInfo["prebleed"]) {
      jCommon.setHtmlValue("prebleedLabel", item["name"]);
    }
  })
  jCommon.setHtmlValue("condChnAnalogLabel", channelPage.getChannelInputLabel(loopInfo["condChnType"], loopInfo["condChn"]));
  predefinedList.forEach(function (item) {
    if (item["value"] === loopInfo["postFeedLoopIndex"]) {
      jCommon.setHtmlValue("postFeedLoopIndexLabel", item["name"]);
    }
    if (item["value"] === loopInfo["preFeedLoopIndex"]) {
      jCommon.setHtmlValue("preFeedLoopIndexLabel", item["name"]);
    }
  })
  initIntervalTableData(loopInfo);
}
//intervaltime.html end

//pdc.html start
window.inintPDCData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var systemIndex = Number(jCommon.getUrlParams("system")) - 1;
  var systemInfo = message["systems"][systemIndex];
  jCommon.setDomElementValue(systemInfo);
  var loopInfo = loopList[loopIndex];
  var processTypeList = constVar.getProcessType();
  processTypeList.forEach(function (item) {
    if (item["value"] === loopInfo["processType"]) {
      jCommon.setClassListValue("processTypeLabel", item["name"]);
    }
  })
  var spInfo = loopInfo["sp"];
  for (var key in spInfo) {
    jCommon.setHtmlValue("sp-" + key, spInfo[key]);
    jCommon.setClassListValue("sp-" + key, spInfo[key]);
  }
  channelPage.setChannelConfig(spInfo["chnType"], spInfo["chn"], "sp-chn");
  jCommon.controlDOMShow("sp-chn");
  jCommon.controlDOMShow("sp-dataType");
  var feedDeviceInfo = loopInfo["fdDevice"];
  var fdvInfo = feedDeviceInfo["fdv"];
  for (var key in feedDeviceInfo) {
    jCommon.setHtmlValue(key, feedDeviceInfo[key]);
  }
  jCommon.controlDOMShow("fdvType");
  if (feedDeviceInfo["fdvType"] === 2) {
    jCommon.setHtmlValue("flowmeterCtrl-correctOn", fdvInfo["correctOn"]);
  } else {
    jCommon.setHtmlValue("flowmeterCtrl-correctOn", false);
  }
}
//pdc.html end

//onoff.html start
window.inintOnOffData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  channelPage.initChannelInput("pvChn", loopInfo["pvChnType"], loopInfo["pvChn"], "analog");
  systemFeed.initConstantChannel(loopInfo);
}

window.systemOnOffControlClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (["localEn", "sp-dataType", "rateManual-dataType", "fallback-dataType", "deadband-dataType", "timeoutEn", "action"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//onoff.html end

//onofftime.html start
window.initOnOffTimeData = function (message) {
  var actionList = ["Direct", "Reverse"];
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var feedDeviceInfo = loopInfo["fdDevice"];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.setHtmlValue("actionLabel", actionList[loopInfo["action"]]);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  systemFeed.initRunTimeConstantChannel(loopInfo);
  channelPage.setChannelConfig(loopInfo["pvChnType"], loopInfo["pvChn"], "pvChn");
  jCommon.setHtmlValue("pvChnAnalogLabel", channelPage.getChannelInputLabel(loopInfo["pvChnType"], loopInfo["pvChn"]));
  jCommon.setHtmlValue("pvChnName", channelPage.getChannelInfo(loopInfo["pvChnType"], loopInfo["pvChn"], "name"));
  systemFeed.initRunTimeFeedDevice(feedDeviceInfo);
}

window.onofftimePageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id === "localEn") {
    systemFeed.btnLocalEnTimeClick();
  } else if (event.target.id === "flowmeterCtrl-correctOn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//onofftime.html end

//pfc.html start
window.inintPFCData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  channelPage.initChannelInput("pvChn", loopInfo["pvChnType"], loopInfo["pvChn"], "analog");
  systemFeed.initConstantChannel(loopInfo);
}

window.systemPFCControlClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (["localEn", "rateManual-dataType", "fallback-dataType"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//pfc.html end

//smtp.html start
window.initSMTPData = function (emailInfo) {
  var initInfo = emailInfo["hosts"][emailInfo["idxSel"]];
  jCommon.setDomElementValue(initInfo);
  jCommon.setHtmlValue("idxSel", emailInfo["idxSel"]);
  jCommon.setDataSaveProperty("idxSel", "/setup/smtp/idxSel");
  var hostList = emailInfo["hosts"];
  for (var index = 0; index < hostList.length; index++) {
    var hostItem = hostList[index];
    for (var key in hostItem) {
      jCommon.setHtmlValue("hosts-" + index + "-" + key, hostItem[key]);
      jCommon.setDataSaveProperty("hosts-" + index + "-" + key, "/setup/smtp/hosts/" + index + "/" + key);
    }
  }
  var defultInfo = emailInfo["hosts"][0];
  jCommon.setHtmlValue("default-smtp-label", defultInfo["host"]);
  jCommon.setHtmlValue("customPort", jCommon.getHtmlValue("hosts-" + emailInfo["idxSel"] + "-port"));
  jCommon.setHtmlAttribute("other-smtp-label", "default-value", emailInfo["hosts"][1]["host"])
}

window.checkSmtpInputValue = function (elementId, newValue, OldValue) {
  if (elementId === "other-smtp-label") {
    jCommon.setHtmlValue("hosts-1-host", newValue);
    setSMTPHostPort(1)
  } else {
    var idxSel = jCommon.getHtmlValue("idxSel");
    jCommon.setHtmlValue("hosts-" + idxSel + "-port", newValue);
    repeatAllPage.updateParameter("hosts-" + idxSel + "-port");
    jCommon.setHtmlValue("port", newValue);
  }
}

window.smtpPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  setSMTPHostPort(0);
}

window.setSMTPHostPort = function (index) {
  jCommon.setHtmlValue("idxSel", index);
  jCommon.setHtmlValue("host", jCommon.getHtmlValue("hosts-" + index + "-host"));
  jCommon.setHtmlValue("port", jCommon.getHtmlValue("hosts-" + index + "-port"));
  jCommon.setHtmlValue("customPort", jCommon.getHtmlValue("hosts-" + index + "-port"));
  repeatAllPage.updateParameter("idxSel");
}
//smtp.html end

//pid.html start
window.inintPidData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  channelPage.initChannelInput("pvChn", loopInfo["pvChnType"], loopInfo["pvChn"], "analog");
  systemFeed.initConstantChannel(loopInfo);
  systemFeed.initPidData(message["plc"]["pids"], loopInfo["pid4Ctrl"]["pidIndex"]);
  jCommon.setHtmlValue("timeout", Number(loopInfo["timeout"] / 60).toFixed(0));
}

window.systemPidControlClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (["localEn", "sp-dataType", "rateManual-dataType", "fallback-dataType", "deadband-dataType", "timeoutEn", "pid-direct"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    })
  } else if (event.target.id === "cmdReset") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id, function () {
        jCommon.setRadioButtonValue(event.target.id);
      });
    })
  }
}
//pid.html end

//pidloop.html start
window.initPidloopData = function (message) {
  //pid 2
  var pidList = message["plc"]["pids"];
  for (var index = 0; index < pidList.length; index++) {
    jCommon.setHtmlValue("pid-" + Number(index + 1) + "-name", pidList[index]["name"])
  }
}
//pidloop.html end

//pidauto.html start
window.initPidAutoData = function (message) {
  var currentPage = Number(jCommon.getUrlParams("p"));
  var pIndex = currentPage - 1;
  var pidInfo = message["plc"]["pids"][pIndex];
  jCommon.setHtmlValue("pidIndex", currentPage);
  jCommon.setDomElementValue(pidInfo, "/plc/pids/" + pIndex + "/");
  jCommon.setHtmlValue("actionName", pidInfo["direct"] ? "Reverse" : "Direct");
  jCommon.dropDownMenu({
    element: document.getElementById('modeReqLabel'),
    choices: constVar.getLoopMode(),
    defaultvalue: pidInfo["modeReq"],
    callback: repeatAllPage.updateSelectValueData
  });
  var tuneEn_OP = jCommon.getHtmlValue("tuneEn_OP");
  if (tuneEn_OP) {
    jCommon.setHtmlAttribute("init_OP", "disabled", false);
    jCommon.setHtmlAttribute("autoTune_OP", "disabled", false);
  } else {
    jCommon.setHtmlAttribute("init_OP", "disabled", true);
    jCommon.setHtmlAttribute("autoTune_OP", "disabled", true);
  }
}

window.pidAutoPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var radioButton = ["tuneEn_OP", "init_OP", "autoTune_OP", "autoMode_OP"];
  if (radioButton.indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "tuneEn_OP") {
        repeatAllPage.updateParameter(event.target.id);
      } else {
        repeatAllPage.updateParameter(event.target.id);
      }
    })
  }
}
//pidauto.html end

//redundantpump.html start
window.initRedundantpumpData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopIndex = jCommon.getUrlParams("Lp") - 1;
  var loopInfo = message["loops"][loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  var list = constVar.getFeedDevicesType(jCommon.getHtmlValue("feed-control-Type"));
  list.forEach(function (item) {
    if (item["value"] === loopInfo["feedDeviceType"]) {
      jCommon.setClassListValue("feedDeviceTypeLabel", item["name"]);
    }
  })
  var feedDeviceInfo = message["loops"][loopIndex]["fdDevice"];
  jCommon.setDomElementValue(feedDeviceInfo, "/loops/" + loopIndex + "/fdDevice/");
  //to do SP
  var redundantPumpInfo = feedDeviceInfo["rdtPump"];
  var primaryFDInfo = redundantPumpInfo["primaryFD"];
  jCommon.setDomElementValue(redundantPumpInfo, "/loops/" + loopIndex + "/fdDevice/rdtPump/");

  channelPage.controlDigitalState("SpareEn");
  for (var key in primaryFDInfo) {
    jCommon.setHtmlValue("primaryFD-" + key + "-chn", primaryFDInfo[key]["chn"]);
    jCommon.setDataSaveProperty("primaryFD-" + key + "-chn", "/loops/" + loopIndex + "/fdDevice/rdtPump/primaryFD/" + key + "/chn");
    jCommon.setHtmlValue("primaryFD-" + key + "-chnType", primaryFDInfo[key]["chnType"]);
    jCommon.setDataSaveProperty("primaryFD-" + key + "-chnType", "/loops/" + loopIndex + "/fdDevice/rdtPump/primaryFD/" + key + "/chnType");
  }
  jCommon.setHtmlValue("primaryFD-enable", primaryFDInfo["enable"]);
  jCommon.setDataSaveProperty("primaryFD-enable", "/loops/" + loopIndex + "/fdDevice/rdtPump/primaryFD/enable");
  channelPage.controlDigitalState("primaryFD-enable");
  channelPage.initChannelInput("primaryFD-outputChn-chn", primaryFDInfo["outputChn"]["chnType"], primaryFDInfo["outputChn"]["chn"], "analog-digital");
  channelPage.initChannelInput("primaryFD-digitChn-chn", primaryFDInfo["digitChn"]["chnType"], primaryFDInfo["outputChn"]["chn"], "analog");
  channelPage.initChannelInput("primaryFD-autoChn-chn", primaryFDInfo["autoChn"]["chnType"], primaryFDInfo["outputChn"]["chn"]);
  channelPage.initChannelInput("primaryFD-handChn-chn", primaryFDInfo["handChn"]["chnType"], primaryFDInfo["outputChn"]["chn"]);
  var spareFDInfo = redundantPumpInfo["spareFD"];
  for (var key in spareFDInfo) {
    jCommon.setHtmlValue("spareFD-" + key + "-chn", spareFDInfo[key]["chn"]);
    jCommon.setDataSaveProperty("spareFD-" + key + "-chn", "/loops/" + loopIndex + "/fdDevice/rdtPump/spareFD/" + key + "/chn");
    jCommon.setHtmlValue("spareFD-" + key + "-chnType", spareFDInfo[key]["chnType"]);
    jCommon.setDataSaveProperty("spareFD-" + key + "-chnType", "/loops/" + loopIndex + "/fdDevice/rdtPump/spareFD/" + key + "/chnType");
  }
  jCommon.setHtmlValue("spareFD-enable", spareFDInfo["enable"]);
  jCommon.setDataSaveProperty("spareFD-enable", "/loops/" + loopIndex + "/fdDevice/rdtPump/spareFD/enable");
  channelPage.controlDigitalState("spareFD-enable");
  channelPage.initChannelInput("spareFD-outputChn-chn", spareFDInfo["outputChn"]["chnType"], spareFDInfo["outputChn"]["chn"], "analog-digital");
  channelPage.initChannelInput("spareFD-digitChn-chn", spareFDInfo["digitChn"]["chnType"], spareFDInfo["outputChn"]["chn"], "analog");
  channelPage.initChannelInput("spareFD-autoChn-chn", spareFDInfo["autoChn"]["chnType"], spareFDInfo["outputChn"]["chn"]);
  channelPage.initChannelInput("spareFD-handChn-chn", spareFDInfo["handChn"]["chnType"], spareFDInfo["outputChn"]["chn"]);
  jCommon.pickerTime({
    element: document.getElementById('startHHMMLabel'),
    defaultvalue: redundantPumpInfo["startHHMM"],
    timeZone: 24,
    callback: repeatAllPage.updateSelectValueData
  });
  setRedundantpumpFeedDeviceTypeOutPutProperty();
}

window.setRedundantpumpFeedDeviceTypeOutPutProperty = function () {
  var feedDeviceType = jCommon.getHtmlValue("feedDeviceType");
  var onoffdisabled = systemFeed.getFeedDeviceChannelRange("OnOffCVOutputChannel");
  var pulsedisabled = systemFeed.getFeedDeviceChannelRange("PulseCVOutputChannel");
  var analogdisabled = systemFeed.getFeedDeviceChannelRange("analogCVOutputChannel");
  var timedisabled = systemFeed.getFeedDeviceChannelRange("TimeCVOutputChannel");
  if (feedDeviceType === 3) {
    jCommon.setHtmlAttribute("primaryFD-outputChn-chnDigitalLabel", "data-disabled", onoffdisabled);
    jCommon.setHtmlAttribute("spareFD-outputChn-chnDigitalLabel", "data-disabled", onoffdisabled);
  } else if (feedDeviceType === 2) {
    jCommon.setHtmlAttribute("primaryFD-outputChn-chnDigitalLabel", "data-disabled", pulsedisabled);
    jCommon.setHtmlAttribute("spareFD-outputChn-chnDigitalLabel", "data-disabled", pulsedisabled);
  } else if (feedDeviceType === 1) {
    jCommon.setHtmlAttribute("primaryFD-outputChn-chnAnalogLabel", "data-disabled", analogdisabled);
    jCommon.setHtmlAttribute("spareFD-outputChn-chnAnalogLabel", "data-disabled", analogdisabled);
  } else if (feedDeviceType === 4) {
    jCommon.setHtmlAttribute("primaryFD-outputChn-chnDigitalLabel", "data-disabled", timedisabled);
    jCommon.setHtmlAttribute("spareFD-outputChn-chnDigitalLabel", "data-disabled", timedisabled);
  }
}

window.redundantpumpPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return false;
  }
  if (["primaryFD-enable", "spareFD-enable"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      channelPage.controlDigitalState(event.target.id);
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//redundantpump.html end

//monitor.html start
window.initMonitorData = function (message) {
  jCommon.removeHtmlClass(".monitor-setup", "hide");
  jCommon.addHtmlClass(".monitor-overview", "hide");
  repeatAllPage.setControlTitle(message["controller"]);
  var predefinedList = systemFeed.getPredefinedLoopList(message);
  var list = constVar.getMonitorType();
  var messageList = message["systems"];
  for (var sysIdx = 0; sysIdx < messageList.length; sysIdx++) { // each system, sysIdx = 0 to 3
    var sysElement = messageList[sysIdx];
    for (var idx = 0; idx < sysElement["monitor"].length; idx++) { // each monitor element in the system, idx = 0 to 14
      var monitorItem = sysElement["monitor"][idx];
      for (var key in monitorItem) { // actual monitor key item such as type/chn etc.
        jCommon.setHtmlValue("systems-" + sysIdx + "-monitor-" + idx + "-" + key, monitorItem[key]);
        jCommon.setDataSaveProperty("systems-" + sysIdx + "-monitor-" + idx + "-" + key, "/systems/" + sysIdx + "/monitor/" + idx + "/" + key);
        jCommon.controlDOMShow("systems-" + sysIdx + "-monitor-" + idx + "-" + key);
      }
      jCommon.dropDownMenu({
        element: document.getElementById("systems-" + sysIdx + "-monitor-" + idx + '-typeLabel'),
        choices: list,
        defaultvalue: monitorItem["type"],
        callback: systemFeed.resetPreDiAnData
      });
      jCommon.dropDownMenu({
        element: document.getElementById("systems-" + sysIdx + "-monitor-" + idx + '-pdLoopLabel'),
        choices: predefinedList,
        defaultvalue: monitorItem["pdLoop"],
        callback: systemFeed.predefinedLoopSelectCallback
      });
      systemFeed.setPredefinedMode("systems-" + sysIdx + "-monitor-" + idx + '-pd');
      channelPage.initChannelInput("systems-" + sysIdx + "-monitor-" + idx + "-chn", monitorItem["chnType"], monitorItem["chn"], "analog-digital");
    }
  }
}

window.checkMonitorInputValue = function () {
  if (arguments[0].endsWith("Label-ch")) {
    var valueType = document.querySelector("input[name='" + arguments[0] + "Type']:checked").value;
    channelPage.setChannelTypeAndValueAndConfig(arguments[0], valueType, arguments[1]);
  } else {
    repeatAllPage.updateParameter(arguments[0]);
  }
}

window.monitorClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return false;
  }
  var id = event.target.id.split("-");
  jCommon.setHtmlValue("systems", id[1]);
  jCommon.controlDOMShow("systems");
  jCommon.removeHtmlClass("#monitorSetupDialog", "hide");
}

window.monitoDialogClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var systemValue = jCommon.getHtmlValue("systems");
  if (["btn-pre", "btn-next"].indexOf(event.target.id) > -1) {
    if (event.target.id === "btn-pre") {
      systemValue--;
    } else if (event.target.id === "btn-next") {
      systemValue++;
    }
    jCommon.setHtmlValue("systems", systemValue);
    jCommon.controlDOMShow("systems");
  } else if (event.target.id === "close-MonitorSetupDialog") {
    jCommon.addHtmlClass("#monitorSetupDialog", "hide");
  }
}

window.monitorPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return false;
  }
  if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id, "noLoginState")) {
    userlogin.showLoginDialog();
    return false;
  }
  if (event.target.id.endsWith("-simData_OP")) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      channelPage.controlDigitalState(event.target.id);
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}
//monitor.html end

//pfctime.html start
window.initPFCTimeData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var feedDeviceInfo = loopInfo["fdDevice"];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  jCommon.setHtmlValue("actionLabel", loopInfo["action"] ? "Reverse" : "Direct");//translation
  systemFeed.initRunTimeConstantChannel(loopInfo);
  channelPage.setChannelConfig(loopInfo["pvChnType"], loopInfo["pvChn"], "pvChn");
  jCommon.setHtmlValue("pvChnAnalogLabel", channelPage.getChannelInputLabel(loopInfo["pvChnType"], loopInfo["pvChn"]));
  jCommon.setHtmlValue("pvChnName", channelPage.getChannelInfo(loopInfo["pvChnType"], loopInfo["pvChn"], "name"));
  systemFeed.initRunTimeFeedDevice(feedDeviceInfo);
}
//pfctime.html end

//ogolanalog.html start
window.initOgolAnalogData = function (message) {
  var ogolAnalogList = message["setup"]["ogol"]["analogPlus"];
  var analogFreq = message["setup"]["ogol"]["analogFreq"];
  var rowNumber = ogolAnalogList.length;
  jCommon.setHtmlValue("topCurrentIndex", 0);
  jCommon.setHtmlStyleAttribute("ogolanalog-list", "marginTop", "0px");
  jCommon.setHtmlValue("ogolanalog-list", jCommon.getPreAnalogDigitalHtml(rowNumber));
  var predefinedList = systemFeed.getPredefinedLoopList(message);
  var list = constVar.getEmailAlarmAnalogType();
  for (var index = 0; index < ogolAnalogList.length; index++) {
    var item = ogolAnalogList[index];
    for (var key in item) {
      jCommon.setHtmlValue("row-" + index + "-" + key, item[key]);
      jCommon.setDataSaveProperty("row-" + index + "-" + key, "/setup/ogol/analogPlus/" + index + "/" + key);
    }
    jCommon.setHtmlValue("row-" + index + "-analogFreq", analogFreq[index]);
    jCommon.setDataSaveProperty("row-" + index + "-analogFreq", "/setup/ogol/analogFreq/" + index + "/");
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-typeLabel'),
      choices: list,
      defaultvalue: item["type"],
      callback: systemFeed.resetPreDiAnData
    });
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-pdLoopLabel'),
      choices: predefinedList,
      defaultvalue: item["pdLoop"],
      callback: systemFeed.predefinedLoopSelectCallback
    });
    systemFeed.setPredefinedMode("row-" + index + '-pd');
    channelPage.initChannelInput("row-" + index + "-chn", item["chnType"], item["chn"], "analog");
    jCommon.setHtmlValue("row-" + index + '-name', channelPage.getChannelInfo(item["chnType"], item["chn"], "name"))
    jCommon.controlDOMShow("row-" + index + '-type');
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-analogFreqLabel'),
      choices: constVar.getOgolanalogFreq(),
      defaultvalue: analogFreq[index],
      callback: repeatAllPage.updateSelectValueData
    });
  }
}
window.controlOgolanalogListPosition = function (event) {
  repeatAllPage.clearEventClick(event);
  var marginPosition = pageNavigate.rowAndPageClick(event.target.id, 14, 146, 43);
  jCommon.setHtmlStyleAttribute("ogolanalog-list", "marginTop", marginPosition);
}
//ogolanalog.html end

//remotesetup.html start
window.initRemoteSetupData = function (messsage) {
  jCommon.setDomElementValue(messsage, "/setup/remoteAlarm/");
  messsage["arrEmails"].forEach(function (item, index) {
    for (var key in item) {
      jCommon.setHtmlValue("arrEmails-" + index + "-" + key, item[key]);
      jCommon.setDataSaveProperty("arrEmails-" + index + "-" + key, "/setup/remoteAlarm/arrEmails/" + index + "/" + key);
    }
  });
  for (var key in messsage["remote"]) {
    jCommon.setHtmlValue("remote-" + key, messsage["remote"][key]);
    jCommon.setDataSaveProperty("remote-" + key, "/setup/remoteAlarm/remote/" + key);
  }
  channelPage.initChannelInput("remote-chn", messsage["remote"]["chnType"], messsage["remote"]["chn"], "", remoteChnCallbackFunc);
  remoteChnCallbackFunc();
}

window.remoteChnCallbackFunc = function () {
  var remoteChn = jCommon.getHtmlValue("remote-chn");
  var remoteChnType = jCommon.getHtmlValue("remote-chnType");
  var channelInfoName = channelPage.getChannelInfo(remoteChnType, remoteChn, "name");
  if (jCommon.empty(channelInfoName)) {
    jCommon.setHtmlValue("remote-chn-ConfigName", "Remote User");
    if (remoteChn > 0) {
      var channelIndex = Number(remoteChn - 1);
      jCommon.setDataSaveProperty("remote-chn-name", "/dis/" + channelIndex + "/name");
      jCommon.setHtmlValue("remote-chn-name", "Remote User")
    }
  }
}

window.remoteClick = function () {
  repeatAllPage.updateParameter("remote-chn-name");
  window.location.hash = jCommon.getHtmlAttriute("remote-chn-ConfigName", "href");
}
//remotesetup.html end

//remoteanalog.html start
window.initRemoteAnalogData = function (message) {
  jCommon.setHtmlValue("analog-alarm-list", "");
  var pdata = {};
  pdata.maxID = jCommon.getHtmlValue("maxID");
  pdata.minID = jCommon.getHtmlValue("minID");
  pdata.action = jCommon.getHtmlValue("action");
  pdata.type = jCommon.getHtmlValue("type");
  cmdlist.getEmailAlarmData(pdata, function (list) {
    var htmArr = [];
    if (!jCommon.empty(list)) {
      list.forEach(function (item, index) {
        htmArr.push(jCommon.getEmailAnalogAndDigital(index, item));
      })
      jCommon.setHtmlValue("allRowNumber", htmArr.length);
      jCommon.setHtmlValue("analog-alarm-list", htmArr.join(""));
      list.forEach(function (item, index) {
        jCommon.setHtmlValue("row-" + index + "-emailEn", item["emailEn"]);
        jCommon.setHtmlValue("row-" + index + "-ogolEn", item["ogolEn"]);
      })
    }
  })
}

window.switchEmailAndOGDL = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id.endsWith("emailEn")) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}

window.controlRemoteanalogListPosition = function (event) {
  repeatAllPage.clearEventClick(event);
  var lastCurrentIndex = jCommon.getHtmlValue("allRowNumber") - 15;
  var currentPosition = pageNavigate.rowAndPageClick(event.target.id, 15, lastCurrentIndex, 40);
  jCommon.setHtmlStyleAttribute("analog-alarm-list", "marginTop", currentPosition);
}
//remoteanalog.html end

//remotedigital.html start
window.initRemoteDigitalData = function (message) {
  jCommon.setHtmlValue("analog-alarm-list", "");
  var pdata = {};
  pdata.maxID = jCommon.getHtmlValue("maxID");
  pdata.minID = jCommon.getHtmlValue("minID");
  pdata.action = jCommon.getHtmlValue("action");
  pdata.type = jCommon.getHtmlValue("type");
  cmdlist.getEmailAlarmData(pdata, function (list) {
    if (list.length > 0) {
      var htmArr = [];
      list.forEach(function (item, index) {
        htmArr.push(jCommon.getEmailAnalogAndDigital(index, item));
      })
      jCommon.setHtmlValue("allRowNumber", htmArr.length);
      jCommon.setHtmlValue("analog-alarm-list", htmArr.join(""));
      list.forEach(function (item, index) {
        jCommon.setHtmlValue("row-" + index + "-emailEn", item["emailEn"]);
        jCommon.setHtmlValue("row-" + index + "-ogolEn", item["ogolEn"]);
      })
    }
  })
}
//remotedigital.html end

window.initRemoteLoopData = function (message) {
  jCommon.setHtmlValue("analog-alarm-list", "");
  var pdata = {};
  pdata.maxID = jCommon.getHtmlValue("maxID");
  pdata.minID = jCommon.getHtmlValue("minID");
  pdata.action = jCommon.getHtmlValue("action");
  pdata.type = jCommon.getHtmlValue("type");
  cmdlist.getEmailAlarmData(pdata, function (list) {
    if (list.length > 0) {
      var htmArr = [];
      list.forEach(function (item, index) {
        htmArr.push(jCommon.getEmailAnalogAndDigital(index, item));
      })
      jCommon.setHtmlValue("allRowNumber", htmArr.length);
      jCommon.setHtmlValue("analog-alarm-list", htmArr.join(""));
      list.forEach(function (item, index) {
        jCommon.setHtmlValue("row-" + index + "-emailEn", item["emailEn"]);
        jCommon.setHtmlValue("row-" + index + "-ogolEn", item["ogolEn"]);
      })
    }
  })
}
// statmonconfig.html start
window.initStatMonitorData = function (message) {
  var monitorList = message["sms"]["monitors"];
  var processList = message["sms"]["processes"];
  var groupList = message["sms"]["groups"];
  var processSelectList = [];
  processList.forEach(function (item, index) {
    processSelectList.push({
      value: index,
      name: item["name"]
    })
  });
  var groupSelectList = [];
  groupList.forEach(function (item, index) {
    groupSelectList.push({
      value: index,
      name: item["name"]
    })
  });
  var letList = [];
  var rightList = [];
  for (var index = 0; index < monitorList.length; index++) {
    var item = monitorList[index];
    if (index <= 9) {
      letList.push(jCommon.getMonitorItem(index));
    } else {
      rightList.push(jCommon.getMonitorItem(index));
    }
    for (var key in item) {
      jCommon.setHtmlValue("monitors-" + index + "-" + key, item[key]);
      jCommon.setDataSaveProperty("monitors-" + index + "-" + key, "/sms/monitors/" + index + "/" + key);
    }
    for (var key in item["cmb"]) {
      jCommon.setHtmlValue("monitors-" + index + "-cmb-" + key, item["cmb"][key]);
      jCommon.setDataSaveProperty("monitors-" + index + "-cmb-" + key, "/sms/monitors/" + index + "/cmb/" + key);
    }
    for (var key in item["signiflowMonitor"]) {
      jCommon.setHtmlValue("monitors-" + index + "-signiflowMonitor-" + key, item["signiflowMonitor"][key]);
      jCommon.setDataSaveProperty("monitors-" + index + "-signiflowMonitor-" + key, "/sms/monitors/" + index + "/signiflowMonitor/" + key);
    }
    jCommon.setHtmlValue("monitors-" + index + "-signiflowMonitor-lower_tail_fraction-double", item["signiflowMonitor"]["lower_tail_fraction"]);
    jCommon.setDataSaveProperty("monitors-" + index + "-signiflowMonitor-lower_tail_fraction-double", "/sms/monitors/" + index + "/signiflowMonitor/lower_tail_fraction");
    jCommon.setHtmlValue("monitors-" + index + "-signiflowMonitor-upper_tail_fraction-double", item["signiflowMonitor"]["upper_tail_fraction"]);
    jCommon.setDataSaveProperty("monitors-" + index + "-signiflowMonitor-upper_tail_fraction-double", "/sms/monitors/" + index + "/signiflowMonitor/upper_tail_fraction");
    jCommon.setHtmlValue("monitors-" + index + "-signiflowMonitor-lower_spec_limit-double", item["signiflowMonitor"]["lower_spec_limit"]);
    jCommon.setDataSaveProperty("monitors-" + index + "-signiflowMonitor-lower_spec_limit-double", "/sms/monitors/" + index + "/signiflowMonitor/lower_spec_limit");
    jCommon.setHtmlValue("monitors-" + index + "-signiflowMonitor-upper_spec_limit-double", item["signiflowMonitor"]["upper_spec_limit"]);
    jCommon.setDataSaveProperty("monitors-" + index + "-signiflowMonitor-upper_spec_limit-double", "/sms/monitors/" + index + "/signiflowMonitor/upper_spec_limit");
    for (var key in item["wmb"]) {
      jCommon.setHtmlValue("monitors-" + index + "-wmb-" + key, item["wmb"][key]);
      jCommon.setDataSaveProperty("monitors-" + index + "-wmb-" + key, "/sms/monitors/" + index + "/wmb/" + key);
    }
    new jCommon.dropDownMenu({
      element: document.getElementById("monitors-" + index + "-signiflowMonitor-exception_typeLabel"),
      choices: constVar.getMonitorExceptionType(),
      defaultvalue: item["signiflowMonitor"]["exception_type"],
      callback: repeatAllPage.updateSelectValueData
    });
    new jCommon.dropDownMenu({
      element: document.getElementById("monitors-" + index + "-withinGroupOrderLabel"),
      choices: constVar.getMonitorGroupOrder(),
      defaultvalue: item["withinGroupOrder"],
      callback: repeatAllPage.updateSelectValueData
    });
    channelPage.initChannelInput("monitors-" + index + "-biscaledChannel", item["biscaledChannelType"], item["biscaledChannel"], "analog");
  }
  jCommon.setHtmlValue("left-monitor-list", letList.join(""));
  jCommon.setHtmlValue("right-monitor-list", rightList.join(""))
  for (var index = 0; index < monitorList.length; index++) {
    var monitorItem = monitorList[index];
    for (var key in monitorItem) {
      jCommon.setHtmlValue("row-" + index + "-" + key, monitorItem[key]);
      jCommon.setDataSaveProperty("row-" + index + "-" + key, "/sms/monitors/" + index + "/" + key);
    }
    new jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + "-processIdLabel"),
      choices: processSelectList,
      defaultvalue: monitorItem["processId"],
      callback: repeatAllPage.updateSelectValueData
    });
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + "-monitoringTypeLabel"),
      choices: constVar.getMonitorProcessType(),
      defaultvalue: monitorItem["monitoringType"],
      callback: repeatAllPage.updateSelectValueData
    })
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + "-groupIdLabel"),
      choices: groupSelectList,
      defaultvalue: monitorItem["groupId"],
      callback: contrlGroupUrl
    })
    if (monitorItem["groupId"] < 0) {
      jCommon.removeHtmlClass("#row-" + index + "-groupUrl", "btn-redirect");
      jCommon.addHtmlClass("#row-" + index + "-groupUrl", "btn-disabled");
    } else {
      jCommon.removeHtmlClass("#row-" + index + "-groupUrl", "btn-disabled");
      jCommon.addHtmlClass("#row-" + index + "-groupUrl", "btn-redirect");
    }
  }
}
window.contrlGroupUrl = function (value, id) {
  var idArr = id.split("-");
  jCommon.removeHtmlClass("#row-" + idArr[1] + "-groupUrl", "btn-disabled");
  jCommon.addHtmlClass("#row-" + idArr[1] + "-groupUrl", "btn-redirect");
  repeatAllPage.updateSelectValueData(value, id)
}
window.statmonconfigPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var arr = event.target.id.split("-");
  if (event.target.id.endsWith("monitorproperty")) {
    jCommon.setHtmlValue("monitorId", arr[1]);
    jCommon.removeHtmlClass("#propertiesOfMonitorDialog", "hide");
    contrlMonitorProperty();
  } else if (event.target.id === "close-PropertiesOfMonitor") {
    jCommon.addHtmlClass("#propertiesOfMonitorDialog", "hide");
    repeatAllPage.initCurrentPageData();
  } else if (["preMonitor", "nextMonitor"].indexOf(event.target.id) > -1) {
    var currentMonitor = jCommon.getHtmlValue("monitorId");
    if (event.target.id === "preMonitor") {
      currentMonitor--;
    } else {
      currentMonitor++;
    }
    jCommon.setHtmlValue("monitorId", currentMonitor);
    jCommon.controlDOMShow("monitorId");
    contrlMonitorProperty();
  } else if (event.target.id.endsWith("monitorChanges")) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  } else if (event.target.id.endsWith("-groupUrl")) {
    var groupId = jCommon.getHtmlValue("row-" + arr[1] + "-groupId");
    if (groupId >= 0) {
      window.location.hash = "#monitorgroup&p=" + Number(groupId + 1);
    }
  }
}
window.contrlMonitorProperty = function () {
  var monitorId = jCommon.getHtmlValue("monitorId");
  jCommon.controlDOMShow("monitorId");
  jCommon.controlDOMShow("row-" + monitorId + "-monitoringType")
  jCommon.setHtmlValue("monitorTitle", Number(monitorId) + 1);
  jCommon.controlDOMShow("monitors-" + monitorId + "-signiflowMonitor-exception_type");
  controlMonitorPage();
}
window.controlMonitorPage = function () {
  var currentMonitor = jCommon.getHtmlValue("monitorId");
  var allNumber = jCommon.getHtmlValue("allNumber");
  if (currentMonitor === 0) {
    jCommon.setHtmlAttribute("preMonitor", "disabled", true);
  } else if (currentMonitor === allNumber) {
    jCommon.setHtmlAttribute("nextMonitor", "disabled", true);
  } else {
    jCommon.setHtmlAttribute("preMonitor", "disabled", false);
    jCommon.setHtmlAttribute("nextMonitor", "disabled", false);
  }
}
//statmonconfig.html end


//monitorprocess.html start
window.initMonitorProcessData = function (message) {
  var monitorList = message["sms"]["monitors"];
  var monitorIndex = Number(jCommon.getUrlParams("p")) - 1;
  var monitorInfo = monitorList[monitorIndex];
  var predefinedList = systemFeed.getPredefinedLoopList(message);
  var predefinedFilterList = predefinedList.filter(function (item) {
    return !item["downBppc"];
  });
  var processList = message["sms"]["processes"];
  var processSelectList = [];
  processList.forEach(function (item, index) {
    processSelectList.push({
      value: index,
      name: item["name"]
    })
  });
  jCommon.setDomElementValue(monitorInfo, "/sms/monitors/" + monitorIndex + "/");
  jCommon.dropDownMenu({
    element: document.getElementById('processIdLabel'),
    choices: processSelectList,
    fixedName: '<span class="iconfont">&#xe65e;</span>',
    defaultvalue: jCommon.getHtmlValue("processId"),
    callback: monotirProcessCallback
  })
  var name = jCommon.getHtmlAttriute("processIdLabel", "select-name");
  jCommon.setHtmlValue("name", name);
  jCommon.dropDownMenu({
    element: document.getElementById('monitoringTypeLabel'),
    choices: constVar.getMonitorProcessType(),
    defaultvalue: jCommon.getHtmlValue("monitoringType"),
    callback: monotirProcessTypeCallback
  })
  var processIndex = monitorInfo["processId"];
  var processInfo = processList[processIndex];
  var streamsList = processInfo["streams"];
  var wmbList = [];
  var cmbList = [];
  var gs1List = [];
  var gs2List = [];
  var gs3List = [];
  var gs4List = [];
  var gs5List = [];
  streamsList.forEach(function (item, index) {
    if (index >= 0 && index <= 6) {
      wmbList.push(jCommon.getMonitorProcessItem(item, index));
    } else if (index >= 7 && index <= 11) {
      cmbList.push(jCommon.getMonitorProcessItem(item, index));
    } else if (index == 12) {
      gs1List.push(jCommon.getMonitorProcessItem(item, index));
    } else if (index == 13) {
      gs2List.push(jCommon.getMonitorProcessItem(item, index));
    } else if (index == 14) {
      gs3List.push(jCommon.getMonitorProcessItem(item, index));
    } else if (index == 15) {
      gs4List.push(jCommon.getMonitorProcessItem(item, index));
    } else if (index == 16) {
      gs5List.push(jCommon.getMonitorProcessItem(item, index));
    }
  })
  jCommon.setDomElementValue(processInfo, "/sms/processes/" + processIndex + "/");
  jCommon.setHtmlValue("wmnlist", wmbList.join(""));
  jCommon.setHtmlValue("cmbList", cmbList.join(""));
  jCommon.setHtmlValue("gs1List", gs1List.join(""));
  jCommon.setHtmlValue("gs2List", gs2List.join(""));
  jCommon.setHtmlValue("gs3List", gs3List.join(""));
  jCommon.setHtmlValue("gs4List", gs4List.join(""));
  jCommon.setHtmlValue("gs5List", gs5List.join(""));
  for (var index = 0; index < streamsList.length; index++) {
    var item = streamsList[index];
    for (var key in item) {
      jCommon.setHtmlValue("row-" + index + "-" + key, item[key]);
      jCommon.setDataSaveProperty("row-" + index + "-" + key, "/sms/processes/" + processIndex + "/streams/" + index + "/" + key);
    }
    channelPage.initChannelInput("row-" + index + "-inputChannel", item["inputChannelType"], item["inputChannel"], "analog");
    jCommon.controlDOMShow("row-" + index + "-inputType");
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-inputLoopLabel'),
      choices: predefinedFilterList,
      defaultvalue: item["inputLoop"],
      defaultInfo: {
        key: "value",
        offset: 1
      },
      callback: monitorProcessLoopSelectCallback
    });
    setMonitorTypeLoop("row-" + index + '-inputLoopLabel');
  }
  jCommon.controlDOMShow("monitoringType");
}
window.setMonitorTypeLoop = function (id) {
  var selectName = jCommon.getHtmlAttriute(id, "select-name");
  var loopUrl = jCommon.getHtmlAttriute(id, "select-loopurl");
  var configDom = id.replace("Label", "-ConfigName");
  jCommon.setHtmlValue(configDom, selectName);
  jCommon.setHtmlAttribute(configDom, "href", loopUrl);
}
window.monotirProcessCallback = function (detail, id, oldValue) {
  var name = jCommon.getHtmlAttriute(id, "select-name");
  jCommon.setHtmlValue("name", name);
  repeatAllPage.updateSelectValueData(detail, id);
}
window.monotirProcessTypeCallback = function (value, id) {
  repeatAllPage.updateSelectValueData(value, id);
  var monitorInputTypeList = document.getElementsByClassName("monitorInputType");
  for (var index = 0; index < monitorInputTypeList.length; index++) {
    jCommon.controlDOMShow(monitorInputTypeList[index].id);
  }
}
window.monitorProcessLoopSelectCallback = function (value, id) {
  setMonitorTypeLoop(id);
  systemFeed.predefinedLoopSelectCallback(value, id);
}
window.monitorProcessPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id.endsWith("-inputType")) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//monitorprocess.html end

//monitorgroup.html start
window.initMonitorGroupData = function (message) {
  var groupsList = message["sms"]["groups"];
  var groupIndex = jCommon.getUrlParams("p") - 1;
  var groupInfo = groupsList[groupIndex];
  jCommon.setDomElementValue(groupInfo, "/sms/groups/" + groupIndex + "/");
  jCommon.dropDownMenu({
    element: document.getElementById('groupOrderLabel'),
    choices: constVar.getMonitorGroupOrder(),
    defaultvalue: groupInfo["groupOrder"],
    callback: repeatAllPage.updateSelectValueData
  })
  channelPage.initChannelInput("omnibusStatChannel", groupInfo["omnibusStatChannelType"], groupInfo["omnibusStatChannel"], "analog")
}
window.checkMonitorGroupInputValue = function (elementId, newValue) {
  var pencent = constVar.getMonitorGroupSampleAndWindowPencent();
  if (elementId === "sampleInterval") {
    jCommon.setHtmlValue("okFractionWindow", Number(newValue * pencent).toFixed(0));
    repeatAllPage.updateParameter("sampleAndOk");
  } else if (elementId === "okFractionWindow") {
    jCommon.setHtmlValue("sampleInterval", Number(newValue / pencent).toFixed(0));
    repeatAllPage.updateParameter("sampleAndOk");
  } else {
    repeatAllPage.updateParameter(elementId);
    jCommon.controlDOMShow(elementId)
    jCommon.setClassListValue(elementId, newValue);
  }
}
window.monotiorGroupClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var radioButton = ["isVisibleAtRunTime", "omnibusStatType", "includeInOverallStat", "mode"];
  if (radioButton.indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  } else if (["canChangeMode", "canStop", "canStart", "canRetrain", "canReset", "canForget"].indexOf(event.target.id) > -1) {
    jCommon.toogleSwitch(event.target.id);
    jCommon.controlDOMShow(event.target.id);
    repeatAllPage.updateParameter(event.target.id);
  }
}
//monitorgroup.html end

//bppcboiler.html start
window.initSystemBppcBoilerData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  jCommon.setHtmlAttribute("bppcprocess", "href", "#bppcprocess&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppchemical", "href", "#bppchemical&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppccontrol", "href", "#bppccontrol&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("next", "href", "#bppcprocess&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
}
window.bppcboilerPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var radioButton = ["ductBurn", "heatFlux"];
  if (radioButton.indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//bppcboiler.html end

//bppcprocess.html start
window.initSystemBppcProcessData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  systemFeed.initBPPCConstantChannel(loopInfo);
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  if (loopInfo["noSampleFlowChnType"]) {
    jCommon.setHtmlValue("sampleFlowChnEn", true);
  } else {
    jCommon.setHtmlValue("sampleFlowChnEn", false);
  }
  jCommon.controlDOMShow("sampleFlowChnEn");
  channelPage.initChannelInput("po4WrnChn", loopInfo["po4WrnChnType"], loopInfo["po4WrnChn"]);
  channelPage.initChannelInput("po4AlmChn", loopInfo["po4AlmChnType"], loopInfo["po4AlmChn"]);
  channelPage.initChannelInput("nh3WrnChn", loopInfo["nh3WrnChnType"], loopInfo["nh3WrnChn"]);
  channelPage.initChannelInput("nh3AlmChn", loopInfo["nh3AlmChnType"], loopInfo["nh3AlmChn"]);
  channelPage.initChannelInput("pHWrnChn", loopInfo["pHWrnChnType"], loopInfo["pHWrnChn"]);
  channelPage.initChannelInput("pHAlmChn", loopInfo["pHAlmChnType"], loopInfo["pHAlmChn"]);
  channelPage.initChannelInput("noSampleFlowChn", loopInfo["noSampleFlowChnType"], loopInfo["noSampleFlowChn"]);
  jCommon.setHtmlAttribute("back", "href", "#bppcboiler&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppchemical", "href", "#bppchemical&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppccontrol", "href", "#bppccontrol&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("next", "href", "#bppchemical&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
}
window.systemBppcProcessPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id.endsWith("-dataType") || event.target.id === "sampleFlowChnEn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
  if (event.target.id === "po4LabCheck_OP") {
    console.log("po4LabCheck_OP Event");
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}
//bppcprocess.html end

//bppchemical.html start
window.initSystemBppcChemicalData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var downLoopId = Number(jCommon.getUrlParams("Lp")) + 1;
  var downFeedId = Number(jCommon.getUrlParams("Fd")) + 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  channelPage.initChannelInput("hiDiChn", loopInfo["hiDiChnType"], loopInfo["hiDiChn"]);
  channelPage.initChannelInput("loDiChn", loopInfo["loDiChnType"], loopInfo["loDiChn"]);
  channelPage.initChannelInput("hpDoChn", loopInfo["hpDoChnType"], loopInfo["hpDoChn"]);
  jCommon.setHtmlAttribute("upfeeddevice", "href", "#feeddevice&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("dnfeeddevice", "href", "#feeddevice&system=" + jCommon.getUrlParams("system") + "&Fd=" + downFeedId + "&Lp=" + downLoopId);
  jCommon.setHtmlAttribute("back", "href", "#bppcprocess&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppcprocess", "href", "#bppcprocess&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppcboiler", "href", "#bppcboiler&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"))
  jCommon.setHtmlAttribute("bppccontrol", "href", "#bppccontrol&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("next", "href", "#bppccontrol&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
}
window.systemBppchemicalPageChamper = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id === "dChamper") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//bppchemical.html end

//bppccontrol.html start
window.initSystemBppcControlData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var downFeedDeviceInfo = loopList[loopIndex + 1]["fdDevice"];
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  systemFeed.initBPPCConstantChannel(loopInfo);
  jCommon.dropDownMenu({
    element: document.getElementById("programLabel"),
    choices: constVar.getBppcControlProgram(),
    defaultvalue: loopInfo["program"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("spModeLabel"),
    choices: constVar.getBppcControlSpMode(),
    defaultvalue: loopInfo["spMode"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.setClassListValue("up-fdDevice-unit", systemFeed.getFeedDevicesUnit(loopInfo["fdDevice"]));
  jCommon.setClassListValue("dn-fdDevice-unit", systemFeed.getFeedDevicesUnit(downFeedDeviceInfo));
  jCommon.setHtmlAttribute("back", "href", "#bppchemical&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppchemical", "href", "#bppchemical&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppcprocess", "href", "#bppcprocess&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"))
  jCommon.setHtmlAttribute("bppcboiler", "href", "#bppcboiler&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
}
window.SystemBppcPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id.endsWith("-dataType") || event.target.id === "localEn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//bppccontrol.html end

//bppctime.html bppctimefd.html start
window.initBPPCTimeData = function (message) {
  var currentPage = jCommon.getCurrentPage();
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var upFeedDeviceInfo = loopInfo["fdDevice"];
  var downFeedDeviceInfo = loopList[loopIndex + 1]["fdDevice"];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  var programList = constVar.getBppcControlProgram();
  programList.forEach(function (item) {
    if (item["value"] === loopInfo["program"]) {
      jCommon.setHtmlValue("programLabel", item["name"]);
    }
  })
  systemFeed.initBPPCTimeConstantChannel(loopInfo);
  if (!jCommon.empty(loopInfo["upPercent"])) {
    var upPercentInfo = loopInfo["upPercent"];
    for (var key in upPercentInfo) {
      jCommon.setHtmlValue("upPercent-" + key, upPercentInfo[key]);
      jCommon.setClassListValue("upPercent-" + key, upPercentInfo[key]);
      jCommon.setDataSaveProperty("upPercent-" + key, "/loops/" + loopIndex + "/upPercent/" + key);
    }
    channelPage.setChannelConfig(upPercentInfo["chnType"], upPercentInfo["chn"], "upPercent-chn");
    jCommon.controlDOMShow("upPercent-dataType");
  }
  channelPage.initChannelInput("hiDiChn", loopInfo["hiDiChnType"], loopInfo["hiDiChn"]);
  channelPage.initChannelInput("loDiChn", loopInfo["loDiChnType"], loopInfo["loDiChn"]);
  channelPage.initChannelInput("hpDoChn", loopInfo["hpDoChnType"], loopInfo["hpDoChn"]);
  jCommon.setClassListValue("up-fdDevice-unit", systemFeed.getFeedDevicesUnit(loopInfo["fdDevice"]));
  jCommon.setHtmlValue("up-feedDeviceType", upFeedDeviceInfo["feedDeviceType"]);
  jCommon.setHtmlValue("up-outputChn", upFeedDeviceInfo["outputChn"]);
  jCommon.setHtmlValue("up-outputChnType", upFeedDeviceInfo["outputChnType"]);
  channelPage.setChannelConfig(upFeedDeviceInfo["outputChnType"], upFeedDeviceInfo["outputChn"], "up-outputChn");
  jCommon.controlDOMShow("up-feedDeviceType");
  jCommon.setClassListValue("dn-fdDevice-unit", systemFeed.getFeedDevicesUnit(downFeedDeviceInfo));
  jCommon.setHtmlValue("dn-feedDeviceType", downFeedDeviceInfo["feedDeviceType"]);
  jCommon.setHtmlValue("dn-outputChn", downFeedDeviceInfo["outputChn"]);
  jCommon.setHtmlValue("dn-outputChnType", downFeedDeviceInfo["outputChnType"]);
  channelPage.setChannelConfig(downFeedDeviceInfo["outputChnType"], downFeedDeviceInfo["outputChn"], "dn-outputChn");
  jCommon.controlDOMShow("dn-feedDeviceType");
  jCommon.setHtmlAttribute("bppctimefd", "href", "#bppctimefd&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppctime", "href", "#bppctime&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("bppctimechemical", "href", "#bppctimechemical&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  if (currentPage === "bppctimefd") {
    systemFeed.initBPPCRunTimeFeedDevice(upFeedDeviceInfo, downFeedDeviceInfo);
  }
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
}
//bppctime.html bppctimefd.html end

//displayfallback.html start
window.initDisplayFallbackData = function (message) {
  var list = constVar.getDefaultDisplayList();
  var systemTypeList = constVar.getSystemType();
  var systemList = message["systems"];
  var trendList = message["trends"];
  var setUp = message["setup"];
  jCommon.setDomElementValue(setUp, "/setup/");
  systemList.forEach(function (item, index) {
    if (!jCommon.empty(item.feeds)) {
      var systemId = Number(index + 1);
      var systemTitle = jCommon.empty(item["name"]) ? "System" + systemId : item["name"];
      var systemType = systemTypeList.filter(function (typeItem) {
        return typeItem.value === item["runGraphic"];
      })
      list.push({
        value: "system&sys=" + systemId + "&name=" + systemTitle,
        name: "System" + systemId + " " + systemType[0]["name"]
      })
    }
  })
  for (var index = 0; index < trendList.length; index++) {
    var trendItemPen = trendList[index]["pens"];
    var trendId = Number(index + 1);
    var isTrend = false
    for (var key = 0; key < trendItemPen.length; key++) {
      var trendItemPenItem = trendItemPen[key];
      if (!jCommon.empty(trendItemPenItem["type"]) && !jCommon.empty(trendItemPenItem["trendEn"])) {
        if (!jCommon.empty(trendItemPenItem["chn"]) || trendItemPenItem["pdLoop"] > -1) {
          isTrend = true;
          break;
        }
      }
    }
    if (!jCommon.empty(isTrend)) {
      list.push({
        value: "trend&p=" + trendId,
        name: "Trend View" + trendId
      })
    }
  }
  jCommon.dropDownMenu({
    element: document.getElementById("homePageLabel"),
    choices: list,
    defaultvalue: setUp["homePage"],
    callback: repeatAllPage.updateSelectValueData
  })
}
window.toggleDisplayFallback = function (event) {
  jCommon.setRadioButtonValue(event.target.id, function () {
    repeatAllPage.updateParameter(event.target.id);
  })
}
//displayfallback.html end


//rtdisplayconfig.html start
window.initRtDisplayConfigPage = function (message) {
  var systemList = message["systems"];
  var rtDisplay = message["setup"]["rtDisplay"];
  for (var index = 0; index < systemList.length; index++) {
    var item = systemList[index];
    var systemId = index + 1;
    jCommon.setHtmlValue("system" + systemId + "Name", jCommon.empty(item["name"]) ? "System" + systemId : item["name"]);
    if (jCommon.empty(item["feedNum"])) {
      jCommon.setSwitchEnabled("system" + systemId, false);
    } else {
      jCommon.setSwitchEnabled("system" + systemId, true);
    }
  }
  jCommon.setDomElementValue(rtDisplay, "/setup/rtDisplay/");
}
window.rtdisplayPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.toogleSwitch(event.target.id);
  repeatAllPage.updateParameter(event.target.id);
}
//rtdisplayconfig.html end

//plcstatus.html start
window.initPlcStatusData = function (message) {
  jCommon.setDomElementValue(message, "/plc/");
  channelPage.initChannelInput("lostChn", message["lostChnType"], message["lostChn"]);
}
//plcstatus.html end

//display.html start
window.initDisplayData = function (message) {
  if (message["analog"]) {
    jCommon.addHtmlClass(".analog", "btn-login");
  } else {
    jCommon.removeHtmlClass(".analog", "btn-login");
  }
  if (message["digital"]) {
    jCommon.addHtmlClass(".digital", "btn-login");
  } else {
    jCommon.removeHtmlClass(".digital", "btn-login");
  }
  jCommon.checkBtnLoginDisabled();
}
//display.html end

//guardonline.html start
window.initGuardOnlineData = function (setupInfo) {
  jCommon.setHtmlValue("enable", setupInfo["ogol"]["enable"]);
  jCommon.setDataSaveProperty("enable", "/setup/ogol/enable");
}
window.guardOnlinePageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id == "enable") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//guardonline.html end

//probe.html start
window.initProbeConfigData = function (message) {
  var probeTypesList = [];
  var currentPage = jCommon.getCurrentPage();
  message["probeTypes"].forEach(function (item) {
    probeTypesList.push({
      value: item["PN"],
      name: item["modelName"],
      modbusAddr: item["modbusAddr"],
      brushAddr: item["brushAddr"]
    })
  })
  if (probeTypesList.length > 0) {
    probeTypesList.push({
      value: "",
      name: "None",
      modbusAddr: "",
      brushAddr: -1
    })
  }
  var probes = message["probes"]["onlines"];
  var list = [];
  probes.forEach(function (item, index) {
    list.push(jCommon.getProbeConfigItem(index, item));
  })
  jCommon.setHtmlValue("prob-html", list.join(""));
  //set
  probes.forEach(function (item, index) {
    for (var key in item) {
      if (key == "ModbusAddr" && item[key] == -1) {
        item[key] = 0;
      }
      jCommon.setHtmlValue("row-" + index + "-" + key, jCommon.empty(item[key]) ? "" : item[key]);
      jCommon.setDataSaveProperty("row-" + index + "-" + key, "/probes/onlines/" + index + "/" + key);
    }
    jCommon.dropDownMenu({
      element: document.getElementById("row-" + index + '-PNLabel'),
      choices: probeTypesList,
      defaultvalue: item["PN"],
      callback: selectProbeCallback
    });
    jCommon.controlDOMShow("row-" + index + '-PN');
    jCommon.controlDOMShow("row-" + index + '-brushAddr');
    if (currentPage == "probetime") {
      jCommon.setDropDownMenuDisabled("row-" + index + '-PNLabel', true);
    } else if (currentPage == "probe") {
      if (jCommon.empty(item["PN"])) {
        jCommon.setInputTextDisabled("row-" + index + "-customName", true);
        jCommon.setInputTextDisabled("row-" + index + "-ModbusAddr", true);
        jCommon.setSwitchEnabled("row-" + index + "-enable", false);
      }
    }
  })
  var rs485 = message["probes"]["rs485"];
  jCommon.setHtmlValue(key, rs485[key]);
  for (var key in rs485) {
    jCommon.setHtmlValue(key, rs485[key]);
    jCommon.setDataSaveProperty(key, "/probes/rs485/" + key);
  }
  getListPortName(repeatAllPage.parameterData.modbus.rs485.portName);
}

window.probeClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var currentPage = jCommon.getCurrentPage();
  var radioButton = ["portName"];
  if (radioButton.indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  } else if (event.target.id == "listProbe") {
    getListPortName(repeatAllPage.parameterData.modbus.rs485.portName);
  } else if (event.target.id.endsWith("ProbeConfig")) {
    if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id, "noLoginState")) {
      userlogin.showLoginDialog();
      return false;
    }
    var list = event.target.id.split("-");
    var pn = jCommon.getHtmlValue(event.target.id.replace("ProbeConfig", "PN"));
    window.location.hash = "pyxissensorcal&pn=" + pn + "&idxP=" + list[1];
  } else if (event.target.id.endsWith("display")) {
    var list = event.target.id.split("-");
    var pn = jCommon.getHtmlValue(event.target.id.replace("display", "PN"));
    window.location.hash = "pyxissensorcaltime&pn=" + pn + "&idxP=" + list[1];
  } else if (event.target.id == "ProbePing") {
    //check user login
    if (jCommon.empty(jCommon.getLocalStorge("user_account")) && !jCommon.getHtmlAttriute(event.target.id, "noLoginState")) {
      userlogin.showLoginDialog();
      return false;
    }
    jCommon.setHtmlAttribute("ProbePing", "disabled", true)
    cmdlist.pingProbe(-1, function () {
      jCommon.setHtmlAttribute("ProbePing", "disabled", false)
    });
  } else if (event.target.id.endsWith("enable") && currentPage == "probe") {
    var pn = jCommon.getHtmlValue(event.target.id.replace("enable", "PN"));
    if (!jCommon.empty(pn)) {
      jCommon.toogleSwitch(event.target.id);
      repeatAllPage.updateParameter(event.target.id);
    }
  } else if (event.target.id == "pyxissensorlog") {
    userlogin.btnLoginClick(event.target);
  }
}

window.getListPortName = function (removeKey) {
  cmdlist.listPortName(function (message) {
    var list = [];
    message.forEach(function (item) {
      if (item != removeKey) {
        list.push({
          value: item,
          name: item
        })
      }
    })
    jCommon.dropDownMenu({
      element: document.getElementById("portNameLabel"),
      choices: list,
      defaultvalue: jCommon.getHtmlValue("portName"),
      callback: repeatAllPage.updateSelectValueData
    });
  })
}
window.selectProbeCallback = function (value, id, callbackfun) {
  var keyId = id.replace("PNLabel", "");
  jCommon.controlDOMShow(keyId + "PN");
  if (jCommon.empty(value)) {
    jCommon.setInputTextDisabled(keyId + "customName", true);
    jCommon.setInputTextDisabled(keyId + "ModbusAddr", true);
    jCommon.setSwitchEnabled(keyId + "enable", false);
    jCommon.setHtmlValue(keyId + "customName", "");
    jCommon.setHtmlValue(keyId + "ModbusAddr", "");
    jCommon.setHtmlValue(keyId + "brushAddr", "");
    jCommon.setHtmlValue(keyId + "enable", false);
  } else {
    jCommon.setInputTextDisabled(keyId + "customName", false);
    jCommon.setInputTextDisabled(keyId + "ModbusAddr", false);
    jCommon.setSwitchEnabled(keyId + "enable", true);
    jCommon.setHtmlValue(keyId + "customName", jCommon.getHtmlAttriute(id, "select-name"));
    jCommon.setHtmlValue(keyId + "ModbusAddr", jCommon.getHtmlAttriute(id, "select-modbusaddr"));
    jCommon.setHtmlValue(keyId + "brushAddr", jCommon.getHtmlAttriute(id, "select-brushaddr"));
    jCommon.setHtmlValue(keyId + "enable", true);
  }
  repeatAllPage.updateSelectValueData(value, id)
}
//probe.html end

// input.html start
function sendMessage() {
  var message = document.getElementById("sendMessageInfo").value;
  cmdlist.setInputMessage(message, function (result) {
    document.getElementById("reciveMessageInfo").value = result
  });
}
//input.html end 

//pyxissensorcal.html start
window.initPyxisSensorCalPage = function (message) {
  //start diagnose
  var currentPage = jCommon.getCurrentPage();
  var idxP = jCommon.getUrlParams("idxP");
  var sindex = jCommon.getUrlParams("sindex");
  jCommon.setHtmlValue("idxProbe", idxP)
  jCommon.setHtmlValue("metaData", false);
  jCommon.controlDOMShow("metaData");
  cmdlist.breakDiagnose(idxP);
  var probInfo = channelPage.getPyxisOnlineInfo(idxP);
  if (jCommon.empty(probInfo["enable"])) {
    jCommon.addHtmlClass(".body-content", "page-disabled")
  } else {
    jCommon.removeHtmlClass(".body-content", "page-disabled")
  }
  // channelPage.initChannelInput("brushChn", probInfo["brushChnType"], probInfo["brushChn"]);
  // channelPage.setChannelConfig(probInfo["brushChnType"], probInfo["brushChn"], "brushChn");
  // jCommon.setHtmlValue("brushChnDigitalDisableLabel", channelPage.getChannelInputLabel(probInfo["brushChnType"], probInfo["brushChn"]));
  jCommon.setHtmlValue("supportRestore", channelPage.getPyxisPNBaseInfo(probInfo["PN"], "supportRestore"));
  jCommon.controlDOMShow("supportRestore");
  var sensorList = channelPage.getPyxisSensorInfoByPN(probInfo["PN"], null, true);
  var btnCalibString = ['<div class="row calibration-row">', '<div class="col-md-12">'];
  sensorList.forEach(function (item, index) {
    if (sindex == undefined) {
      btnCalibString.push('<div class="col-md-2"><div class="dom-container input-group"><button type="button" class="btn btn-default btn-calibrate-type" id="calibrate-type-' + index + '">' + item.name + '</button></div></div>');
    } else {
      if (index == sindex) {
        btnCalibString.push('<div class="col-md-2"><div class="dom-container input-group"><button type="button" class="btn btn-default btn-calibrate-type" id="calibrate-type-' + index + '">' + item.name + '</button></div></div>');
      } else {
        btnCalibString.push('<div class="col-md-2 hide"><div class="dom-container input-group"><button type="button" class="btn btn-default btn-calibrate-type" id="calibrate-type-' + index + '">' + item.name + '</button></div></div>');
      }
    }
  })
  if (probInfo["PN"] == 51007) {
    var alloyFactorString = '<div class="col-md-2 text-right">Alloy Factor:</div>';
    if (currentPage == "pyxissensorcal") {
      alloyFactorString += '<input id="alloyName" type="hidden" /><div class="col-md-5 dom-container" id="alloyNameLabel"></div><div class="col-md-1 hide" v-show="alloyName == ' + "Customize" + '"><div class="input-div-enabled form-inline"><input type="text" class="form-control keyboardnumberInput" data-title="alloy Factor" id="alloyFactorValue" data-min="0.1" data-max="5.0" /></div></div>';
    }
    alloyFactorString += '<div class="col-md-1"><div class="dom-container input-group"><div class="input-div-disabled"><label id="alloyFactor"></label></div></div></div>';
    btnCalibString.push(alloyFactorString);
  }
  btnCalibString.push('</div>');
  btnCalibString.push('</div>');
  jCommon.setHtmlValue("sensor-list", btnCalibString.join(""));
  for (var key in probInfo) {
    jCommon.setHtmlValue(key, probInfo[key]);
    jCommon.setDataSaveProperty(key, "/probes/onlines/" + idxP + "/" + key);
  }
  jCommon.controlDOMShow("brushAddr");
  if (probInfo["PN"] == 51007) {
    var alloyFactorList = constVar.getCR300AlloyFactor();
    jCommon.dropDownMenu({
      element: document.getElementById("alloyNameLabel"),
      choices: alloyFactorList,
      callback: alloyFactorCallback
    });
    jCommon.setDropDownMenuValueAndLabel("alloyName", probInfo["alloyName"]);
  }
  if (sindex != undefined) {
    jCommon.setHtmlValue("sindex", sindex);
  }
  controlActiveSensor();
  getSensorInfoList();
  //smoothing Factor
  var configList = channelPage.getPyxisPNBaseInfo(probInfo["PN"], "configs");
  var smoothingList = [];
  configList.forEach(function (item, index) {
    if (item.Name.startsWith("Smoothing Factor")) {
      smoothingList.push({
        "value": index,
        "name": item.Name,
        "Tip": item.Tip,
        "Editable": item.Editable
      });
    }
  })
  jCommon.setHtmlValue("smoothLength", smoothingList.length);
  jCommon.controlDOMShow("smoothLength");
  if (smoothingList.length == 1) {
    jCommon.setHtmlValue("smoothIndexLabelName", smoothingList[0]["name"]);
    jCommon.setHtmlValue("smooth-title", smoothingList[0]["name"]);
    jCommon.setHtmlValue("smooth-message", smoothingList[0]["Tip"]);
    jCommon.setHtmlValue("smooth-edit", smoothingList[0]["Editable"]);
    jCommon.setHtmlValue("smooth-index", smoothingList[0]["value"]);
    jCommon.controlDOMShow("smooth-edit");
  } else {
    jCommon.dropDownMenu({
      element: document.getElementById("smoothIndexLabel"),
      choices: smoothingList,
      defaultName: "Smooth",
      callback: smoothingClickCallback
    });
  }
}

window.checkPyxisSensorcalInputValue = function (elementId, newValue, oldValue) {
  if (elementId === "ModbusAddr") {
    ToolstipDialog.showConfirmToolsTip("", "Are you sure to change the address of modusbus from " + oldValue + " to " + newValue + "?", function () {
      jCommon.removeHtmlClass("#change-result-container", "hide");
      jCommon.setHtmlValue("change-result", "Waiting...");
      jCommon.setHtmlAttribute("ModbusAddr", "disabled", true);
      var pdata = {};
      pdata.PN = Number(jCommon.getHtmlValue("PN"));
      pdata.idxProbe = Number(jCommon.getUrlParams("idxP"));
      pdata.modbusAddr = Number(oldValue);
      pdata.modbusAddrNew = Number(newValue);
      cmdlist.changeAddrProbe(pdata)
    }, function () {
      jCommon.setHtmlValue(elementId, oldValue);
    })
  } else if (elementId === "alloyFactorValue") {
    var idxP = jCommon.getUrlParams("idxP");
    var pdata = {};
    pdata.idxProbe = Number(idxP);
    pdata.alloyName = "Customize";
    pdata.alloyFactor = Number(newValue);
    cmdlist.setAlloyFactor(pdata);
  } else {
    repeatAllPage.updateParameter(elementId);
  }
}

window.alloyFactorCallback = function () {
  var alloyFactor = Number(jCommon.getHtmlAttriute("alloyNameLabel", "select-factor"));
  jCommon.setHtmlValue("alloyName", arguments[0]);
  jCommon.controlDOMShow("alloyName");
  var idxP = jCommon.getUrlParams("idxP");
  var pdata = {};
  pdata.idxProbe = Number(idxP);
  pdata.alloyName = arguments[0];
  if (arguments[0] != "Customize") {
    pdata.alloyFactor = alloyFactor;
  }
  cmdlist.setAlloyFactor(pdata, function () {
    repeatAllPage.updateParameter("alloyName");
  });
}

window.smoothingClickCallback = function () {
  var labelId = arguments[1];
  jCommon.setHtmlValue("smooth-title", jCommon.getHtmlAttriute(labelId, "select-name"));
  jCommon.setHtmlValue("smooth-message", jCommon.getHtmlAttriute(labelId, "select-tip"));
  jCommon.setHtmlValue("smooth-edit", jCommon.getHtmlAttriute(labelId, "select-editable"));
  jCommon.setHtmlValue("smooth-index", jCommon.getHtmlAttriute(labelId, "select-value"));
  jCommon.controlDOMShow("smooth-edit");
  jCommon.removeHtmlClass("#smooth-dialog", "hide");
}

window.smoothSensor = function () {
  var pdata = {
    "idxProbe": jCommon.getHtmlValue("idxProbe"),
    "idxConfig": jCommon.getHtmlValue("smooth-index"),
    "data": jCommon.getHtmlValue("smooth-editNumber")
  };
  cmdlist.configProbe(pdata, function () {
    jCommon.addHtmlClass("#smooth-dialog", "hide");
  });
}

window.controlActiveSensor = function () {
  var sindex = "calibrate-type-" + jCommon.getHtmlValue("sindex");
  var btnCalibrateListType = document.getElementsByClassName("btn-calibrate-type");
  for (var index = 0; index < btnCalibrateListType.length; index++) {
    var targetId = btnCalibrateListType[index].getAttribute("id");
    jCommon.removeHtmlClass("#" + targetId, "active");
    if (targetId === sindex) {
      jCommon.addHtmlClass("#" + targetId, "active");
    }
  }
}

window.getSensorInfoList = function () {
  var disable = jCommon.getCurrentPage() == "pyxissensorcaltime" ? true : false;
  var idxP = jCommon.getUrlParams("idxP");
  var probInfo = channelPage.getPyxisOnlineInfo(idxP);
  var sindex = jCommon.getHtmlValue("sindex");
  var sensorList = channelPage.getPyxisSensorInfoByPN(probInfo["PN"]);
  var calibrateList = channelPage.getPyxisLastCalibrateList();
  var calibrateSensorList = [];
  if (!jCommon.empty(calibrateList)) {
    calibrateSensorList = calibrateList[sindex];
  }
  var sensorInfo = sensorList[sindex];
  var string = [];
  //get Sensor Calibrate Info
  sensorInfo.calbs.forEach(function (item, index) {
    var itemName = jCommon.translatePyxisSensor(item.name).replaceAll("{Name}", sensorInfo.name);
    var itemMessage = jCommon.translatePyxisSensor(item["message"]).replaceAll("{Name}", sensorInfo.name).replaceAll("{Unit}", sensorInfo.unit).replaceAll("{MinValue}", item.min).replaceAll("{MaxValue}", item.max);
    string.push('<div class="row calibration-row">');
    string.push('<div class="col-md-12 form-inline">');
    if (disable) {
      string.push('<div class="col-md-3 text-right">' + itemName + '</div>');
    } else {
      string.push('<div class="col-md-3 text-right">' + itemName + ':</div>');
      string.push('<div class="col-md-2">');
      string.push('<div class="col-md-offset-1 col-md-8"><div class="input-group"><button type="button" class="btn btn-default btn-calibrate" data-message="' + itemMessage + '" data-editable="' + item["editable"] + '" data-calIndex="' + item["calIndex"] + '" onclick="showCalibrateDialog(event)">Calibrate</button></div></div>');
      string.push("</div>");
    }
    var calibrateString = "";
    if (!jCommon.empty(calibrateSensorList) && !jCommon.empty(calibrateSensorList[index])) {
      var info = calibrateSensorList[index];
      if (info["time"] != "") {
        calibrateString = "<div class='display-block'>Last time:" + info["time"] + "</div>";
      }
      if (info["input"] != "") {
        calibrateString = calibrateString + "<div class='display-block'> Last solution:" + jCommon.formatNumber(info["input"], true) + "</div>";
      }
    }
    string.push('<div class="col-md-5 solution-value" id="' + sindex + '-' + item["calIndex"] + '-label">' + calibrateString + '</div>');
    string.push("</div>");
    string.push("</div>");
  })
  jCommon.setHtmlValue("calibrate-list", string.join(""));
}

window.settingSensor = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id.startsWith("calibrate-type")) {
    jCommon.setHtmlValue("sindex", event.target.id.replace("calibrate-type-", ""));
    controlActiveSensor();
    getSensorInfoList();
  } else if (event.target.id == "resetFactory") {
    ToolstipDialog.showConfirmToolsTip("", "Are you sure you want to perform a factory reset? Please select Confirm or Cancel.", function () {
      cmdlist.restoreProbe(Number(jCommon.getUrlParams("idxP")));
    })
  } else if (["metaData"].indexOf(event.target.id) > -1) {
    jCommon.toogleSwitch(event.target.id);
    jCommon.controlDOMShow(event.target.id);
    var metaData = jCommon.getHtmlValue("metaData");
    if (metaData) {
      cmdlist.startDiagnose();
    } else {
      cmdlist.breakDiagnose(jCommon.getUrlParams("idxP"));
    }
  } else if (event.target.id == "smoothIndexLabelName") {
    jCommon.removeHtmlClass("#smooth-dialog", "hide");
  }
}

window.showCalibrateDialog = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.setHtmlValue("calibrate-message", event.target.getAttribute("data-message"));
  var editable = event.target.getAttribute("data-editable");
  if (editable == "false") {
    jCommon.setHtmlValue("calibrate-editNumber", 0);
  } else {
    jCommon.setHtmlValue("calibrate-editNumber", "");
  }
  jCommon.setHtmlValue("calibrate-edit", editable);
  jCommon.controlDOMShow("calibrate-edit");
  jCommon.setHtmlValue("calibrate-index", event.target.getAttribute("data-calindex"));
  jCommon.removeHtmlClass("#pyxis-calibrate-dialog", "hide");
}

window.calibrateSensor = function (event) {
  repeatAllPage.clearEventClick(event);
  var calindex = jCommon.getHtmlValue("calibrate-index");
  var sindex = Number(jCommon.getHtmlValue("sindex"));
  var solution = Number(jCommon.getHtmlValue("calibrate-editNumber"));
  var pdata = {};
  pdata.idxCal = Number(calindex);
  pdata.idxProbe = Number(jCommon.getUrlParams("idxP"));
  pdata.idxSensor = sindex;
  pdata.solution = solution;
  cmdlist.calibrateSensorInfo(pdata, function () {
    jCommon.setHtmlValue(sindex + "-" + calindex + "-label", "");
    jCommon.addHtmlClass("#pyxis-calibrate-dialog", "hide");
  })
}

window.closeDialog = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.addHtmlClass("#pyxis-calibrate-dialog", "hide");
  jCommon.addHtmlClass("#smooth-dialog", "hide");
}
//pyxissensorcal.html end


// 3b3hconfig.html start -----------------------------------
window.init3b3hconfigPage = function (data_3C) {
  jCommon.setDomElementValue(data_3C, "/analyzer_3C/");
  channelPage.initChannelInput("condChn", data_3C["condChnType"], data_3C["condChn"], "analog");
  jCommon.setDomElementValue(data_3C["B"], "/analyzer_3C/B/");
  channelPage.setChannelConfig(data_3C["B"]["pvChnType"], data_3C["B"]["pvChn"], "pvChn");
}
window.is3b3hconfigPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return;
  }
  if (event.target.id === "installed") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
  if (event.target.id === "condLabInuse_OP") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}
// 3b3hconfig.html end -----------------------------------

// 3b3hrtime.html start -----------------------------------
window.init3b3hrtimePage = function (data_3C) {
  jCommon.setDomElementValue(data_3C, "/analyzer_3C/");
  channelPage.setChannelConfig(data_3C["condChnType"], data_3C["condChn"], "condChn");
  jCommon.setHtmlValue("condChnAnalogLabel", channelPage.getChannelInputLabel(data_3C["condChnType"], data_3C["condChn"]));
  jCommon.setDomElementValue(data_3C["B"], "/analyzer_3C/B/");
  channelPage.setChannelConfig(data_3C["B"]["pvChnType"], data_3C["B"]["pvChn"], "pvChn");
  channelPage.setChannelConfig(data_3C["B"]["foulingChnType"], data_3C["B"]["foulingChn"], "foulingChn");
}
// 3b3hrtime.html end -----------------------------------

// 3bconfig.html start -----------------------------------
window.init3bconfigPage = function (data_3C) {
  jCommon.setDomElementValue(data_3C["B"], "/analyzer_3C/B/");
  channelPage.initChannelInput("pvChn", data_3C["B"]["pvChnType"], data_3C["B"]["pvChn"], "analog");
  channelPage.initChannelInput("aoChn", data_3C["B"]["aoChnType"], data_3C["B"]["aoChn"], "analog");
}

window.init3bconfig2Page = function (data_3C) {
  jCommon.setDomElementValue(data_3C["B"], "/analyzer_3C/B/");
  channelPage.initChannelInput("htrPwrChn", data_3C["B"]["htrPwrChnType"], data_3C["B"]["htrPwrChn"], "analog");
  channelPage.initChannelInput("bulkTempChn", data_3C["B"]["bulkTempChnType"], data_3C["B"]["bulkTempChn"], "analog");
  channelPage.initChannelInput("skinTempChn", data_3C["B"]["skinTempChnType"], data_3C["B"]["skinTempChn"], "analog");
  channelPage.initChannelInput("scaleThkChn", data_3C["B"]["scaleThkChnType"], data_3C["B"]["scaleThkChn"], "analog");
  channelPage.initChannelInput("organicThkChn", data_3C["B"]["organicThkChnType"], data_3C["B"]["organicThkChn"], "analog");
  channelPage.initChannelInput("biofilmThkChn", data_3C["B"]["biofilmThkChnType"], data_3C["B"]["biofilmThkChn"], "analog");
  channelPage.initChannelInput("oilThkChn", data_3C["B"]["oilThkChnType"], data_3C["B"]["oilThkChn"], "analog");
  channelPage.initChannelInput("dtIOSChn", data_3C["B"]["dtIOSChnType"], data_3C["B"]["dtIOSChn"], "analog");
  channelPage.initChannelInput("foulingChn", data_3C["B"]["foulingChnType"], data_3C["B"]["foulingChn"], "analog");
}

window.is3bconfigPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return;
  }
  if (event.target.id === "heaterCmd_OP") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
  if (event.target.id === "zeroCalbtn3b") {
    jCommon.removeHtmlClass("#zero3b-dialog", "hide");
  }
  if (event.target.id === "diagbtn3b") {
    jCommon.removeHtmlClass("#diag3b-dialog", "hide");
  }
  if (event.target.id === "getDiagbtn3b") {
    jCommon.removeHtmlClass("#getDiagData-dialog", "hide");
  }
}

window.zeroCal3b = function () {
  var pdata = {
    "paramName": "zeroCalStartReq",
    "value": true
  };
  cmdlist.operation3B(pdata, function () {
    jCommon.addHtmlClass("#zero3b-dialog", "hide");
  });
}

window.closeZero3b = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.addHtmlClass("#zero3b-dialog", "hide");
}

window.diag3b = function () {
  var pdata = {
    "paramName": "diagStartReq",
    "value": true
  };
  cmdlist.operation3B(pdata, function () {
    jCommon.addHtmlClass("#diag3b-dialog", "hide");
  });
}

window.closeDiag3b = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.addHtmlClass("#diag3b-dialog", "hide");
}

window.getDiagData3b = function () {
  var pdata = {
    "paramName": "getDiagDataReq",
    "value": true
  };
  cmdlist.operation3B(pdata, function () {
    jCommon.addHtmlClass("#getDiagData-dialog", "hide");
  });
}

window.closeGetDiagData3b = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.addHtmlClass("#getDiagData-dialog", "hide");
}
// 3bconfig.html end -----------------------------------

// 3brtime.html start -----------------------------------
window.init3brtimePage = function (data_3C) {
  jCommon.setDomElementValue(data_3C["B"], "/analyzer_3C/B/");
  channelPage.setChannelConfig(data_3C["B"]["pvChnType"], data_3C["B"]["pvChn"], "pvChn");
  jCommon.setHtmlValue("pvChnAnalogLabel", channelPage.getChannelInputLabel(data_3C["B"]["pvChnType"], data_3C["B"]["pvChn"]));
  channelPage.setChannelConfig(data_3C["B"]["aoChnType"], data_3C["B"]["aoChn"], "aoChn");
  jCommon.setHtmlValue("aoChnAnalogLabel", channelPage.getChannelInputLabel(data_3C["B"]["aoChnType"], data_3C["B"]["aoChn"]));
  channelPage.setChannelConfig(data_3C["B"]["foulingChnType"], data_3C["B"]["foulingChn"], "foulingChn");
}
// 3brtime.html end -----------------------------------

// 3hconfig.html start -----------------------------------
window.init3hconfigPage = function (data_3C) {
  jCommon.setDomElementValue(data_3C["H"], "/analyzer_3C/H/");
  channelPage.initChannelInput("pvChn", data_3C["H"]["pvChnType"], data_3C["H"]["pvChn"], "analog");
  channelPage.initChannelInput("aoChn", data_3C["H"]["aoChnType"], data_3C["H"]["aoChn"], "analog");
  channelPage.initChannelInput("htrPwrChn", data_3C["H"]["htrPwrChnType"], data_3C["H"]["htrPwrChn"], "analog");
  channelPage.initChannelInput("bulkTempChn", data_3C["H"]["bulkTempChnType"], data_3C["H"]["bulkTempChn"], "analog");
  channelPage.initChannelInput("skinTempChn", data_3C["H"]["skinTempChnType"], data_3C["H"]["skinTempChn"], "analog");
  channelPage.initChannelInput("scaleThkChn", data_3C["H"]["scaleThkChnType"], data_3C["H"]["scaleThkChn"], "analog");
  channelPage.initChannelInput("foulingChn", data_3C["H"]["foulingChnType"], data_3C["H"]["foulingChn"], "analog");
}

window.is3hconfigPageClick = function (event) {
  if (jCommon.empty(event.target.id)) {
    return;
  }
  if (event.target.id === "heaterCmd_OP") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
  if (event.target.id === "zeroCalbtn3h") {
    jCommon.removeHtmlClass("#zero3h-dialog", "hide");
  }
}

window.zeroCal3h = function () {
  var pdata = {
    "paramName": "zeroCalStartReq",
    "value": true
  };
  cmdlist.operation3H(pdata, function () {
    jCommon.addHtmlClass("#zero3h-dialog", "hide");
  });
}

window.closeZero3h = function (event) {
  repeatAllPage.clearEventClick(event);
  jCommon.addHtmlClass("#zero3h-dialog", "hide");
}
// 3hconfig.html end -----------------------------------

// 3hrtime.html start -----------------------------------
window.init3hrtimePage = function (data_3C) {
  jCommon.setDomElementValue(data_3C["H"], "/analyzer_3C/H/");
  channelPage.setChannelConfig(data_3C["H"]["pvChnType"], data_3C["H"]["pvChn"], "pvChn");
  jCommon.setHtmlValue("pvChnAnalogLabel", channelPage.getChannelInputLabel(data_3C["H"]["pvChnType"], data_3C["H"]["pvChn"]));
  channelPage.setChannelConfig(data_3C["H"]["aoChnType"], data_3C["H"]["aoChn"], "aoChn");
  jCommon.setHtmlValue("aoChnAnalogLabel", channelPage.getChannelInputLabel(data_3C["H"]["aoChnType"], data_3C["H"]["aoChn"]));
  channelPage.setChannelConfig(data_3C["H"]["foulingChnType"], data_3C["H"]["foulingChn"], "foulingChn");
}
// 3hrtime.html end -----------------------------------

// 3bdiagresult.html start -----------------------------------
window.init3bdiagresultData = function () {
  var n3gains = repeatAllPage.initLiveData["analyzer_3C"]["B"]["n3Gains"]
  var xmin = 0;
  var xmax = 80;
  var ymin = Math.min.apply(null, n3gains) - 2;
  var ymax = Math.max.apply(null, n3gains) + 2;
  var data = [];
  var dyGraphConfigInstance = dyGraphConfig.getDyGraphConfig();
  dyGraphConfigInstance.labels = ["Gain [dB]", "Runtime  [us]"];
  dyGraphConfigInstance.valueRange = [ymin, ymax];
  dyGraphConfigInstance.strokeWidth = 0.0;
  dyGraphConfigInstance.drawPoints = true;
  dyGraphConfigInstance.pointSize = 5;
  n3gains.forEach(function (value, i) {
    data.push([i * 2, value]);
  })
  data.push([xmax, null]);
  jCommon.setHtmlValue("x-label", "Gain [dB]");
  jCommon.setHtmlValue("y-label", "Runtime[us]");
  jCommon.setHtmlValue("x-min", xmin);
  jCommon.setHtmlValue("x-max", xmax);
  jCommon.setHtmlValue("y-min", ymin);
  jCommon.setHtmlValue("y-max", ymax);
  new Dygraph(
    document.getElementById("dygraph-container3b"),
    data,
    dyGraphConfigInstance
  );
}
// 3bdiagresult.html end -----------------------------------

//systemsetting.html start --------------------------------
function initSystemSettingData() {
  jCommon.setHtmlValue("switchTime", false);
  jCommon.setDomElementItemValue("switchTime", false)
  jCommon.setHtmlValue("systemTime", jCommon.formatDate((new Date()).getTime()));
}

function systemSettingClick(event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id == "switchTime") {
    var metricFlag = jCommon.checkBoolenValue(jCommon.getHtmlValue("switchTime")) ? false : true;
    jCommon.setDomElementItemValue({
      "switchTime": metricFlag
    });
  } else if (event.target.id == "settingSystemTime") {
    var systemTime = jCommon.getHtmlValue("systemTime");
    if (!jCommon.checkBoolenValue(jCommon.getHtmlValue("switchTime"))) {
      systemTime = ""
    }
    cmdlist.setDatetime(systemTime);
  }
}
//systemsetting.html end --------------------------------

//factoryconfigs.html start --------------------------------
function initFactoryConfigPage(message) {
  var controllerInfo = message["controller"];
  jCommon.setHtmlValue("serialNum_SYS", controllerInfo["serialNum_SYS"]);
  jCommon.setHtmlValue("projectNum_SYS", controllerInfo["projectNum_SYS"]);
  jCommon.setHtmlValue("hmiSerial_SYS", controllerInfo["hmiSerial_SYS"]);
}
function setFactoryConfig(event) {
  repeatAllPage.clearEventClick(event);
  ToolstipDialog.showConfirmToolsTip("", "Apply Factory Settings?", function () {
    var pdata = {};
    pdata.serialNum_SYS = jCommon.getHtmlValue("serialNum_SYS");
    pdata.projectNum = jCommon.getHtmlValue("projectNum_SYS");
    pdata.hmiSerial_SYS = jCommon.getHtmlValue("hmiSerial_SYS");
    cmdlist.updateFactory(pdata);
  })
}
//factoryconfigs.html end -------------------------------- 


//moxaio.html
function initMoxaioPage(message) {
  var moxaInfo = message["moxa"];
  jCommon.setDomElementValue(moxaInfo, "/moxa/");
}

window.moxaioPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id == "stdMoxaAISetup") {
    repeatAllPage.updateParameter(event.target.id);
  }
}

// export.html start
window.initExportPageData = function (message) {
  var trendList = [];
  message.trends.forEach(function (trendItem, trendIndex) {
    trendList.push({ "value": trendIndex, "name": jCommon.empty(trendItem.name) ? "Trend " + Number(trendIndex + 1) : trendItem.name })
  });
  jCommon.dropDownMenu({
    element: document.getElementById("trendLabel"),
    choices: trendList,
    defaultvalue: 0,
  });
}

// PBC Page Start
window.initPBCPageData = function (message) {
  var pdList = systemFeed.getPredefinedLoopList(message);
  var pbcInfo = message["pbc"];
  jCommon.setDomElementValue(pbcInfo, "/pbc/");
  jCommon.setDomElementValue(pbcInfo["toPBC_user"], "/pbc/toPBC_user/");
  channelPage.initChannelInput("pHChn", pbcInfo["pHChnType"], pbcInfo["pHChn"], "analog");
  channelPage.initChannelInput("orpChn", pbcInfo["orpChnType"], pbcInfo["orpChn"], "analog");
  channelPage.initChannelInput("trackerChn", pbcInfo["trackerChnType"], pbcInfo["trackerChn"], "analog");
  channelPage.initChannelInput("condChn", pbcInfo["condChnType"], pbcInfo["condChn"], "analog");
  channelPage.initChannelInput("turbChn", pbcInfo["turbChnType"], pbcInfo["turbChn"], "analog");
  channelPage.initChannelInput("corr1Chn", pbcInfo["corr1ChnType"], pbcInfo["corr1Chn"], "analog");
  channelPage.initChannelInput("imb1Chn", pbcInfo["imb1ChnType"], pbcInfo["imb1Chn"], "analog");
  channelPage.initChannelInput("corr2Chn", pbcInfo["corr2ChnType"], pbcInfo["corr2Chn"], "analog");
  channelPage.initChannelInput("imb2Chn", pbcInfo["imb2ChnType"], pbcInfo["imb2Chn"], "analog");
  channelPage.initChannelInput("sclThkChn", pbcInfo["sclThkChnType"], pbcInfo["sclThkChn"], "analog");
  channelPage.initChannelInput("ft3bChn", pbcInfo["ft3bChnType"], pbcInfo["ft3bChn"], "analog");
  channelPage.initChannelInput("ft3hChn", pbcInfo["ft3hChnType"], pbcInfo["ft3hChn"], "analog");
  channelPage.initChannelInput("bdChn", pbcInfo["bdChnType"], pbcInfo["bdChn"], "analog");
  channelPage.initChannelInput("muChn", pbcInfo["muChnType"], pbcInfo["muChn"], "analog");
  jCommon.dropDownMenu({
    element: document.getElementById("pHLoopNLabel"),
    choices: pdList,
    defaultvalue: pbcInfo["pHLoopN"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("trackerLoopNLabel"),
    choices: pdList,
    defaultvalue: pbcInfo["trackerLoopN"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("oxiBio1LoopNLabel"),
    choices: pdList,
    defaultvalue: pbcInfo["oxiBio1LoopN"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("oxiBio2LoopNLabel"),
    choices: pdList,
    defaultvalue: pbcInfo["oxiBio2LoopN"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("nonOxiBio1LoopNLabel"),
    choices: pdList,
    defaultvalue: pbcInfo["nonOxiBio1LoopN"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("nonOxiBio2LoopNLabel"),
    choices: pdList,
    defaultvalue: pbcInfo["nonOxiBio2LoopN"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("orgDispsnt1LoopNLabel"),
    choices: pdList,
    defaultvalue: pbcInfo["orgDispsnt1LoopN"],
    callback: repeatAllPage.updateSelectValueData
  });

}

window.pbc1Click = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id === "enableReq_OP") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
  if (event.target.id === "timer_bypass_OP") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    });
  }
}
// PBC Page End

window.exportPageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  var dateTimeList = jCommon.getHtmlValue("header-server-time").split(" ");
  var dateList = dateTimeList[0].split("-");
  var timeList = dateTimeList[1].split(":");
  if (event.target.id == "set-trend-date") {
    jCommon.setHtmlValue("end_trend_date_year", jCommon.formatExceptYYYY(dateList[0]));
    jCommon.setHtmlValue("end_trend_date_month", jCommon.formatExceptYYYY(dateList[1]));
    jCommon.setHtmlValue("end_trend_date_day", jCommon.formatExceptYYYY(dateList[2]));
    jCommon.setHtmlValue("end_trend_date_hour", jCommon.formatExceptYYYY(timeList[0]));
    jCommon.setHtmlValue("end_trend_date_min", jCommon.formatExceptYYYY(timeList[1]));
    jCommon.setHtmlValue("end_trend_date_sec", jCommon.formatExceptYYYY(timeList[2]));
  } else if (event.target.id == "last-year") {
    jCommon.setHtmlValue("start_trend_date_year", jCommon.formatExceptYYYY(Number(dateList[0]) - 1));
    jCommon.setHtmlValue("start_trend_date_month", jCommon.formatExceptYYYY(dateList[1]));
    jCommon.setHtmlValue("start_trend_date_day", jCommon.formatExceptYYYY(dateList[2]));
    jCommon.setHtmlValue("start_trend_date_hour", jCommon.formatExceptYYYY(timeList[0]));
    jCommon.setHtmlValue("start_trend_date_min", jCommon.formatExceptYYYY(timeList[1]));
    jCommon.setHtmlValue("start_trend_date_sec", jCommon.formatExceptYYYY(timeList[2]));
  } else if (event.target.id == "refresh") {

  } else if (event.target.id == "export") {
    var startTime = jCommon.formatExceptYYYY(document.getElementById("start_trend_date_year").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("start_trend_date_month").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("start_trend_date_day").value) + " " + jCommon.formatExceptYYYY(document.getElementById("start_trend_date_hour").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("start_trend_date_min").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("start_trend_date_sec").value);
    var endTime = jCommon.formatExceptYYYY(document.getElementById("end_trend_date_year").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("end_trend_date_month").value) + "-" + jCommon.formatExceptYYYY(document.getElementById("end_trend_date_day").value) + " " + jCommon.formatExceptYYYY(document.getElementById("end_trend_date_hour").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("end_trend_date_min").value) + ":" + jCommon.formatExceptYYYY(document.getElementById("end_trend_date_sec").value);
    var pdata = {};
    pdata["starttime"] = startTime;
    pdata["endtime"] = endTime;
    pdata["trendIdx"] = Number(jCommon.getHtmlAttriute("trendLabel", "select-value"));
    pdata["path"] = jCommon.getHtmlAttriute("mediaLabel", "select-value");
    if (jCommon.empty(pdata["path"])) {
      ToolstipDialog.showAlertToolsTip("Error", "Please insert a USB flash drive");
    } else {
      ToolstipDialog.showConfirmToolsTip("", "Continue to Export Selected Data?", function () {
        jCommon.contorlBtnStatus("btn-export", true);
        cmdlist.exportCSV(pdata);
      }, null, "Yes");
    }
  }
}
// export.html end 

//apid.html start
window.initAPIDPageData = function (message) {
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  var loopInfo = loopList[loopIndex];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  channelPage.initChannelInput("pvChn", loopInfo["pvChnType"], loopInfo["pvChn"], "analog");
  // channelPage.initChannelInput("ffChn", loopInfo["ffChnType"], loopInfo["ffChn"], "analog");
  systemFeed.initConstantChannel(loopInfo);
  if (!jCommon.empty(loopInfo["ff"])) {
    var ffInfo = loopInfo["ff"];
    for (var key in ffInfo) {
      jCommon.setHtmlValue("ff-" + key, ffInfo[key]);
      jCommon.setClassListValue("ff-" + key, ffInfo[key]);
      jCommon.setDataSaveProperty("ff-" + key, "/loops/" + loopIndex + "/ff/" + key);
    }
    channelPage.initChannelInput("ff-chn", ffInfo["chnType"], ffInfo["chn"], "analog");
    jCommon.controlDOMShow("ff-dataType");
  }
  jCommon.setHtmlValue("timeout", Number(loopInfo["timeout"] / 60).toFixed(0));
  jCommon.setHtmlAttribute("apid2", "href", "#apid2&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.setHtmlAttribute("apid1", "href", "#apid1&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  jCommon.dropDownMenu({
    element: document.getElementById("equationLabel"),
    choices: constVar.getAPidEquationList(),
    defaultvalue: loopInfo["equation"],
    callback: repeatAllPage.updateSelectValueData
  });
  jCommon.dropDownMenu({
    element: document.getElementById("anti_windupLabel"),
    choices: constVar.getAPidAntiwindupList(),
    defaultvalue: loopInfo["anti_windup"],
    callback: repeatAllPage.updateSelectValueData
  });
}

window.systemAPidControlClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (["localEn", "sp-dataType", "rateManual-dataType", "fallback-dataType", "deadband-dataType", "timeoutEn", "action", "update_mode", "tuneParam", "ff-dataType", "derivative_filter_enable", "integral_filter_enable"].indexOf(event.target.id) > -1) {
    jCommon.setRadioButtonValue(event.target.id, function () {
      if (event.target.id === "localEn") {
        systemFeed.controlLoopLocalEnProperty();
      }
      repeatAllPage.updateParameter(event.target.id);
    })
  } else if (event.target.id === "cmdReset") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id, function () {
        jCommon.setRadioButtonValue(event.target.id);
      });
    })
  }
}
//apid.html end

//apidrtime.html start
window.initAPidRTimeData = function (message) {
  systemFeed.setLoopTitleAndFeedName(message["systems"]);
  jCommon.setHtmlAttribute("pdc", "href", "#pdc&system=" + jCommon.getUrlParams("system") + "&Fd=" + jCommon.getUrlParams("Fd") + "&Lp=" + jCommon.getUrlParams("Lp"));
  var loopList = message["loops"];
  var loopIndex = Number(jCommon.getUrlParams("Lp")) - 1;
  var loopInfo = loopList[loopIndex];
  var feedDeviceInfo = loopInfo["fdDevice"];
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  jCommon.setDomElementValue(loopInfo, "/loops/" + loopIndex + "/");
  systemFeed.initLoopMode(loopInfo);
  jCommon.setHtmlValue("ctrlType-name", constVar.getControlTypeName(loopInfo["ctrlType"]));
  jCommon.setHtmlValue("actionLabel", loopInfo["action"] ? "Reverse" : "Direct");
  systemFeed.initRunTimeConstantChannel(loopInfo);
  channelPage.setChannelConfig(loopInfo["pvChnType"], loopInfo["pvChn"], "pvChn");
  jCommon.setHtmlValue("pvChnAnalogLabel", channelPage.getChannelInputLabel(loopInfo["pvChnType"], loopInfo["pvChn"]));
  jCommon.setHtmlValue("pvChnName", channelPage.getChannelInfo(loopInfo["pvChnType"], loopInfo["pvChn"], "name"));
  systemFeed.initRunTimeFeedDevice(feedDeviceInfo);
}

window.apidrtimePageClick = function (event) {
  repeatAllPage.clearEventClick(event);
  if (event.target.id === "localEn") {
    systemFeed.btnLocalEnTimeClick();
  } else if (event.target.id === "flowmeterCtrl-correctOn") {
    jCommon.setRadioButtonValue(event.target.id, function () {
      repeatAllPage.updateParameter(event.target.id);
    })
  }
}
//apidrtime.html end

//pyxissensorlog.html start
window.initPyxisSensorLogPageData = function (message) {
  var onLineProbes = message["probes"]["onlines"];
  var channel = jCommon.getUrlParams("p");
  var channelIndex = channel - 1;
  jCommon.setHtmlValue("pageNum", channel);
  var onLineProbesInfoName = onLineProbes[channelIndex]["customName"]
  jCommon.setHtmlValue("name", onLineProbesInfoName);
  pageNavigate.controlPageState();
  let pdata = {};
  pdata.channel = channelIndex;
  var logList = [];
  cmdlist.getCalibLog(pdata, function (list) {
    list.forEach(function (item) {
      var logItem = [];
      logItem.push('<div  class="row alarm-item">');
      logItem.push('<div class="label-left pull-left time">' + item.datetime + '</div>');
      logItem.push('<div class="label-content pull-left">' + item.msg + '</div>');
      logItem.push('</div>');
      logList.push(logItem.join(""));
    })
    jCommon.setHtmlValue("log-list", logList.join(""));
  })
}

window.pyxisSensorLogPageClick = function (event) {
  var marginPosition = pageNavigate.rowAndPageClick(event.target.id, 17, jCommon.getHtmlValue("lastIndex"), 40);
  jCommon.setHtmlStyleAttribute("log-list", "marginTop", marginPosition);
}
//pyxissensorlog.html end