import os
import sys

def get_rtc_name():
    name = "/dev/rtc"
    for i in range(3):
        filename = f"/sys/class/rtc/rtc{i}/name"
        with open(filename, "rt") as f:
            txt = f.read(10)
            if txt.startswith("rtc-rx8025"):
                name = f"/dev/rtc{i}"
                break
    return name

def write_rtc():
    name = get_rtc_name()
    cmd = f"hwclock -w -f {name}"
    ret = os.system(cmd)
    print(f"{cmd} = {ret}")
    return ret

def read_rtc():
    name = get_rtc_name()
    cmd = f"hwclock -s -f {name}"
    ret = os.system(cmd)
    print(f"{cmd} = {ret}")
    return ret


def ntp_update():
    cmds = ["ntpdate 0.north-america.pool.ntp.org",
            "ntpdate 1.north-america.pool.ntp.org"]
    ret = False
    for c in cmds:
        if os.system(c)==0:
            ret = True
            break
    return ret


if __name__ == "__main__":
    args = sys.argv[1:]
    print(args)
    if len(args)==1 and args[0] == "read_rtc":
        read_rtc()
    if len(args)==1 and args[0] == "write_rtc":
        write_rtc()
    else: # ntp_rtc
        ret = ntp_update()
        if ret:
            write_rtc()
        else:  # use hwclock if ntpdate fails
            read_rtc()


